/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.Closeable;
import java.nio.ByteOrder;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJException;
import org.libjpegturbo.turbojpeg.TJLoader;
import org.libjpegturbo.turbojpeg.TJScalingFactor;
import org.libjpegturbo.turbojpeg.YUVImage;

public class TJDecompressor
implements Closeable {
    private static final String NO_ASSOC_ERROR = "No JPEG image is associated with this instance";
    private long handle = 0L;
    private byte[] jpegBuf = null;
    private int jpegBufSize = 0;
    private YUVImage yuvImage = null;
    private TJScalingFactor scalingFactor = TJ.UNSCALED;
    private Rectangle croppingRegion = TJ.UNCROPPED;
    private ByteOrder byteOrder = null;

    public TJDecompressor() throws TJException {
        this.init();
    }

    public TJDecompressor(byte[] byArray) throws TJException {
        this.init();
        this.setSourceImage(byArray, byArray.length);
    }

    public TJDecompressor(byte[] byArray, int n) throws TJException {
        this.init();
        this.setSourceImage(byArray, n);
    }

    public TJDecompressor(YUVImage yUVImage) throws TJException {
        this.init();
        this.setSourceImage(yUVImage);
    }

    public void setSourceImage(byte[] byArray, int n) throws TJException {
        if (byArray == null || n < 1) {
            throw new IllegalArgumentException("Invalid argument in setSourceImage()");
        }
        this.jpegBuf = byArray;
        this.jpegBufSize = n;
        this.decompressHeader(this.jpegBuf, this.jpegBufSize);
        this.yuvImage = null;
    }

    public void setSourceImage(YUVImage yUVImage) {
        if (yUVImage == null) {
            throw new IllegalArgumentException("Invalid argument in setSourceImage()");
        }
        this.yuvImage = yUVImage;
        this.set(4, yUVImage.getSubsamp());
        this.jpegBuf = null;
        this.jpegBufSize = 0;
    }

    public int getWidth() {
        if (this.yuvImage != null) {
            return this.yuvImage.getWidth();
        }
        return this.getJPEGWidth();
    }

    private int getJPEGWidth() {
        int n = this.get(5);
        if (n < 1) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        return n;
    }

    public int getHeight() {
        if (this.yuvImage != null) {
            return this.yuvImage.getHeight();
        }
        return this.getJPEGHeight();
    }

    private int getJPEGHeight() {
        int n = this.get(6);
        if (n < 1) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        return n;
    }

    public native void set(int var1, int var2);

    public native int get(int var1);

    public void setScalingFactor(TJScalingFactor tJScalingFactor) {
        int n;
        if (tJScalingFactor == null) {
            throw new IllegalArgumentException("Invalid argument in setScalingFactor()");
        }
        TJScalingFactor[] tJScalingFactorArray = TJ.getScalingFactors();
        for (n = 0; n < tJScalingFactorArray.length && (tJScalingFactor.getNum() != tJScalingFactorArray[n].getNum() || tJScalingFactor.getDenom() != tJScalingFactorArray[n].getDenom()); ++n) {
        }
        if (n >= tJScalingFactorArray.length) {
            throw new IllegalArgumentException("Unsupported scaling factor");
        }
        this.scalingFactor = tJScalingFactor;
    }

    public void setCroppingRegion(Rectangle rectangle) throws TJException {
        this.croppingRegion = rectangle;
        this.setCroppingRegion();
    }

    @Deprecated
    public int getSubsamp() {
        int n = this.get(4);
        if (n == -1) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (n >= 7) {
            throw new IllegalStateException("JPEG header information is invalid");
        }
        return n;
    }

    @Deprecated
    public int getColorspace() {
        if (this.yuvImage != null) {
            return 1;
        }
        int n = this.get(8);
        if (n < 0) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (n >= 5) {
            throw new IllegalStateException("JPEG header information is invalid");
        }
        return n;
    }

    public byte[] getJPEGBuf() {
        if (this.jpegBuf == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        return this.jpegBuf;
    }

    public int getJPEGSize() {
        if (this.jpegBufSize < 1) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        return this.jpegBufSize;
    }

    @Deprecated
    public int getScaledWidth(int n, int n2) {
        TJScalingFactor tJScalingFactor = this.getScalingFactor(n, n2);
        return tJScalingFactor.getScaled(this.getJPEGWidth());
    }

    @Deprecated
    public int getScaledHeight(int n, int n2) {
        TJScalingFactor tJScalingFactor = this.getScalingFactor(n, n2);
        return tJScalingFactor.getScaled(this.getJPEGHeight());
    }

    private TJScalingFactor getScalingFactor(int n, int n2) {
        int n3;
        int n4 = this.getJPEGWidth();
        int n5 = this.getJPEGHeight();
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Invalid argument");
        }
        TJScalingFactor[] tJScalingFactorArray = TJ.getScalingFactors();
        if (n == 0) {
            n = n4;
        }
        if (n2 == 0) {
            n2 = n5;
        }
        for (n3 = 0; n3 < tJScalingFactorArray.length && (tJScalingFactorArray[n3].getScaled(n4) > n || tJScalingFactorArray[n3].getScaled(n5) > n2); ++n3) {
        }
        if (n3 >= tJScalingFactorArray.length) {
            throw new IllegalArgumentException("Could not scale down to desired image dimensions");
        }
        return tJScalingFactorArray[n3];
    }

    public void decompress8(byte[] byArray, int n, int n2, int n3, int n4) throws TJException {
        if (this.jpegBuf == null && this.yuvImage == null) {
            throw new IllegalStateException("No source image is associated with this instance");
        }
        if (byArray == null || n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n4 >= 12) {
            throw new IllegalArgumentException("Invalid argument in decompress8()");
        }
        if (this.yuvImage != null) {
            this.checkSubsampling();
            this.decodeYUV8(this.yuvImage.getPlanes(), this.yuvImage.getOffsets(), this.yuvImage.getStrides(), byArray, n, n2, this.yuvImage.getWidth(), n3, this.yuvImage.getHeight(), n4);
        } else {
            this.decompress8(this.jpegBuf, this.jpegBufSize, byArray, n, n2, n3, n4);
        }
    }

    @Deprecated
    public void decompress(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) throws TJException {
        if (this.yuvImage != null && (n3 < 0 || n5 < 0) || n7 < 0) {
            throw new IllegalArgumentException("Invalid argument in decompress()");
        }
        if (this.yuvImage == null) {
            TJScalingFactor tJScalingFactor = this.getScalingFactor(n3, n5);
            this.setScalingFactor(tJScalingFactor);
        }
        this.processFlags(n7);
        this.decompress8(byArray, n, n2, n4, n6);
    }

    public byte[] decompress8(int n, int n2) throws TJException {
        if (n < 0 || n2 < 0 || n2 >= 12) {
            throw new IllegalArgumentException("Invalid argument in decompress8()");
        }
        int n3 = TJ.getPixelSize(n2);
        int n4 = this.scalingFactor.getScaled(this.getJPEGWidth());
        int n5 = this.scalingFactor.getScaled(this.getJPEGHeight());
        if (n == 0) {
            n = n4 * n3;
        }
        byte[] byArray = new byte[n * n5];
        this.decompress8(byArray, 0, 0, n, n2);
        return byArray;
    }

    @Deprecated
    public byte[] decompress(int n, int n2, int n3, int n4, int n5) throws TJException {
        if (this.yuvImage == null && (n < 0 || n3 < 0) || n5 < 0) {
            throw new IllegalArgumentException("Invalid argument in decompress()");
        }
        if (this.yuvImage == null) {
            TJScalingFactor tJScalingFactor = this.getScalingFactor(n, n3);
            this.setScalingFactor(tJScalingFactor);
        }
        this.processFlags(n5);
        return this.decompress8(n2, n4);
    }

    public void decompress12(short[] sArray, int n, int n2, int n3, int n4) throws TJException {
        if (this.jpegBuf == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (sArray == null || n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n4 >= 12) {
            throw new IllegalArgumentException("Invalid argument in decompress12()");
        }
        this.decompress12(this.jpegBuf, this.jpegBufSize, sArray, n, n2, n3, n4);
    }

    public short[] decompress12(int n, int n2) throws TJException {
        if (n < 0 || n2 < 0 || n2 >= 12) {
            throw new IllegalArgumentException("Invalid argument in decompress12()");
        }
        int n3 = TJ.getPixelSize(n2);
        int n4 = this.scalingFactor.getScaled(this.getJPEGWidth());
        int n5 = this.scalingFactor.getScaled(this.getJPEGHeight());
        if (n == 0) {
            n = n4 * n3;
        }
        short[] sArray = new short[n * n5];
        this.decompress12(sArray, 0, 0, n, n2);
        return sArray;
    }

    public void decompress16(short[] sArray, int n, int n2, int n3, int n4) throws TJException {
        if (this.jpegBuf == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (sArray == null || n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n4 >= 12) {
            throw new IllegalArgumentException("Invalid argument in decompress16()");
        }
        this.decompress16(this.jpegBuf, this.jpegBufSize, sArray, n, n2, n3, n4);
    }

    public short[] decompress16(int n, int n2) throws TJException {
        if (n < 0 || n2 < 0 || n2 >= 12) {
            throw new IllegalArgumentException("Invalid argument in decompress16()");
        }
        int n3 = TJ.getPixelSize(n2);
        int n4 = this.scalingFactor.getScaled(this.getJPEGWidth());
        int n5 = this.scalingFactor.getScaled(this.getJPEGHeight());
        if (n == 0) {
            n = n4 * n3;
        }
        short[] sArray = new short[n * n5];
        this.decompress16(sArray, 0, 0, n, n2);
        return sArray;
    }

    public void decompressToYUV(YUVImage yUVImage) throws TJException {
        if (this.jpegBuf == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (yUVImage == null) {
            throw new IllegalArgumentException("Invalid argument in decompressToYUV()");
        }
        this.checkSubsampling();
        if (this.get(4) != yUVImage.getSubsamp()) {
            throw new IllegalArgumentException("YUVImage subsampling level does not match that of the JPEG image");
        }
        if (this.scalingFactor.getScaled(this.getJPEGWidth()) != yUVImage.getWidth() || this.scalingFactor.getScaled(this.getJPEGHeight()) != yUVImage.getHeight()) {
            throw new IllegalArgumentException("YUVImage dimensions do not match the scaled JPEG dimensions");
        }
        this.decompressToYUV8(this.jpegBuf, this.jpegBufSize, yUVImage.getPlanes(), yUVImage.getOffsets(), yUVImage.getStrides());
    }

    @Deprecated
    public void decompressToYUV(YUVImage yUVImage, int n) throws TJException {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid argument in decompressToYUV()");
        }
        TJScalingFactor tJScalingFactor = this.getScalingFactor(yUVImage.getWidth(), yUVImage.getHeight());
        if (tJScalingFactor.getScaled(this.getJPEGWidth()) != yUVImage.getWidth() || tJScalingFactor.getScaled(this.getJPEGHeight()) != yUVImage.getHeight()) {
            throw new IllegalArgumentException("YUVImage dimensions do not match one of the scaled image sizes that the decompressor is capable of generating.");
        }
        this.setScalingFactor(tJScalingFactor);
        this.processFlags(n);
        this.decompressToYUV(yUVImage);
    }

    public YUVImage decompressToYUV(int[] nArray) throws TJException {
        int n = this.getJPEGWidth();
        int n2 = this.getJPEGHeight();
        this.checkSubsampling();
        if (this.yuvImage != null) {
            throw new IllegalStateException("Source image is the wrong type");
        }
        YUVImage yUVImage = new YUVImage(this.scalingFactor.getScaled(n), null, this.scalingFactor.getScaled(n2), this.get(4));
        this.decompressToYUV(yUVImage);
        return yUVImage;
    }

    @Deprecated
    public YUVImage decompressToYUV(int n, int[] nArray, int n2, int n3) throws TJException {
        if (n3 < 0) {
            throw new IllegalArgumentException("Invalid argument in decompressToYUV()");
        }
        TJScalingFactor tJScalingFactor = this.getScalingFactor(n, n2);
        this.setScalingFactor(tJScalingFactor);
        this.processFlags(n3);
        return this.decompressToYUV(nArray);
    }

    public YUVImage decompressToYUV(int n) throws TJException {
        int n2 = this.getJPEGWidth();
        int n3 = this.getJPEGHeight();
        this.checkSubsampling();
        if (this.yuvImage != null) {
            throw new IllegalStateException("Source image is the wrong type");
        }
        YUVImage yUVImage = new YUVImage(this.scalingFactor.getScaled(n2), n, this.scalingFactor.getScaled(n3), this.get(4));
        this.decompressToYUV(yUVImage);
        return yUVImage;
    }

    @Deprecated
    public YUVImage decompressToYUV(int n, int n2, int n3, int n4) throws TJException {
        if (n4 < 0) {
            throw new IllegalArgumentException("Invalid argument in decompressToYUV()");
        }
        TJScalingFactor tJScalingFactor = this.getScalingFactor(n, n3);
        this.setScalingFactor(tJScalingFactor);
        this.processFlags(n4);
        return this.decompressToYUV(n2);
    }

    public void decompress8(int[] nArray, int n, int n2, int n3, int n4) throws TJException {
        if (this.jpegBuf == null && this.yuvImage == null) {
            throw new IllegalStateException("No source image is associated with this instance");
        }
        if (nArray == null || n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n4 >= 12) {
            throw new IllegalArgumentException("Invalid argument in decompress8()");
        }
        if (this.yuvImage != null) {
            this.checkSubsampling();
            this.decodeYUV8(this.yuvImage.getPlanes(), this.yuvImage.getOffsets(), this.yuvImage.getStrides(), nArray, n, n2, this.yuvImage.getWidth(), n3, this.yuvImage.getHeight(), n4);
        } else {
            this.decompress8(this.jpegBuf, this.jpegBufSize, nArray, n, n2, n3, n4);
        }
    }

    @Deprecated
    public void decompress(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) throws TJException {
        if (this.yuvImage != null && (n3 < 0 || n5 < 0) || n7 < 0) {
            throw new IllegalArgumentException("Invalid argument in decompress()");
        }
        if (this.yuvImage == null) {
            TJScalingFactor tJScalingFactor = this.getScalingFactor(n3, n5);
            this.setScalingFactor(tJScalingFactor);
        }
        this.processFlags(n7);
        this.decompress8(nArray, n, n2, n4, n6);
    }

    public void decompress8(BufferedImage bufferedImage) throws TJException {
        int n;
        if (bufferedImage == null) {
            throw new IllegalArgumentException("Invalid argument in decompress8()");
        }
        if (this.yuvImage != null) {
            if (bufferedImage.getWidth() != this.yuvImage.getWidth() || bufferedImage.getHeight() != this.yuvImage.getHeight()) {
                throw new IllegalArgumentException("BufferedImage dimensions do not match the dimensions of the source image.");
            }
        } else if (this.scalingFactor.getScaled(this.getJPEGWidth()) != bufferedImage.getWidth() || this.scalingFactor.getScaled(this.getJPEGHeight()) != bufferedImage.getHeight()) {
            throw new IllegalArgumentException("BufferedImage dimensions do not match the scaled JPEG dimensions.");
        }
        boolean bl = false;
        if (this.byteOrder == null) {
            this.byteOrder = ByteOrder.nativeOrder();
        }
        switch (bufferedImage.getType()) {
            case 5: {
                n = 1;
                break;
            }
            case 6: 
            case 7: {
                n = 4;
                break;
            }
            case 10: {
                n = 6;
                break;
            }
            case 4: {
                n = this.byteOrder == ByteOrder.BIG_ENDIAN ? 4 : 2;
                bl = true;
                break;
            }
            case 1: {
                n = this.byteOrder == ByteOrder.BIG_ENDIAN ? 5 : 3;
                bl = true;
                break;
            }
            case 2: 
            case 3: {
                n = this.byteOrder == ByteOrder.BIG_ENDIAN ? 10 : 8;
                bl = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported BufferedImage format");
            }
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (bl) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)bufferedImage.getSampleModel();
            int n2 = singlePixelPackedSampleModel.getScanlineStride();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            int[] nArray = dataBufferInt.getData();
            if (this.yuvImage != null) {
                this.checkSubsampling();
                this.decodeYUV8(this.yuvImage.getPlanes(), this.yuvImage.getOffsets(), this.yuvImage.getStrides(), nArray, 0, 0, this.yuvImage.getWidth(), n2, this.yuvImage.getHeight(), n);
            } else {
                if (this.jpegBuf == null) {
                    throw new IllegalStateException(NO_ASSOC_ERROR);
                }
                this.decompress8(this.jpegBuf, this.jpegBufSize, nArray, 0, 0, n2, n);
            }
        } else {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)bufferedImage.getSampleModel();
            int n3 = componentSampleModel.getPixelStride();
            if (n3 != TJ.getPixelSize(n)) {
                throw new IllegalArgumentException("Inconsistency between pixel format and pixel size in BufferedImage");
            }
            int n4 = componentSampleModel.getScanlineStride();
            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
            byte[] byArray = dataBufferByte.getData();
            this.decompress8(byArray, 0, 0, n4, n);
        }
    }

    @Deprecated
    public void decompress(BufferedImage bufferedImage, int n) throws TJException {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid argument in decompress()");
        }
        if (this.yuvImage == null) {
            TJScalingFactor tJScalingFactor = this.getScalingFactor(bufferedImage.getWidth(), bufferedImage.getHeight());
            if (tJScalingFactor.getScaled(this.getJPEGWidth()) != bufferedImage.getWidth() || tJScalingFactor.getScaled(this.getJPEGHeight()) != bufferedImage.getHeight()) {
                throw new IllegalArgumentException("BufferedImage dimensions do not match one of the scaled image sizes that TurboJPEG is capable of generating.");
            }
            this.setScalingFactor(tJScalingFactor);
        }
        this.processFlags(n);
        this.decompress8(bufferedImage);
    }

    public BufferedImage decompress8(int n) throws TJException {
        BufferedImage bufferedImage = new BufferedImage(this.scalingFactor.getScaled(this.getJPEGWidth()), this.scalingFactor.getScaled(this.getJPEGHeight()), n);
        this.decompress8(bufferedImage);
        return bufferedImage;
    }

    @Deprecated
    public BufferedImage decompress(int n, int n2, int n3, int n4) throws TJException {
        if (this.yuvImage == null && (n < 0 || n2 < 0) || n4 < 0) {
            throw new IllegalArgumentException("Invalid argument in decompress()");
        }
        if (this.yuvImage == null) {
            TJScalingFactor tJScalingFactor = this.getScalingFactor(n, n2);
            this.setScalingFactor(tJScalingFactor);
        }
        this.processFlags(n4);
        return this.decompress8(n3);
    }

    @Override
    public void close() throws TJException {
        if (this.handle != 0L) {
            this.destroy();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (TJException tJException) {
        }
        finally {
            super.finalize();
        }
    }

    final void processFlags(int n) {
        this.set(1, (n & 2) != 0 ? 1 : 0);
        this.set(9, (n & 0x100) != 0 ? 1 : 0);
        this.set(10, (n & 0x800) != 0 ? 1 : 0);
        this.set(0, (n & 0x2000) != 0 ? 1 : 0);
        this.set(13, (n & 0x8000) != 0 ? 500 : 0);
    }

    final void checkSubsampling() {
        if (this.get(4) == -1) {
            throw new IllegalStateException("Unknown or unspecified subsampling level");
        }
    }

    private native void init() throws TJException;

    private native void destroy() throws TJException;

    private native void decompressHeader(byte[] var1, int var2) throws TJException;

    private native void setCroppingRegion() throws TJException;

    private native void decompress8(byte[] var1, int var2, byte[] var3, int var4, int var5, int var6, int var7) throws TJException;

    private native void decompress12(byte[] var1, int var2, short[] var3, int var4, int var5, int var6, int var7) throws TJException;

    private native void decompress16(byte[] var1, int var2, short[] var3, int var4, int var5, int var6, int var7) throws TJException;

    private native void decompress8(byte[] var1, int var2, int[] var3, int var4, int var5, int var6, int var7) throws TJException;

    private native void decompressToYUV8(byte[] var1, int var2, byte[][] var3, int[] var4, int[] var5) throws TJException;

    private native void decodeYUV8(byte[][] var1, int[] var2, int[] var3, byte[] var4, int var5, int var6, int var7, int var8, int var9, int var10) throws TJException;

    private native void decodeYUV8(byte[][] var1, int[] var2, int[] var3, int[] var4, int var5, int var6, int var7, int var8, int var9, int var10) throws TJException;

    public native void saveImage(int var1, String var2, Object var3, int var4, int var5, int var6, int var7) throws TJException;

    static {
        TJLoader.load();
    }
}

