// Generated by gmmproc 2.80.0 -- DO NOT MODIFY!
#ifndef _GTKMM_FONTDIALOG_H
#define _GTKMM_FONTDIALOG_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2022 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/object.h>
#include <giomm/asyncresult.h>
#include <giomm/cancellable.h>
#include <pangomm/fontdescription.h>
#include <pangomm/fontface.h>
#include <pangomm/fontfamily.h>
#include <pangomm/fontmap.h>
#include <pangomm/language.h>
#include <gtkmm/filter.h>
#include <gtk/gtk.h>
#include <tuple>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API FontDialog_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{
class Window;

/** A %Gtk::FontDialog object collects the arguments that
 * are needed to present a font chooser dialog to the
 * user, such as a title for the dialog and whether it
 * should be modal.
 *
 * The dialog is shown with the choose_font() method or its variants.
 * This API follows the GIO async pattern,
 * and the result can be obtained by calling the corresponding
 * finish method, such as choose_font_finish().
 *
 * See Gtk::FontDialogButton for a convenient control
 * that uses %Gtk::FontDialog and presents the results.
 *
 * @ingroup Dialogs
 * @newin{4,10}
 */

class GTKMM_API FontDialog : public Glib::Object
{
   
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = FontDialog;
  using CppClassType = FontDialog_Class;
  using BaseObjectType = GtkFontDialog;
  using BaseClassType = GtkFontDialogClass;

  // noncopyable
  FontDialog(const FontDialog&) = delete;
  FontDialog& operator=(const FontDialog&) = delete;

private:  friend class FontDialog_Class;
  static CppClassType fontdialog_class_;

protected:
  explicit FontDialog(const Glib::ConstructParams& construct_params);
  explicit FontDialog(GtkFontDialog* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  FontDialog(FontDialog&& src) noexcept;
  FontDialog& operator=(FontDialog&& src) noexcept;

  ~FontDialog() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkFontDialog*       gobj()       { return reinterpret_cast<GtkFontDialog*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkFontDialog* gobj() const { return reinterpret_cast<GtkFontDialog*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkFontDialog* gobj_copy();

private:

     
protected:
  FontDialog();

public:
  
  static Glib::RefPtr<FontDialog> create();


  /** Returns the title that will be shown on the
   * font chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The title.
   */
  Glib::ustring get_title() const;
  
  /** Sets the title that will be shown on the
   * font chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @param title The new title.
   */
  void set_title(const Glib::ustring& title);
  
  /** Returns whether the font chooser dialog
   * blocks interaction with the parent window
   * while it is presented.
   * 
   * @newin{4,10}
   * 
   * @return <tt>true</tt> if the font chooser dialog is modal.
   */
  bool get_modal() const;
  
  /** Sets whether the font chooser dialog
   * blocks interaction with the parent window
   * while it is presented.
   * 
   * @newin{4,10}
   * 
   * @param modal The new value.
   */
  void set_modal(bool modal =  true);
  
  /** Returns the language for which font features are applied.
   * 
   * @newin{4,10}
   * 
   * @return The language for font features.
   */
  Pango::Language get_language() const;
 

  /** Sets the language for which font features are applied.
   * 
   * @newin{4,10}
   * 
   * @param language The language for font features.
   */
  void set_language(const Pango::Language& language);

  
  /** Returns the fontmap from which fonts are selected,
   * or <tt>nullptr</tt> for the default fontmap.
   * 
   * @newin{4,10}
   * 
   * @return The fontmap.
   */
  Glib::RefPtr<Pango::FontMap> get_font_map();
  
  /** Returns the fontmap from which fonts are selected,
   * or <tt>nullptr</tt> for the default fontmap.
   * 
   * @newin{4,10}
   * 
   * @return The fontmap.
   */
  Glib::RefPtr<const Pango::FontMap> get_font_map() const;
  
  /** Sets the fontmap from which fonts are selected.
   * 
   * If @a fontmap is <tt>nullptr</tt>, the default fontmap is used.
   * 
   * @newin{4,10}
   * 
   * @param fontmap The fontmap.
   */
  void set_font_map(const Glib::RefPtr<Pango::FontMap>& fontmap);

  
  /** Returns the filter that decides which fonts to display
   * in the font chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The filter.
   */
  Glib::RefPtr<Filter> get_filter();
  
  /** Returns the filter that decides which fonts to display
   * in the font chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The filter.
   */
  Glib::RefPtr<const Filter> get_filter() const;
  
  /** Adds a filter that decides which fonts to display
   * in the font chooser dialog.
   * 
   * The `Gtk::Filter` must be able to handle both `Pango::FontFamily`
   * and `Pango::FontFace` objects.
   * 
   * @newin{4,10}
   * 
   * @param filter A `Gtk::Filter`.
   */
  void set_filter(const Glib::RefPtr<Filter>& filter);

 
  /** This function initiates a font selection operation by
   * presenting a dialog to the user for selecting a font family.
   * 
   * The @a slot will be called when the dialog is dismissed.
   * It should call choose_family_finish()
   * to obtain the result.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent `Gtk::Window`.
   * @param initial_value The initial value.
   * @param cancellable A `Cancellable` to cancel the operation.
   * @param slot A callback to call when the operation is complete.
   */
  void choose_family(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Pango::FontFamily>& initial_value =  {}, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  /// A choose_family() convenience overload.
  void choose_family(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Pango::FontFamily>& initial_value =  {}, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});
  
  /** Finishes the choose_family() call
   * and returns the resulting family.
   * 
   * This function never returns an error. If the operation is
   * not finished successfully, the value passed as @a initial_value
   * to choose_family() is returned.
   * 
   * @newin{4,10}
   * 
   * @param result A `Gio::AsyncResult`.
   * @return The selected family.
   * 
   * @throws Gtk::DialogError
   */
  Glib::RefPtr<Pango::FontFamily> choose_family_finish(const Glib::RefPtr<Gio::AsyncResult>& result);

 
  /** This function initiates a font selection operation by
   * presenting a dialog to the user for selecting a font face
   * (i.e.\ a font family and style, but not a specific font size).
   * 
   * The @a slot will be called when the dialog is dismissed.
   * It should call choose_face_finish()
   * to obtain the result.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent `Gtk::Window`.
   * @param initial_value The initial value.
   * @param cancellable A `Cancellable` to cancel the operation.
   * @param slot A callback to call when the operation is complete.
   */
  void choose_face(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Pango::FontFace>& initial_value =  {}, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});

  /// A choose_face() convenience overload.
  void choose_face(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Pango::FontFace>& initial_value =  {}, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {});
  
  /** Finishes the choose_face() call
   * and returns the resulting font face.
   * 
   * @newin{4,10}
   * 
   * @param result A `Gio::AsyncResult`.
   * @return The selected font face.
   * 
   * @throws Gtk::DialogError
   */
  Glib::RefPtr<Pango::FontFace> choose_face_finish(const Glib::RefPtr<Gio::AsyncResult>& result);

  
  /** This function initiates a font selection operation by
   * presenting a dialog to the user for selecting a font.
   * 
   * The @a slot will be called when the dialog is dismissed.
   * It should call choose_font_finish()
   * to obtain the result.
   * 
   * If you want to let the user select font features as well,
   * use choose_font_and_features() instead.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent `Gtk::Window`.
   * @param initial_value The font to select initially.
   * @param cancellable A `Cancellable` to cancel the operation.
   * @param slot A callback to call when the operation is complete.
   */
  void choose_font(Window& parent, const Gio::SlotAsyncReady& slot, const Pango::FontDescription& initial_value, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;

  /// A choose_font() convenience overload.
  void choose_font(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;

  /// A choose_font() convenience overload.
  void choose_font(const Gio::SlotAsyncReady& slot, const Pango::FontDescription& initial_value, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;

  /// A choose_font() convenience overload.
  void choose_font(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;
 

  /** Finishes the choose_font() call
   * and returns the resulting font description.
   * 
   * @newin{4,10}
   * 
   * @param result A `Gio::AsyncResult`.
   * @return The selected font.
   * 
   * @throws Gtk::DialogError
   */
  Pango::FontDescription choose_font_finish(const Glib::RefPtr<Gio::AsyncResult>& result) const;

  
  /** This function initiates a font selection operation by
   * presenting a dialog to the user for selecting a font and
   * font features.
   * 
   * Font features affect how the font is rendered, for example
   * enabling glyph variants or ligatures.
   * 
   * The @a slot will be called when the dialog is dismissed.
   * It should call choose_font_and_features_finish()
   * to obtain the result.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent `Gtk::Window`.
   * @param initial_value The font to select initially.
   * @param cancellable A `Cancellable` to cancel the operation.
   * @param slot A callback to call when the operation is complete.
   */
  void choose_font_and_features(Window& parent, const Gio::SlotAsyncReady& slot, const Pango::FontDescription& initial_value, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;

  /// A choose_font_and_features() convenience overload.
  void choose_font_and_features(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;

  /// A choose_font_and_features() convenience overload.
  void choose_font_and_features(const Gio::SlotAsyncReady& slot, const Pango::FontDescription& initial_value, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;

  /// A choose_font_and_features() convenience overload.
  void choose_font_and_features(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;

  /** Finishes the choose_font_and_features() call
   * and returns the resulting font description and font features.
   *
   * You can use structured binding or std::tie() to get the return value.
   * @code
   * auto [font_desc, font_features, language] =
   *   font_dialog->choose_font_and_features_finish(result);
   *
   * // or
   * Pango::FontDescription font_desc;
   * Glib::ustring font_features;
   * Pango::Language language;
   * std::tie(font_desc, font_features, language) =
   *   font_dialog->choose_font_and_features_finish(result);
   *
   * // or, if you don't need all return values, for instance
   * std::tie(font_desc, font_features, std::ignore) =
   *   font_dialog->choose_font_and_features_finish(result);
   * @endcode
   * 
   * @newin{4,10}
   * 
   * @param result A Gio::AsyncResult.
   * @return {font_desc, font_features, language} A Pango::FontDescription,
   *   a Glib::ustring with font features, and a Pango::Language.
   *
   * @throws Gtk::DialogError
   */
  std::tuple<Pango::FontDescription, Glib::ustring, Pango::Language>
  choose_font_and_features_finish(const Glib::RefPtr<Gio::AsyncResult>& result) const;
  

  /** A title that may be shown on the font chooser
   * dialog that is presented by Gtk::FontDialog::choose_font().
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_title() ;

/** A title that may be shown on the font chooser
   * dialog that is presented by Gtk::FontDialog::choose_font().
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_title() const;

  /** Whether the font chooser dialog is modal.
   * 
   * @newin{4,10}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_modal() ;

/** Whether the font chooser dialog is modal.
   * 
   * @newin{4,10}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_modal() const;

  /** The language for which the font features are selected.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Pango::Language > property_language() ;

/** The language for which the font features are selected.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Pango::Language > property_language() const;

  /** Sets a custom font map to select fonts from.
   * 
   * A custom font map can be used to present application-specific
   * fonts instead of or in addition to the normal system fonts.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Pango::FontMap> > property_font_map() ;

/** Sets a custom font map to select fonts from.
   * 
   * A custom font map can be used to present application-specific
   * fonts instead of or in addition to the normal system fonts.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Pango::FontMap> > property_font_map() const;

  /** Sets a filter to restrict what fonts are shown
   * in the font chooser dialog.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Filter> > property_filter() ;

/** Sets a filter to restrict what fonts are shown
   * in the font chooser dialog.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Filter> > property_filter() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::FontDialog
   */
  GTKMM_API
  Glib::RefPtr<Gtk::FontDialog> wrap(GtkFontDialog* object, bool take_copy = false);
}


#endif /* _GTKMM_FONTDIALOG_H */

