/* granite.vapi generated by valac 0.56.13, do not modify. */

[CCode (gir_namespace = "Granite", gir_version = "1.0")]
namespace Granite {
	namespace DateTime {
		[CCode (cheader_filename = "granite.h")]
		public static string get_default_date_format (bool with_weekday = false, bool with_day = true, bool with_year = false);
		[CCode (cheader_filename = "granite.h")]
		public static string get_default_time_format (bool is_12h = false, bool with_second = false);
		[CCode (cheader_filename = "granite.h")]
		public static string get_relative_datetime (GLib.DateTime date_time);
		[CCode (cheader_filename = "granite.h")]
		public static bool is_same_day (GLib.DateTime day1, GLib.DateTime day2);
		[CCode (cheader_filename = "granite.h")]
		public static string seconds_to_time (int seconds);
	}
	namespace Drawing {
		[CCode (cheader_filename = "granite.h")]
		public class BufferSurface : GLib.Object {
			public BufferSurface (int width, int height);
			public Granite.Drawing.Color average_color ();
			public void clear ();
			public void exponential_blur (int radius);
			public void fast_blur (int radius, int process_count = 1);
			public void gaussian_blur (int radius);
			public Gdk.Pixbuf load_to_pixbuf ();
			public BufferSurface.with_buffer_surface (int width, int height, Granite.Drawing.BufferSurface model);
			public BufferSurface.with_surface (int width, int height, Cairo.Surface model);
			public Cairo.Context context { get; }
			public int height { get; private set; }
			public Cairo.Surface surface { get; private set; }
			public int width { get; private set; }
		}
		[CCode (cheader_filename = "granite.h")]
		public class Color : GLib.Object, Granite.Services.SettingsSerializable {
			public double A;
			public double B;
			public double G;
			public double R;
			public Color (double R, double G, double B, double A);
			public Granite.Drawing.Color add_hue (double val);
			public static uint8 alpha_from_int (int color);
			public static uint8 blue_from_int (int color);
			public Granite.Drawing.Color brighten_val (double amount);
			public Granite.Drawing.Color darken_by_sat (double amount);
			public Granite.Drawing.Color darken_val (double amount);
			public Color.from_gdk (Gdk.Color color);
			public Color.from_int (int color);
			public Color.from_rgba (Gdk.RGBA color);
			public Color.from_string (string color);
			public double get_hue ();
			public double get_sat ();
			public double get_val ();
			public static uint8 green_from_int (int color);
			public Granite.Drawing.Color multiply_sat (double amount);
			public static uint8 red_from_int (int color);
			public Granite.Drawing.Color set_alpha (double alpha);
			public Granite.Drawing.Color set_hue (double hue);
			public Granite.Drawing.Color set_max_sat (double sat);
			public Granite.Drawing.Color set_max_val (double val);
			public Granite.Drawing.Color set_min_sat (double sat);
			public Granite.Drawing.Color set_min_value (double val);
			public Granite.Drawing.Color set_sat (double sat);
			public Granite.Drawing.Color set_val (double val);
			public int to_int ();
			public string to_string ();
		}
		[CCode (cheader_filename = "granite.h")]
		public class Utilities : GLib.Object {
			public Utilities ();
			public static Granite.Drawing.Color average_color (Gdk.Pixbuf source);
			public static void cairo_rounded_rectangle (Cairo.Context cr, double x, double y, double width, double height, double radius);
		}
	}
	namespace FDO {
	}
	namespace Pantheon {
	}
	namespace Portal {
	}
	[CCode (gir_namespace = "GraniteServices", gir_version = "1.0")]
	namespace Services {
		namespace Application {
			[CCode (cheader_filename = "granite.h")]
			public static async bool set_badge (int64 count) throws GLib.Error;
			[CCode (cheader_filename = "granite.h")]
			public static async bool set_badge_visible (bool visible) throws GLib.Error;
			[CCode (cheader_filename = "granite.h")]
			public static async bool set_progress (double progress) throws GLib.Error;
			[CCode (cheader_filename = "granite.h")]
			public static async bool set_progress_visible (bool visible) throws GLib.Error;
		}
		[CCode (cheader_filename = "granite.h")]
		public class ContractorProxy : GLib.Object {
			public static Gee.List<Granite.Services.Contract> get_all_contracts () throws GLib.Error;
			public static Gee.List<Granite.Services.Contract> get_contracts_by_mime (string mime_type) throws GLib.Error;
			public static Gee.List<Granite.Services.Contract> get_contracts_by_mimelist (string[] mime_types) throws GLib.Error;
			public static Gee.List<Granite.Services.Contract> get_contracts_for_file (GLib.File file) throws GLib.Error;
			public static Gee.List<Granite.Services.Contract> get_contracts_for_files (GLib.File[] files) throws GLib.Error;
			public static Granite.Services.ContractorProxy get_instance () throws GLib.Error;
			public signal void contracts_changed ();
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "5.2.4", replacement = "")]
		public class IconFactory : GLib.Object {
			public IconFactory ();
			public static Granite.Services.IconFactory get_default ();
			[Version (deprecated = true, deprecated_since = "5.2.4", replacement = "")]
			public Gdk.Pixbuf? load_symbolic_icon (Gtk.StyleContext style, string iconname, int size);
			[Version (deprecated = true, deprecated_since = "5.2.4", replacement = "")]
			public Gdk.Pixbuf? load_symbolic_icon_from_gicon (Gtk.StyleContext style, GLib.Icon gicon, int size);
		}
		[CCode (cheader_filename = "granite.h")]
		public class Logger : GLib.Object {
			public Logger ();
			public static void initialize (string app_name);
			public static void notification (string msg);
			public static Granite.Services.LogLevel DisplayLevel { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "5.5.0", replacement = "GLib.Environment")]
		public class Paths : GLib.Object {
			public Paths ();
			public static bool ensure_directory_exists (GLib.File dir);
			public static void initialize (string app_name, string data_folder_path);
			public static GLib.File data_folder { get; protected set; }
			public static GLib.File home_folder { get; protected set; }
			public static GLib.File user_cache_folder { get; protected set; }
			public static GLib.File user_config_folder { get; protected set; }
			public static GLib.File user_data_folder { get; protected set; }
			public static GLib.File xdg_cache_home_folder { get; protected set; }
			public static GLib.File xdg_config_home_folder { get; protected set; }
			public static GLib.List<GLib.File> xdg_data_dir_folders { get; protected owned set; }
			public static GLib.File xdg_data_home_folder { get; protected set; }
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "5.4.0", replacement = "GLib.Settings")]
		public abstract class Settings : GLib.Object {
			protected Settings (string schema);
			protected virtual void verify (string key);
			protected Settings.with_backend (string schema, GLib.SettingsBackend backend);
			protected Settings.with_backend_and_path (string schema, GLib.SettingsBackend backend, string path);
			protected Settings.with_path (string schema, string path);
			public GLib.Settings schema { get; construct; }
			[Signal (action = true, detailed = true, no_hooks = true, no_recurse = true, run = "first")]
			public signal void changed ();
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "5.5.0", replacement = "GLib.AppInfo.create_from_commandline")]
		public class SimpleCommand : GLib.Object {
			public string error_output_str;
			public string output_str;
			public string standard_output_str;
			public SimpleCommand (string dir, string command);
			public void run ();
			public signal void done (int exit);
			public signal void error_changed (string text);
			public signal void output_changed (string text);
			public signal void standard_changed (string text);
		}
		[CCode (cheader_filename = "granite.h")]
		public class System : GLib.Object {
			public System ();
			[Version (deprecated = true, deprecated_since = "5.2.4", replacement = "AppInfo.create_from_commandline")]
			public static bool execute_command (string command);
			public static bool history_is_enabled ();
			[Version (deprecated = true, deprecated_since = "5.2.4", replacement = "GLib.AppInfo.launch")]
			public static void launch (GLib.File app);
			[Version (deprecated = true, deprecated_since = "5.2.4", replacement = "GLib.AppInfo.launch")]
			public static void launch_with_files (GLib.File? app, GLib.File[] files);
			[Version (deprecated = true, deprecated_since = "5.2.4", replacement = "GLib.AppInfo.launch_default_for_uri")]
			public static void open (GLib.File file);
			[Version (deprecated = true, deprecated_since = "5.2.4", replacement = "GLib.AppInfo.launch_default_for_uri")]
			public static void open_files (GLib.File[] files);
			[Version (deprecated = true, deprecated_since = "5.2.4", replacement = "GLib.AppInfo.launch_default_for_uri")]
			public static void open_uri (string uri);
		}
		[CCode (cheader_filename = "granite.h")]
		public interface Contract : GLib.Object {
			public abstract void execute_with_file (GLib.File file) throws GLib.Error;
			public abstract void execute_with_files (GLib.File[] files) throws GLib.Error;
			public abstract string get_description ();
			public abstract string get_display_name ();
			public abstract GLib.Icon get_icon ();
		}
		[CCode (cheader_filename = "granite.h")]
		public interface SettingsSerializable : GLib.Object {
			public abstract void settings_deserialize (string s);
			public abstract string settings_serialize ();
		}
		[CCode (cheader_filename = "granite.h")]
		public enum LogLevel {
			DEBUG,
			INFO,
			NOTIFY,
			WARN,
			ERROR,
			FATAL
		}
		[CCode (cheader_filename = "granite.h")]
		public errordomain ContractorError {
			SERVICE_NOT_AVAILABLE
		}
		[CCode (cheader_filename = "granite.h")]
		public static Granite.Services.IconFactory? icon_factory;
	}
	namespace StyleClass {
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "Granite.STYLE_CLASS_BADGE")]
		public const string BADGE;
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "Granite.STYLE_CLASS_CATEGORY_EXPANDER")]
		public const string CATEGORY_EXPANDER;
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public const string COMPOSITED;
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public const string CONTENT_VIEW;
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public const string CONTENT_VIEW_WINDOW;
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public const string DECORATED_WINDOW;
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "Granite.STYLE_CLASS_H1_LABEL")]
		public const string H1_TEXT;
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "Granite.STYLE_CLASS_H2_LABEL")]
		public const string H2_TEXT;
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "Granite.STYLE_CLASS_H3_LABEL")]
		public const string H3_TEXT;
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public const string HELP_BUTTON;
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "Granite.STYLE_CLASS_OVERLAY_BAR")]
		public const string OVERLAY_BAR;
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "Gtk.STYLE_CLASS_POPOVER")]
		public const string POPOVER;
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public const string POPOVER_BG;
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "Granite.STYLE_CLASS_SOURCE_LIST")]
		public const string SOURCE_LIST;
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public const string THIN_PANE_SEPARATOR;
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "Gtk.STYLE_CLASS_TITLE")]
		public const string TITLE_TEXT;
	}
	namespace Widgets {
		namespace Utils {
			[CCode (cheader_filename = "granite.h")]
			[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
			public static void apply_text_style_to_label (Granite.TextStyle text_style, Gtk.Label label);
			[CCode (cheader_filename = "granite.h")]
			[Version (deprecated = true, deprecated_since = "5.5.0", replacement = "")]
			public static string? get_button_layout_schema ();
			[CCode (cheader_filename = "granite.h")]
			[Version (deprecated = true, deprecated_since = "5.5.0", replacement = "Gtk.CssProvider.load_from_data")]
			public static Gtk.CssProvider? get_css_provider (string stylesheet);
			[CCode (cheader_filename = "granite.h")]
			[Version (deprecated = true, deprecated_since = "5.5.0", replacement = "")]
			public static bool get_default_close_button_position (out Granite.CloseButtonPosition position);
			[CCode (cheader_filename = "granite.h")]
			public static Gtk.CssProvider? set_color_primary (Gtk.Widget window, Gdk.RGBA color, int priority = Gtk.STYLE_PROVIDER_PRIORITY_APPLICATION);
			[CCode (cheader_filename = "granite.h")]
			[Version (deprecated = true, deprecated_since = "5.5.0", replacement = "")]
			public static Gtk.CssProvider? set_theming (Gtk.Widget widget, string stylesheet, string? class_name, int priority);
			[CCode (cheader_filename = "granite.h")]
			[Version (deprecated = true, deprecated_since = "5.5.0", replacement = "Gtk.StyleContext.add_provider_for_screen")]
			public static Gtk.CssProvider? set_theming_for_screen (Gdk.Screen screen, string stylesheet, int priority);
		}
		[CCode (cheader_filename = "granite.h")]
		public class AlertView : Gtk.Grid {
			public AlertView (string title, string description, string icon_name);
			public void hide_action ();
			public void show_action (string? label = null);
			public string description { get; set; }
			public string icon_name { owned get; set; }
			public string title { get; set; }
			public signal void action_activated ();
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "6.0.0", replacement = "Hdy.Avatar")]
		public class Avatar : Gtk.EventBox {
			public Avatar ();
			public override bool draw (Cairo.Context cr);
			public Avatar.from_file (string filepath, int pixel_size);
			public Avatar.from_pixbuf (Gdk.Pixbuf pixbuf);
			public void show_default (int pixel_size);
			public Avatar.with_default_icon (int pixel_size);
			public Gdk.Pixbuf? pixbuf { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		public class CellRendererBadge : Gtk.CellRenderer {
			public CellRendererBadge ();
			public override void get_preferred_height_for_width (Gtk.Widget widget, int width, out int minimum_height, out int natural_height);
			public override void get_preferred_width (Gtk.Widget widget, out int minimum_size, out int natural_size);
			public override Gtk.SizeRequestMode get_request_mode ();
			public override void render (Cairo.Context context, Gtk.Widget widget, Gdk.Rectangle bg_area, Gdk.Rectangle cell_area, Gtk.CellRendererState flags);
			public string text { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		public class CellRendererExpander : Gtk.CellRenderer {
			public CellRendererExpander ();
			public virtual int get_arrow_size (Gtk.Widget widget);
			public override void get_preferred_height_for_width (Gtk.Widget widget, int width, out int minimum_height, out int natural_height);
			public override void get_preferred_width (Gtk.Widget widget, out int minimum_size, out int natural_size);
			public override Gtk.SizeRequestMode get_request_mode ();
			public override void render (Cairo.Context context, Gtk.Widget widget, Gdk.Rectangle bg_area, Gdk.Rectangle cell_area, Gtk.CellRendererState flags);
			public bool is_category_expander { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "5.5.0", replacement = "Gtk.Paned")]
		public class CollapsiblePaned : Gtk.Paned {
			public CollapsiblePaned (Gtk.Orientation orientation);
			public Granite.CollapseMode collapse_mode { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		[Version (deprecated = true, deprecated_since = "5.5.0", replacement = "Gtk.Window")]
		public class CompositedWindow : Gtk.Window, Gtk.Buildable {
			public CompositedWindow ();
		}
		[CCode (cheader_filename = "granite.h")]
		public class DatePicker : Gtk.Entry, Gtk.Buildable {
			protected Gtk.Calendar calendar;
			protected Gtk.EventBox dropdown;
			public DatePicker ();
			protected virtual void position_dropdown (out Gdk.Rectangle rect);
			public DatePicker.with_format (string format);
			public GLib.DateTime date { get; set; }
			public string format { get; construct; }
			public signal void date_changed ();
		}
		[CCode (cheader_filename = "granite.h")]
		public class DynamicNotebook : Gtk.EventBox {
			public enum TabBarBehavior {
				ALWAYS,
				SINGLE,
				NEVER
			}
			public DynamicNotebook ();
			public new GLib.List<Gtk.Widget> get_children ();
			public Gtk.Widget get_nth_page (int index);
			public Granite.Widgets.Tab? get_tab_by_index (int index);
			public Granite.Widgets.Tab? get_tab_by_widget (Gtk.Widget widget);
			public int get_tab_position (Granite.Widgets.Tab tab);
			public uint insert_tab (Granite.Widgets.Tab tab, int index);
			public void next_page ();
			public void previous_page ();
			public void remove_tab (Granite.Widgets.Tab tab);
			public void set_tab_position (Granite.Widgets.Tab tab, int position);
			public override void show ();
			public DynamicNotebook.with_accellabels (Granite.AccelLabel new_tab_label = new Granite.AccelLabel (GLib._ ("New Tab"), null), Granite.AccelLabel restore_tab_label = new Granite.AccelLabel (GLib._ ("Undo Close Tab"), null));
			public string add_button_tooltip { get; set; }
			public bool add_button_visible { get; set; }
			public bool allow_drag { get; set; }
			public bool allow_duplication { get; set; }
			public bool allow_new_window { get; set; }
			public bool allow_pinning { get; set; }
			public bool allow_restoring { get; set; }
			public Granite.Widgets.Tab current { get; set; }
			public bool force_left { get; set; }
			public string group_name { get; set; }
			public int max_restorable_tabs { get; set; }
			public Gtk.Menu menu { get; private set; }
			public int n_tabs { get; }
			public Granite.AccelLabel new_tab_label { get; construct; }
			public Granite.AccelLabel restore_tab_label { get; construct; }
			public bool show_tabs { get; set; }
			public Granite.Widgets.DynamicNotebook.TabBarBehavior tab_bar_behavior { get; set; }
			public GLib.List<Granite.Widgets.Tab> tabs { get; }
			public bool tabs_closable { get; set; }
			public signal bool close_tab_requested (Granite.Widgets.Tab tab);
			public signal void new_tab_requested ();
			public signal void tab_added (Granite.Widgets.Tab tab);
			public signal void tab_duplicated (Granite.Widgets.Tab duplicated_tab);
			public signal void tab_moved (Granite.Widgets.Tab tab, int x, int y);
			public signal void tab_removed (Granite.Widgets.Tab tab);
			public signal void tab_reordered (Granite.Widgets.Tab tab, int new_pos);
			public signal void tab_restored (string label, string data, GLib.Icon? icon);
			public signal void tab_switched (Granite.Widgets.Tab? old_tab, Granite.Widgets.Tab new_tab);
		}
		[CCode (cheader_filename = "granite.h")]
		public class ModeButton : Gtk.Box {
			public ModeButton ();
			public int append (Gtk.Widget w);
			public int append_icon (string icon_name, Gtk.IconSize size);
			public int append_pixbuf (Gdk.Pixbuf pixbuf);
			public int append_text (string text);
			public void clear_children ();
			public new void remove (int index);
			public void set_active (int new_active_index);
			public void set_item_visible (int index, bool val);
			public uint n_items { get; }
			public int selected { get; set; }
			public signal void mode_added (int index, Gtk.Widget widget);
			public signal void mode_changed (Gtk.Widget widget);
			public signal void mode_removed (int index, Gtk.Widget widget);
		}
		[CCode (cheader_filename = "granite.h")]
		public class OverlayBar : Gtk.EventBox {
			public OverlayBar (Gtk.Overlay? overlay = null);
			public override void parent_set (Gtk.Widget? old_parent);
			public bool active { get; set; }
			public string label { get; set; }
			[Version (deprecated = true, deprecated_since = "0.5.1", replacement = "")]
			public Gtk.Overlay? overlay { get; construct; }
			[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "OverlayBar.label")]
			public string status { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		public class SourceList : Gtk.ScrolledWindow {
			public class ExpandableItem : Granite.Widgets.SourceList.Item {
				public ExpandableItem (string name = "");
				public void add (Granite.Widgets.SourceList.Item item);
				public void clear ();
				public void collapse_all (bool inclusive = true, bool recursive = true);
				public void collapse_with_parents ();
				public bool contains (Granite.Widgets.SourceList.Item item);
				public void expand_all (bool inclusive = true, bool recursive = true);
				public void expand_with_parents ();
				public void remove (Granite.Widgets.SourceList.Item item);
				public Gee.Collection<Granite.Widgets.SourceList.Item> children { owned get; }
				public bool collapsible { get; set; }
				public bool expanded { get; set; }
				public uint n_children { get; }
				public signal void child_added (Granite.Widgets.SourceList.Item item);
				public signal void child_removed (Granite.Widgets.SourceList.Item item);
				public virtual signal void toggled ();
			}
			public class Item : GLib.Object {
				public Item (string name = "");
				public virtual Gtk.Menu? get_context_menu ();
				public GLib.Icon activatable { get; set; }
				public string activatable_tooltip { get; set; }
				public string badge { get; set; }
				public bool editable { get; set; }
				public GLib.Icon icon { get; set; }
				public string? markup { get; set; }
				public string name { get; set; }
				public Granite.Widgets.SourceList.ExpandableItem parent { get; internal set; }
				public bool selectable { get; set; }
				public string? tooltip { get; set; }
				public bool visible { get; set; }
				public virtual signal void action_activated ();
				public virtual signal void activated ();
				public virtual signal void edited (string new_name);
			}
			public delegate bool VisibleFunc (Granite.Widgets.SourceList.Item item);
			public SourceList (Granite.Widgets.SourceList.ExpandableItem root = new Granite.Widgets.SourceList.ExpandableItem (""));
			public void disable_drag_dest ();
			public void disable_drag_source ();
			public void enable_drag_dest (Gtk.TargetEntry[] dest_entries, Gdk.DragAction actions);
			public void enable_drag_source (Gtk.TargetEntry[] src_entries);
			public Granite.Widgets.SourceList.Item? get_first_child (Granite.Widgets.SourceList.ExpandableItem parent);
			public Granite.Widgets.SourceList.Item? get_last_child (Granite.Widgets.SourceList.ExpandableItem parent);
			public uint get_n_visible_children (Granite.Widgets.SourceList.ExpandableItem parent);
			public Granite.Widgets.SourceList.Item? get_next_item (Granite.Widgets.SourceList.Item reference);
			public Granite.Widgets.SourceList.Item? get_previous_item (Granite.Widgets.SourceList.Item reference);
			public bool has_item (Granite.Widgets.SourceList.Item item);
			public bool is_item_expanded (Granite.Widgets.SourceList.Item item);
			public void refilter ();
			public bool scroll_to_item (Granite.Widgets.SourceList.Item item, bool expand_parents = true, bool use_align = false, float row_align = 0);
			public void set_filter_func (Granite.Widgets.SourceList.VisibleFunc? visible_func, bool refilter);
			public bool start_editing_item (Granite.Widgets.SourceList.Item item);
			public void stop_editing ();
			public bool editing { get; }
			public Pango.EllipsizeMode ellipsize_mode { get; set; }
			public Granite.Widgets.SourceList.ExpandableItem root { get; set; }
			public Granite.Widgets.SourceList.Item? selected { get; set; }
			public virtual signal void item_selected (Granite.Widgets.SourceList.Item? item);
		}
		[CCode (cheader_filename = "granite.h")]
		public class StorageBar : Gtk.Box {
			public enum ItemDescription {
				OTHER,
				AUDIO,
				VIDEO,
				PHOTO,
				APP,
				FILES;
				public static string? get_class (Granite.Widgets.StorageBar.ItemDescription description);
				public static string get_name (Granite.Widgets.StorageBar.ItemDescription description);
			}
			public StorageBar (uint64 storage);
			public void update_block_size (Granite.Widgets.StorageBar.ItemDescription description, uint64 size);
			public StorageBar.with_total_usage (uint64 storage, uint64 total_usage);
			public int inner_margin_sides { get; set; }
			public uint64 storage { get; set; }
			public uint64 total_usage { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		public class Tab : Gtk.EventBox {
			public Granite.WidgetsDroppedDelegate dropped_callback;
			public Tab (string? label = null, GLib.Icon? icon = null, Gtk.Widget? page = null);
			public void close ();
			public Tab.with_accellabels (string? label = null, GLib.Icon? icon = null, Gtk.Widget? page = null, Granite.AccelLabel? _close_tab_label = null, Granite.AccelLabel? _duplicate_tab_label = null, Granite.AccelLabel? _new_window_label = null);
			public Granite.AccelLabel? close_tab_label { get; construct; }
			public Granite.AccelLabel? duplicate_tab_label { get; construct; }
			public Pango.EllipsizeMode ellipsize_mode { get; set; }
			public GLib.Icon? icon { owned get; set; }
			public string label { get; set; }
			public Gtk.Menu menu { get; set; }
			public Granite.AccelLabel? new_window_label { get; construct; }
			public Gtk.Widget page { get; set; }
			public bool pinnable { get; set; }
			public bool pinned { get; set; }
			public string restore_data { get; set; }
			public string tooltip { set; }
			public bool working { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		public class TimePicker : Gtk.Entry {
			public TimePicker ();
			[Version (deprecated = true, deprecated_since = "5.2.0")]
			protected virtual void position_dropdown (out int x, out int y);
			public TimePicker.with_format (string format_12, string format_24);
			public string format_12 { get; construct; }
			public string format_24 { get; construct; }
			public GLib.DateTime time { get; set; }
			public signal void time_changed ();
		}
		[CCode (cheader_filename = "granite.h")]
		public class Toast : Gtk.Revealer {
			public Toast (string title);
			public void send_notification ();
			public void set_default_action (string? label);
			public string title { get; set construct; }
			public signal void closed ();
			public signal void default_action ();
		}
		[CCode (cheader_filename = "granite.h")]
		public class Welcome : Gtk.EventBox {
			protected new GLib.List<Gtk.Button> children;
			protected Gtk.Grid options;
			public Welcome (string title_text, string subtitle_text);
			public int append (string icon_name, string option_text, string description_text);
			public int append_with_image (Gtk.Image? image, string option_text, string description_text);
			public int append_with_pixbuf (Gdk.Pixbuf? pixbuf, string option_text, string description_text);
			public Granite.Widgets.WelcomeButton? get_button_from_index (int index);
			public void remove_item (uint index);
			public void set_item_sensitivity (uint index, bool val);
			public void set_item_visible (uint index, bool val);
			public string subtitle { get; set; }
			public string title { get; set; }
			public signal void activated (int index);
		}
		[CCode (cheader_filename = "granite.h")]
		public class WelcomeButton : Gtk.Button {
			public WelcomeButton (Gtk.Image? image, string option_text, string description_text);
			public string description { get; set; }
			public Gtk.Image? icon { get; set; }
			public string title { get; set; }
		}
		[CCode (cheader_filename = "granite.h")]
		public interface SourceListDragDest : Granite.Widgets.SourceList.Item {
			public abstract bool data_drop_possible (Gdk.DragContext context, Gtk.SelectionData data);
			public abstract Gdk.DragAction data_received (Gdk.DragContext context, Gtk.SelectionData data);
		}
		[CCode (cheader_filename = "granite.h")]
		public interface SourceListDragSource : Granite.Widgets.SourceList.Item {
			public abstract bool draggable ();
			public abstract void prepare_selection_data (Gtk.SelectionData selection_data);
		}
		[CCode (cheader_filename = "granite.h")]
		public interface SourceListSortable : Granite.Widgets.SourceList.ExpandableItem {
			public abstract bool allow_dnd_sorting ();
			public abstract int compare (Granite.Widgets.SourceList.Item a, Granite.Widgets.SourceList.Item b);
			public signal void user_moved_item (Granite.Widgets.SourceList.Item moved);
		}
	}
	[CCode (cheader_filename = "granite.h")]
	public class AccelLabel : Gtk.Grid {
		public AccelLabel (string label, string? accel_string = null);
		public AccelLabel.from_action_name (string label, string action_name);
		public string? accel_string { get; set construct; }
		public string action_name { get; set construct; }
		public string label { get; set construct; }
	}
	[CCode (cheader_filename = "granite.h")]
	[Version (deprecated = true, deprecated_since = "0.5.0", replacement = "Gtk.Application")]
	public abstract class Application : Gtk.Application {
		protected static bool DEBUG;
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public string[] about_artists;
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public string[] about_authors;
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public string about_comments;
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public string[] about_documenters;
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public string about_license;
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public Gtk.License about_license_type;
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public string about_translators;
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public string app_copyright;
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public string app_icon;
		public string app_launcher;
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public string app_years;
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public string bug_url;
		public string build_data_dir;
		public string build_pkg_data_dir;
		public string build_release_name;
		public string build_version;
		public string build_version_info;
		public string exec_name;
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public string help_url;
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public string main_url;
		public string program_name;
		[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
		public string translate_url;
		protected const GLib.OptionEntry[] options;
		protected Application ();
		public new int run (string[] args);
		protected virtual void set_options ();
	}
	[CCode (cheader_filename = "granite.h")]
	public class AsyncImage : Gtk.Image {
		public AsyncImage (bool load_on_realize = true, bool auto_size_request = true);
		public AsyncImage.from_gicon_async (GLib.Icon icon, int size, bool load_on_realize = true, bool auto_size_request = true);
		public AsyncImage.from_icon_name_async (string icon_name, Gtk.IconSize icon_size, bool load_on_realize = true, bool auto_size_request = true);
		public async void set_from_file_async (GLib.File file, int width, int height, bool preserve_aspect_ratio, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async void set_from_gicon_async (GLib.Icon icon, int size, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async void set_from_icon_name_async (string icon_name, Gtk.IconSize icon_size, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool auto_size_request { private get; construct; }
		public GLib.Icon? gicon_async { get; private set; }
		public bool load_on_realize { private get; construct; }
		public int size_async { get; private set; }
	}
	[CCode (cheader_filename = "granite.h")]
	public class Dialog : Gtk.Dialog {
		public Dialog ();
		public override void constructed ();
	}
	[CCode (cheader_filename = "granite.h")]
	public class HeaderLabel : Gtk.Label {
		public HeaderLabel (string label);
	}
	[CCode (cheader_filename = "granite.h")]
	public class HyperTextView : Gtk.TextView {
		public HyperTextView ();
	}
	[CCode (cheader_filename = "granite.h")]
	public class MessageDialog : Granite.Dialog {
		public MessageDialog (string primary_text, string secondary_text, GLib.Icon image_icon, Gtk.ButtonsType buttons = Gtk.ButtonsType.CLOSE);
		public void show_error_details (string error_message);
		public MessageDialog.with_image_from_icon_name (string primary_text, string secondary_text, string image_icon_name = "dialog-information", Gtk.ButtonsType buttons = Gtk.ButtonsType.CLOSE);
		public GLib.Icon badge_icon { owned get; set; }
		public Gtk.ButtonsType buttons { construct; }
		public Gtk.Bin custom_bin { get; construct; }
		public GLib.Icon image_icon { owned get; set; }
		public Gtk.Label primary_label { get; construct; }
		public string primary_text { get; set; }
		public Gtk.Label secondary_label { get; construct; }
		public string secondary_text { get; set; }
	}
	[CCode (cheader_filename = "granite.h")]
	public class ModeSwitch : Gtk.Grid {
		public ModeSwitch (GLib.Icon primary_icon_gicon, GLib.Icon secondary_icon_gicon);
		public ModeSwitch.from_icon_name (string primary_icon_name, string secondary_icon_name);
		public bool active { get; set; }
		public GLib.Icon primary_icon_gicon { get; set construct; }
		public string primary_icon_name { get; set construct; }
		public string primary_icon_tooltip_text { get; set; }
		public GLib.Icon secondary_icon_gicon { get; set construct; }
		public string secondary_icon_name { get; set construct; }
		public string secondary_icon_tooltip_text { get; set; }
	}
	[CCode (cheader_filename = "granite.h")]
	public class SeekBar : Gtk.Grid {
		public SeekBar (double playback_duration);
		public override void get_preferred_width (out int minimum_width, out int natural_width);
		public Gtk.Label duration_label { get; set construct; }
		public bool is_grabbing { get; private set; }
		public bool is_hovering { get; private set; }
		public double playback_duration { get; set; }
		public double playback_progress { get; set; }
		public Gtk.Label progression_label { get; set construct; }
		public Gtk.Scale scale { get; set construct; }
	}
	[CCode (cheader_filename = "granite.h")]
	public class Settings : GLib.Object {
		public enum ColorScheme {
			NO_PREFERENCE,
			DARK,
			LIGHT
		}
		public static unowned Granite.Settings get_default ();
		public Granite.Settings.ColorScheme prefers_color_scheme { get; private set; }
	}
	[CCode (cheader_filename = "granite.h")]
	public abstract class SettingsPage : Gtk.ScrolledWindow {
		public enum StatusType {
			ERROR,
			OFFLINE,
			SUCCESS,
			WARNING,
			NONE
		}
		protected string _icon_name;
		protected string _title;
		protected SettingsPage ();
		public Gtk.Widget? display_widget { get; construct; }
		public string? header { get; construct; }
		public string? icon_name { get; set construct; }
		public string status { get; set construct; }
		public Granite.SettingsPage.StatusType status_type { get; set; }
		public string title { get; set construct; }
	}
	[CCode (cheader_filename = "granite.h")]
	public class SettingsSidebar : Gtk.ScrolledWindow {
		public SettingsSidebar (Gtk.Stack stack);
		public Gtk.Stack stack { get; construct; }
		public string? visible_child_name { get; set; }
	}
	[CCode (cheader_filename = "granite.h")]
	public abstract class SimpleSettingsPage : Granite.SettingsPage {
		protected SimpleSettingsPage ();
		public Gtk.ButtonBox action_area { get; construct; }
		public bool activatable { get; construct; }
		public Gtk.Grid content_area { get; construct; }
		public string description { get; set construct; }
		public new string icon_name { get; set construct; }
		public Gtk.Switch? status_switch { get; construct; }
		public new string title { get; set construct; }
	}
	[CCode (cheader_filename = "granite.h")]
	public class SwitchModelButton : Gtk.ToggleButton {
		public SwitchModelButton (string text);
		public string? description { get; set; }
		public string text { get; set construct; }
	}
	[CCode (cheader_filename = "granite.h")]
	public class ValidatedEntry : Gtk.Entry {
		public ValidatedEntry ();
		public ValidatedEntry.from_regex (GLib.Regex regex_arg);
		public bool is_valid { get; set; }
		public int min_length { get; set; }
		public GLib.Regex regex { get; set construct; }
	}
	[CCode (cheader_filename = "granite.h")]
	public enum CloseButtonPosition {
		LEFT,
		RIGHT
	}
	[CCode (cheader_filename = "granite.h")]
	public enum CollapseMode {
		NONE,
		LEFT,
		TOP,
		FIRST,
		RIGHT,
		BOTTOM,
		LAST
	}
	[CCode (cheader_filename = "granite.h")]
	[Version (deprecated = true, deprecated_since = "0.4.2", replacement = "")]
	public enum TextStyle {
		TITLE,
		H1,
		H2,
		H3;
		public string get_stylesheet (out string style_class = null);
	}
	[CCode (cheader_filename = "granite.h")]
	public delegate void WidgetsDroppedDelegate ();
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_ACCENT;
	[CCode (cheader_filename = "granite.h")]
	[Version (deprecated = true, deprecated_since = "6.0.0", replacement = "")]
	public const string STYLE_CLASS_AVATAR;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_BACK_BUTTON;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_BADGE;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_CARD;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_CATEGORY_EXPANDER;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_CHECKERBOARD;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_COLOR_BUTTON;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_DEFAULT_DECORATION;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_H1_LABEL;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_H2_LABEL;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_H3_LABEL;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_H4_LABEL;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_KEYCAP;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_MODE_SWITCH;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_OVERLAY_BAR;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_PRIMARY_LABEL;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_ROUNDED;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_SEEKBAR;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_SMALL_LABEL;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_SOURCE_LIST;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_STORAGEBAR;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_TEMPERATURE;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_TERMINAL;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_WARMTH;
	[CCode (cheader_filename = "granite.h")]
	public const string STYLE_CLASS_WELCOME;
	[CCode (cheader_filename = "granite.h")]
	public const string TOOLTIP_SECONDARY_TEXT_MARKUP;
	[CCode (cheader_filename = "granite.h")]
	public const int TRANSITION_DURATION_CLOSE;
	[CCode (cheader_filename = "granite.h")]
	public const int TRANSITION_DURATION_IN_PLACE;
	[CCode (cheader_filename = "granite.h")]
	public const int TRANSITION_DURATION_OPEN;
	[CCode (cheader_filename = "granite.h")]
	public static string accel_to_string (string? accel);
	[CCode (cheader_filename = "granite.h")]
	public static Gdk.RGBA contrasting_foreground_color (Gdk.RGBA bg_color);
	[CCode (cheader_filename = "granite.h")]
	public static string markup_accel_tooltip (string[]? accels, string? description = null);
}
