#!/usr/bin/python
from __future__ import absolute_import, division, print_function
# Copyright 2019-2024 Fortinet, Inc.
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

__metaclass__ = type

ANSIBLE_METADATA = {'status': ['preview'],
                    'supported_by': 'community',
                    'metadata_version': '1.1'}

DOCUMENTATION = '''
---
module: fmgr_export_playbooks
short_description: Export fortimanager configuration as playbooks.
description:
    - This module is able to configure a FortiManager device.
    - Examples include all parameters and values which need to be adjusted to data sources before usage.

version_added: "2.1.0"
author:
    - Xinwei Du (@dux-fortinet)
    - Xing Li (@lix-fortinet)
    - Jie Xue (@JieX19)
    - Link Zheng (@chillancezen)
    - Frank Shen (@fshen01)
    - Hongbin Lu (@fgtdev-hblu)
notes:
    - Running in workspace locking mode is supported in this FortiManager module, the top
      level parameters workspace_locking_adom and workspace_locking_timeout help do the work.
    - Normally, running one module can fail when a non-zero rc is returned. you can also override
      the conditions to fail or succeed with parameters rc_failed and rc_succeeded
options:
    access_token:
        description: The token to access FortiManager without using username and password.
        required: false
        type: str
    enable_log:
        description: Enable/Disable logging for task.
        required: false
        type: bool
        default: false
    forticloud_access_token:
        description: Access token of FortiCloud managed API users, this option is available with FortiManager later than 6.4.0.
        required: false
        type: str
    workspace_locking_adom:
        description: The adom to lock for FortiManager running in workspace mode, the value can be global and others including root.
        required: false
        type: str
    workspace_locking_timeout:
        description: The maximum time in seconds to wait for other users to release workspace lock.
        required: false
        type: int
        default: 300
    export_playbooks:
        description: Export playbooks for selectors.
        type: dict
        required: true
        suboptions:
            selector:
                required: true
                description: Selector of the FortiManager object category.
                type: list
                elements: str
                choices:
                    - 'all'
                    - 'adom_options'
                    - 'antivirus_mmschecksum'
                    - 'antivirus_mmschecksum_entries'
                    - 'antivirus_notification'
                    - 'antivirus_notification_entries'
                    - 'antivirus_profile'
                    - 'antivirus_profile_cifs'
                    - 'antivirus_profile_contentdisarm'
                    - 'antivirus_profile_ftp'
                    - 'antivirus_profile_http'
                    - 'antivirus_profile_imap'
                    - 'antivirus_profile_mapi'
                    - 'antivirus_profile_nacquar'
                    - 'antivirus_profile_nntp'
                    - 'antivirus_profile_outbreakprevention'
                    - 'antivirus_profile_pop3'
                    - 'antivirus_profile_smb'
                    - 'antivirus_profile_smtp'
                    - 'antivirus_profile_ssh'
                    - 'apcfgprofile'
                    - 'apcfgprofile_commandlist'
                    - 'application_casi_profile'
                    - 'application_casi_profile_entries'
                    - 'application_categories'
                    - 'application_custom'
                    - 'application_group'
                    - 'application_internetservice'
                    - 'application_internetservice_entry'
                    - 'application_internetservicecustom'
                    - 'application_internetservicecustom_disableentry'
                    - 'application_internetservicecustom_disableentry_iprange'
                    - 'application_internetservicecustom_entry'
                    - 'application_internetservicecustom_entry_portrange'
                    - 'application_list'
                    - 'application_list_defaultnetworkservices'
                    - 'application_list_entries'
                    - 'application_list_entries_parameters'
                    - 'application_list_entries_parameters_members'
                    - 'arrpprofile'
                    - 'authentication_scheme'
                    - 'bleprofile'
                    - 'bonjourprofile'
                    - 'bonjourprofile_policylist'
                    - 'casb_profile'
                    - 'casb_profile_saasapplication'
                    - 'casb_profile_saasapplication_accessrule'
                    - 'casb_profile_saasapplication_customcontrol'
                    - 'casb_profile_saasapplication_customcontrol_option'
                    - 'casb_saasapplication'
                    - 'casb_useractivity'
                    - 'casb_useractivity_controloptions'
                    - 'casb_useractivity_controloptions_operations'
                    - 'casb_useractivity_match'
                    - 'casb_useractivity_match_rules'
                    - 'certificate_template'
                    - 'cifs_domaincontroller'
                    - 'cifs_profile'
                    - 'cifs_profile_filefilter'
                    - 'cifs_profile_filefilter_entries'
                    - 'cifs_profile_serverkeytab'
                    - 'cloud_orchestaws'
                    - 'cloud_orchestawsconnector'
                    - 'cloud_orchestawstemplate_autoscaleexistingvpc'
                    - 'cloud_orchestawstemplate_autoscalenewvpc'
                    - 'cloud_orchestawstemplate_autoscaletgwnewvpc'
                    - 'cloud_orchestration'
                    - 'credentialstore_domaincontroller'
                    - 'devprof_device_profile_fortianalyzer'
                    - 'devprof_device_profile_fortiguard'
                    - 'devprof_log_fortianalyzer_setting'
                    - 'devprof_log_fortianalyzercloud_setting'
                    - 'devprof_log_syslogd_filter'
                    - 'devprof_log_syslogd_filter_excludelist'
                    - 'devprof_log_syslogd_filter_excludelist_fields'
                    - 'devprof_log_syslogd_filter_freestyle'
                    - 'devprof_log_syslogd_setting'
                    - 'devprof_log_syslogd_setting_customfieldname'
                    - 'devprof_system_centralmanagement'
                    - 'devprof_system_centralmanagement_serverlist'
                    - 'devprof_system_dns'
                    - 'devprof_system_emailserver'
                    - 'devprof_system_global'
                    - 'devprof_system_ntp'
                    - 'devprof_system_ntp_ntpserver'
                    - 'devprof_system_replacemsg_admin'
                    - 'devprof_system_replacemsg_alertmail'
                    - 'devprof_system_replacemsg_auth'
                    - 'devprof_system_replacemsg_devicedetectionportal'
                    - 'devprof_system_replacemsg_ec'
                    - 'devprof_system_replacemsg_fortiguardwf'
                    - 'devprof_system_replacemsg_ftp'
                    - 'devprof_system_replacemsg_http'
                    - 'devprof_system_replacemsg_mail'
                    - 'devprof_system_replacemsg_mms'
                    - 'devprof_system_replacemsg_nacquar'
                    - 'devprof_system_replacemsg_nntp'
                    - 'devprof_system_replacemsg_spam'
                    - 'devprof_system_replacemsg_sslvpn'
                    - 'devprof_system_replacemsg_trafficquota'
                    - 'devprof_system_replacemsg_utm'
                    - 'devprof_system_replacemsg_webproxy'
                    - 'devprof_system_snmp_community'
                    - 'devprof_system_snmp_community_hosts'
                    - 'devprof_system_snmp_community_hosts6'
                    - 'devprof_system_snmp_sysinfo'
                    - 'devprof_system_snmp_user'
                    - 'diameterfilter_profile'
                    - 'dlp_datatype'
                    - 'dlp_dictionary'
                    - 'dlp_dictionary_entries'
                    - 'dlp_filepattern'
                    - 'dlp_filepattern_entries'
                    - 'dlp_fpsensitivity'
                    - 'dlp_profile'
                    - 'dlp_profile_rule'
                    - 'dlp_sensitivity'
                    - 'dlp_sensor'
                    - 'dlp_sensor_entries'
                    - 'dlp_sensor_filter'
                    - 'dnsfilter_domainfilter'
                    - 'dnsfilter_domainfilter_entries'
                    - 'dnsfilter_profile'
                    - 'dnsfilter_profile_dnstranslation'
                    - 'dnsfilter_profile_domainfilter'
                    - 'dnsfilter_profile_ftgddns'
                    - 'dnsfilter_profile_ftgddns_filters'
                    - 'dnsfilter_profile_urlfilter'
                    - 'dnsfilter_urlfilter'
                    - 'dnsfilter_urlfilter_entries'
                    - 'dvmdb_adom'
                    - 'dvmdb_device'
                    - 'dvmdb_device_haslave'
                    - 'dvmdb_device_vdom'
                    - 'dvmdb_folder'
                    - 'dvmdb_group'
                    - 'dvmdb_metafields_adom'
                    - 'dvmdb_metafields_device'
                    - 'dvmdb_metafields_group'
                    - 'dvmdb_revision'
                    - 'dvmdb_script'
                    - 'dvmdb_script_log_latest'
                    - 'dvmdb_script_log_latest_device'
                    - 'dvmdb_script_log_list'
                    - 'dvmdb_script_log_list_device'
                    - 'dvmdb_script_log_output_device_logid'
                    - 'dvmdb_script_log_output_logid'
                    - 'dvmdb_script_log_summary'
                    - 'dvmdb_script_log_summary_device'
                    - 'dvmdb_script_scriptschedule'
                    - 'dvmdb_workflow'
                    - 'dvmdb_workflow_wflog'
                    - 'dvmdb_workspace_dirty'
                    - 'dvmdb_workspace_dirty_dev'
                    - 'dvmdb_workspace_lockinfo'
                    - 'dvmdb_workspace_lockinfo_dev'
                    - 'dvmdb_workspace_lockinfo_obj'
                    - 'dvmdb_workspace_lockinfo_pkg'
                    - 'dynamic_address'
                    - 'dynamic_address_dynamicaddrmapping'
                    - 'dynamic_certificate_local'
                    - 'dynamic_certificate_local_dynamicmapping'
                    - 'dynamic_input_interface'
                    - 'dynamic_input_interface_dynamicmapping'
                    - 'dynamic_interface'
                    - 'dynamic_interface_dynamicmapping'
                    - 'dynamic_interface_platformmapping'
                    - 'dynamic_ippool'
                    - 'dynamic_multicast_interface'
                    - 'dynamic_multicast_interface_dynamicmapping'
                    - 'dynamic_vip'
                    - 'dynamic_virtualwanlink_members'
                    - 'dynamic_virtualwanlink_members_dynamicmapping'
                    - 'dynamic_virtualwanlink_neighbor'
                    - 'dynamic_virtualwanlink_neighbor_dynamicmapping'
                    - 'dynamic_virtualwanlink_server'
                    - 'dynamic_virtualwanlink_server_dynamicmapping'
                    - 'dynamic_vpntunnel'
                    - 'dynamic_vpntunnel_dynamicmapping'
                    - 'emailfilter_blockallowlist'
                    - 'emailfilter_blockallowlist_entries'
                    - 'emailfilter_bwl'
                    - 'emailfilter_bwl_entries'
                    - 'emailfilter_bword'
                    - 'emailfilter_bword_entries'
                    - 'emailfilter_dnsbl'
                    - 'emailfilter_dnsbl_entries'
                    - 'emailfilter_fortishield'
                    - 'emailfilter_iptrust'
                    - 'emailfilter_iptrust_entries'
                    - 'emailfilter_mheader'
                    - 'emailfilter_mheader_entries'
                    - 'emailfilter_options'
                    - 'emailfilter_profile'
                    - 'emailfilter_profile_filefilter'
                    - 'emailfilter_profile_filefilter_entries'
                    - 'emailfilter_profile_gmail'
                    - 'emailfilter_profile_imap'
                    - 'emailfilter_profile_mapi'
                    - 'emailfilter_profile_msnhotmail'
                    - 'emailfilter_profile_otherwebmails'
                    - 'emailfilter_profile_pop3'
                    - 'emailfilter_profile_smtp'
                    - 'emailfilter_profile_yahoomail'
                    - 'endpointcontrol_fctems'
                    - 'extendercontroller_dataplan'
                    - 'extendercontroller_extenderprofile'
                    - 'extendercontroller_extenderprofile_cellular'
                    - 'extendercontroller_extenderprofile_cellular_controllerreport'
                    - 'extendercontroller_extenderprofile_cellular_modem1'
                    - 'extendercontroller_extenderprofile_cellular_modem1_autoswitch'
                    - 'extendercontroller_extenderprofile_cellular_modem2'
                    - 'extendercontroller_extenderprofile_cellular_modem2_autoswitch'
                    - 'extendercontroller_extenderprofile_cellular_smsnotification'
                    - 'extendercontroller_extenderprofile_cellular_smsnotification_alert'
                    - 'extendercontroller_extenderprofile_cellular_smsnotification_receiver'
                    - 'extendercontroller_extenderprofile_lanextension'
                    - 'extendercontroller_extenderprofile_lanextension_backhaul'
                    - 'extendercontroller_simprofile'
                    - 'extendercontroller_simprofile_autoswitchprofile'
                    - 'extendercontroller_template'
                    - 'extensioncontroller_dataplan'
                    - 'extensioncontroller_extenderprofile'
                    - 'extensioncontroller_extenderprofile_cellular'
                    - 'extensioncontroller_extenderprofile_cellular_controllerreport'
                    - 'extensioncontroller_extenderprofile_cellular_modem1'
                    - 'extensioncontroller_extenderprofile_cellular_modem1_autoswitch'
                    - 'extensioncontroller_extenderprofile_cellular_modem2'
                    - 'extensioncontroller_extenderprofile_cellular_modem2_autoswitch'
                    - 'extensioncontroller_extenderprofile_cellular_smsnotification'
                    - 'extensioncontroller_extenderprofile_cellular_smsnotification_alert'
                    - 'extensioncontroller_extenderprofile_cellular_smsnotification_receiver'
                    - 'extensioncontroller_extenderprofile_lanextension'
                    - 'extensioncontroller_extenderprofile_lanextension_backhaul'
                    - 'filefilter_profile'
                    - 'filefilter_profile_rules'
                    - 'firewall_accessproxy'
                    - 'firewall_accessproxy6'
                    - 'firewall_accessproxy6_apigateway'
                    - 'firewall_accessproxy6_apigateway6'
                    - 'firewall_accessproxy6_apigateway6_quic'
                    - 'firewall_accessproxy6_apigateway6_realservers'
                    - 'firewall_accessproxy6_apigateway6_sslciphersuites'
                    - 'firewall_accessproxy6_apigateway_quic'
                    - 'firewall_accessproxy6_apigateway_realservers'
                    - 'firewall_accessproxy6_apigateway_sslciphersuites'
                    - 'firewall_accessproxy_apigateway'
                    - 'firewall_accessproxy_apigateway6'
                    - 'firewall_accessproxy_apigateway6_quic'
                    - 'firewall_accessproxy_apigateway6_realservers'
                    - 'firewall_accessproxy_apigateway6_sslciphersuites'
                    - 'firewall_accessproxy_apigateway_quic'
                    - 'firewall_accessproxy_apigateway_realservers'
                    - 'firewall_accessproxy_apigateway_sslciphersuites'
                    - 'firewall_accessproxy_realservers'
                    - 'firewall_accessproxy_serverpubkeyauthsettings'
                    - 'firewall_accessproxy_serverpubkeyauthsettings_certextension'
                    - 'firewall_accessproxysshclientcert'
                    - 'firewall_accessproxysshclientcert_certextension'
                    - 'firewall_accessproxyvirtualhost'
                    - 'firewall_address'
                    - 'firewall_address6'
                    - 'firewall_address6_dynamicmapping'
                    - 'firewall_address6_dynamicmapping_subnetsegment'
                    - 'firewall_address6_list'
                    - 'firewall_address6_profilelist'
                    - 'firewall_address6_subnetsegment'
                    - 'firewall_address6_tagging'
                    - 'firewall_address6template'
                    - 'firewall_address6template_subnetsegment'
                    - 'firewall_address6template_subnetsegment_values'
                    - 'firewall_address_dynamicmapping'
                    - 'firewall_address_list'
                    - 'firewall_address_profilelist'
                    - 'firewall_address_tagging'
                    - 'firewall_addrgrp'
                    - 'firewall_addrgrp6'
                    - 'firewall_addrgrp6_dynamicmapping'
                    - 'firewall_addrgrp6_tagging'
                    - 'firewall_addrgrp_dynamicmapping'
                    - 'firewall_addrgrp_tagging'
                    - 'firewall_carrierendpointbwl'
                    - 'firewall_carrierendpointbwl_entries'
                    - 'firewall_casbprofile'
                    - 'firewall_casbprofile_saasapplication'
                    - 'firewall_casbprofile_saasapplication_accessrule'
                    - 'firewall_casbprofile_saasapplication_customcontrol'
                    - 'firewall_casbprofile_saasapplication_customcontrol_option'
                    - 'firewall_decryptedtrafficmirror'
                    - 'firewall_explicitproxyaddress'
                    - 'firewall_explicitproxyaddress_headergroup'
                    - 'firewall_explicitproxyaddrgrp'
                    - 'firewall_gtp'
                    - 'firewall_gtp_apn'
                    - 'firewall_gtp_ieremovepolicy'
                    - 'firewall_gtp_ievalidation'
                    - 'firewall_gtp_imsi'
                    - 'firewall_gtp_ippolicy'
                    - 'firewall_gtp_messagefilter'
                    - 'firewall_gtp_messageratelimit'
                    - 'firewall_gtp_messageratelimitv0'
                    - 'firewall_gtp_messageratelimitv1'
                    - 'firewall_gtp_messageratelimitv2'
                    - 'firewall_gtp_noippolicy'
                    - 'firewall_gtp_perapnshaper'
                    - 'firewall_gtp_policy'
                    - 'firewall_gtp_policyv2'
                    - 'firewall_identitybasedroute'
                    - 'firewall_identitybasedroute_rule'
                    - 'firewall_internetservice'
                    - 'firewall_internetservice_entry'
                    - 'firewall_internetserviceaddition'
                    - 'firewall_internetserviceaddition_entry'
                    - 'firewall_internetserviceaddition_entry_portrange'
                    - 'firewall_internetservicecustom'
                    - 'firewall_internetservicecustom_disableentry'
                    - 'firewall_internetservicecustom_disableentry_iprange'
                    - 'firewall_internetservicecustom_entry'
                    - 'firewall_internetservicecustom_entry_portrange'
                    - 'firewall_internetservicecustomgroup'
                    - 'firewall_internetservicegroup'
                    - 'firewall_internetservicename'
                    - 'firewall_ippool'
                    - 'firewall_ippool6'
                    - 'firewall_ippool6_dynamicmapping'
                    - 'firewall_ippool_dynamicmapping'
                    - 'firewall_ippoolgrp'
                    - 'firewall_ldbmonitor'
                    - 'firewall_mmsprofile'
                    - 'firewall_mmsprofile_dupe'
                    - 'firewall_mmsprofile_flood'
                    - 'firewall_mmsprofile_notification'
                    - 'firewall_mmsprofile_notifmsisdn'
                    - 'firewall_mmsprofile_outbreakprevention'
                    - 'firewall_multicastaddress'
                    - 'firewall_multicastaddress6'
                    - 'firewall_multicastaddress6_tagging'
                    - 'firewall_multicastaddress_tagging'
                    - 'firewall_networkservicedynamic'
                    - 'firewall_profilegroup'
                    - 'firewall_profileprotocoloptions'
                    - 'firewall_profileprotocoloptions_cifs'
                    - 'firewall_profileprotocoloptions_cifs_filefilter'
                    - 'firewall_profileprotocoloptions_cifs_filefilter_entries'
                    - 'firewall_profileprotocoloptions_cifs_serverkeytab'
                    - 'firewall_profileprotocoloptions_dns'
                    - 'firewall_profileprotocoloptions_ftp'
                    - 'firewall_profileprotocoloptions_http'
                    - 'firewall_profileprotocoloptions_imap'
                    - 'firewall_profileprotocoloptions_mailsignature'
                    - 'firewall_profileprotocoloptions_mapi'
                    - 'firewall_profileprotocoloptions_nntp'
                    - 'firewall_profileprotocoloptions_pop3'
                    - 'firewall_profileprotocoloptions_smtp'
                    - 'firewall_profileprotocoloptions_ssh'
                    - 'firewall_proxyaddress'
                    - 'firewall_proxyaddress_headergroup'
                    - 'firewall_proxyaddress_tagging'
                    - 'firewall_proxyaddrgrp'
                    - 'firewall_proxyaddrgrp_tagging'
                    - 'firewall_schedule_group'
                    - 'firewall_schedule_onetime'
                    - 'firewall_schedule_recurring'
                    - 'firewall_service_category'
                    - 'firewall_service_custom'
                    - 'firewall_service_group'
                    - 'firewall_shaper_peripshaper'
                    - 'firewall_shaper_trafficshaper'
                    - 'firewall_shapingprofile'
                    - 'firewall_shapingprofile_shapingentries'
                    - 'firewall_ssh_localca'
                    - 'firewall_sslsshprofile'
                    - 'firewall_sslsshprofile_dot'
                    - 'firewall_sslsshprofile_ftps'
                    - 'firewall_sslsshprofile_https'
                    - 'firewall_sslsshprofile_imaps'
                    - 'firewall_sslsshprofile_pop3s'
                    - 'firewall_sslsshprofile_smtps'
                    - 'firewall_sslsshprofile_ssh'
                    - 'firewall_sslsshprofile_ssl'
                    - 'firewall_sslsshprofile_sslexempt'
                    - 'firewall_sslsshprofile_sslserver'
                    - 'firewall_trafficclass'
                    - 'firewall_vendormac'
                    - 'firewall_vip'
                    - 'firewall_vip46'
                    - 'firewall_vip46_dynamicmapping'
                    - 'firewall_vip46_realservers'
                    - 'firewall_vip6'
                    - 'firewall_vip64'
                    - 'firewall_vip64_dynamicmapping'
                    - 'firewall_vip64_realservers'
                    - 'firewall_vip6_dynamicmapping'
                    - 'firewall_vip6_dynamicmapping_realservers'
                    - 'firewall_vip6_dynamicmapping_sslciphersuites'
                    - 'firewall_vip6_quic'
                    - 'firewall_vip6_realservers'
                    - 'firewall_vip6_sslciphersuites'
                    - 'firewall_vip6_sslserverciphersuites'
                    - 'firewall_vip_dynamicmapping'
                    - 'firewall_vip_dynamicmapping_realservers'
                    - 'firewall_vip_dynamicmapping_sslciphersuites'
                    - 'firewall_vip_gslbpublicips'
                    - 'firewall_vip_quic'
                    - 'firewall_vip_realservers'
                    - 'firewall_vip_sslciphersuites'
                    - 'firewall_vip_sslserverciphersuites'
                    - 'firewall_vipgrp'
                    - 'firewall_vipgrp46'
                    - 'firewall_vipgrp6'
                    - 'firewall_vipgrp64'
                    - 'firewall_vipgrp_dynamicmapping'
                    - 'firewall_wildcardfqdn_custom'
                    - 'firewall_wildcardfqdn_group'
                    - 'fmg_device_blueprint'
                    - 'fmg_fabric_authorization_template'
                    - 'fmg_fabric_authorization_template_platforms'
                    - 'fmg_variable'
                    - 'fmg_variable_dynamicmapping'
                    - 'fmupdate_analyzer_virusreport'
                    - 'fmupdate_avips_advancedlog'
                    - 'fmupdate_avips_webproxy'
                    - 'fmupdate_customurllist'
                    - 'fmupdate_diskquota'
                    - 'fmupdate_fctservices'
                    - 'fmupdate_fdssetting'
                    - 'fmupdate_fdssetting_pushoverride'
                    - 'fmupdate_fdssetting_pushoverridetoclient'
                    - 'fmupdate_fdssetting_pushoverridetoclient_announceip'
                    - 'fmupdate_fdssetting_serveroverride'
                    - 'fmupdate_fdssetting_serveroverride_servlist'
                    - 'fmupdate_fdssetting_updateschedule'
                    - 'fmupdate_fwmsetting'
                    - 'fmupdate_fwmsetting_upgradetimeout'
                    - 'fmupdate_multilayer'
                    - 'fmupdate_publicnetwork'
                    - 'fmupdate_serveraccesspriorities'
                    - 'fmupdate_serveraccesspriorities_privateserver'
                    - 'fmupdate_serveroverridestatus'
                    - 'fmupdate_service'
                    - 'fmupdate_webspam_fgdsetting'
                    - 'fmupdate_webspam_fgdsetting_serveroverride'
                    - 'fmupdate_webspam_fgdsetting_serveroverride_servlist'
                    - 'fmupdate_webspam_webproxy'
                    - 'footer_consolidated_policy'
                    - 'footer_policy'
                    - 'footer_policy6'
                    - 'footer_policy6_identitybasedpolicy6'
                    - 'footer_policy_identitybasedpolicy'
                    - 'footer_shapingpolicy'
                    - 'fsp_vlan'
                    - 'fsp_vlan_dhcpserver'
                    - 'fsp_vlan_dhcpserver_excluderange'
                    - 'fsp_vlan_dhcpserver_iprange'
                    - 'fsp_vlan_dhcpserver_options'
                    - 'fsp_vlan_dhcpserver_reservedaddress'
                    - 'fsp_vlan_dynamicmapping'
                    - 'fsp_vlan_dynamicmapping_dhcpserver'
                    - 'fsp_vlan_dynamicmapping_dhcpserver_excluderange'
                    - 'fsp_vlan_dynamicmapping_dhcpserver_iprange'
                    - 'fsp_vlan_dynamicmapping_dhcpserver_options'
                    - 'fsp_vlan_dynamicmapping_dhcpserver_reservedaddress'
                    - 'fsp_vlan_dynamicmapping_interface'
                    - 'fsp_vlan_dynamicmapping_interface_ipv6'
                    - 'fsp_vlan_dynamicmapping_interface_ipv6_ip6delegatedprefixlist'
                    - 'fsp_vlan_dynamicmapping_interface_ipv6_ip6extraaddr'
                    - 'fsp_vlan_dynamicmapping_interface_ipv6_ip6prefixlist'
                    - 'fsp_vlan_dynamicmapping_interface_ipv6_vrrp6'
                    - 'fsp_vlan_dynamicmapping_interface_secondaryip'
                    - 'fsp_vlan_dynamicmapping_interface_vrrp'
                    - 'fsp_vlan_dynamicmapping_interface_vrrp_proxyarp'
                    - 'fsp_vlan_interface'
                    - 'fsp_vlan_interface_ipv6'
                    - 'fsp_vlan_interface_ipv6_ip6delegatedprefixlist'
                    - 'fsp_vlan_interface_ipv6_ip6extraaddr'
                    - 'fsp_vlan_interface_ipv6_ip6prefixlist'
                    - 'fsp_vlan_interface_ipv6_vrrp6'
                    - 'fsp_vlan_interface_secondaryip'
                    - 'fsp_vlan_interface_vrrp'
                    - 'fsp_vlan_interface_vrrp_proxyarp'
                    - 'gtp_apn'
                    - 'gtp_apngrp'
                    - 'gtp_iewhitelist'
                    - 'gtp_iewhitelist_entries'
                    - 'gtp_messagefilterv0v1'
                    - 'gtp_messagefilterv2'
                    - 'gtp_tunnellimit'
                    - 'header_consolidated_policy'
                    - 'header_policy'
                    - 'header_policy6'
                    - 'header_policy6_identitybasedpolicy6'
                    - 'header_policy_identitybasedpolicy'
                    - 'header_shapingpolicy'
                    - 'hotspot20_anqp3gppcellular'
                    - 'hotspot20_anqp3gppcellular_mccmnclist'
                    - 'hotspot20_anqpipaddresstype'
                    - 'hotspot20_anqpnairealm'
                    - 'hotspot20_anqpnairealm_nailist'
                    - 'hotspot20_anqpnairealm_nailist_eapmethod'
                    - 'hotspot20_anqpnairealm_nailist_eapmethod_authparam'
                    - 'hotspot20_anqpnetworkauthtype'
                    - 'hotspot20_anqproamingconsortium'
                    - 'hotspot20_anqproamingconsortium_oilist'
                    - 'hotspot20_anqpvenuename'
                    - 'hotspot20_anqpvenuename_valuelist'
                    - 'hotspot20_anqpvenueurl'
                    - 'hotspot20_anqpvenueurl_valuelist'
                    - 'hotspot20_h2qpadviceofcharge'
                    - 'hotspot20_h2qpadviceofcharge_aoclist'
                    - 'hotspot20_h2qpadviceofcharge_aoclist_planinfo'
                    - 'hotspot20_h2qpconncapability'
                    - 'hotspot20_h2qpoperatorname'
                    - 'hotspot20_h2qpoperatorname_valuelist'
                    - 'hotspot20_h2qposuprovider'
                    - 'hotspot20_h2qposuprovider_friendlyname'
                    - 'hotspot20_h2qposuprovider_servicedescription'
                    - 'hotspot20_h2qposuprovidernai'
                    - 'hotspot20_h2qposuprovidernai_nailist'
                    - 'hotspot20_h2qptermsandconditions'
                    - 'hotspot20_h2qpwanmetric'
                    - 'hotspot20_hsprofile'
                    - 'hotspot20_icon'
                    - 'hotspot20_icon_iconlist'
                    - 'hotspot20_qosmap'
                    - 'hotspot20_qosmap_dscpexcept'
                    - 'hotspot20_qosmap_dscprange'
                    - 'icap_profile'
                    - 'icap_profile_icapheaders'
                    - 'icap_profile_respmodforwardrules'
                    - 'icap_profile_respmodforwardrules_headergroup'
                    - 'icap_server'
                    - 'ips_baseline_sensor'
                    - 'ips_baseline_sensor_entries'
                    - 'ips_baseline_sensor_entries_exemptip'
                    - 'ips_baseline_sensor_filter'
                    - 'ips_baseline_sensor_override'
                    - 'ips_baseline_sensor_override_exemptip'
                    - 'ips_custom'
                    - 'ips_sensor'
                    - 'ips_sensor_entries'
                    - 'ips_sensor_entries_exemptip'
                    - 'ips_sensor_filter'
                    - 'ips_sensor_override'
                    - 'ips_sensor_override_exemptip'
                    - 'log_customfield'
                    - 'log_npuserver'
                    - 'log_npuserver_servergroup'
                    - 'log_npuserver_serverinfo'
                    - 'metafields_system_admin_user'
                    - 'mpskprofile'
                    - 'mpskprofile_mpskgroup'
                    - 'mpskprofile_mpskgroup_mpskkey'
                    - 'nacprofile'
                    - 'pkg_authentication_rule'
                    - 'pkg_authentication_setting'
                    - 'pkg_central_dnat'
                    - 'pkg_central_dnat6'
                    - 'pkg_firewall_acl'
                    - 'pkg_firewall_acl6'
                    - 'pkg_firewall_centralsnatmap'
                    - 'pkg_firewall_consolidated_policy'
                    - 'pkg_firewall_dospolicy'
                    - 'pkg_firewall_dospolicy6'
                    - 'pkg_firewall_dospolicy6_anomaly'
                    - 'pkg_firewall_dospolicy_anomaly'
                    - 'pkg_firewall_explicitproxypolicy'
                    - 'pkg_firewall_explicitproxypolicy_identitybasedpolicy'
                    - 'pkg_firewall_hyperscalepolicy'
                    - 'pkg_firewall_hyperscalepolicy46'
                    - 'pkg_firewall_hyperscalepolicy6'
                    - 'pkg_firewall_hyperscalepolicy64'
                    - 'pkg_firewall_interfacepolicy'
                    - 'pkg_firewall_interfacepolicy6'
                    - 'pkg_firewall_localinpolicy'
                    - 'pkg_firewall_localinpolicy6'
                    - 'pkg_firewall_multicastpolicy'
                    - 'pkg_firewall_multicastpolicy6'
                    - 'pkg_firewall_policy'
                    - 'pkg_firewall_policy46'
                    - 'pkg_firewall_policy6'
                    - 'pkg_firewall_policy64'
                    - 'pkg_firewall_policy_vpndstnode'
                    - 'pkg_firewall_policy_vpnsrcnode'
                    - 'pkg_firewall_proxypolicy'
                    - 'pkg_firewall_securitypolicy'
                    - 'pkg_firewall_shapingpolicy'
                    - 'pkg_footer_consolidated_policy'
                    - 'pkg_footer_policy'
                    - 'pkg_footer_policy6'
                    - 'pkg_footer_policy6_identitybasedpolicy6'
                    - 'pkg_footer_policy_identitybasedpolicy'
                    - 'pkg_footer_shapingpolicy'
                    - 'pkg_header_consolidated_policy'
                    - 'pkg_header_policy'
                    - 'pkg_header_policy6'
                    - 'pkg_header_policy6_identitybasedpolicy6'
                    - 'pkg_header_policy_identitybasedpolicy'
                    - 'pkg_header_shapingpolicy'
                    - 'pkg_user_nacpolicy'
                    - 'pm_config_adom_options'
                    - 'pm_config_application_list'
                    - 'pm_config_category_list'
                    - 'pm_config_data_defaultsslvpnoschecklist'
                    - 'pm_config_data_tablesize'
                    - 'pm_config_data_tablesize_faz'
                    - 'pm_config_data_tablesize_fmg'
                    - 'pm_config_data_tablesize_fos'
                    - 'pm_config_data_tablesize_log'
                    - 'pm_config_fct_endpointcontrol_profile'
                    - 'pm_config_metafields_firewall_address'
                    - 'pm_config_metafields_firewall_addrgrp'
                    - 'pm_config_metafields_firewall_centralsnatmap'
                    - 'pm_config_metafields_firewall_policy'
                    - 'pm_config_metafields_firewall_service_custom'
                    - 'pm_config_metafields_firewall_service_group'
                    - 'pm_config_package_status'
                    - 'pm_config_pblock_firewall_consolidated_policy'
                    - 'pm_config_pblock_firewall_policy'
                    - 'pm_config_pblock_firewall_policy6'
                    - 'pm_config_pblock_firewall_securitypolicy'
                    - 'pm_config_rule_list'
                    - 'pm_devprof'
                    - 'pm_devprof_adom'
                    - 'pm_pblock'
                    - 'pm_pblock_adom'
                    - 'pm_pkg'
                    - 'pm_pkg_adom'
                    - 'pm_pkg_global'
                    - 'pm_pkg_schedule'
                    - 'pm_wanprof'
                    - 'pm_wanprof_adom'
                    - 'qosprofile'
                    - 'region'
                    - 'router_accesslist'
                    - 'router_accesslist6'
                    - 'router_accesslist6_rule'
                    - 'router_accesslist_rule'
                    - 'router_aspathlist'
                    - 'router_aspathlist_rule'
                    - 'router_communitylist'
                    - 'router_communitylist_rule'
                    - 'router_prefixlist'
                    - 'router_prefixlist6'
                    - 'router_prefixlist6_rule'
                    - 'router_prefixlist_rule'
                    - 'router_routemap'
                    - 'router_routemap_rule'
                    - 'sctpfilter_profile'
                    - 'sctpfilter_profile_ppidfilters'
                    - 'spamfilter_bwl'
                    - 'spamfilter_bwl_entries'
                    - 'spamfilter_bword'
                    - 'spamfilter_bword_entries'
                    - 'spamfilter_dnsbl'
                    - 'spamfilter_dnsbl_entries'
                    - 'spamfilter_iptrust'
                    - 'spamfilter_iptrust_entries'
                    - 'spamfilter_mheader'
                    - 'spamfilter_mheader_entries'
                    - 'spamfilter_profile'
                    - 'spamfilter_profile_gmail'
                    - 'spamfilter_profile_imap'
                    - 'spamfilter_profile_mapi'
                    - 'spamfilter_profile_msnhotmail'
                    - 'spamfilter_profile_pop3'
                    - 'spamfilter_profile_smtp'
                    - 'spamfilter_profile_yahoomail'
                    - 'sshfilter_profile'
                    - 'sshfilter_profile_filefilter'
                    - 'sshfilter_profile_filefilter_entries'
                    - 'sshfilter_profile_shellcommands'
                    - 'switchcontroller_acl_group'
                    - 'switchcontroller_acl_ingress'
                    - 'switchcontroller_acl_ingress_action'
                    - 'switchcontroller_acl_ingress_classifier'
                    - 'switchcontroller_customcommand'
                    - 'switchcontroller_dsl_policy'
                    - 'switchcontroller_dynamicportpolicy'
                    - 'switchcontroller_dynamicportpolicy_policy'
                    - 'switchcontroller_fortilinksettings'
                    - 'switchcontroller_fortilinksettings_nacports'
                    - 'switchcontroller_lldpprofile'
                    - 'switchcontroller_lldpprofile_customtlvs'
                    - 'switchcontroller_lldpprofile_medlocationservice'
                    - 'switchcontroller_lldpprofile_mednetworkpolicy'
                    - 'switchcontroller_macpolicy'
                    - 'switchcontroller_managedswitch'
                    - 'switchcontroller_managedswitch_8021xsettings'
                    - 'switchcontroller_managedswitch_customcommand'
                    - 'switchcontroller_managedswitch_dhcpsnoopingstaticclient'
                    - 'switchcontroller_managedswitch_igmpsnooping'
                    - 'switchcontroller_managedswitch_ipsourceguard'
                    - 'switchcontroller_managedswitch_ipsourceguard_bindingentry'
                    - 'switchcontroller_managedswitch_mirror'
                    - 'switchcontroller_managedswitch_ports'
                    - 'switchcontroller_managedswitch_ports_dhcpsnoopoption82override'
                    - 'switchcontroller_managedswitch_remotelog'
                    - 'switchcontroller_managedswitch_routeoffloadrouter'
                    - 'switchcontroller_managedswitch_snmpcommunity'
                    - 'switchcontroller_managedswitch_snmpcommunity_hosts'
                    - 'switchcontroller_managedswitch_snmpsysinfo'
                    - 'switchcontroller_managedswitch_snmptrapthreshold'
                    - 'switchcontroller_managedswitch_snmpuser'
                    - 'switchcontroller_managedswitch_staticmac'
                    - 'switchcontroller_managedswitch_stormcontrol'
                    - 'switchcontroller_managedswitch_stpinstance'
                    - 'switchcontroller_managedswitch_stpsettings'
                    - 'switchcontroller_managedswitch_switchlog'
                    - 'switchcontroller_managedswitch_switchstpsettings'
                    - 'switchcontroller_managedswitch_vlan'
                    - 'switchcontroller_ptp_profile'
                    - 'switchcontroller_qos_dot1pmap'
                    - 'switchcontroller_qos_ipdscpmap'
                    - 'switchcontroller_qos_ipdscpmap_map'
                    - 'switchcontroller_qos_qospolicy'
                    - 'switchcontroller_qos_queuepolicy'
                    - 'switchcontroller_qos_queuepolicy_cosqueue'
                    - 'switchcontroller_securitypolicy_8021x'
                    - 'switchcontroller_securitypolicy_captiveportal'
                    - 'switchcontroller_switchinterfacetag'
                    - 'switchcontroller_trafficpolicy'
                    - 'switchcontroller_vlanpolicy'
                    - 'sys_ha_status'
                    - 'sys_status'
                    - 'system_admin_group'
                    - 'system_admin_group_member'
                    - 'system_admin_ldap'
                    - 'system_admin_ldap_adom'
                    - 'system_admin_profile'
                    - 'system_admin_profile_datamaskcustomfields'
                    - 'system_admin_profile_writepasswdprofiles'
                    - 'system_admin_profile_writepasswduserlist'
                    - 'system_admin_radius'
                    - 'system_admin_setting'
                    - 'system_admin_tacacs'
                    - 'system_admin_user'
                    - 'system_admin_user_adom'
                    - 'system_admin_user_adomexclude'
                    - 'system_admin_user_appfilter'
                    - 'system_admin_user_dashboard'
                    - 'system_admin_user_dashboardtabs'
                    - 'system_admin_user_ipsfilter'
                    - 'system_admin_user_metadata'
                    - 'system_admin_user_policypackage'
                    - 'system_admin_user_restrictdevvdom'
                    - 'system_admin_user_webfilter'
                    - 'system_alertconsole'
                    - 'system_alertemail'
                    - 'system_alertevent'
                    - 'system_alertevent_alertdestination'
                    - 'system_autodelete'
                    - 'system_autodelete_dlpfilesautodeletion'
                    - 'system_autodelete_logautodeletion'
                    - 'system_autodelete_quarantinefilesautodeletion'
                    - 'system_autodelete_reportautodeletion'
                    - 'system_backup_allsettings'
                    - 'system_certificate_ca'
                    - 'system_certificate_crl'
                    - 'system_certificate_local'
                    - 'system_certificate_oftp'
                    - 'system_certificate_remote'
                    - 'system_certificate_ssh'
                    - 'system_connector'
                    - 'system_csf'
                    - 'system_csf_fabricconnector'
                    - 'system_csf_trustedlist'
                    - 'system_customlanguage'
                    - 'system_dhcp_server'
                    - 'system_dhcp_server_excluderange'
                    - 'system_dhcp_server_iprange'
                    - 'system_dhcp_server_options'
                    - 'system_dhcp_server_reservedaddress'
                    - 'system_dm'
                    - 'system_dns'
                    - 'system_docker'
                    - 'system_externalresource'
                    - 'system_fips'
                    - 'system_fortiguard'
                    - 'system_fortiview_autocache'
                    - 'system_fortiview_setting'
                    - 'system_geoipcountry'
                    - 'system_geoipoverride'
                    - 'system_geoipoverride_ip6range'
                    - 'system_geoipoverride_iprange'
                    - 'system_global'
                    - 'system_guiact'
                    - 'system_ha'
                    - 'system_ha_monitoredinterfaces'
                    - 'system_ha_monitoredips'
                    - 'system_ha_peer'
                    - 'system_hascheduledcheck'
                    - 'system_interface'
                    - 'system_interface_ipv6'
                    - 'system_interface_member'
                    - 'system_localinpolicy'
                    - 'system_localinpolicy6'
                    - 'system_locallog_disk_filter'
                    - 'system_locallog_disk_setting'
                    - 'system_locallog_fortianalyzer2_filter'
                    - 'system_locallog_fortianalyzer2_setting'
                    - 'system_locallog_fortianalyzer3_filter'
                    - 'system_locallog_fortianalyzer3_setting'
                    - 'system_locallog_fortianalyzer_filter'
                    - 'system_locallog_fortianalyzer_setting'
                    - 'system_locallog_memory_filter'
                    - 'system_locallog_memory_setting'
                    - 'system_locallog_setting'
                    - 'system_locallog_syslogd2_filter'
                    - 'system_locallog_syslogd2_setting'
                    - 'system_locallog_syslogd3_filter'
                    - 'system_locallog_syslogd3_setting'
                    - 'system_locallog_syslogd_filter'
                    - 'system_locallog_syslogd_setting'
                    - 'system_log_alert'
                    - 'system_log_devicedisable'
                    - 'system_log_fospolicystats'
                    - 'system_log_interfacestats'
                    - 'system_log_ioc'
                    - 'system_log_maildomain'
                    - 'system_log_ratelimit'
                    - 'system_log_ratelimit_device'
                    - 'system_log_ratelimit_ratelimits'
                    - 'system_log_settings'
                    - 'system_log_settings_rollinganalyzer'
                    - 'system_log_settings_rollinglocal'
                    - 'system_log_settings_rollingregular'
                    - 'system_log_topology'
                    - 'system_logfetch_clientprofile'
                    - 'system_logfetch_clientprofile_devicefilter'
                    - 'system_logfetch_clientprofile_logfilter'
                    - 'system_logfetch_serversettings'
                    - 'system_mail'
                    - 'system_mcpolicydisabledadoms'
                    - 'system_meta'
                    - 'system_meta_sysmetafields'
                    - 'system_metadata_admins'
                    - 'system_npu'
                    - 'system_npu_backgroundssescan'
                    - 'system_npu_dosoptions'
                    - 'system_npu_dswdtsprofile'
                    - 'system_npu_dswqueuedtsprofile'
                    - 'system_npu_fpanomaly'
                    - 'system_npu_hpe'
                    - 'system_npu_ipreassembly'
                    - 'system_npu_isfnpqueues'
                    - 'system_npu_npqueues'
                    - 'system_npu_npqueues_ethernettype'
                    - 'system_npu_npqueues_ipprotocol'
                    - 'system_npu_npqueues_ipservice'
                    - 'system_npu_npqueues_profile'
                    - 'system_npu_npqueues_scheduler'
                    - 'system_npu_nputcam'
                    - 'system_npu_nputcam_data'
                    - 'system_npu_nputcam_mask'
                    - 'system_npu_nputcam_miract'
                    - 'system_npu_nputcam_priact'
                    - 'system_npu_nputcam_sact'
                    - 'system_npu_nputcam_tact'
                    - 'system_npu_portcpumap'
                    - 'system_npu_portnpumap'
                    - 'system_npu_portpathoption'
                    - 'system_npu_priorityprotocol'
                    - 'system_npu_ssehascan'
                    - 'system_npu_swehhash'
                    - 'system_npu_swtrhash'
                    - 'system_npu_tcptimeoutprofile'
                    - 'system_npu_udptimeoutprofile'
                    - 'system_ntp'
                    - 'system_ntp_ntpserver'
                    - 'system_objecttag'
                    - 'system_objecttagging'
                    - 'system_passwordpolicy'
                    - 'system_performance'
                    - 'system_replacemsggroup'
                    - 'system_replacemsggroup_admin'
                    - 'system_replacemsggroup_alertmail'
                    - 'system_replacemsggroup_auth'
                    - 'system_replacemsggroup_automation'
                    - 'system_replacemsggroup_custommessage'
                    - 'system_replacemsggroup_devicedetectionportal'
                    - 'system_replacemsggroup_ec'
                    - 'system_replacemsggroup_fortiguardwf'
                    - 'system_replacemsggroup_ftp'
                    - 'system_replacemsggroup_http'
                    - 'system_replacemsggroup_icap'
                    - 'system_replacemsggroup_mail'
                    - 'system_replacemsggroup_mm1'
                    - 'system_replacemsggroup_mm3'
                    - 'system_replacemsggroup_mm4'
                    - 'system_replacemsggroup_mm7'
                    - 'system_replacemsggroup_mms'
                    - 'system_replacemsggroup_nacquar'
                    - 'system_replacemsggroup_nntp'
                    - 'system_replacemsggroup_spam'
                    - 'system_replacemsggroup_sslvpn'
                    - 'system_replacemsggroup_trafficquota'
                    - 'system_replacemsggroup_utm'
                    - 'system_replacemsggroup_webproxy'
                    - 'system_replacemsgimage'
                    - 'system_report_autocache'
                    - 'system_report_estbrowsetime'
                    - 'system_report_group'
                    - 'system_report_group_chartalternative'
                    - 'system_report_group_groupby'
                    - 'system_report_setting'
                    - 'system_route'
                    - 'system_route6'
                    - 'system_saml'
                    - 'system_saml_fabricidp'
                    - 'system_saml_serviceproviders'
                    - 'system_sdnconnector'
                    - 'system_sdnconnector_compartmentlist'
                    - 'system_sdnconnector_externalaccountlist'
                    - 'system_sdnconnector_externalip'
                    - 'system_sdnconnector_forwardingrule'
                    - 'system_sdnconnector_gcpprojectlist'
                    - 'system_sdnconnector_nic'
                    - 'system_sdnconnector_nic_ip'
                    - 'system_sdnconnector_ociregionlist'
                    - 'system_sdnconnector_route'
                    - 'system_sdnconnector_routetable'
                    - 'system_sdnconnector_routetable_route'
                    - 'system_sdnproxy'
                    - 'system_smsserver'
                    - 'system_sniffer'
                    - 'system_snmp_community'
                    - 'system_snmp_community_hosts'
                    - 'system_snmp_community_hosts6'
                    - 'system_snmp_sysinfo'
                    - 'system_snmp_user'
                    - 'system_socfabric'
                    - 'system_socfabric_trustedlist'
                    - 'system_sql'
                    - 'system_sql_customindex'
                    - 'system_sql_customskipidx'
                    - 'system_sql_tsindexfield'
                    - 'system_sslciphersuites'
                    - 'system_status'
                    - 'system_syslog'
                    - 'system_virtualwirepair'
                    - 'system_webproxy'
                    - 'system_workflow_approvalmatrix'
                    - 'system_workflow_approvalmatrix_approver'
                    - 'task_task'
                    - 'task_task_history'
                    - 'task_task_line'
                    - 'task_task_line_history'
                    - 'template'
                    - 'templategroup'
                    - 'user_adgrp'
                    - 'user_certificate'
                    - 'user_clearpass'
                    - 'user_connector'
                    - 'user_device'
                    - 'user_device_dynamicmapping'
                    - 'user_device_tagging'
                    - 'user_deviceaccesslist'
                    - 'user_deviceaccesslist_devicelist'
                    - 'user_devicecategory'
                    - 'user_devicegroup'
                    - 'user_devicegroup_dynamicmapping'
                    - 'user_devicegroup_tagging'
                    - 'user_domaincontroller'
                    - 'user_domaincontroller_extraserver'
                    - 'user_exchange'
                    - 'user_flexvm'
                    - 'user_fortitoken'
                    - 'user_fsso'
                    - 'user_fsso_dynamicmapping'
                    - 'user_fssopolling'
                    - 'user_fssopolling_adgrp'
                    - 'user_group'
                    - 'user_group_dynamicmapping'
                    - 'user_group_dynamicmapping_guest'
                    - 'user_group_dynamicmapping_match'
                    - 'user_group_dynamicmapping_sslvpnoschecklist'
                    - 'user_group_guest'
                    - 'user_group_match'
                    - 'user_json'
                    - 'user_krbkeytab'
                    - 'user_ldap'
                    - 'user_ldap_dynamicmapping'
                    - 'user_local'
                    - 'user_nsx'
                    - 'user_nsx_service'
                    - 'user_passwordpolicy'
                    - 'user_peer'
                    - 'user_peergrp'
                    - 'user_pop3'
                    - 'user_pxgrid'
                    - 'user_radius'
                    - 'user_radius_accountingserver'
                    - 'user_radius_dynamicmapping'
                    - 'user_radius_dynamicmapping_accountingserver'
                    - 'user_saml'
                    - 'user_saml_dynamicmapping'
                    - 'user_securityexemptlist'
                    - 'user_securityexemptlist_rule'
                    - 'user_tacacs'
                    - 'user_tacacs_dynamicmapping'
                    - 'user_vcenter'
                    - 'user_vcenter_rule'
                    - 'utmprofile'
                    - 'vap'
                    - 'vap_dynamicmapping'
                    - 'vap_macfilterlist'
                    - 'vap_mpskkey'
                    - 'vap_portalmessageoverrides'
                    - 'vap_vlanname'
                    - 'vap_vlanpool'
                    - 'vapgroup'
                    - 'videofilter_keyword'
                    - 'videofilter_keyword_word'
                    - 'videofilter_profile'
                    - 'videofilter_profile_filters'
                    - 'videofilter_profile_fortiguardcategory'
                    - 'videofilter_profile_fortiguardcategory_filters'
                    - 'videofilter_youtubechannelfilter'
                    - 'videofilter_youtubechannelfilter_entries'
                    - 'videofilter_youtubekey'
                    - 'virtualpatch_profile'
                    - 'virtualpatch_profile_exemption'
                    - 'voip_profile'
                    - 'voip_profile_msrp'
                    - 'voip_profile_sccp'
                    - 'voip_profile_sip'
                    - 'vpn_certificate_ca'
                    - 'vpn_certificate_ocspserver'
                    - 'vpn_certificate_remote'
                    - 'vpn_ipsec_fec'
                    - 'vpn_ipsec_fec_mappings'
                    - 'vpn_ssl_settings'
                    - 'vpn_ssl_settings_authenticationrule'
                    - 'vpnmgr_node'
                    - 'vpnmgr_node_iprange'
                    - 'vpnmgr_node_ipv4excluderange'
                    - 'vpnmgr_node_protectedsubnet'
                    - 'vpnmgr_node_summaryaddr'
                    - 'vpnmgr_vpntable'
                    - 'vpnsslweb_hostchecksoftware'
                    - 'vpnsslweb_hostchecksoftware_checkitemlist'
                    - 'vpnsslweb_portal'
                    - 'vpnsslweb_portal_bookmarkgroup'
                    - 'vpnsslweb_portal_bookmarkgroup_bookmarks'
                    - 'vpnsslweb_portal_bookmarkgroup_bookmarks_formdata'
                    - 'vpnsslweb_portal_landingpage'
                    - 'vpnsslweb_portal_landingpage_formdata'
                    - 'vpnsslweb_portal_macaddrcheckrule'
                    - 'vpnsslweb_portal_oschecklist'
                    - 'vpnsslweb_portal_splitdns'
                    - 'vpnsslweb_realm'
                    - 'vpnsslweb_virtualdesktopapplist'
                    - 'vpnsslweb_virtualdesktopapplist_apps'
                    - 'waf_mainclass'
                    - 'waf_profile'
                    - 'waf_profile_addresslist'
                    - 'waf_profile_constraint'
                    - 'waf_profile_constraint_contentlength'
                    - 'waf_profile_constraint_exception'
                    - 'waf_profile_constraint_headerlength'
                    - 'waf_profile_constraint_hostname'
                    - 'waf_profile_constraint_linelength'
                    - 'waf_profile_constraint_malformed'
                    - 'waf_profile_constraint_maxcookie'
                    - 'waf_profile_constraint_maxheaderline'
                    - 'waf_profile_constraint_maxrangesegment'
                    - 'waf_profile_constraint_maxurlparam'
                    - 'waf_profile_constraint_method'
                    - 'waf_profile_constraint_paramlength'
                    - 'waf_profile_constraint_urlparamlength'
                    - 'waf_profile_constraint_version'
                    - 'waf_profile_method'
                    - 'waf_profile_method_methodpolicy'
                    - 'waf_profile_signature'
                    - 'waf_profile_signature_customsignature'
                    - 'waf_profile_signature_mainclass'
                    - 'waf_profile_urlaccess'
                    - 'waf_profile_urlaccess_accesspattern'
                    - 'waf_signature'
                    - 'waf_subclass'
                    - 'wagprofile'
                    - 'wanopt_authgroup'
                    - 'wanopt_peer'
                    - 'wanopt_profile'
                    - 'wanopt_profile_cifs'
                    - 'wanopt_profile_ftp'
                    - 'wanopt_profile_http'
                    - 'wanopt_profile_mapi'
                    - 'wanopt_profile_tcp'
                    - 'wanprof_system_sdwan'
                    - 'wanprof_system_sdwan_duplication'
                    - 'wanprof_system_sdwan_healthcheck'
                    - 'wanprof_system_sdwan_healthcheck_sla'
                    - 'wanprof_system_sdwan_members'
                    - 'wanprof_system_sdwan_neighbor'
                    - 'wanprof_system_sdwan_service'
                    - 'wanprof_system_sdwan_service_sla'
                    - 'wanprof_system_sdwan_zone'
                    - 'wanprof_system_virtualwanlink'
                    - 'wanprof_system_virtualwanlink_healthcheck'
                    - 'wanprof_system_virtualwanlink_healthcheck_sla'
                    - 'wanprof_system_virtualwanlink_members'
                    - 'wanprof_system_virtualwanlink_neighbor'
                    - 'wanprof_system_virtualwanlink_service'
                    - 'wanprof_system_virtualwanlink_service_sla'
                    - 'webfilter_categories'
                    - 'webfilter_content'
                    - 'webfilter_content_entries'
                    - 'webfilter_contentheader'
                    - 'webfilter_contentheader_entries'
                    - 'webfilter_ftgdlocalcat'
                    - 'webfilter_ftgdlocalrating'
                    - 'webfilter_profile'
                    - 'webfilter_profile_antiphish'
                    - 'webfilter_profile_antiphish_custompatterns'
                    - 'webfilter_profile_antiphish_inspectionentries'
                    - 'webfilter_profile_filefilter'
                    - 'webfilter_profile_filefilter_entries'
                    - 'webfilter_profile_ftgdwf'
                    - 'webfilter_profile_ftgdwf_filters'
                    - 'webfilter_profile_ftgdwf_quota'
                    - 'webfilter_profile_override'
                    - 'webfilter_profile_urlextraction'
                    - 'webfilter_profile_web'
                    - 'webfilter_profile_youtubechannelfilter'
                    - 'webfilter_urlfilter'
                    - 'webfilter_urlfilter_entries'
                    - 'webproxy_forwardserver'
                    - 'webproxy_forwardservergroup'
                    - 'webproxy_forwardservergroup_serverlist'
                    - 'webproxy_profile'
                    - 'webproxy_profile_headers'
                    - 'webproxy_wisp'
                    - 'widsprofile'
                    - 'wireless_accesscontrollist'
                    - 'wireless_accesscontrollist_layer3ipv4rules'
                    - 'wireless_accesscontrollist_layer3ipv6rules'
                    - 'wireless_address'
                    - 'wireless_addrgrp'
                    - 'wireless_ssidpolicy'
                    - 'wireless_syslogprofile'
                    - 'wtpprofile'
                    - 'wtpprofile_denymaclist'
                    - 'wtpprofile_eslsesdongle'
                    - 'wtpprofile_lan'
                    - 'wtpprofile_lbs'
                    - 'wtpprofile_platform'
                    - 'wtpprofile_radio1'
                    - 'wtpprofile_radio2'
                    - 'wtpprofile_radio3'
                    - 'wtpprofile_radio4'
                    - 'wtpprofile_splittunnelingacl'
            path:
                required: false
                description: Path to store exported playbooks and log files.
                default: './'
                type: str
            params:
                required: false
                description: The specific parameters for each different selector.
                type: dict
'''

EXAMPLES = '''
- name: Export Playbooks
  hosts: fortimanagers
  gather_facts: false
  connection: httpapi
  vars:
    ansible_httpapi_use_ssl: true
    ansible_httpapi_validate_certs: false
    ansible_httpapi_port: 443
  tasks:
    - name: Export Playbooks
      fortinet.fortimanager.fmgr_export_playbooks:
        export_playbooks:
          selector:
            - all
          path: "./exported"
          params:
            all:
              adom: root
'''

RETURN = '''
meta:
    description: The result of the request.
    type: dict
    returned: always
    contains:
        request_url:
            description: The full url requested.
            returned: always
            type: str
            sample: /sys/login/user
        response_code:
            description: The status of api request.
            returned: always
            type: int
            sample: 0
        response_data:
            description: The api response.
            type: list
            returned: always
        response_message:
            description: The descriptive message of the api response.
            type: str
            returned: always
            sample: OK.
        system_information:
            description: The information of the target system.
            type: dict
            returned: always
rc:
    description: The status the request.
    type: int
    returned: always
    sample: 0
version_check_warning:
    description: Warning if the parameters used in the playbook are not supported by the current FortiManager version.
    type: list
    returned: complex
'''

from ansible.module_utils.basic import AnsibleModule
from ansible.module_utils.connection import Connection
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import NAPIManager


def main():
    export_metadata = {
        'adom_options': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/adom/options',
                '/pm/config/global/obj/adom/options'
            ],
            'v_range': [['6.0.0', '']]
        },
        'antivirus_mmschecksum': {
            'params': ['mms-checksum', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/antivirus/mms-checksum/{mms-checksum}',
                '/pm/config/global/obj/antivirus/mms-checksum/{mms-checksum}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'antivirus_mmschecksum_entries': {
            'params': ['mms-checksum', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/antivirus/mms-checksum/{mms-checksum}/entries/{entries}',
                '/pm/config/global/obj/antivirus/mms-checksum/{mms-checksum}/entries/{entries}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'antivirus_notification': {
            'params': ['notification', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/antivirus/notification/{notification}',
                '/pm/config/global/obj/antivirus/notification/{notification}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'antivirus_notification_entries': {
            'params': ['notification', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/antivirus/notification/{notification}/entries/{entries}',
                '/pm/config/global/obj/antivirus/notification/{notification}/entries/{entries}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'antivirus_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/antivirus/profile/{profile}',
                '/pm/config/global/obj/antivirus/profile/{profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'antivirus_profile_cifs': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/antivirus/profile/{profile}/cifs',
                '/pm/config/global/obj/antivirus/profile/{profile}/cifs'
            ],
            'v_range': [['6.2.0', '']]
        },
        'antivirus_profile_contentdisarm': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/antivirus/profile/{profile}/content-disarm',
                '/pm/config/global/obj/antivirus/profile/{profile}/content-disarm'
            ],
            'v_range': [['6.0.0', '']]
        },
        'antivirus_profile_ftp': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/antivirus/profile/{profile}/ftp',
                '/pm/config/global/obj/antivirus/profile/{profile}/ftp'
            ],
            'v_range': [['6.0.0', '']]
        },
        'antivirus_profile_http': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/antivirus/profile/{profile}/http',
                '/pm/config/global/obj/antivirus/profile/{profile}/http'
            ],
            'v_range': [['6.0.0', '']]
        },
        'antivirus_profile_imap': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/antivirus/profile/{profile}/imap',
                '/pm/config/global/obj/antivirus/profile/{profile}/imap'
            ],
            'v_range': [['6.0.0', '']]
        },
        'antivirus_profile_mapi': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/antivirus/profile/{profile}/mapi',
                '/pm/config/global/obj/antivirus/profile/{profile}/mapi'
            ],
            'v_range': [['6.0.0', '']]
        },
        'antivirus_profile_nacquar': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/antivirus/profile/{profile}/nac-quar',
                '/pm/config/global/obj/antivirus/profile/{profile}/nac-quar'
            ],
            'v_range': [['6.0.0', '']]
        },
        'antivirus_profile_nntp': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/antivirus/profile/{profile}/nntp',
                '/pm/config/global/obj/antivirus/profile/{profile}/nntp'
            ],
            'v_range': [['6.0.0', '']]
        },
        'antivirus_profile_outbreakprevention': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/antivirus/profile/{profile}/outbreak-prevention',
                '/pm/config/global/obj/antivirus/profile/{profile}/outbreak-prevention'
            ],
            'v_range': [['6.2.0', '']]
        },
        'antivirus_profile_pop3': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/antivirus/profile/{profile}/pop3',
                '/pm/config/global/obj/antivirus/profile/{profile}/pop3'
            ],
            'v_range': [['6.0.0', '']]
        },
        'antivirus_profile_smb': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/antivirus/profile/{profile}/smb',
                '/pm/config/global/obj/antivirus/profile/{profile}/smb'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'antivirus_profile_smtp': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/antivirus/profile/{profile}/smtp',
                '/pm/config/global/obj/antivirus/profile/{profile}/smtp'
            ],
            'v_range': [['6.0.0', '']]
        },
        'antivirus_profile_ssh': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/antivirus/profile/{profile}/ssh',
                '/pm/config/global/obj/antivirus/profile/{profile}/ssh'
            ],
            'v_range': [['6.2.2', '']]
        },
        'apcfgprofile': {
            'params': ['apcfg-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/apcfg-profile/{apcfg-profile}',
                '/pm/config/global/obj/wireless-controller/apcfg-profile/{apcfg-profile}'
            ],
            'v_range': [['6.4.6', '']]
        },
        'apcfgprofile_commandlist': {
            'params': ['apcfg-profile', 'command-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/apcfg-profile/{apcfg-profile}/command-list/{command-list}',
                '/pm/config/global/obj/wireless-controller/apcfg-profile/{apcfg-profile}/command-list/{command-list}'
            ],
            'v_range': [['6.4.6', '']]
        },
        'application_casi_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/application/casi/profile/{profile}',
                '/pm/config/global/obj/application/casi/profile/{profile}'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'application_casi_profile_entries': {
            'params': ['profile', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/application/casi/profile/{profile}/entries/{entries}',
                '/pm/config/global/obj/application/casi/profile/{profile}/entries/{entries}'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'application_categories': {
            'params': ['categories', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/application/categories/{categories}',
                '/pm/config/global/obj/application/categories/{categories}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'application_custom': {
            'params': ['custom', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/application/custom/{custom}',
                '/pm/config/global/obj/application/custom/{custom}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'application_group': {
            'params': ['group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/application/group/{group}',
                '/pm/config/global/obj/application/group/{group}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'application_internetservice': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/application/internet-service',
                '/pm/config/global/obj/application/internet-service'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'application_internetservice_entry': {
            'params': ['entry', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/application/internet-service/entry/{entry}',
                '/pm/config/global/obj/application/internet-service/entry/{entry}'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'application_internetservicecustom': {
            'params': ['internet-service-custom', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/application/internet-service-custom/{internet-service-custom}',
                '/pm/config/global/obj/application/internet-service-custom/{internet-service-custom}'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'application_internetservicecustom_disableentry': {
            'params': ['internet-service-custom', 'disable-entry', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/application/internet-service-custom/{internet-service-custom}/disable-entry/{disable-entry}',
                '/pm/config/global/obj/application/internet-service-custom/{internet-service-custom}/disable-entry/{disable-entry}'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'application_internetservicecustom_disableentry_iprange': {
            'params': ['internet-service-custom', 'disable-entry', 'ip-range', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/application/internet-service-custom/{internet-service-custom}/disable-entry/{disable-entry}/ip-range/{ip-range}',
                '/pm/config/global/obj/application/internet-service-custom/{internet-service-custom}/disable-entry/{disable-entry}/ip-range/{ip-range}'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'application_internetservicecustom_entry': {
            'params': ['internet-service-custom', 'entry', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/application/internet-service-custom/{internet-service-custom}/entry/{entry}',
                '/pm/config/global/obj/application/internet-service-custom/{internet-service-custom}/entry/{entry}'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'application_internetservicecustom_entry_portrange': {
            'params': ['internet-service-custom', 'entry', 'port-range', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/application/internet-service-custom/{internet-service-custom}/entry/{entry}/port-range/{port-range}',
                '/pm/config/global/obj/application/internet-service-custom/{internet-service-custom}/entry/{entry}/port-range/{port-range}'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'application_list': {
            'params': ['list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/application/list/{list}',
                '/pm/config/global/obj/application/list/{list}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'application_list_defaultnetworkservices': {
            'params': ['list', 'default-network-services', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/application/list/{list}/default-network-services/{default-network-services}',
                '/pm/config/global/obj/application/list/{list}/default-network-services/{default-network-services}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'application_list_entries': {
            'params': ['list', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/application/list/{list}/entries/{entries}',
                '/pm/config/global/obj/application/list/{list}/entries/{entries}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'application_list_entries_parameters': {
            'params': ['list', 'entries', 'parameters', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/application/list/{list}/entries/{entries}/parameters/{parameters}',
                '/pm/config/global/obj/application/list/{list}/entries/{entries}/parameters/{parameters}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'application_list_entries_parameters_members': {
            'params': ['list', 'entries', 'parameters', 'members', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/application/list/{list}/entries/{entries}/parameters/{parameters}/members/{members}',
                '/pm/config/global/obj/application/list/{list}/entries/{entries}/parameters/{parameters}/members/{members}'
            ],
            'v_range': [['6.4.0', '']]
        },
        'arrpprofile': {
            'params': ['arrp-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/arrp-profile/{arrp-profile}',
                '/pm/config/global/obj/wireless-controller/arrp-profile/{arrp-profile}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'authentication_scheme': {
            'params': ['scheme', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/authentication/scheme/{scheme}',
                '/pm/config/global/obj/authentication/scheme/{scheme}'
            ],
            'v_range': [['6.2.1', '']]
        },
        'bleprofile': {
            'params': ['ble-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/ble-profile/{ble-profile}',
                '/pm/config/global/obj/wireless-controller/ble-profile/{ble-profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'bonjourprofile': {
            'params': ['bonjour-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/bonjour-profile/{bonjour-profile}',
                '/pm/config/global/obj/wireless-controller/bonjour-profile/{bonjour-profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'bonjourprofile_policylist': {
            'params': ['bonjour-profile', 'policy-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/bonjour-profile/{bonjour-profile}/policy-list/{policy-list}',
                '/pm/config/global/obj/wireless-controller/bonjour-profile/{bonjour-profile}/policy-list/{policy-list}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'casb_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/casb/profile/{profile}',
                '/pm/config/global/obj/casb/profile/{profile}'
            ],
            'v_range': [['7.4.1', '']]
        },
        'casb_profile_saasapplication': {
            'params': ['profile', 'saas-application', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/casb/profile/{profile}/saas-application/{saas-application}',
                '/pm/config/global/obj/casb/profile/{profile}/saas-application/{saas-application}'
            ],
            'v_range': [['7.4.1', '']]
        },
        'casb_profile_saasapplication_accessrule': {
            'params': ['profile', 'saas-application', 'access-rule', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/casb/profile/{profile}/saas-application/{saas-application}/access-rule/{access-rule}',
                '/pm/config/global/obj/casb/profile/{profile}/saas-application/{saas-application}/access-rule/{access-rule}'
            ],
            'v_range': [['7.4.1', '']]
        },
        'casb_profile_saasapplication_customcontrol': {
            'params': ['profile', 'saas-application', 'custom-control', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/casb/profile/{profile}/saas-application/{saas-application}/custom-control/{custom-control}',
                '/pm/config/global/obj/casb/profile/{profile}/saas-application/{saas-application}/custom-control/{custom-control}'
            ],
            'v_range': [['7.4.1', '']]
        },
        'casb_profile_saasapplication_customcontrol_option': {
            'params': ['profile', 'saas-application', 'custom-control', 'option', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/casb/profile/{profile}/saas-application/{saas-application}/custom-control/{custom-control}/option/{option}',
                '/pm/config/global/obj/casb/profile/{profile}/saas-application/{saas-application}/custom-control/{custom-control}/option/{option}'
            ],
            'v_range': [['7.4.1', '']]
        },
        'casb_saasapplication': {
            'params': ['saas-application', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/casb/saas-application/{saas-application}',
                '/pm/config/global/obj/casb/saas-application/{saas-application}'
            ],
            'v_range': [['7.4.1', '']]
        },
        'casb_useractivity': {
            'params': ['user-activity', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/casb/user-activity/{user-activity}',
                '/pm/config/global/obj/casb/user-activity/{user-activity}'
            ],
            'v_range': [['7.4.1', '']]
        },
        'casb_useractivity_controloptions': {
            'params': ['user-activity', 'control-options', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/casb/user-activity/{user-activity}/control-options/{control-options}',
                '/pm/config/global/obj/casb/user-activity/{user-activity}/control-options/{control-options}'
            ],
            'v_range': [['7.4.1', '']]
        },
        'casb_useractivity_controloptions_operations': {
            'params': ['user-activity', 'control-options', 'operations', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/casb/user-activity/{user-activity}/control-options/{control-options}/operations/{operations}',
                '/pm/config/global/obj/casb/user-activity/{user-activity}/control-options/{control-options}/operations/{operations}'
            ],
            'v_range': [['7.4.1', '']]
        },
        'casb_useractivity_match': {
            'params': ['user-activity', 'match', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/casb/user-activity/{user-activity}/match/{match}',
                '/pm/config/global/obj/casb/user-activity/{user-activity}/match/{match}'
            ],
            'v_range': [['7.4.1', '']]
        },
        'casb_useractivity_match_rules': {
            'params': ['user-activity', 'match', 'rules', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/casb/user-activity/{user-activity}/match/{match}/rules/{rules}',
                '/pm/config/global/obj/casb/user-activity/{user-activity}/match/{match}/rules/{rules}'
            ],
            'v_range': [['7.4.1', '']]
        },
        'certificate_template': {
            'params': ['template', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/certificate/template/{template}',
                '/pm/config/global/obj/certificate/template/{template}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'cifs_domaincontroller': {
            'params': ['domain-controller', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/cifs/domain-controller/{domain-controller}',
                '/pm/config/global/obj/cifs/domain-controller/{domain-controller}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'cifs_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/cifs/profile/{profile}',
                '/pm/config/global/obj/cifs/profile/{profile}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'cifs_profile_filefilter': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/cifs/profile/{profile}/file-filter',
                '/pm/config/global/obj/cifs/profile/{profile}/file-filter'
            ],
            'v_range': [['6.2.0', '']]
        },
        'cifs_profile_filefilter_entries': {
            'params': ['profile', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/cifs/profile/{profile}/file-filter/entries/{entries}',
                '/pm/config/global/obj/cifs/profile/{profile}/file-filter/entries/{entries}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'cifs_profile_serverkeytab': {
            'params': ['profile', 'server-keytab', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/cifs/profile/{profile}/server-keytab/{server-keytab}',
                '/pm/config/global/obj/cifs/profile/{profile}/server-keytab/{server-keytab}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'cloud_orchestaws': {
            'params': ['orchest-aws', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/cloud/orchest-aws/{orchest-aws}',
                '/pm/config/global/obj/cloud/orchest-aws/{orchest-aws}'
            ],
            'v_range': [['7.4.0', '']]
        },
        'cloud_orchestawsconnector': {
            'params': ['orchest-awsconnector', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/cloud/orchest-awsconnector/{orchest-awsconnector}',
                '/pm/config/global/obj/cloud/orchest-awsconnector/{orchest-awsconnector}'
            ],
            'v_range': [['7.4.0', '']]
        },
        'cloud_orchestawstemplate_autoscaleexistingvpc': {
            'params': ['autoscale-existing-vpc', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/cloud/orchest-awstemplate/autoscale-existing-vpc/{autoscale-existing-vpc}',
                '/pm/config/global/obj/cloud/orchest-awstemplate/autoscale-existing-vpc/{autoscale-existing-vpc}'
            ],
            'v_range': [['7.4.0', '']]
        },
        'cloud_orchestawstemplate_autoscalenewvpc': {
            'params': ['autoscale-new-vpc', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/cloud/orchest-awstemplate/autoscale-new-vpc/{autoscale-new-vpc}',
                '/pm/config/global/obj/cloud/orchest-awstemplate/autoscale-new-vpc/{autoscale-new-vpc}'
            ],
            'v_range': [['7.4.0', '']]
        },
        'cloud_orchestawstemplate_autoscaletgwnewvpc': {
            'params': ['autoscale-tgw-new-vpc', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/cloud/orchest-awstemplate/autoscale-tgw-new-vpc/{autoscale-tgw-new-vpc}',
                '/pm/config/global/obj/cloud/orchest-awstemplate/autoscale-tgw-new-vpc/{autoscale-tgw-new-vpc}'
            ],
            'v_range': [['7.4.0', '']]
        },
        'cloud_orchestration': {
            'params': ['orchestration', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/cloud/orchestration/{orchestration}',
                '/pm/config/global/obj/cloud/orchestration/{orchestration}'
            ],
            'v_range': [['7.4.0', '']]
        },
        'credentialstore_domaincontroller': {
            'params': ['domain-controller', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/credential-store/domain-controller/{domain-controller}',
                '/pm/config/global/obj/credential-store/domain-controller/{domain-controller}'
            ],
            'v_range': [['6.4.0', '']]
        },
        'devprof_device_profile_fortianalyzer': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/device/profile/fortianalyzer'
            ],
            'v_range': [['6.0.0', '']]
        },
        'devprof_device_profile_fortiguard': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/device/profile/fortiguard'
            ],
            'v_range': [['6.0.0', '']]
        },
        'devprof_log_fortianalyzer_setting': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/log/fortianalyzer/setting'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_log_fortianalyzercloud_setting': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/log/fortianalyzer-cloud/setting'
            ],
            'v_range': [['6.2.1', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_log_syslogd_filter': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/log/syslogd/filter'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_log_syslogd_filter_excludelist': {
            'params': ['devprof', 'exclude-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/log/syslogd/filter/exclude-list/{exclude-list}'
            ],
            'v_range': [['7.0.4', '7.0.12']]
        },
        'devprof_log_syslogd_filter_excludelist_fields': {
            'params': ['devprof', 'exclude-list', 'fields', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/log/syslogd/filter/exclude-list/{exclude-list}/fields/{fields}'
            ],
            'v_range': [['7.0.4', '7.0.12']]
        },
        'devprof_log_syslogd_filter_freestyle': {
            'params': ['devprof', 'free-style', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/log/syslogd/filter/free-style/{free-style}'
            ],
            'v_range': [['7.0.4', '7.0.12'], ['7.2.1', '']]
        },
        'devprof_log_syslogd_setting': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/log/syslogd/setting'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_log_syslogd_setting_customfieldname': {
            'params': ['devprof', 'custom-field-name', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/log/syslogd/setting/custom-field-name/{custom-field-name}'
            ],
            'v_range': [['7.0.4', '7.0.12'], ['7.2.1', '']]
        },
        'devprof_system_centralmanagement': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/central-management'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_centralmanagement_serverlist': {
            'params': ['devprof', 'server-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/central-management/server-list/{server-list}'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_dns': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/dns'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1']]
        },
        'devprof_system_emailserver': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/email-server'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_global': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/global'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_ntp': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/ntp'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_ntp_ntpserver': {
            'params': ['devprof', 'ntpserver', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/ntp/ntpserver/{ntpserver}'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_replacemsg_admin': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/replacemsg/admin'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_replacemsg_alertmail': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/replacemsg/alertmail'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_replacemsg_auth': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/replacemsg/auth'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_replacemsg_devicedetectionportal': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/replacemsg/device-detection-portal'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_replacemsg_ec': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/replacemsg/ec'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '7.2.1']]
        },
        'devprof_system_replacemsg_fortiguardwf': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/replacemsg/fortiguard-wf'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_replacemsg_ftp': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/replacemsg/ftp'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_replacemsg_http': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/replacemsg/http'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_replacemsg_mail': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/replacemsg/mail'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_replacemsg_mms': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/replacemsg/mms'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_replacemsg_nacquar': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/replacemsg/nac-quar'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_replacemsg_nntp': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/replacemsg/nntp'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_replacemsg_spam': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/replacemsg/spam'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_replacemsg_sslvpn': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/replacemsg/sslvpn'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_replacemsg_trafficquota': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/replacemsg/traffic-quota'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_replacemsg_utm': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/replacemsg/utm'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_replacemsg_webproxy': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/replacemsg/webproxy'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_snmp_community': {
            'params': ['devprof', 'community', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/snmp/community/{community}'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_snmp_community_hosts': {
            'params': ['devprof', 'community', 'hosts', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/snmp/community/{community}/hosts/{hosts}'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_snmp_community_hosts6': {
            'params': ['devprof', 'community', 'hosts6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/snmp/community/{community}/hosts6/{hosts6}'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_snmp_sysinfo': {
            'params': ['devprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/snmp/sysinfo'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'devprof_system_snmp_user': {
            'params': ['devprof', 'user', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/devprof/{devprof}/system/snmp/user/{user}'
            ],
            'v_range': [['6.0.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'diameterfilter_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/diameter-filter/profile/{profile}',
                '/pm/config/global/obj/diameter-filter/profile/{profile}'
            ],
            'v_range': [['7.4.2', '']]
        },
        'dlp_datatype': {
            'params': ['data-type', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dlp/data-type/{data-type}',
                '/pm/config/global/obj/dlp/data-type/{data-type}'
            ],
            'v_range': [['7.2.0', '']]
        },
        'dlp_dictionary': {
            'params': ['dictionary', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dlp/dictionary/{dictionary}',
                '/pm/config/global/obj/dlp/dictionary/{dictionary}'
            ],
            'v_range': [['7.2.0', '']]
        },
        'dlp_dictionary_entries': {
            'params': ['dictionary', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dlp/dictionary/{dictionary}/entries/{entries}',
                '/pm/config/global/obj/dlp/dictionary/{dictionary}/entries/{entries}'
            ],
            'v_range': [['7.2.0', '']]
        },
        'dlp_filepattern': {
            'params': ['filepattern', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dlp/filepattern/{filepattern}',
                '/pm/config/global/obj/dlp/filepattern/{filepattern}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dlp_filepattern_entries': {
            'params': ['filepattern', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dlp/filepattern/{filepattern}/entries/{entries}',
                '/pm/config/global/obj/dlp/filepattern/{filepattern}/entries/{entries}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dlp_fpsensitivity': {
            'params': ['fp-sensitivity', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dlp/fp-sensitivity/{fp-sensitivity}',
                '/pm/config/global/obj/dlp/fp-sensitivity/{fp-sensitivity}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'dlp_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dlp/profile/{profile}',
                '/pm/config/global/obj/dlp/profile/{profile}'
            ],
            'v_range': [['7.2.0', '']]
        },
        'dlp_profile_rule': {
            'params': ['profile', 'rule', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dlp/profile/{profile}/rule/{rule}',
                '/pm/config/global/obj/dlp/profile/{profile}/rule/{rule}'
            ],
            'v_range': [['7.2.0', '']]
        },
        'dlp_sensitivity': {
            'params': ['sensitivity', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dlp/sensitivity/{sensitivity}',
                '/pm/config/global/obj/dlp/sensitivity/{sensitivity}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'dlp_sensor': {
            'params': ['sensor', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dlp/sensor/{sensor}',
                '/pm/config/global/obj/dlp/sensor/{sensor}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dlp_sensor_entries': {
            'params': ['sensor', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dlp/sensor/{sensor}/entries/{entries}',
                '/pm/config/global/obj/dlp/sensor/{sensor}/entries/{entries}'
            ],
            'v_range': [['7.2.0', '']]
        },
        'dlp_sensor_filter': {
            'params': ['sensor', 'filter', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dlp/sensor/{sensor}/filter/{filter}',
                '/pm/config/global/obj/dlp/sensor/{sensor}/filter/{filter}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dnsfilter_domainfilter': {
            'params': ['domain-filter', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dnsfilter/domain-filter/{domain-filter}',
                '/pm/config/global/obj/dnsfilter/domain-filter/{domain-filter}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dnsfilter_domainfilter_entries': {
            'params': ['domain-filter', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dnsfilter/domain-filter/{domain-filter}/entries/{entries}',
                '/pm/config/global/obj/dnsfilter/domain-filter/{domain-filter}/entries/{entries}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dnsfilter_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dnsfilter/profile/{profile}',
                '/pm/config/global/obj/dnsfilter/profile/{profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dnsfilter_profile_dnstranslation': {
            'params': ['profile', 'dns-translation', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dnsfilter/profile/{profile}/dns-translation/{dns-translation}',
                '/pm/config/global/obj/dnsfilter/profile/{profile}/dns-translation/{dns-translation}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'dnsfilter_profile_domainfilter': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dnsfilter/profile/{profile}/domain-filter',
                '/pm/config/global/obj/dnsfilter/profile/{profile}/domain-filter'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dnsfilter_profile_ftgddns': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dnsfilter/profile/{profile}/ftgd-dns',
                '/pm/config/global/obj/dnsfilter/profile/{profile}/ftgd-dns'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dnsfilter_profile_ftgddns_filters': {
            'params': ['profile', 'filters', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dnsfilter/profile/{profile}/ftgd-dns/filters/{filters}',
                '/pm/config/global/obj/dnsfilter/profile/{profile}/ftgd-dns/filters/{filters}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dnsfilter_profile_urlfilter': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dnsfilter/profile/{profile}/urlfilter',
                '/pm/config/global/obj/dnsfilter/profile/{profile}/urlfilter'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'dnsfilter_urlfilter': {
            'params': ['urlfilter', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dnsfilter/urlfilter/{urlfilter}',
                '/pm/config/global/obj/dnsfilter/urlfilter/{urlfilter}'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'dnsfilter_urlfilter_entries': {
            'params': ['urlfilter', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dnsfilter/urlfilter/{urlfilter}/entries/{entries}',
                '/pm/config/global/obj/dnsfilter/urlfilter/{urlfilter}/entries/{entries}'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'dvmdb_adom': {
            'params': ['adom'],
            'urls': [
                '/dvmdb/adom/{adom}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_device': {
            'params': ['device', 'adom'],
            'urls': [
                '/dvmdb/adom/{adom}/device/{device}',
                '/dvmdb/device/{device}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_device_haslave': {
            'params': ['device', 'ha_slave', 'adom'],
            'urls': [
                '/dvmdb/adom/{adom}/device/{device}/ha_slave/{ha_slave}',
                '/dvmdb/device/{device}/ha_slave/{ha_slave}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_device_vdom': {
            'params': ['device', 'vdom', 'adom'],
            'urls': [
                '/dvmdb/adom/{adom}/device/{device}/vdom/{vdom}',
                '/dvmdb/device/{device}/vdom/{vdom}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_folder': {
            'params': ['folder', 'adom'],
            'urls': [
                '/dvmdb/adom/{adom}/folder/{folder}',
                '/dvmdb/folder/{folder}'
            ],
            'v_range': [['6.4.2', '']]
        },
        'dvmdb_group': {
            'params': ['group', 'adom'],
            'urls': [
                '/dvmdb/adom/{adom}/group/{group}',
                '/dvmdb/group/{group}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_metafields_adom': {
            'params': [],
            'urls': [
                '/dvmdb/_meta_fields/adom'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_metafields_device': {
            'params': [],
            'urls': [
                '/dvmdb/_meta_fields/device'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_metafields_group': {
            'params': [],
            'urls': [
                '/dvmdb/_meta_fields/group'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_revision': {
            'params': ['revision', 'adom'],
            'urls': [
                '/dvmdb/adom/{adom}/revision/{revision}',
                '/dvmdb/global/revision/{revision}',
                '/dvmdb/revision/{revision}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_script': {
            'params': ['script', 'adom'],
            'urls': [
                '/dvmdb/adom/{adom}/script/{script}',
                '/dvmdb/global/script/{script}',
                '/dvmdb/script/{script}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_script_log_latest': {
            'params': ['adom'],
            'urls': [
                '/dvmdb/adom/{adom}/script/log/latest',
                '/dvmdb/global/script/log/latest'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_script_log_latest_device': {
            'params': ['device_name', 'adom'],
            'urls': [
                '/dvmdb/adom/{adom}/script/log/latest/device/{device_name}',
                '/dvmdb/script/log/latest/device/{device_name}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_script_log_list': {
            'params': ['adom'],
            'urls': [
                '/dvmdb/adom/{adom}/script/log/list',
                '/dvmdb/global/script/log/list'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_script_log_list_device': {
            'params': ['device_name', 'adom'],
            'urls': [
                '/dvmdb/adom/{adom}/script/log/list/device/{device_name}',
                '/dvmdb/script/log/list/device/{device_name}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_script_log_output_device_logid': {
            'params': ['device', 'log_id', 'adom'],
            'urls': [
                '/dvmdb/adom/{adom}/script/log/output/device/{device}/logid/{log_id}',
                '/dvmdb/script/log/output/device/{device}/logid/{log_id}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_script_log_output_logid': {
            'params': ['log_id', 'adom'],
            'urls': [
                '/dvmdb/adom/{adom}/script/log/output/logid/{log_id}',
                '/dvmdb/global/script/log/output/logid/{log_id}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_script_log_summary': {
            'params': ['adom'],
            'urls': [
                '/dvmdb/adom/{adom}/script/log/summary',
                '/dvmdb/global/script/log/summary'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_script_log_summary_device': {
            'params': ['device_name', 'adom'],
            'urls': [
                '/dvmdb/adom/{adom}/script/log/summary/device/{device_name}',
                '/dvmdb/script/log/summary/device/{device_name}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_script_scriptschedule': {
            'params': ['script', 'script_schedule', 'adom'],
            'urls': [
                '/dvmdb/adom/{adom}/script/{script}/script_schedule/{script_schedule}',
                '/dvmdb/global/script/{script}/script_schedule/{script_schedule}',
                '/dvmdb/script/{script}/script_schedule/{script_schedule}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_workflow': {
            'params': ['workflow', 'adom'],
            'urls': [
                '/dvmdb/adom/{adom}/workflow/{workflow}',
                '/dvmdb/global/workflow/{workflow}',
                '/dvmdb/workflow/{workflow}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_workflow_wflog': {
            'params': ['workflow', 'wflog', 'adom'],
            'urls': [
                '/dvmdb/adom/{adom}/workflow/{workflow}/wflog/{wflog}',
                '/dvmdb/global/workflow/{workflow}/wflog/{wflog}',
                '/dvmdb/workflow/{workflow}/wflog/{wflog}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_workspace_dirty': {
            'params': ['adom'],
            'urls': [
                '/dvmdb/adom/{adom}/workspace/dirty',
                '/dvmdb/global/workspace/dirty'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_workspace_dirty_dev': {
            'params': ['device_name', 'adom'],
            'urls': [
                '/dvmdb/adom/{adom}/workspace/dirty/dev/{device_name}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_workspace_lockinfo': {
            'params': ['adom'],
            'urls': [
                '/dvmdb/adom/{adom}/workspace/lockinfo',
                '/dvmdb/global/workspace/lockinfo'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_workspace_lockinfo_dev': {
            'params': ['device_name', 'adom'],
            'urls': [
                '/dvmdb/adom/{adom}/workspace/lockinfo/dev/{device_name}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_workspace_lockinfo_obj': {
            'params': ['object_url_name', 'adom'],
            'urls': [
                '/dvmdb/adom/{adom}/workspace/lockinfo/obj/{object_url_name}',
                '/dvmdb/global/workspace/lockinfo/obj/{object_url_name}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dvmdb_workspace_lockinfo_pkg': {
            'params': ['package_path_name', 'adom'],
            'urls': [
                '/dvmdb/adom/{adom}/workspace/lockinfo/pkg/{package_path_name}',
                '/dvmdb/global/workspace/lockinfo/pkg/{package_path_name}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dynamic_address': {
            'params': ['address', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/address/{address}',
                '/pm/config/global/obj/dynamic/address/{address}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dynamic_address_dynamicaddrmapping': {
            'params': ['address', 'dynamic_addr_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/address/{address}/dynamic_addr_mapping/{dynamic_addr_mapping}',
                '/pm/config/global/obj/dynamic/address/{address}/dynamic_addr_mapping/{dynamic_addr_mapping}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dynamic_certificate_local': {
            'params': ['local', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/certificate/local/{local}',
                '/pm/config/global/obj/dynamic/certificate/local/{local}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dynamic_certificate_local_dynamicmapping': {
            'params': ['local', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/certificate/local/{local}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/dynamic/certificate/local/{local}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'dynamic_input_interface': {
            'params': ['interface', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/input/interface/{interface}',
                '/pm/config/global/obj/dynamic/input/interface/{interface}'
            ],
            'v_range': [['6.2.2', '6.4.0']]
        },
        'dynamic_input_interface_dynamicmapping': {
            'params': ['interface', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/input/interface/{interface}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/dynamic/input/interface/{interface}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.2.2', '6.4.0']]
        },
        'dynamic_interface': {
            'params': ['interface', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/interface/{interface}',
                '/pm/config/global/obj/dynamic/interface/{interface}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dynamic_interface_dynamicmapping': {
            'params': ['interface', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/interface/{interface}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/dynamic/interface/{interface}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'dynamic_interface_platformmapping': {
            'params': ['interface', 'platform_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/interface/{interface}/platform_mapping/{platform_mapping}',
                '/pm/config/global/obj/dynamic/interface/{interface}/platform_mapping/{platform_mapping}'
            ],
            'v_range': [['6.4.1', '']]
        },
        'dynamic_ippool': {
            'params': ['ippool', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/ippool/{ippool}',
                '/pm/config/global/obj/dynamic/ippool/{ippool}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dynamic_multicast_interface': {
            'params': ['interface', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/multicast/interface/{interface}',
                '/pm/config/global/obj/dynamic/multicast/interface/{interface}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dynamic_multicast_interface_dynamicmapping': {
            'params': ['interface', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/multicast/interface/{interface}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/dynamic/multicast/interface/{interface}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'dynamic_vip': {
            'params': ['vip', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/vip/{vip}',
                '/pm/config/global/obj/dynamic/vip/{vip}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dynamic_virtualwanlink_members': {
            'params': ['members', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/virtual-wan-link/members/{members}',
                '/pm/config/global/obj/dynamic/virtual-wan-link/members/{members}'
            ],
            'v_range': [['6.0.0', '6.4.14']]
        },
        'dynamic_virtualwanlink_members_dynamicmapping': {
            'params': ['members', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/virtual-wan-link/members/{members}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/dynamic/virtual-wan-link/members/{members}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '6.4.14']]
        },
        'dynamic_virtualwanlink_neighbor': {
            'params': ['neighbor', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/virtual-wan-link/neighbor/{neighbor}',
                '/pm/config/global/obj/dynamic/virtual-wan-link/neighbor/{neighbor}'
            ],
            'v_range': [['6.2.2', '6.4.14']]
        },
        'dynamic_virtualwanlink_neighbor_dynamicmapping': {
            'params': ['neighbor', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/virtual-wan-link/neighbor/{neighbor}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/dynamic/virtual-wan-link/neighbor/{neighbor}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.2.2', '6.4.14']]
        },
        'dynamic_virtualwanlink_server': {
            'params': ['server', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/virtual-wan-link/server/{server}',
                '/pm/config/global/obj/dynamic/virtual-wan-link/server/{server}'
            ],
            'v_range': [['6.0.0', '6.4.14']]
        },
        'dynamic_virtualwanlink_server_dynamicmapping': {
            'params': ['server', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/virtual-wan-link/server/{server}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/dynamic/virtual-wan-link/server/{server}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '6.4.14']]
        },
        'dynamic_vpntunnel': {
            'params': ['vpntunnel', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/vpntunnel/{vpntunnel}',
                '/pm/config/global/obj/dynamic/vpntunnel/{vpntunnel}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'dynamic_vpntunnel_dynamicmapping': {
            'params': ['vpntunnel', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/dynamic/vpntunnel/{vpntunnel}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/dynamic/vpntunnel/{vpntunnel}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'emailfilter_blockallowlist': {
            'params': ['block-allow-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/block-allow-list/{block-allow-list}',
                '/pm/config/global/obj/emailfilter/block-allow-list/{block-allow-list}'
            ],
            'v_range': [['7.0.0', '']]
        },
        'emailfilter_blockallowlist_entries': {
            'params': ['block-allow-list', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/block-allow-list/{block-allow-list}/entries/{entries}',
                '/pm/config/global/obj/emailfilter/block-allow-list/{block-allow-list}/entries/{entries}'
            ],
            'v_range': [['7.0.0', '']]
        },
        'emailfilter_bwl': {
            'params': ['bwl', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/bwl/{bwl}',
                '/pm/config/global/obj/emailfilter/bwl/{bwl}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_bwl_entries': {
            'params': ['bwl', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/bwl/{bwl}/entries/{entries}',
                '/pm/config/global/obj/emailfilter/bwl/{bwl}/entries/{entries}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_bword': {
            'params': ['bword', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/bword/{bword}',
                '/pm/config/global/obj/emailfilter/bword/{bword}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_bword_entries': {
            'params': ['bword', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/bword/{bword}/entries/{entries}',
                '/pm/config/global/obj/emailfilter/bword/{bword}/entries/{entries}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_dnsbl': {
            'params': ['dnsbl', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/dnsbl/{dnsbl}',
                '/pm/config/global/obj/emailfilter/dnsbl/{dnsbl}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_dnsbl_entries': {
            'params': ['dnsbl', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/dnsbl/{dnsbl}/entries/{entries}',
                '/pm/config/global/obj/emailfilter/dnsbl/{dnsbl}/entries/{entries}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_fortishield': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/fortishield',
                '/pm/config/global/obj/emailfilter/fortishield'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_iptrust': {
            'params': ['iptrust', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/iptrust/{iptrust}',
                '/pm/config/global/obj/emailfilter/iptrust/{iptrust}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_iptrust_entries': {
            'params': ['iptrust', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/iptrust/{iptrust}/entries/{entries}',
                '/pm/config/global/obj/emailfilter/iptrust/{iptrust}/entries/{entries}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_mheader': {
            'params': ['mheader', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/mheader/{mheader}',
                '/pm/config/global/obj/emailfilter/mheader/{mheader}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_mheader_entries': {
            'params': ['mheader', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/mheader/{mheader}/entries/{entries}',
                '/pm/config/global/obj/emailfilter/mheader/{mheader}/entries/{entries}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_options': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/options',
                '/pm/config/global/obj/emailfilter/options'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/profile/{profile}',
                '/pm/config/global/obj/emailfilter/profile/{profile}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_profile_filefilter': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/profile/{profile}/file-filter',
                '/pm/config/global/obj/emailfilter/profile/{profile}/file-filter'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_profile_filefilter_entries': {
            'params': ['profile', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/profile/{profile}/file-filter/entries/{entries}',
                '/pm/config/global/obj/emailfilter/profile/{profile}/file-filter/entries/{entries}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_profile_gmail': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/profile/{profile}/gmail',
                '/pm/config/global/obj/emailfilter/profile/{profile}/gmail'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_profile_imap': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/profile/{profile}/imap',
                '/pm/config/global/obj/emailfilter/profile/{profile}/imap'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_profile_mapi': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/profile/{profile}/mapi',
                '/pm/config/global/obj/emailfilter/profile/{profile}/mapi'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_profile_msnhotmail': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/profile/{profile}/msn-hotmail',
                '/pm/config/global/obj/emailfilter/profile/{profile}/msn-hotmail'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_profile_otherwebmails': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/profile/{profile}/other-webmails',
                '/pm/config/global/obj/emailfilter/profile/{profile}/other-webmails'
            ],
            'v_range': [['6.4.2', '']]
        },
        'emailfilter_profile_pop3': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/profile/{profile}/pop3',
                '/pm/config/global/obj/emailfilter/profile/{profile}/pop3'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_profile_smtp': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/profile/{profile}/smtp',
                '/pm/config/global/obj/emailfilter/profile/{profile}/smtp'
            ],
            'v_range': [['6.2.0', '']]
        },
        'emailfilter_profile_yahoomail': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/emailfilter/profile/{profile}/yahoo-mail',
                '/pm/config/global/obj/emailfilter/profile/{profile}/yahoo-mail'
            ],
            'v_range': [['6.2.0', '6.2.0']]
        },
        'endpointcontrol_fctems': {
            'params': ['fctems', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/endpoint-control/fctems/{fctems}',
                '/pm/config/global/obj/endpoint-control/fctems/{fctems}'
            ],
            'v_range': [['7.0.2', '']]
        },
        'extendercontroller_dataplan': {
            'params': ['dataplan', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extender-controller/dataplan/{dataplan}',
                '/pm/config/global/obj/extender-controller/dataplan/{dataplan}'
            ],
            'v_range': [['6.4.4', '']]
        },
        'extendercontroller_extenderprofile': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extender-controller/extender-profile/{extender-profile}',
                '/pm/config/global/obj/extender-controller/extender-profile/{extender-profile}'
            ],
            'v_range': [['7.0.2', '']]
        },
        'extendercontroller_extenderprofile_cellular': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extender-controller/extender-profile/{extender-profile}/cellular',
                '/pm/config/global/obj/extender-controller/extender-profile/{extender-profile}/cellular'
            ],
            'v_range': [['7.0.2', '']]
        },
        'extendercontroller_extenderprofile_cellular_controllerreport': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extender-controller/extender-profile/{extender-profile}/cellular/controller-report',
                '/pm/config/global/obj/extender-controller/extender-profile/{extender-profile}/cellular/controller-report'
            ],
            'v_range': [['7.0.2', '']]
        },
        'extendercontroller_extenderprofile_cellular_modem1': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extender-controller/extender-profile/{extender-profile}/cellular/modem1',
                '/pm/config/global/obj/extender-controller/extender-profile/{extender-profile}/cellular/modem1'
            ],
            'v_range': [['7.0.2', '']]
        },
        'extendercontroller_extenderprofile_cellular_modem1_autoswitch': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extender-controller/extender-profile/{extender-profile}/cellular/modem1/auto-switch',
                '/pm/config/global/obj/extender-controller/extender-profile/{extender-profile}/cellular/modem1/auto-switch'
            ],
            'v_range': [['7.0.2', '']]
        },
        'extendercontroller_extenderprofile_cellular_modem2': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extender-controller/extender-profile/{extender-profile}/cellular/modem2',
                '/pm/config/global/obj/extender-controller/extender-profile/{extender-profile}/cellular/modem2'
            ],
            'v_range': [['7.0.2', '']]
        },
        'extendercontroller_extenderprofile_cellular_modem2_autoswitch': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extender-controller/extender-profile/{extender-profile}/cellular/modem2/auto-switch',
                '/pm/config/global/obj/extender-controller/extender-profile/{extender-profile}/cellular/modem2/auto-switch'
            ],
            'v_range': [['7.0.2', '']]
        },
        'extendercontroller_extenderprofile_cellular_smsnotification': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extender-controller/extender-profile/{extender-profile}/cellular/sms-notification',
                '/pm/config/global/obj/extender-controller/extender-profile/{extender-profile}/cellular/sms-notification'
            ],
            'v_range': [['7.0.2', '']]
        },
        'extendercontroller_extenderprofile_cellular_smsnotification_alert': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extender-controller/extender-profile/{extender-profile}/cellular/sms-notification/alert',
                '/pm/config/global/obj/extender-controller/extender-profile/{extender-profile}/cellular/sms-notification/alert'
            ],
            'v_range': [['7.0.2', '']]
        },
        'extendercontroller_extenderprofile_cellular_smsnotification_receiver': {
            'params': ['extender-profile', 'receiver', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extender-controller/extender-profile/{extender-profile}/cellular/sms-notification/receiver/{receiver}',
                '/pm/config/global/obj/extender-controller/extender-profile/{extender-profile}/cellular/sms-notification/receiver/{receiver}'
            ],
            'v_range': [['7.0.2', '']]
        },
        'extendercontroller_extenderprofile_lanextension': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extender-controller/extender-profile/{extender-profile}/lan-extension',
                '/pm/config/global/obj/extender-controller/extender-profile/{extender-profile}/lan-extension'
            ],
            'v_range': [['7.0.2', '']]
        },
        'extendercontroller_extenderprofile_lanextension_backhaul': {
            'params': ['extender-profile', 'backhaul', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extender-controller/extender-profile/{extender-profile}/lan-extension/backhaul/{backhaul}',
                '/pm/config/global/obj/extender-controller/extender-profile/{extender-profile}/lan-extension/backhaul/{backhaul}'
            ],
            'v_range': [['7.0.2', '']]
        },
        'extendercontroller_simprofile': {
            'params': ['sim_profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extender-controller/sim_profile/{sim_profile}',
                '/pm/config/global/obj/extender-controller/sim_profile/{sim_profile}'
            ],
            'v_range': [['6.4.4', '']]
        },
        'extendercontroller_simprofile_autoswitchprofile': {
            'params': ['sim_profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extender-controller/sim_profile/{sim_profile}/auto-switch_profile',
                '/pm/config/global/obj/extender-controller/sim_profile/{sim_profile}/auto-switch_profile'
            ],
            'v_range': [['6.4.4', '']]
        },
        'extendercontroller_template': {
            'params': ['template', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extender-controller/template/{template}',
                '/pm/config/global/obj/extender-controller/template/{template}'
            ],
            'v_range': [['7.0.0', '']]
        },
        'extensioncontroller_dataplan': {
            'params': ['dataplan', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extension-controller/dataplan/{dataplan}',
                '/pm/config/global/obj/extension-controller/dataplan/{dataplan}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'extensioncontroller_extenderprofile': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extension-controller/extender-profile/{extender-profile}',
                '/pm/config/global/obj/extension-controller/extender-profile/{extender-profile}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'extensioncontroller_extenderprofile_cellular': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extension-controller/extender-profile/{extender-profile}/cellular',
                '/pm/config/global/obj/extension-controller/extender-profile/{extender-profile}/cellular'
            ],
            'v_range': [['7.2.1', '']]
        },
        'extensioncontroller_extenderprofile_cellular_controllerreport': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extension-controller/extender-profile/{extender-profile}/cellular/controller-report',
                '/pm/config/global/obj/extension-controller/extender-profile/{extender-profile}/cellular/controller-report'
            ],
            'v_range': [['7.2.1', '']]
        },
        'extensioncontroller_extenderprofile_cellular_modem1': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extension-controller/extender-profile/{extender-profile}/cellular/modem1',
                '/pm/config/global/obj/extension-controller/extender-profile/{extender-profile}/cellular/modem1'
            ],
            'v_range': [['7.2.1', '']]
        },
        'extensioncontroller_extenderprofile_cellular_modem1_autoswitch': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extension-controller/extender-profile/{extender-profile}/cellular/modem1/auto-switch',
                '/pm/config/global/obj/extension-controller/extender-profile/{extender-profile}/cellular/modem1/auto-switch'
            ],
            'v_range': [['7.2.1', '']]
        },
        'extensioncontroller_extenderprofile_cellular_modem2': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extension-controller/extender-profile/{extender-profile}/cellular/modem2',
                '/pm/config/global/obj/extension-controller/extender-profile/{extender-profile}/cellular/modem2'
            ],
            'v_range': [['7.2.1', '']]
        },
        'extensioncontroller_extenderprofile_cellular_modem2_autoswitch': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extension-controller/extender-profile/{extender-profile}/cellular/modem2/auto-switch',
                '/pm/config/global/obj/extension-controller/extender-profile/{extender-profile}/cellular/modem2/auto-switch'
            ],
            'v_range': [['7.2.1', '']]
        },
        'extensioncontroller_extenderprofile_cellular_smsnotification': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extension-controller/extender-profile/{extender-profile}/cellular/sms-notification',
                '/pm/config/global/obj/extension-controller/extender-profile/{extender-profile}/cellular/sms-notification'
            ],
            'v_range': [['7.2.1', '']]
        },
        'extensioncontroller_extenderprofile_cellular_smsnotification_alert': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extension-controller/extender-profile/{extender-profile}/cellular/sms-notification/alert',
                '/pm/config/global/obj/extension-controller/extender-profile/{extender-profile}/cellular/sms-notification/alert'
            ],
            'v_range': [['7.2.1', '']]
        },
        'extensioncontroller_extenderprofile_cellular_smsnotification_receiver': {
            'params': ['extender-profile', 'receiver', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extension-controller/extender-profile/{extender-profile}/cellular/sms-notification/receiver/{receiver}',
                '/pm/config/global/obj/extension-controller/extender-profile/{extender-profile}/cellular/sms-notification/receiver/{receiver}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'extensioncontroller_extenderprofile_lanextension': {
            'params': ['extender-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extension-controller/extender-profile/{extender-profile}/lan-extension',
                '/pm/config/global/obj/extension-controller/extender-profile/{extender-profile}/lan-extension'
            ],
            'v_range': [['7.2.1', '']]
        },
        'extensioncontroller_extenderprofile_lanextension_backhaul': {
            'params': ['extender-profile', 'backhaul', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/extension-controller/extender-profile/{extender-profile}/lan-extension/backhaul/{backhaul}',
                '/pm/config/global/obj/extension-controller/extender-profile/{extender-profile}/lan-extension/backhaul/{backhaul}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'filefilter_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/file-filter/profile/{profile}',
                '/pm/config/global/obj/file-filter/profile/{profile}'
            ],
            'v_range': [['6.4.1', '']]
        },
        'filefilter_profile_rules': {
            'params': ['profile', 'rules', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/file-filter/profile/{profile}/rules/{rules}',
                '/pm/config/global/obj/file-filter/profile/{profile}/rules/{rules}'
            ],
            'v_range': [['6.4.1', '']]
        },
        'firewall_accessproxy': {
            'params': ['access-proxy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy/{access-proxy}',
                '/pm/config/global/obj/firewall/access-proxy/{access-proxy}'
            ],
            'v_range': [['7.0.0', '']]
        },
        'firewall_accessproxy6': {
            'params': ['access-proxy6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy6/{access-proxy6}',
                '/pm/config/global/obj/firewall/access-proxy6/{access-proxy6}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'firewall_accessproxy6_apigateway': {
            'params': ['access-proxy6', 'api-gateway', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy6/{access-proxy6}/api-gateway/{api-gateway}',
                '/pm/config/global/obj/firewall/access-proxy6/{access-proxy6}/api-gateway/{api-gateway}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'firewall_accessproxy6_apigateway6': {
            'params': ['access-proxy6', 'api-gateway6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy6/{access-proxy6}/api-gateway6/{api-gateway6}',
                '/pm/config/global/obj/firewall/access-proxy6/{access-proxy6}/api-gateway6/{api-gateway6}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'firewall_accessproxy6_apigateway6_quic': {
            'params': ['access-proxy6', 'api-gateway6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy6/{access-proxy6}/api-gateway6/{api-gateway6}/quic',
                '/pm/config/global/obj/firewall/access-proxy6/{access-proxy6}/api-gateway6/{api-gateway6}/quic'
            ],
            'v_range': [['7.4.1', '']]
        },
        'firewall_accessproxy6_apigateway6_realservers': {
            'params': ['access-proxy6', 'api-gateway6', 'realservers', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy6/{access-proxy6}/api-gateway6/{api-gateway6}/realservers/{realservers}',
                '/pm/config/global/obj/firewall/access-proxy6/{access-proxy6}/api-gateway6/{api-gateway6}/realservers/{realservers}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'firewall_accessproxy6_apigateway6_sslciphersuites': {
            'params': ['access-proxy6', 'api-gateway6', 'ssl-cipher-suites', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy6/{access-proxy6}/api-gateway6/{api-gateway6}/ssl-cipher-suites/{ssl-cipher-suites}',
                '/pm/config/global/obj/firewall/access-proxy6/{access-proxy6}/api-gateway6/{api-gateway6}/ssl-cipher-suites/{ssl-cipher-suites}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'firewall_accessproxy6_apigateway_quic': {
            'params': ['access-proxy6', 'api-gateway', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy6/{access-proxy6}/api-gateway/{api-gateway}/quic',
                '/pm/config/global/obj/firewall/access-proxy6/{access-proxy6}/api-gateway/{api-gateway}/quic'
            ],
            'v_range': [['7.4.1', '']]
        },
        'firewall_accessproxy6_apigateway_realservers': {
            'params': ['access-proxy6', 'api-gateway', 'realservers', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy6/{access-proxy6}/api-gateway/{api-gateway}/realservers/{realservers}',
                '/pm/config/global/obj/firewall/access-proxy6/{access-proxy6}/api-gateway/{api-gateway}/realservers/{realservers}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'firewall_accessproxy6_apigateway_sslciphersuites': {
            'params': ['access-proxy6', 'api-gateway', 'ssl-cipher-suites', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy6/{access-proxy6}/api-gateway/{api-gateway}/ssl-cipher-suites/{ssl-cipher-suites}',
                '/pm/config/global/obj/firewall/access-proxy6/{access-proxy6}/api-gateway/{api-gateway}/ssl-cipher-suites/{ssl-cipher-suites}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'firewall_accessproxy_apigateway': {
            'params': ['access-proxy', 'api-gateway', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy/{access-proxy}/api-gateway/{api-gateway}',
                '/pm/config/global/obj/firewall/access-proxy/{access-proxy}/api-gateway/{api-gateway}'
            ],
            'v_range': [['7.0.0', '']]
        },
        'firewall_accessproxy_apigateway6': {
            'params': ['access-proxy', 'api-gateway6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy/{access-proxy}/api-gateway6/{api-gateway6}',
                '/pm/config/global/obj/firewall/access-proxy/{access-proxy}/api-gateway6/{api-gateway6}'
            ],
            'v_range': [['7.0.1', '']]
        },
        'firewall_accessproxy_apigateway6_quic': {
            'params': ['access-proxy', 'api-gateway6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy/{access-proxy}/api-gateway6/{api-gateway6}/quic',
                '/pm/config/global/obj/firewall/access-proxy/{access-proxy}/api-gateway6/{api-gateway6}/quic'
            ],
            'v_range': [['7.4.1', '']]
        },
        'firewall_accessproxy_apigateway6_realservers': {
            'params': ['access-proxy', 'api-gateway6', 'realservers', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy/{access-proxy}/api-gateway6/{api-gateway6}/realservers/{realservers}',
                '/pm/config/global/obj/firewall/access-proxy/{access-proxy}/api-gateway6/{api-gateway6}/realservers/{realservers}'
            ],
            'v_range': [['7.0.1', '']]
        },
        'firewall_accessproxy_apigateway6_sslciphersuites': {
            'params': ['access-proxy', 'api-gateway6', 'ssl-cipher-suites', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy/{access-proxy}/api-gateway6/{api-gateway6}/ssl-cipher-suites/{ssl-cipher-suites}',
                '/pm/config/global/obj/firewall/access-proxy/{access-proxy}/api-gateway6/{api-gateway6}/ssl-cipher-suites/{ssl-cipher-suites}'
            ],
            'v_range': [['7.0.1', '']]
        },
        'firewall_accessproxy_apigateway_quic': {
            'params': ['access-proxy', 'api-gateway', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy/{access-proxy}/api-gateway/{api-gateway}/quic',
                '/pm/config/global/obj/firewall/access-proxy/{access-proxy}/api-gateway/{api-gateway}/quic'
            ],
            'v_range': [['7.4.1', '']]
        },
        'firewall_accessproxy_apigateway_realservers': {
            'params': ['access-proxy', 'api-gateway', 'realservers', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy/{access-proxy}/api-gateway/{api-gateway}/realservers/{realservers}',
                '/pm/config/global/obj/firewall/access-proxy/{access-proxy}/api-gateway/{api-gateway}/realservers/{realservers}'
            ],
            'v_range': [['7.0.0', '']]
        },
        'firewall_accessproxy_apigateway_sslciphersuites': {
            'params': ['access-proxy', 'api-gateway', 'ssl-cipher-suites', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy/{access-proxy}/api-gateway/{api-gateway}/ssl-cipher-suites/{ssl-cipher-suites}',
                '/pm/config/global/obj/firewall/access-proxy/{access-proxy}/api-gateway/{api-gateway}/ssl-cipher-suites/{ssl-cipher-suites}'
            ],
            'v_range': [['7.0.0', '']]
        },
        'firewall_accessproxy_realservers': {
            'params': ['access-proxy', 'realservers', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy/{access-proxy}/realservers/{realservers}',
                '/pm/config/global/obj/firewall/access-proxy/{access-proxy}/realservers/{realservers}'
            ],
            'v_range': [['7.0.0', '']]
        },
        'firewall_accessproxy_serverpubkeyauthsettings': {
            'params': ['access-proxy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy/{access-proxy}/server-pubkey-auth-settings',
                '/pm/config/global/obj/firewall/access-proxy/{access-proxy}/server-pubkey-auth-settings'
            ],
            'v_range': [['7.0.0', '']]
        },
        'firewall_accessproxy_serverpubkeyauthsettings_certextension': {
            'params': ['access-proxy', 'cert-extension', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy/{access-proxy}/server-pubkey-auth-settings/cert-extension/{cert-extension}',
                '/pm/config/global/obj/firewall/access-proxy/{access-proxy}/server-pubkey-auth-settings/cert-extension/{cert-extension}'
            ],
            'v_range': [['7.0.0', '']]
        },
        'firewall_accessproxysshclientcert': {
            'params': ['access-proxy-ssh-client-cert', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy-ssh-client-cert/{access-proxy-ssh-client-cert}',
                '/pm/config/global/obj/firewall/access-proxy-ssh-client-cert/{access-proxy-ssh-client-cert}'
            ],
            'v_range': [['7.4.2', '']]
        },
        'firewall_accessproxysshclientcert_certextension': {
            'params': ['access-proxy-ssh-client-cert', 'cert-extension', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy-ssh-client-cert/{access-proxy-ssh-client-cert}/cert-extension/{cert-extension}',
                '/pm/config/global/obj/firewall/access-proxy-ssh-client-cert/{access-proxy-ssh-client-cert}/cert-extension/{cert-extension}'
            ],
            'v_range': [['7.4.2', '']]
        },
        'firewall_accessproxyvirtualhost': {
            'params': ['access-proxy-virtual-host', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/access-proxy-virtual-host/{access-proxy-virtual-host}',
                '/pm/config/global/obj/firewall/access-proxy-virtual-host/{access-proxy-virtual-host}'
            ],
            'v_range': [['7.0.1', '']]
        },
        'firewall_address': {
            'params': ['address', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/address/{address}',
                '/pm/config/global/obj/firewall/address/{address}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_address6': {
            'params': ['address6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/address6/{address6}',
                '/pm/config/global/obj/firewall/address6/{address6}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_address6_dynamicmapping': {
            'params': ['address6', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/address6/{address6}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/firewall/address6/{address6}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'firewall_address6_dynamicmapping_subnetsegment': {
            'params': ['address6', 'dynamic_mapping', 'subnet-segment', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/address6/{address6}/dynamic_mapping/{dynamic_mapping}/subnet-segment/{subnet-segment}',
                '/pm/config/global/obj/firewall/address6/{address6}/dynamic_mapping/{dynamic_mapping}/subnet-segment/{subnet-segment}'
            ],
            'v_range': [['6.2.1', '7.4.0']]
        },
        'firewall_address6_list': {
            'params': ['address6', 'list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/address6/{address6}/list/{list}',
                '/pm/config/global/obj/firewall/address6/{address6}/list/{list}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_address6_profilelist': {
            'params': ['address6', 'profile-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/address6/{address6}/profile-list/{profile-list}',
                '/pm/config/global/obj/firewall/address6/{address6}/profile-list/{profile-list}'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'firewall_address6_subnetsegment': {
            'params': ['address6', 'subnet-segment', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/address6/{address6}/subnet-segment/{subnet-segment}',
                '/pm/config/global/obj/firewall/address6/{address6}/subnet-segment/{subnet-segment}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_address6_tagging': {
            'params': ['address6', 'tagging', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/address6/{address6}/tagging/{tagging}',
                '/pm/config/global/obj/firewall/address6/{address6}/tagging/{tagging}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_address6template': {
            'params': ['address6-template', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/address6-template/{address6-template}',
                '/pm/config/global/obj/firewall/address6-template/{address6-template}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_address6template_subnetsegment': {
            'params': ['address6-template', 'subnet-segment', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/address6-template/{address6-template}/subnet-segment/{subnet-segment}',
                '/pm/config/global/obj/firewall/address6-template/{address6-template}/subnet-segment/{subnet-segment}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_address6template_subnetsegment_values': {
            'params': ['address6-template', 'subnet-segment', 'values', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/address6-template/{address6-template}/subnet-segment/{subnet-segment}/values/{values}',
                '/pm/config/global/obj/firewall/address6-template/{address6-template}/subnet-segment/{subnet-segment}/values/{values}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_address_dynamicmapping': {
            'params': ['address', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/address/{address}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/firewall/address/{address}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'firewall_address_list': {
            'params': ['address', 'list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/address/{address}/list/{list}',
                '/pm/config/global/obj/firewall/address/{address}/list/{list}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_address_profilelist': {
            'params': ['address', 'profile-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/address/{address}/profile-list/{profile-list}',
                '/pm/config/global/obj/firewall/address/{address}/profile-list/{profile-list}'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'firewall_address_tagging': {
            'params': ['address', 'tagging', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/address/{address}/tagging/{tagging}',
                '/pm/config/global/obj/firewall/address/{address}/tagging/{tagging}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_addrgrp': {
            'params': ['addrgrp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/addrgrp/{addrgrp}',
                '/pm/config/global/obj/firewall/addrgrp/{addrgrp}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_addrgrp6': {
            'params': ['addrgrp6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/addrgrp6/{addrgrp6}',
                '/pm/config/global/obj/firewall/addrgrp6/{addrgrp6}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_addrgrp6_dynamicmapping': {
            'params': ['addrgrp6', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/addrgrp6/{addrgrp6}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/firewall/addrgrp6/{addrgrp6}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'firewall_addrgrp6_tagging': {
            'params': ['addrgrp6', 'tagging', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/addrgrp6/{addrgrp6}/tagging/{tagging}',
                '/pm/config/global/obj/firewall/addrgrp6/{addrgrp6}/tagging/{tagging}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_addrgrp_dynamicmapping': {
            'params': ['addrgrp', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/addrgrp/{addrgrp}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/firewall/addrgrp/{addrgrp}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'firewall_addrgrp_tagging': {
            'params': ['addrgrp', 'tagging', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/addrgrp/{addrgrp}/tagging/{tagging}',
                '/pm/config/global/obj/firewall/addrgrp/{addrgrp}/tagging/{tagging}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_carrierendpointbwl': {
            'params': ['carrier-endpoint-bwl', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/carrier-endpoint-bwl/{carrier-endpoint-bwl}',
                '/pm/config/global/obj/firewall/carrier-endpoint-bwl/{carrier-endpoint-bwl}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_carrierendpointbwl_entries': {
            'params': ['carrier-endpoint-bwl', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/carrier-endpoint-bwl/{carrier-endpoint-bwl}/entries/{entries}',
                '/pm/config/global/obj/firewall/carrier-endpoint-bwl/{carrier-endpoint-bwl}/entries/{entries}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_casbprofile': {
            'params': ['casb-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/casb-profile/{casb-profile}',
                '/pm/config/global/obj/firewall/casb-profile/{casb-profile}'
            ],
            'v_range': [['7.4.1', '7.4.1']]
        },
        'firewall_casbprofile_saasapplication': {
            'params': ['casb-profile', 'saas-application', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/casb-profile/{casb-profile}/saas-application/{saas-application}',
                '/pm/config/global/obj/firewall/casb-profile/{casb-profile}/saas-application/{saas-application}'
            ],
            'v_range': [['7.4.1', '7.4.1']]
        },
        'firewall_casbprofile_saasapplication_accessrule': {
            'params': ['casb-profile', 'saas-application', 'access-rule', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/casb-profile/{casb-profile}/saas-application/{saas-application}/access-rule/{access-rule}',
                '/pm/config/global/obj/firewall/casb-profile/{casb-profile}/saas-application/{saas-application}/access-rule/{access-rule}'
            ],
            'v_range': [['7.4.1', '7.4.1']]
        },
        'firewall_casbprofile_saasapplication_customcontrol': {
            'params': ['casb-profile', 'saas-application', 'custom-control', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/casb-profile/{casb-profile}/saas-application/{saas-application}/custom-control/{custom-control}',
                '/pm/config/global/obj/firewall/casb-profile/{casb-profile}/saas-application/{saas-application}/custom-control/{custom-control}'
            ],
            'v_range': [['7.4.1', '7.4.1']]
        },
        'firewall_casbprofile_saasapplication_customcontrol_option': {
            'params': ['casb-profile', 'saas-application', 'custom-control', 'option', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/casb-profile/{casb-profile}/saas-application/{saas-application}/custom-control/{custom-control}/option/{'
                'option}',
                '/pm/config/global/obj/firewall/casb-profile/{casb-profile}/saas-application/{saas-application}/custom-control/{custom-control}/option/{optio'
                'n}'
            ],
            'v_range': [['7.4.1', '7.4.1']]
        },
        'firewall_decryptedtrafficmirror': {
            'params': ['decrypted-traffic-mirror', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/decrypted-traffic-mirror/{decrypted-traffic-mirror}',
                '/pm/config/global/obj/firewall/decrypted-traffic-mirror/{decrypted-traffic-mirror}'
            ],
            'v_range': [['6.4.1', '']]
        },
        'firewall_explicitproxyaddress': {
            'params': ['explicit-proxy-address', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/explicit-proxy-address/{explicit-proxy-address}',
                '/pm/config/global/obj/firewall/explicit-proxy-address/{explicit-proxy-address}'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'firewall_explicitproxyaddress_headergroup': {
            'params': ['explicit-proxy-address', 'header-group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/explicit-proxy-address/{explicit-proxy-address}/header-group/{header-group}',
                '/pm/config/global/obj/firewall/explicit-proxy-address/{explicit-proxy-address}/header-group/{header-group}'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'firewall_explicitproxyaddrgrp': {
            'params': ['explicit-proxy-addrgrp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/explicit-proxy-addrgrp/{explicit-proxy-addrgrp}',
                '/pm/config/global/obj/firewall/explicit-proxy-addrgrp/{explicit-proxy-addrgrp}'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'firewall_gtp': {
            'params': ['gtp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/gtp/{gtp}',
                '/pm/config/global/obj/firewall/gtp/{gtp}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_gtp_apn': {
            'params': ['gtp', 'apn', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/gtp/{gtp}/apn/{apn}',
                '/pm/config/global/obj/firewall/gtp/{gtp}/apn/{apn}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_gtp_ieremovepolicy': {
            'params': ['gtp', 'ie-remove-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/gtp/{gtp}/ie-remove-policy/{ie-remove-policy}',
                '/pm/config/global/obj/firewall/gtp/{gtp}/ie-remove-policy/{ie-remove-policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_gtp_ievalidation': {
            'params': ['gtp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/gtp/{gtp}/ie-validation',
                '/pm/config/global/obj/firewall/gtp/{gtp}/ie-validation'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_gtp_imsi': {
            'params': ['gtp', 'imsi', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/gtp/{gtp}/imsi/{imsi}',
                '/pm/config/global/obj/firewall/gtp/{gtp}/imsi/{imsi}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_gtp_ippolicy': {
            'params': ['gtp', 'ip-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/gtp/{gtp}/ip-policy/{ip-policy}',
                '/pm/config/global/obj/firewall/gtp/{gtp}/ip-policy/{ip-policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_gtp_messagefilter': {
            'params': ['gtp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/gtp/{gtp}/message-filter',
                '/pm/config/global/obj/firewall/gtp/{gtp}/message-filter'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'firewall_gtp_messageratelimit': {
            'params': ['gtp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/gtp/{gtp}/message-rate-limit',
                '/pm/config/global/obj/firewall/gtp/{gtp}/message-rate-limit'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_gtp_messageratelimitv0': {
            'params': ['gtp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/gtp/{gtp}/message-rate-limit-v0',
                '/pm/config/global/obj/firewall/gtp/{gtp}/message-rate-limit-v0'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_gtp_messageratelimitv1': {
            'params': ['gtp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/gtp/{gtp}/message-rate-limit-v1',
                '/pm/config/global/obj/firewall/gtp/{gtp}/message-rate-limit-v1'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_gtp_messageratelimitv2': {
            'params': ['gtp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/gtp/{gtp}/message-rate-limit-v2',
                '/pm/config/global/obj/firewall/gtp/{gtp}/message-rate-limit-v2'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_gtp_noippolicy': {
            'params': ['gtp', 'noip-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/gtp/{gtp}/noip-policy/{noip-policy}',
                '/pm/config/global/obj/firewall/gtp/{gtp}/noip-policy/{noip-policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_gtp_perapnshaper': {
            'params': ['gtp', 'per-apn-shaper', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/gtp/{gtp}/per-apn-shaper/{per-apn-shaper}',
                '/pm/config/global/obj/firewall/gtp/{gtp}/per-apn-shaper/{per-apn-shaper}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_gtp_policy': {
            'params': ['gtp', 'policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/gtp/{gtp}/policy/{policy}',
                '/pm/config/global/obj/firewall/gtp/{gtp}/policy/{policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_gtp_policyv2': {
            'params': ['gtp', 'policy-v2', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/gtp/{gtp}/policy-v2/{policy-v2}',
                '/pm/config/global/obj/firewall/gtp/{gtp}/policy-v2/{policy-v2}'
            ],
            'v_range': [['6.2.1', '']]
        },
        'firewall_identitybasedroute': {
            'params': ['identity-based-route', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/identity-based-route/{identity-based-route}',
                '/pm/config/global/obj/firewall/identity-based-route/{identity-based-route}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_identitybasedroute_rule': {
            'params': ['identity-based-route', 'rule', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/identity-based-route/{identity-based-route}/rule/{rule}',
                '/pm/config/global/obj/firewall/identity-based-route/{identity-based-route}/rule/{rule}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_internetservice': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/internet-service',
                '/pm/config/global/obj/firewall/internet-service'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_internetservice_entry': {
            'params': ['entry', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/internet-service/entry/{entry}',
                '/pm/config/global/obj/firewall/internet-service/entry/{entry}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'firewall_internetserviceaddition': {
            'params': ['internet-service-addition', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/internet-service-addition/{internet-service-addition}',
                '/pm/config/global/obj/firewall/internet-service-addition/{internet-service-addition}'
            ],
            'v_range': [['6.2.2', '']]
        },
        'firewall_internetserviceaddition_entry': {
            'params': ['internet-service-addition', 'entry', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/internet-service-addition/{internet-service-addition}/entry/{entry}',
                '/pm/config/global/obj/firewall/internet-service-addition/{internet-service-addition}/entry/{entry}'
            ],
            'v_range': [['6.2.2', '']]
        },
        'firewall_internetserviceaddition_entry_portrange': {
            'params': ['internet-service-addition', 'entry', 'port-range', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/internet-service-addition/{internet-service-addition}/entry/{entry}/port-range/{port-range}',
                '/pm/config/global/obj/firewall/internet-service-addition/{internet-service-addition}/entry/{entry}/port-range/{port-range}'
            ],
            'v_range': [['6.2.2', '']]
        },
        'firewall_internetservicecustom': {
            'params': ['internet-service-custom', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/internet-service-custom/{internet-service-custom}',
                '/pm/config/global/obj/firewall/internet-service-custom/{internet-service-custom}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_internetservicecustom_disableentry': {
            'params': ['internet-service-custom', 'disable-entry', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/internet-service-custom/{internet-service-custom}/disable-entry/{disable-entry}',
                '/pm/config/global/obj/firewall/internet-service-custom/{internet-service-custom}/disable-entry/{disable-entry}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'firewall_internetservicecustom_disableentry_iprange': {
            'params': ['internet-service-custom', 'disable-entry', 'ip-range', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/internet-service-custom/{internet-service-custom}/disable-entry/{disable-entry}/ip-range/{ip-range}',
                '/pm/config/global/obj/firewall/internet-service-custom/{internet-service-custom}/disable-entry/{disable-entry}/ip-range/{ip-range}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'firewall_internetservicecustom_entry': {
            'params': ['internet-service-custom', 'entry', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/internet-service-custom/{internet-service-custom}/entry/{entry}',
                '/pm/config/global/obj/firewall/internet-service-custom/{internet-service-custom}/entry/{entry}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_internetservicecustom_entry_portrange': {
            'params': ['internet-service-custom', 'entry', 'port-range', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/internet-service-custom/{internet-service-custom}/entry/{entry}/port-range/{port-range}',
                '/pm/config/global/obj/firewall/internet-service-custom/{internet-service-custom}/entry/{entry}/port-range/{port-range}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_internetservicecustomgroup': {
            'params': ['internet-service-custom-group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/internet-service-custom-group/{internet-service-custom-group}',
                '/pm/config/global/obj/firewall/internet-service-custom-group/{internet-service-custom-group}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_internetservicegroup': {
            'params': ['internet-service-group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/internet-service-group/{internet-service-group}',
                '/pm/config/global/obj/firewall/internet-service-group/{internet-service-group}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_internetservicename': {
            'params': ['internet-service-name', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/internet-service-name/{internet-service-name}',
                '/pm/config/global/obj/firewall/internet-service-name/{internet-service-name}'
            ],
            'v_range': [['6.4.0', '']]
        },
        'firewall_ippool': {
            'params': ['ippool', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/ippool/{ippool}',
                '/pm/config/global/obj/firewall/ippool/{ippool}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_ippool6': {
            'params': ['ippool6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/ippool6/{ippool6}',
                '/pm/config/global/obj/firewall/ippool6/{ippool6}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_ippool6_dynamicmapping': {
            'params': ['ippool6', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/ippool6/{ippool6}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/firewall/ippool6/{ippool6}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'firewall_ippool_dynamicmapping': {
            'params': ['ippool', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/ippool/{ippool}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/firewall/ippool/{ippool}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'firewall_ippoolgrp': {
            'params': ['ippool_grp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/ippool_grp/{ippool_grp}',
                '/pm/config/global/obj/firewall/ippool_grp/{ippool_grp}'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'firewall_ldbmonitor': {
            'params': ['ldb-monitor', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/ldb-monitor/{ldb-monitor}',
                '/pm/config/global/obj/firewall/ldb-monitor/{ldb-monitor}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_mmsprofile': {
            'params': ['mms-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/mms-profile/{mms-profile}',
                '/pm/config/global/obj/firewall/mms-profile/{mms-profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_mmsprofile_dupe': {
            'params': ['mms-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/mms-profile/{mms-profile}/dupe',
                '/pm/config/global/obj/firewall/mms-profile/{mms-profile}/dupe'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_mmsprofile_flood': {
            'params': ['mms-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/mms-profile/{mms-profile}/flood',
                '/pm/config/global/obj/firewall/mms-profile/{mms-profile}/flood'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_mmsprofile_notification': {
            'params': ['mms-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/mms-profile/{mms-profile}/notification',
                '/pm/config/global/obj/firewall/mms-profile/{mms-profile}/notification'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_mmsprofile_notifmsisdn': {
            'params': ['mms-profile', 'notif-msisdn', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/mms-profile/{mms-profile}/notif-msisdn/{notif-msisdn}',
                '/pm/config/global/obj/firewall/mms-profile/{mms-profile}/notif-msisdn/{notif-msisdn}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_mmsprofile_outbreakprevention': {
            'params': ['mms-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/mms-profile/{mms-profile}/outbreak-prevention',
                '/pm/config/global/obj/firewall/mms-profile/{mms-profile}/outbreak-prevention'
            ],
            'v_range': [['6.2.0', '']]
        },
        'firewall_multicastaddress': {
            'params': ['multicast-address', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/multicast-address/{multicast-address}',
                '/pm/config/global/obj/firewall/multicast-address/{multicast-address}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_multicastaddress6': {
            'params': ['multicast-address6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/multicast-address6/{multicast-address6}',
                '/pm/config/global/obj/firewall/multicast-address6/{multicast-address6}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_multicastaddress6_tagging': {
            'params': ['multicast-address6', 'tagging', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/multicast-address6/{multicast-address6}/tagging/{tagging}',
                '/pm/config/global/obj/firewall/multicast-address6/{multicast-address6}/tagging/{tagging}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_multicastaddress_tagging': {
            'params': ['multicast-address', 'tagging', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/multicast-address/{multicast-address}/tagging/{tagging}',
                '/pm/config/global/obj/firewall/multicast-address/{multicast-address}/tagging/{tagging}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_networkservicedynamic': {
            'params': ['network-service-dynamic', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/network-service-dynamic/{network-service-dynamic}',
                '/pm/config/global/obj/firewall/network-service-dynamic/{network-service-dynamic}'
            ],
            'v_range': [['7.2.2', '']]
        },
        'firewall_profilegroup': {
            'params': ['profile-group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/profile-group/{profile-group}',
                '/pm/config/global/obj/firewall/profile-group/{profile-group}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_profileprotocoloptions': {
            'params': ['profile-protocol-options', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/profile-protocol-options/{profile-protocol-options}',
                '/pm/config/global/obj/firewall/profile-protocol-options/{profile-protocol-options}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_profileprotocoloptions_cifs': {
            'params': ['profile-protocol-options', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/profile-protocol-options/{profile-protocol-options}/cifs',
                '/pm/config/global/obj/firewall/profile-protocol-options/{profile-protocol-options}/cifs'
            ],
            'v_range': [['6.2.0', '']]
        },
        'firewall_profileprotocoloptions_cifs_filefilter': {
            'params': ['profile-protocol-options', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/profile-protocol-options/{profile-protocol-options}/cifs/file-filter',
                '/pm/config/global/obj/firewall/profile-protocol-options/{profile-protocol-options}/cifs/file-filter'
            ],
            'v_range': [['6.4.2', '']]
        },
        'firewall_profileprotocoloptions_cifs_filefilter_entries': {
            'params': ['profile-protocol-options', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/profile-protocol-options/{profile-protocol-options}/cifs/file-filter/entries/{entries}',
                '/pm/config/global/obj/firewall/profile-protocol-options/{profile-protocol-options}/cifs/file-filter/entries/{entries}'
            ],
            'v_range': [['6.4.2', '']]
        },
        'firewall_profileprotocoloptions_cifs_serverkeytab': {
            'params': ['profile-protocol-options', 'server-keytab', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/profile-protocol-options/{profile-protocol-options}/cifs/server-keytab/{server-keytab}',
                '/pm/config/global/obj/firewall/profile-protocol-options/{profile-protocol-options}/cifs/server-keytab/{server-keytab}'
            ],
            'v_range': [['6.4.2', '']]
        },
        'firewall_profileprotocoloptions_dns': {
            'params': ['profile-protocol-options', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/profile-protocol-options/{profile-protocol-options}/dns',
                '/pm/config/global/obj/firewall/profile-protocol-options/{profile-protocol-options}/dns'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_profileprotocoloptions_ftp': {
            'params': ['profile-protocol-options', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/profile-protocol-options/{profile-protocol-options}/ftp',
                '/pm/config/global/obj/firewall/profile-protocol-options/{profile-protocol-options}/ftp'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_profileprotocoloptions_http': {
            'params': ['profile-protocol-options', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/profile-protocol-options/{profile-protocol-options}/http',
                '/pm/config/global/obj/firewall/profile-protocol-options/{profile-protocol-options}/http'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_profileprotocoloptions_imap': {
            'params': ['profile-protocol-options', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/profile-protocol-options/{profile-protocol-options}/imap',
                '/pm/config/global/obj/firewall/profile-protocol-options/{profile-protocol-options}/imap'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_profileprotocoloptions_mailsignature': {
            'params': ['profile-protocol-options', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/profile-protocol-options/{profile-protocol-options}/mail-signature',
                '/pm/config/global/obj/firewall/profile-protocol-options/{profile-protocol-options}/mail-signature'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_profileprotocoloptions_mapi': {
            'params': ['profile-protocol-options', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/profile-protocol-options/{profile-protocol-options}/mapi',
                '/pm/config/global/obj/firewall/profile-protocol-options/{profile-protocol-options}/mapi'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_profileprotocoloptions_nntp': {
            'params': ['profile-protocol-options', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/profile-protocol-options/{profile-protocol-options}/nntp',
                '/pm/config/global/obj/firewall/profile-protocol-options/{profile-protocol-options}/nntp'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_profileprotocoloptions_pop3': {
            'params': ['profile-protocol-options', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/profile-protocol-options/{profile-protocol-options}/pop3',
                '/pm/config/global/obj/firewall/profile-protocol-options/{profile-protocol-options}/pop3'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_profileprotocoloptions_smtp': {
            'params': ['profile-protocol-options', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/profile-protocol-options/{profile-protocol-options}/smtp',
                '/pm/config/global/obj/firewall/profile-protocol-options/{profile-protocol-options}/smtp'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_profileprotocoloptions_ssh': {
            'params': ['profile-protocol-options', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/profile-protocol-options/{profile-protocol-options}/ssh',
                '/pm/config/global/obj/firewall/profile-protocol-options/{profile-protocol-options}/ssh'
            ],
            'v_range': [['6.2.2', '']]
        },
        'firewall_proxyaddress': {
            'params': ['proxy-address', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/proxy-address/{proxy-address}',
                '/pm/config/global/obj/firewall/proxy-address/{proxy-address}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_proxyaddress_headergroup': {
            'params': ['proxy-address', 'header-group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/proxy-address/{proxy-address}/header-group/{header-group}',
                '/pm/config/global/obj/firewall/proxy-address/{proxy-address}/header-group/{header-group}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_proxyaddress_tagging': {
            'params': ['proxy-address', 'tagging', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/proxy-address/{proxy-address}/tagging/{tagging}',
                '/pm/config/global/obj/firewall/proxy-address/{proxy-address}/tagging/{tagging}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_proxyaddrgrp': {
            'params': ['proxy-addrgrp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/proxy-addrgrp/{proxy-addrgrp}',
                '/pm/config/global/obj/firewall/proxy-addrgrp/{proxy-addrgrp}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_proxyaddrgrp_tagging': {
            'params': ['proxy-addrgrp', 'tagging', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/proxy-addrgrp/{proxy-addrgrp}/tagging/{tagging}',
                '/pm/config/global/obj/firewall/proxy-addrgrp/{proxy-addrgrp}/tagging/{tagging}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_schedule_group': {
            'params': ['group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/schedule/group/{group}',
                '/pm/config/global/obj/firewall/schedule/group/{group}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_schedule_onetime': {
            'params': ['onetime', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/schedule/onetime/{onetime}',
                '/pm/config/global/obj/firewall/schedule/onetime/{onetime}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_schedule_recurring': {
            'params': ['recurring', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/schedule/recurring/{recurring}',
                '/pm/config/global/obj/firewall/schedule/recurring/{recurring}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_service_category': {
            'params': ['category', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/service/category/{category}',
                '/pm/config/global/obj/firewall/service/category/{category}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_service_custom': {
            'params': ['custom', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/service/custom/{custom}',
                '/pm/config/global/obj/firewall/service/custom/{custom}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_service_group': {
            'params': ['group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/service/group/{group}',
                '/pm/config/global/obj/firewall/service/group/{group}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_shaper_peripshaper': {
            'params': ['per-ip-shaper', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/shaper/per-ip-shaper/{per-ip-shaper}',
                '/pm/config/global/obj/firewall/shaper/per-ip-shaper/{per-ip-shaper}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_shaper_trafficshaper': {
            'params': ['traffic-shaper', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/shaper/traffic-shaper/{traffic-shaper}',
                '/pm/config/global/obj/firewall/shaper/traffic-shaper/{traffic-shaper}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_shapingprofile': {
            'params': ['shaping-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/shaping-profile/{shaping-profile}',
                '/pm/config/global/obj/firewall/shaping-profile/{shaping-profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_shapingprofile_shapingentries': {
            'params': ['shaping-profile', 'shaping-entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/shaping-profile/{shaping-profile}/shaping-entries/{shaping-entries}',
                '/pm/config/global/obj/firewall/shaping-profile/{shaping-profile}/shaping-entries/{shaping-entries}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_ssh_localca': {
            'params': ['local-ca', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/ssh/local-ca/{local-ca}',
                '/pm/config/global/obj/firewall/ssh/local-ca/{local-ca}'
            ],
            'v_range': [['6.2.1', '']]
        },
        'firewall_sslsshprofile': {
            'params': ['ssl-ssh-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}',
                '/pm/config/global/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_sslsshprofile_dot': {
            'params': ['ssl-ssh-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/dot',
                '/pm/config/global/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/dot'
            ],
            'v_range': [['7.0.0', '']]
        },
        'firewall_sslsshprofile_ftps': {
            'params': ['ssl-ssh-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/ftps',
                '/pm/config/global/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/ftps'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_sslsshprofile_https': {
            'params': ['ssl-ssh-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/https',
                '/pm/config/global/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/https'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_sslsshprofile_imaps': {
            'params': ['ssl-ssh-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/imaps',
                '/pm/config/global/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/imaps'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_sslsshprofile_pop3s': {
            'params': ['ssl-ssh-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/pop3s',
                '/pm/config/global/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/pop3s'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_sslsshprofile_smtps': {
            'params': ['ssl-ssh-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/smtps',
                '/pm/config/global/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/smtps'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_sslsshprofile_ssh': {
            'params': ['ssl-ssh-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/ssh',
                '/pm/config/global/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/ssh'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_sslsshprofile_ssl': {
            'params': ['ssl-ssh-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/ssl',
                '/pm/config/global/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/ssl'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_sslsshprofile_sslexempt': {
            'params': ['ssl-ssh-profile', 'ssl-exempt', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/ssl-exempt/{ssl-exempt}',
                '/pm/config/global/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/ssl-exempt/{ssl-exempt}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_sslsshprofile_sslserver': {
            'params': ['ssl-ssh-profile', 'ssl-server', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/ssl-server/{ssl-server}',
                '/pm/config/global/obj/firewall/ssl-ssh-profile/{ssl-ssh-profile}/ssl-server/{ssl-server}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_trafficclass': {
            'params': ['traffic-class', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/traffic-class/{traffic-class}',
                '/pm/config/global/obj/firewall/traffic-class/{traffic-class}'
            ],
            'v_range': [['6.2.2', '']]
        },
        'firewall_vendormac': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vendor-mac',
                '/pm/config/global/obj/firewall/vendor-mac'
            ],
            'v_range': [['7.2.4', '7.2.5'], ['7.4.1', '']]
        },
        'firewall_vip': {
            'params': ['vip', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip/{vip}',
                '/pm/config/global/obj/firewall/vip/{vip}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_vip46': {
            'params': ['vip46', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip46/{vip46}',
                '/pm/config/global/obj/firewall/vip46/{vip46}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_vip46_dynamicmapping': {
            'params': ['vip46', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip46/{vip46}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/firewall/vip46/{vip46}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'firewall_vip46_realservers': {
            'params': ['vip46', 'realservers', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip46/{vip46}/realservers/{realservers}',
                '/pm/config/global/obj/firewall/vip46/{vip46}/realservers/{realservers}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_vip6': {
            'params': ['vip6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip6/{vip6}',
                '/pm/config/global/obj/firewall/vip6/{vip6}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_vip64': {
            'params': ['vip64', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip64/{vip64}',
                '/pm/config/global/obj/firewall/vip64/{vip64}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_vip64_dynamicmapping': {
            'params': ['vip64', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip64/{vip64}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/firewall/vip64/{vip64}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'firewall_vip64_realservers': {
            'params': ['vip64', 'realservers', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip64/{vip64}/realservers/{realservers}',
                '/pm/config/global/obj/firewall/vip64/{vip64}/realservers/{realservers}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_vip6_dynamicmapping': {
            'params': ['vip6', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip6/{vip6}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/firewall/vip6/{vip6}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'firewall_vip6_dynamicmapping_realservers': {
            'params': ['vip6', 'dynamic_mapping', 'realservers', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip6/{vip6}/dynamic_mapping/{dynamic_mapping}/realservers/{realservers}',
                '/pm/config/global/obj/firewall/vip6/{vip6}/dynamic_mapping/{dynamic_mapping}/realservers/{realservers}'
            ],
            'v_range': [['7.0.2', '7.4.0']]
        },
        'firewall_vip6_dynamicmapping_sslciphersuites': {
            'params': ['vip6', 'dynamic_mapping', 'ssl-cipher-suites', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip6/{vip6}/dynamic_mapping/{dynamic_mapping}/ssl-cipher-suites/{ssl-cipher-suites}',
                '/pm/config/global/obj/firewall/vip6/{vip6}/dynamic_mapping/{dynamic_mapping}/ssl-cipher-suites/{ssl-cipher-suites}'
            ],
            'v_range': [['7.0.2', '7.4.0']]
        },
        'firewall_vip6_quic': {
            'params': ['vip6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip6/{vip6}/quic',
                '/pm/config/global/obj/firewall/vip6/{vip6}/quic'
            ],
            'v_range': [['7.4.2', '']]
        },
        'firewall_vip6_realservers': {
            'params': ['vip6', 'realservers', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip6/{vip6}/realservers/{realservers}',
                '/pm/config/global/obj/firewall/vip6/{vip6}/realservers/{realservers}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_vip6_sslciphersuites': {
            'params': ['vip6', 'ssl-cipher-suites', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip6/{vip6}/ssl-cipher-suites/{ssl-cipher-suites}',
                '/pm/config/global/obj/firewall/vip6/{vip6}/ssl-cipher-suites/{ssl-cipher-suites}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_vip6_sslserverciphersuites': {
            'params': ['vip6', 'ssl-server-cipher-suites', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip6/{vip6}/ssl-server-cipher-suites/{ssl-server-cipher-suites}',
                '/pm/config/global/obj/firewall/vip6/{vip6}/ssl-server-cipher-suites/{ssl-server-cipher-suites}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_vip_dynamicmapping': {
            'params': ['vip', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip/{vip}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/firewall/vip/{vip}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'firewall_vip_dynamicmapping_realservers': {
            'params': ['vip', 'dynamic_mapping', 'realservers', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip/{vip}/dynamic_mapping/{dynamic_mapping}/realservers/{realservers}',
                '/pm/config/global/obj/firewall/vip/{vip}/dynamic_mapping/{dynamic_mapping}/realservers/{realservers}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'firewall_vip_dynamicmapping_sslciphersuites': {
            'params': ['vip', 'dynamic_mapping', 'ssl-cipher-suites', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip/{vip}/dynamic_mapping/{dynamic_mapping}/ssl-cipher-suites/{ssl-cipher-suites}',
                '/pm/config/global/obj/firewall/vip/{vip}/dynamic_mapping/{dynamic_mapping}/ssl-cipher-suites/{ssl-cipher-suites}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'firewall_vip_gslbpublicips': {
            'params': ['vip', 'gslb-public-ips', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip/{vip}/gslb-public-ips/{gslb-public-ips}',
                '/pm/config/global/obj/firewall/vip/{vip}/gslb-public-ips/{gslb-public-ips}'
            ],
            'v_range': [['7.4.2', '']]
        },
        'firewall_vip_quic': {
            'params': ['vip', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip/{vip}/quic',
                '/pm/config/global/obj/firewall/vip/{vip}/quic'
            ],
            'v_range': [['7.4.1', '']]
        },
        'firewall_vip_realservers': {
            'params': ['vip', 'realservers', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip/{vip}/realservers/{realservers}',
                '/pm/config/global/obj/firewall/vip/{vip}/realservers/{realservers}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_vip_sslciphersuites': {
            'params': ['vip', 'ssl-cipher-suites', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip/{vip}/ssl-cipher-suites/{ssl-cipher-suites}',
                '/pm/config/global/obj/firewall/vip/{vip}/ssl-cipher-suites/{ssl-cipher-suites}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_vip_sslserverciphersuites': {
            'params': ['vip', 'ssl-server-cipher-suites', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vip/{vip}/ssl-server-cipher-suites/{ssl-server-cipher-suites}',
                '/pm/config/global/obj/firewall/vip/{vip}/ssl-server-cipher-suites/{ssl-server-cipher-suites}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_vipgrp': {
            'params': ['vipgrp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vipgrp/{vipgrp}',
                '/pm/config/global/obj/firewall/vipgrp/{vipgrp}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_vipgrp46': {
            'params': ['vipgrp46', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vipgrp46/{vipgrp46}',
                '/pm/config/global/obj/firewall/vipgrp46/{vipgrp46}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_vipgrp6': {
            'params': ['vipgrp6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vipgrp6/{vipgrp6}',
                '/pm/config/global/obj/firewall/vipgrp6/{vipgrp6}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_vipgrp64': {
            'params': ['vipgrp64', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vipgrp64/{vipgrp64}',
                '/pm/config/global/obj/firewall/vipgrp64/{vipgrp64}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_vipgrp_dynamicmapping': {
            'params': ['vipgrp', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/vipgrp/{vipgrp}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/firewall/vipgrp/{vipgrp}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'firewall_wildcardfqdn_custom': {
            'params': ['custom', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/wildcard-fqdn/custom/{custom}',
                '/pm/config/global/obj/firewall/wildcard-fqdn/custom/{custom}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'firewall_wildcardfqdn_group': {
            'params': ['group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/firewall/wildcard-fqdn/group/{group}',
                '/pm/config/global/obj/firewall/wildcard-fqdn/group/{group}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmg_device_blueprint': {
            'params': ['blueprint', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fmg/device/blueprint/{blueprint}',
                '/pm/config/global/obj/fmg/device/blueprint/{blueprint}'
            ],
            'v_range': [['7.2.0', '']]
        },
        'fmg_fabric_authorization_template': {
            'params': ['template', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fmg/fabric/authorization/template/{template}',
                '/pm/config/global/obj/fmg/fabric/authorization/template/{template}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'fmg_fabric_authorization_template_platforms': {
            'params': ['template', 'platforms', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fmg/fabric/authorization/template/{template}/platforms/{platforms}',
                '/pm/config/global/obj/fmg/fabric/authorization/template/{template}/platforms/{platforms}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'fmg_variable': {
            'params': ['variable', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fmg/variable/{variable}',
                '/pm/config/global/obj/fmg/variable/{variable}'
            ],
            'v_range': [['7.2.0', '']]
        },
        'fmg_variable_dynamicmapping': {
            'params': ['variable', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fmg/variable/{variable}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/fmg/variable/{variable}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['7.2.0', '7.4.0']]
        },
        'fmupdate_analyzer_virusreport': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/analyzer/virusreport'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_avips_advancedlog': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/av-ips/advanced-log'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_avips_webproxy': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/av-ips/web-proxy'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'fmupdate_customurllist': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/custom-url-list'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_diskquota': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/disk-quota'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_fctservices': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/fct-services'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_fdssetting': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/fds-setting'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_fdssetting_pushoverride': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/fds-setting/push-override'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_fdssetting_pushoverridetoclient': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/fds-setting/push-override-to-client'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_fdssetting_pushoverridetoclient_announceip': {
            'params': ['announce-ip'],
            'urls': [
                '/cli/global/fmupdate/fds-setting/push-override-to-client/announce-ip/{announce-ip}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_fdssetting_serveroverride': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/fds-setting/server-override'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_fdssetting_serveroverride_servlist': {
            'params': ['servlist'],
            'urls': [
                '/cli/global/fmupdate/fds-setting/server-override/servlist/{servlist}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_fdssetting_updateschedule': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/fds-setting/update-schedule'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_fwmsetting': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/fwm-setting'
            ],
            'v_range': [['6.2.2', '']]
        },
        'fmupdate_fwmsetting_upgradetimeout': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/fwm-setting/upgrade-timeout'
            ],
            'v_range': [['7.0.5', '7.0.12'], ['7.2.2', '']]
        },
        'fmupdate_multilayer': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/multilayer'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_publicnetwork': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/publicnetwork'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_serveraccesspriorities': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/server-access-priorities'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_serveraccesspriorities_privateserver': {
            'params': ['private-server'],
            'urls': [
                '/cli/global/fmupdate/server-access-priorities/private-server/{private-server}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_serveroverridestatus': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/server-override-status'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_service': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/service'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_webspam_fgdsetting': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/web-spam/fgd-setting'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_webspam_fgdsetting_serveroverride': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/web-spam/fgd-setting/server-override'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_webspam_fgdsetting_serveroverride_servlist': {
            'params': ['servlist'],
            'urls': [
                '/cli/global/fmupdate/web-spam/fgd-setting/server-override/servlist/{servlist}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fmupdate_webspam_webproxy': {
            'params': [],
            'urls': [
                '/cli/global/fmupdate/web-spam/web-proxy'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'footer_consolidated_policy': {
            'params': ['policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/global/footer/consolidated/policy/{policy}'
            ],
            'v_range': [['6.0.0', '7.0.4'], ['7.2.0', '7.2.1']]
        },
        'footer_policy': {
            'params': ['policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/global/footer/policy/{policy}'
            ],
            'v_range': [['6.0.0', '7.0.4'], ['7.2.0', '7.2.1']]
        },
        'footer_policy6': {
            'params': ['policy6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/global/footer/policy6/{policy6}'
            ],
            'v_range': [['6.0.0', '7.0.4'], ['7.2.0', '7.2.1']]
        },
        'footer_policy6_identitybasedpolicy6': {
            'params': ['policy6', 'identity-based-policy6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/global/footer/policy6/{policy6}/identity-based-policy6/{identity-based-policy6}'
            ],
            'v_range': [['6.0.0', '6.2.0']]
        },
        'footer_policy_identitybasedpolicy': {
            'params': ['policy', 'identity-based-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/global/footer/policy/{policy}/identity-based-policy/{identity-based-policy}'
            ],
            'v_range': [['6.0.0', '6.2.0']]
        },
        'footer_shapingpolicy': {
            'params': ['shaping-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/global/footer/shaping-policy/{shaping-policy}'
            ],
            'v_range': [['6.0.0', '7.0.4'], ['7.2.0', '7.2.1']]
        },
        'fsp_vlan': {
            'params': ['vlan', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}',
                '/pm/config/global/obj/fsp/vlan/{vlan}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fsp_vlan_dhcpserver': {
            'params': ['vlan', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dhcp-server',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dhcp-server'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fsp_vlan_dhcpserver_excluderange': {
            'params': ['vlan', 'exclude-range', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dhcp-server/exclude-range/{exclude-range}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dhcp-server/exclude-range/{exclude-range}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fsp_vlan_dhcpserver_iprange': {
            'params': ['vlan', 'ip-range', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dhcp-server/ip-range/{ip-range}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dhcp-server/ip-range/{ip-range}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fsp_vlan_dhcpserver_options': {
            'params': ['vlan', 'options', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dhcp-server/options/{options}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dhcp-server/options/{options}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fsp_vlan_dhcpserver_reservedaddress': {
            'params': ['vlan', 'reserved-address', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dhcp-server/reserved-address/{reserved-address}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dhcp-server/reserved-address/{reserved-address}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fsp_vlan_dynamicmapping': {
            'params': ['vlan', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'fsp_vlan_dynamicmapping_dhcpserver': {
            'params': ['vlan', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/dhcp-server',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/dhcp-server'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'fsp_vlan_dynamicmapping_dhcpserver_excluderange': {
            'params': ['vlan', 'dynamic_mapping', 'exclude-range', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/dhcp-server/exclude-range/{exclude-range}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/dhcp-server/exclude-range/{exclude-range}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'fsp_vlan_dynamicmapping_dhcpserver_iprange': {
            'params': ['vlan', 'dynamic_mapping', 'ip-range', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/dhcp-server/ip-range/{ip-range}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/dhcp-server/ip-range/{ip-range}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'fsp_vlan_dynamicmapping_dhcpserver_options': {
            'params': ['vlan', 'dynamic_mapping', 'options', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/dhcp-server/options/{options}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/dhcp-server/options/{options}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'fsp_vlan_dynamicmapping_dhcpserver_reservedaddress': {
            'params': ['vlan', 'dynamic_mapping', 'reserved-address', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/dhcp-server/reserved-address/{reserved-address}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/dhcp-server/reserved-address/{reserved-address}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'fsp_vlan_dynamicmapping_interface': {
            'params': ['vlan', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/interface',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/interface'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'fsp_vlan_dynamicmapping_interface_ipv6': {
            'params': ['vlan', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/interface/ipv6',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/interface/ipv6'
            ],
            'v_range': [['6.2.2', '7.4.0']]
        },
        'fsp_vlan_dynamicmapping_interface_ipv6_ip6delegatedprefixlist': {
            'params': ['vlan', 'dynamic_mapping', 'ip6-delegated-prefix-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/interface/ipv6/ip6-delegated-prefix-list/{ip6-delegated-prefix-'
                'list}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/interface/ipv6/ip6-delegated-prefix-list/{ip6-delegated-prefix-list}'
            ],
            'v_range': [['6.2.2', '7.4.0']]
        },
        'fsp_vlan_dynamicmapping_interface_ipv6_ip6extraaddr': {
            'params': ['vlan', 'dynamic_mapping', 'ip6-extra-addr', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/interface/ipv6/ip6-extra-addr/{ip6-extra-addr}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/interface/ipv6/ip6-extra-addr/{ip6-extra-addr}'
            ],
            'v_range': [['6.2.2', '7.4.0']]
        },
        'fsp_vlan_dynamicmapping_interface_ipv6_ip6prefixlist': {
            'params': ['vlan', 'dynamic_mapping', 'ip6-prefix-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/interface/ipv6/ip6-prefix-list/{ip6-prefix-list}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/interface/ipv6/ip6-prefix-list/{ip6-prefix-list}'
            ],
            'v_range': [['6.2.2', '7.4.0']]
        },
        'fsp_vlan_dynamicmapping_interface_ipv6_vrrp6': {
            'params': ['vlan', 'dynamic_mapping', 'vrrp6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/interface/ipv6/vrrp6/{vrrp6}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/interface/ipv6/vrrp6/{vrrp6}'
            ],
            'v_range': [['6.2.2', '7.4.0']]
        },
        'fsp_vlan_dynamicmapping_interface_secondaryip': {
            'params': ['vlan', 'dynamic_mapping', 'secondaryip', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/interface/secondaryip/{secondaryip}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/interface/secondaryip/{secondaryip}'
            ],
            'v_range': [['6.2.3', '7.4.0']]
        },
        'fsp_vlan_dynamicmapping_interface_vrrp': {
            'params': ['vlan', 'dynamic_mapping', 'vrrp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/interface/vrrp/{vrrp}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/interface/vrrp/{vrrp}'
            ],
            'v_range': [['7.4.0', '7.4.0']]
        },
        'fsp_vlan_dynamicmapping_interface_vrrp_proxyarp': {
            'params': ['vlan', 'dynamic_mapping', 'vrrp', 'proxy-arp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/interface/vrrp/{vrrp}/proxy-arp/{proxy-arp}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/dynamic_mapping/{dynamic_mapping}/interface/vrrp/{vrrp}/proxy-arp/{proxy-arp}'
            ],
            'v_range': [['7.4.0', '7.4.0']]
        },
        'fsp_vlan_interface': {
            'params': ['vlan', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/interface',
                '/pm/config/global/obj/fsp/vlan/{vlan}/interface'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fsp_vlan_interface_ipv6': {
            'params': ['vlan', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/interface/ipv6',
                '/pm/config/global/obj/fsp/vlan/{vlan}/interface/ipv6'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fsp_vlan_interface_ipv6_ip6delegatedprefixlist': {
            'params': ['vlan', 'ip6-delegated-prefix-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/interface/ipv6/ip6-delegated-prefix-list/{ip6-delegated-prefix-list}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/interface/ipv6/ip6-delegated-prefix-list/{ip6-delegated-prefix-list}'
            ],
            'v_range': [['6.2.2', '']]
        },
        'fsp_vlan_interface_ipv6_ip6extraaddr': {
            'params': ['vlan', 'ip6-extra-addr', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/interface/ipv6/ip6-extra-addr/{ip6-extra-addr}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/interface/ipv6/ip6-extra-addr/{ip6-extra-addr}'
            ],
            'v_range': [['6.2.2', '']]
        },
        'fsp_vlan_interface_ipv6_ip6prefixlist': {
            'params': ['vlan', 'ip6-prefix-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/interface/ipv6/ip6-prefix-list/{ip6-prefix-list}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/interface/ipv6/ip6-prefix-list/{ip6-prefix-list}'
            ],
            'v_range': [['6.2.2', '']]
        },
        'fsp_vlan_interface_ipv6_vrrp6': {
            'params': ['vlan', 'vrrp6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/interface/ipv6/vrrp6/{vrrp6}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/interface/ipv6/vrrp6/{vrrp6}'
            ],
            'v_range': [['6.2.2', '']]
        },
        'fsp_vlan_interface_secondaryip': {
            'params': ['vlan', 'secondaryip', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/interface/secondaryip/{secondaryip}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/interface/secondaryip/{secondaryip}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fsp_vlan_interface_vrrp': {
            'params': ['vlan', 'vrrp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/interface/vrrp/{vrrp}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/interface/vrrp/{vrrp}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'fsp_vlan_interface_vrrp_proxyarp': {
            'params': ['vlan', 'vrrp', 'proxy-arp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/fsp/vlan/{vlan}/interface/vrrp/{vrrp}/proxy-arp/{proxy-arp}',
                '/pm/config/global/obj/fsp/vlan/{vlan}/interface/vrrp/{vrrp}/proxy-arp/{proxy-arp}'
            ],
            'v_range': [['7.4.0', '']]
        },
        'gtp_apn': {
            'params': ['apn', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/gtp/apn/{apn}',
                '/pm/config/global/obj/gtp/apn/{apn}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'gtp_apngrp': {
            'params': ['apngrp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/gtp/apngrp/{apngrp}',
                '/pm/config/global/obj/gtp/apngrp/{apngrp}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'gtp_iewhitelist': {
            'params': ['ie-white-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/gtp/ie-white-list/{ie-white-list}',
                '/pm/config/global/obj/gtp/ie-white-list/{ie-white-list}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'gtp_iewhitelist_entries': {
            'params': ['ie-white-list', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/gtp/ie-white-list/{ie-white-list}/entries/{entries}',
                '/pm/config/global/obj/gtp/ie-white-list/{ie-white-list}/entries/{entries}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'gtp_messagefilterv0v1': {
            'params': ['message-filter-v0v1', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/gtp/message-filter-v0v1/{message-filter-v0v1}',
                '/pm/config/global/obj/gtp/message-filter-v0v1/{message-filter-v0v1}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'gtp_messagefilterv2': {
            'params': ['message-filter-v2', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/gtp/message-filter-v2/{message-filter-v2}',
                '/pm/config/global/obj/gtp/message-filter-v2/{message-filter-v2}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'gtp_tunnellimit': {
            'params': ['tunnel-limit', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/gtp/tunnel-limit/{tunnel-limit}',
                '/pm/config/global/obj/gtp/tunnel-limit/{tunnel-limit}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'header_consolidated_policy': {
            'params': ['policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/global/header/consolidated/policy/{policy}'
            ],
            'v_range': [['6.0.0', '7.0.4'], ['7.2.0', '7.2.1']]
        },
        'header_policy': {
            'params': ['policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/global/header/policy/{policy}'
            ],
            'v_range': [['6.0.0', '7.0.4'], ['7.2.0', '7.2.1']]
        },
        'header_policy6': {
            'params': ['policy6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/global/header/policy6/{policy6}'
            ],
            'v_range': [['6.0.0', '7.0.4'], ['7.2.0', '7.2.1']]
        },
        'header_policy6_identitybasedpolicy6': {
            'params': ['policy6', 'identity-based-policy6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/global/header/policy6/{policy6}/identity-based-policy6/{identity-based-policy6}'
            ],
            'v_range': [['6.0.0', '6.2.0']]
        },
        'header_policy_identitybasedpolicy': {
            'params': ['policy', 'identity-based-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/global/header/policy/{policy}/identity-based-policy/{identity-based-policy}'
            ],
            'v_range': [['6.0.0', '6.2.0']]
        },
        'header_shapingpolicy': {
            'params': ['shaping-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/global/header/shaping-policy/{shaping-policy}'
            ],
            'v_range': [['6.0.0', '7.0.4'], ['7.2.0', '7.2.1']]
        },
        'hotspot20_anqp3gppcellular': {
            'params': ['anqp-3gpp-cellular', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/anqp-3gpp-cellular/{anqp-3gpp-cellular}',
                '/pm/config/global/obj/wireless-controller/hotspot20/anqp-3gpp-cellular/{anqp-3gpp-cellular}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_anqp3gppcellular_mccmnclist': {
            'params': ['anqp-3gpp-cellular', 'mcc-mnc-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/anqp-3gpp-cellular/{anqp-3gpp-cellular}/mcc-mnc-list/{mcc-mnc-list}',
                '/pm/config/global/obj/wireless-controller/hotspot20/anqp-3gpp-cellular/{anqp-3gpp-cellular}/mcc-mnc-list/{mcc-mnc-list}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_anqpipaddresstype': {
            'params': ['anqp-ip-address-type', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/anqp-ip-address-type/{anqp-ip-address-type}',
                '/pm/config/global/obj/wireless-controller/hotspot20/anqp-ip-address-type/{anqp-ip-address-type}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_anqpnairealm': {
            'params': ['anqp-nai-realm', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/anqp-nai-realm/{anqp-nai-realm}',
                '/pm/config/global/obj/wireless-controller/hotspot20/anqp-nai-realm/{anqp-nai-realm}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_anqpnairealm_nailist': {
            'params': ['anqp-nai-realm', 'nai-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/anqp-nai-realm/{anqp-nai-realm}/nai-list/{nai-list}',
                '/pm/config/global/obj/wireless-controller/hotspot20/anqp-nai-realm/{anqp-nai-realm}/nai-list/{nai-list}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_anqpnairealm_nailist_eapmethod': {
            'params': ['anqp-nai-realm', 'nai-list', 'eap-method', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/anqp-nai-realm/{anqp-nai-realm}/nai-list/{nai-list}/eap-method/{eap-method}',
                '/pm/config/global/obj/wireless-controller/hotspot20/anqp-nai-realm/{anqp-nai-realm}/nai-list/{nai-list}/eap-method/{eap-method}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_anqpnairealm_nailist_eapmethod_authparam': {
            'params': ['anqp-nai-realm', 'nai-list', 'eap-method', 'auth-param', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/anqp-nai-realm/{anqp-nai-realm}/nai-list/{nai-list}/eap-method/{eap-method}/auth-pa'
                'ram/{auth-param}',
                '/pm/config/global/obj/wireless-controller/hotspot20/anqp-nai-realm/{anqp-nai-realm}/nai-list/{nai-list}/eap-method/{eap-method}/auth-param/{'
                'auth-param}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_anqpnetworkauthtype': {
            'params': ['anqp-network-auth-type', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/anqp-network-auth-type/{anqp-network-auth-type}',
                '/pm/config/global/obj/wireless-controller/hotspot20/anqp-network-auth-type/{anqp-network-auth-type}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_anqproamingconsortium': {
            'params': ['anqp-roaming-consortium', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/anqp-roaming-consortium/{anqp-roaming-consortium}',
                '/pm/config/global/obj/wireless-controller/hotspot20/anqp-roaming-consortium/{anqp-roaming-consortium}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_anqproamingconsortium_oilist': {
            'params': ['anqp-roaming-consortium', 'oi-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/anqp-roaming-consortium/{anqp-roaming-consortium}/oi-list/{oi-list}',
                '/pm/config/global/obj/wireless-controller/hotspot20/anqp-roaming-consortium/{anqp-roaming-consortium}/oi-list/{oi-list}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_anqpvenuename': {
            'params': ['anqp-venue-name', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/anqp-venue-name/{anqp-venue-name}',
                '/pm/config/global/obj/wireless-controller/hotspot20/anqp-venue-name/{anqp-venue-name}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_anqpvenuename_valuelist': {
            'params': ['anqp-venue-name', 'value-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/anqp-venue-name/{anqp-venue-name}/value-list/{value-list}',
                '/pm/config/global/obj/wireless-controller/hotspot20/anqp-venue-name/{anqp-venue-name}/value-list/{value-list}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_anqpvenueurl': {
            'params': ['anqp-venue-url', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/anqp-venue-url/{anqp-venue-url}',
                '/pm/config/global/obj/wireless-controller/hotspot20/anqp-venue-url/{anqp-venue-url}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'hotspot20_anqpvenueurl_valuelist': {
            'params': ['anqp-venue-url', 'value-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/anqp-venue-url/{anqp-venue-url}/value-list/{value-list}',
                '/pm/config/global/obj/wireless-controller/hotspot20/anqp-venue-url/{anqp-venue-url}/value-list/{value-list}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'hotspot20_h2qpadviceofcharge': {
            'params': ['h2qp-advice-of-charge', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/h2qp-advice-of-charge/{h2qp-advice-of-charge}',
                '/pm/config/global/obj/wireless-controller/hotspot20/h2qp-advice-of-charge/{h2qp-advice-of-charge}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'hotspot20_h2qpadviceofcharge_aoclist': {
            'params': ['h2qp-advice-of-charge', 'aoc-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/h2qp-advice-of-charge/{h2qp-advice-of-charge}/aoc-list/{aoc-list}',
                '/pm/config/global/obj/wireless-controller/hotspot20/h2qp-advice-of-charge/{h2qp-advice-of-charge}/aoc-list/{aoc-list}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'hotspot20_h2qpadviceofcharge_aoclist_planinfo': {
            'params': ['h2qp-advice-of-charge', 'aoc-list', 'plan-info', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/h2qp-advice-of-charge/{h2qp-advice-of-charge}/aoc-list/{aoc-list}/plan-info/{plan-i'
                'nfo}',
                '/pm/config/global/obj/wireless-controller/hotspot20/h2qp-advice-of-charge/{h2qp-advice-of-charge}/aoc-list/{aoc-list}/plan-info/{plan-info}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'hotspot20_h2qpconncapability': {
            'params': ['h2qp-conn-capability', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/h2qp-conn-capability/{h2qp-conn-capability}',
                '/pm/config/global/obj/wireless-controller/hotspot20/h2qp-conn-capability/{h2qp-conn-capability}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_h2qpoperatorname': {
            'params': ['h2qp-operator-name', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/h2qp-operator-name/{h2qp-operator-name}',
                '/pm/config/global/obj/wireless-controller/hotspot20/h2qp-operator-name/{h2qp-operator-name}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_h2qpoperatorname_valuelist': {
            'params': ['h2qp-operator-name', 'value-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/h2qp-operator-name/{h2qp-operator-name}/value-list/{value-list}',
                '/pm/config/global/obj/wireless-controller/hotspot20/h2qp-operator-name/{h2qp-operator-name}/value-list/{value-list}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_h2qposuprovider': {
            'params': ['h2qp-osu-provider', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/h2qp-osu-provider/{h2qp-osu-provider}',
                '/pm/config/global/obj/wireless-controller/hotspot20/h2qp-osu-provider/{h2qp-osu-provider}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_h2qposuprovider_friendlyname': {
            'params': ['h2qp-osu-provider', 'friendly-name', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/h2qp-osu-provider/{h2qp-osu-provider}/friendly-name/{friendly-name}',
                '/pm/config/global/obj/wireless-controller/hotspot20/h2qp-osu-provider/{h2qp-osu-provider}/friendly-name/{friendly-name}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_h2qposuprovider_servicedescription': {
            'params': ['h2qp-osu-provider', 'service-description', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/h2qp-osu-provider/{h2qp-osu-provider}/service-description/{service-description}',
                '/pm/config/global/obj/wireless-controller/hotspot20/h2qp-osu-provider/{h2qp-osu-provider}/service-description/{service-description}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_h2qposuprovidernai': {
            'params': ['h2qp-osu-provider-nai', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/h2qp-osu-provider-nai/{h2qp-osu-provider-nai}',
                '/pm/config/global/obj/wireless-controller/hotspot20/h2qp-osu-provider-nai/{h2qp-osu-provider-nai}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'hotspot20_h2qposuprovidernai_nailist': {
            'params': ['h2qp-osu-provider-nai', 'nai-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/h2qp-osu-provider-nai/{h2qp-osu-provider-nai}/nai-list/{nai-list}',
                '/pm/config/global/obj/wireless-controller/hotspot20/h2qp-osu-provider-nai/{h2qp-osu-provider-nai}/nai-list/{nai-list}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'hotspot20_h2qptermsandconditions': {
            'params': ['h2qp-terms-and-conditions', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/h2qp-terms-and-conditions/{h2qp-terms-and-conditions}',
                '/pm/config/global/obj/wireless-controller/hotspot20/h2qp-terms-and-conditions/{h2qp-terms-and-conditions}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'hotspot20_h2qpwanmetric': {
            'params': ['h2qp-wan-metric', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/h2qp-wan-metric/{h2qp-wan-metric}',
                '/pm/config/global/obj/wireless-controller/hotspot20/h2qp-wan-metric/{h2qp-wan-metric}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_hsprofile': {
            'params': ['hs-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/hs-profile/{hs-profile}',
                '/pm/config/global/obj/wireless-controller/hotspot20/hs-profile/{hs-profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_icon': {
            'params': ['icon', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/icon/{icon}',
                '/pm/config/global/obj/wireless-controller/hotspot20/icon/{icon}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'hotspot20_icon_iconlist': {
            'params': ['icon', 'icon-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/icon/{icon}/icon-list/{icon-list}',
                '/pm/config/global/obj/wireless-controller/hotspot20/icon/{icon}/icon-list/{icon-list}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'hotspot20_qosmap': {
            'params': ['qos-map', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/qos-map/{qos-map}',
                '/pm/config/global/obj/wireless-controller/hotspot20/qos-map/{qos-map}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_qosmap_dscpexcept': {
            'params': ['qos-map', 'dscp-except', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/qos-map/{qos-map}/dscp-except/{dscp-except}',
                '/pm/config/global/obj/wireless-controller/hotspot20/qos-map/{qos-map}/dscp-except/{dscp-except}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'hotspot20_qosmap_dscprange': {
            'params': ['qos-map', 'dscp-range', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/hotspot20/qos-map/{qos-map}/dscp-range/{dscp-range}',
                '/pm/config/global/obj/wireless-controller/hotspot20/qos-map/{qos-map}/dscp-range/{dscp-range}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'icap_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/icap/profile/{profile}',
                '/pm/config/global/obj/icap/profile/{profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'icap_profile_icapheaders': {
            'params': ['profile', 'icap-headers', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/icap/profile/{profile}/icap-headers/{icap-headers}',
                '/pm/config/global/obj/icap/profile/{profile}/icap-headers/{icap-headers}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'icap_profile_respmodforwardrules': {
            'params': ['profile', 'respmod-forward-rules', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/icap/profile/{profile}/respmod-forward-rules/{respmod-forward-rules}',
                '/pm/config/global/obj/icap/profile/{profile}/respmod-forward-rules/{respmod-forward-rules}'
            ],
            'v_range': [['6.4.0', '']]
        },
        'icap_profile_respmodforwardrules_headergroup': {
            'params': ['profile', 'respmod-forward-rules', 'header-group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/icap/profile/{profile}/respmod-forward-rules/{respmod-forward-rules}/header-group/{header-group}',
                '/pm/config/global/obj/icap/profile/{profile}/respmod-forward-rules/{respmod-forward-rules}/header-group/{header-group}'
            ],
            'v_range': [['6.4.0', '']]
        },
        'icap_server': {
            'params': ['server', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/icap/server/{server}',
                '/pm/config/global/obj/icap/server/{server}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'ips_baseline_sensor': {
            'params': ['sensor', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/ips/baseline/sensor/{sensor}',
                '/pm/config/global/obj/ips/baseline/sensor/{sensor}'
            ],
            'v_range': [['7.0.1', '7.0.2']]
        },
        'ips_baseline_sensor_entries': {
            'params': ['sensor', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/ips/baseline/sensor/{sensor}/entries/{entries}',
                '/pm/config/global/obj/ips/baseline/sensor/{sensor}/entries/{entries}'
            ],
            'v_range': [['7.0.1', '7.0.2']]
        },
        'ips_baseline_sensor_entries_exemptip': {
            'params': ['sensor', 'entries', 'exempt-ip', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/ips/baseline/sensor/{sensor}/entries/{entries}/exempt-ip/{exempt-ip}',
                '/pm/config/global/obj/ips/baseline/sensor/{sensor}/entries/{entries}/exempt-ip/{exempt-ip}'
            ],
            'v_range': [['7.0.1', '7.0.2']]
        },
        'ips_baseline_sensor_filter': {
            'params': ['sensor', 'filter', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/ips/baseline/sensor/{sensor}/filter/{filter}',
                '/pm/config/global/obj/ips/baseline/sensor/{sensor}/filter/{filter}'
            ],
            'v_range': [['7.0.1', '7.0.2']]
        },
        'ips_baseline_sensor_override': {
            'params': ['sensor', 'override', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/ips/baseline/sensor/{sensor}/override/{override}',
                '/pm/config/global/obj/ips/baseline/sensor/{sensor}/override/{override}'
            ],
            'v_range': [['7.0.1', '7.0.2']]
        },
        'ips_baseline_sensor_override_exemptip': {
            'params': ['sensor', 'override', 'exempt-ip', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/ips/baseline/sensor/{sensor}/override/{override}/exempt-ip/{exempt-ip}',
                '/pm/config/global/obj/ips/baseline/sensor/{sensor}/override/{override}/exempt-ip/{exempt-ip}'
            ],
            'v_range': [['7.0.1', '7.0.2']]
        },
        'ips_custom': {
            'params': ['custom', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/ips/custom/{custom}',
                '/pm/config/global/obj/ips/custom/{custom}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'ips_sensor': {
            'params': ['sensor', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/global/ips/sensor/{sensor}',
                '/pm/config/adom/{adom}/obj/ips/sensor/{sensor}',
                '/pm/config/global/obj/global/ips/sensor/{sensor}',
                '/pm/config/global/obj/ips/sensor/{sensor}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'ips_sensor_entries': {
            'params': ['sensor', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/ips/sensor/{sensor}/entries/{entries}',
                '/pm/config/global/obj/ips/sensor/{sensor}/entries/{entries}',
                '/pm/config/adom/{adom}/obj/global/ips/sensor/{sensor}/entries/{entries}',
                '/pm/config/global/obj/global/ips/sensor/{sensor}/entries/{entries}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'ips_sensor_entries_exemptip': {
            'params': ['sensor', 'entries', 'exempt-ip', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/global/ips/sensor/{sensor}/entries/{entries}/exempt-ip/{exempt-ip}',
                '/pm/config/adom/{adom}/obj/ips/sensor/{sensor}/entries/{entries}/exempt-ip/{exempt-ip}',
                '/pm/config/global/obj/global/ips/sensor/{sensor}/entries/{entries}/exempt-ip/{exempt-ip}',
                '/pm/config/global/obj/ips/sensor/{sensor}/entries/{entries}/exempt-ip/{exempt-ip}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'ips_sensor_filter': {
            'params': ['sensor', 'filter', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/ips/sensor/{sensor}/filter/{filter}',
                '/pm/config/global/obj/ips/sensor/{sensor}/filter/{filter}',
                '/pm/config/adom/{adom}/obj/global/ips/sensor/{sensor}/filter/{filter}',
                '/pm/config/global/obj/global/ips/sensor/{sensor}/filter/{filter}'
            ],
            'v_range': [['6.0.0', '6.2.0']]
        },
        'ips_sensor_override': {
            'params': ['sensor', 'override', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/global/ips/sensor/{sensor}/override/{override}',
                '/pm/config/adom/{adom}/obj/ips/sensor/{sensor}/override/{override}',
                '/pm/config/global/obj/global/ips/sensor/{sensor}/override/{override}',
                '/pm/config/global/obj/ips/sensor/{sensor}/override/{override}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'ips_sensor_override_exemptip': {
            'params': ['sensor', 'override', 'exempt-ip', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/global/ips/sensor/{sensor}/override/{override}/exempt-ip/{exempt-ip}',
                '/pm/config/adom/{adom}/obj/ips/sensor/{sensor}/override/{override}/exempt-ip/{exempt-ip}',
                '/pm/config/global/obj/global/ips/sensor/{sensor}/override/{override}/exempt-ip/{exempt-ip}',
                '/pm/config/global/obj/ips/sensor/{sensor}/override/{override}/exempt-ip/{exempt-ip}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'log_customfield': {
            'params': ['custom-field', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/log/custom-field/{custom-field}',
                '/pm/config/global/obj/log/custom-field/{custom-field}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'log_npuserver': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/log/npu-server',
                '/pm/config/global/obj/log/npu-server'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'log_npuserver_servergroup': {
            'params': ['server-group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/log/npu-server/server-group/{server-group}',
                '/pm/config/global/obj/log/npu-server/server-group/{server-group}'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'log_npuserver_serverinfo': {
            'params': ['server-info', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/log/npu-server/server-info/{server-info}',
                '/pm/config/global/obj/log/npu-server/server-info/{server-info}'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'metafields_system_admin_user': {
            'params': [],
            'urls': [
                '/cli/global/_meta_fields/system/admin/user'
            ],
            'v_range': [['6.0.0', '']]
        },
        'mpskprofile': {
            'params': ['mpsk-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/mpsk-profile/{mpsk-profile}',
                '/pm/config/global/obj/wireless-controller/mpsk-profile/{mpsk-profile}'
            ],
            'v_range': [['6.4.2', '']]
        },
        'mpskprofile_mpskgroup': {
            'params': ['mpsk-profile', 'mpsk-group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/mpsk-profile/{mpsk-profile}/mpsk-group/{mpsk-group}',
                '/pm/config/global/obj/wireless-controller/mpsk-profile/{mpsk-profile}/mpsk-group/{mpsk-group}'
            ],
            'v_range': [['6.4.2', '']]
        },
        'mpskprofile_mpskgroup_mpskkey': {
            'params': ['mpsk-profile', 'mpsk-group', 'mpsk-key', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/mpsk-profile/{mpsk-profile}/mpsk-group/{mpsk-group}/mpsk-key/{mpsk-key}',
                '/pm/config/global/obj/wireless-controller/mpsk-profile/{mpsk-profile}/mpsk-group/{mpsk-group}/mpsk-key/{mpsk-key}'
            ],
            'v_range': [['6.4.2', '']]
        },
        'nacprofile': {
            'params': ['nac-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/nac-profile/{nac-profile}',
                '/pm/config/global/obj/wireless-controller/nac-profile/{nac-profile}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'pkg_authentication_rule': {
            'params': ['pkg', 'rule', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/authentication/rule/{rule}'
            ],
            'v_range': [['6.2.1', '']]
        },
        'pkg_authentication_setting': {
            'params': ['pkg', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/authentication/setting'
            ],
            'v_range': [['6.2.1', '']]
        },
        'pkg_central_dnat': {
            'params': ['pkg', 'dnat', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/central/dnat/{dnat}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_central_dnat6': {
            'params': ['pkg', 'dnat6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/central/dnat6/{dnat6}'
            ],
            'v_range': [['6.4.2', '']]
        },
        'pkg_firewall_acl': {
            'params': ['pkg', 'acl', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/acl/{acl}'
            ],
            'v_range': [['7.2.0', '7.2.0']]
        },
        'pkg_firewall_acl6': {
            'params': ['pkg', 'acl6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/acl6/{acl6}'
            ],
            'v_range': [['7.2.0', '7.2.0']]
        },
        'pkg_firewall_centralsnatmap': {
            'params': ['pkg', 'central-snat-map', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/central-snat-map/{central-snat-map}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_firewall_consolidated_policy': {
            'params': ['pkg', 'policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/consolidated/policy/{policy}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'pkg_firewall_dospolicy': {
            'params': ['pkg', 'DoS-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/DoS-policy/{DoS-policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_firewall_dospolicy6': {
            'params': ['pkg', 'DoS-policy6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/DoS-policy6/{DoS-policy6}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_firewall_dospolicy6_anomaly': {
            'params': ['pkg', 'DoS-policy6', 'anomaly', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/DoS-policy6/{DoS-policy6}/anomaly/{anomaly}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_firewall_dospolicy_anomaly': {
            'params': ['pkg', 'DoS-policy', 'anomaly', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/DoS-policy/{DoS-policy}/anomaly/{anomaly}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_firewall_explicitproxypolicy': {
            'params': ['pkg', 'explicit-proxy-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/explicit-proxy-policy/{explicit-proxy-policy}'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'pkg_firewall_explicitproxypolicy_identitybasedpolicy': {
            'params': ['pkg', 'explicit-proxy-policy', 'identity-based-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/explicit-proxy-policy/{explicit-proxy-policy}/identity-based-policy/{identity-based-policy}'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'pkg_firewall_hyperscalepolicy': {
            'params': ['pkg', 'hyperscale-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/hyperscale-policy/{hyperscale-policy}'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '7.2.0']]
        },
        'pkg_firewall_hyperscalepolicy46': {
            'params': ['pkg', 'hyperscale-policy46', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/hyperscale-policy46/{hyperscale-policy46}'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '7.2.0']]
        },
        'pkg_firewall_hyperscalepolicy6': {
            'params': ['pkg', 'hyperscale-policy6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/hyperscale-policy6/{hyperscale-policy6}'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '7.2.0']]
        },
        'pkg_firewall_hyperscalepolicy64': {
            'params': ['pkg', 'hyperscale-policy64', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/hyperscale-policy64/{hyperscale-policy64}'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '7.2.0']]
        },
        'pkg_firewall_interfacepolicy': {
            'params': ['pkg', 'interface-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/interface-policy/{interface-policy}'
            ],
            'v_range': [['6.0.0', '7.2.2']]
        },
        'pkg_firewall_interfacepolicy6': {
            'params': ['pkg', 'interface-policy6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/interface-policy6/{interface-policy6}'
            ],
            'v_range': [['6.0.0', '7.2.2']]
        },
        'pkg_firewall_localinpolicy': {
            'params': ['pkg', 'local-in-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/local-in-policy/{local-in-policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_firewall_localinpolicy6': {
            'params': ['pkg', 'local-in-policy6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/local-in-policy6/{local-in-policy6}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_firewall_multicastpolicy': {
            'params': ['pkg', 'multicast-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/multicast-policy/{multicast-policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_firewall_multicastpolicy6': {
            'params': ['pkg', 'multicast-policy6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/multicast-policy6/{multicast-policy6}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_firewall_policy': {
            'params': ['pkg', 'policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/policy/{policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_firewall_policy46': {
            'params': ['pkg', 'policy46', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/policy46/{policy46}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_firewall_policy6': {
            'params': ['pkg', 'policy6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/policy6/{policy6}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_firewall_policy64': {
            'params': ['pkg', 'policy64', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/policy64/{policy64}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_firewall_policy_vpndstnode': {
            'params': ['pkg', 'policy', 'vpn_dst_node', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/policy/{policy}/vpn_dst_node/{vpn_dst_node}'
            ],
            'v_range': [['6.0.0', '7.0.2']]
        },
        'pkg_firewall_policy_vpnsrcnode': {
            'params': ['pkg', 'policy', 'vpn_src_node', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/policy/{policy}/vpn_src_node/{vpn_src_node}'
            ],
            'v_range': [['6.0.0', '7.0.2']]
        },
        'pkg_firewall_proxypolicy': {
            'params': ['pkg', 'proxy-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/proxy-policy/{proxy-policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_firewall_securitypolicy': {
            'params': ['pkg', 'security-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/security-policy/{security-policy}'
            ],
            'v_range': [['6.2.1', '']]
        },
        'pkg_firewall_shapingpolicy': {
            'params': ['pkg', 'shaping-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/firewall/shaping-policy/{shaping-policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_footer_consolidated_policy': {
            'params': ['pkg', 'policy', 'adom'],
            'urls': [
                '/pm/config/global/pkg/{pkg}/global/footer/consolidated/policy/{policy}',
                '/pm/config/adom/{adom}/pkg/{pkg}/global/footer/consolidated/policy/{policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_footer_policy': {
            'params': ['pkg', 'policy', 'adom'],
            'urls': [
                '/pm/config/global/pkg/{pkg}/global/footer/policy/{policy}',
                '/pm/config/adom/{adom}/pkg/{pkg}/global/footer/policy/{policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_footer_policy6': {
            'params': ['pkg', 'policy6', 'adom'],
            'urls': [
                '/pm/config/global/pkg/{pkg}/global/footer/policy6/{policy6}',
                '/pm/config/adom/{adom}/pkg/{pkg}/global/footer/policy6/{policy6}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_footer_policy6_identitybasedpolicy6': {
            'params': ['pkg', 'policy6', 'identity-based-policy6'],
            'urls': [
                '/pm/config/global/pkg/{pkg}/global/footer/policy6/{policy6}/identity-based-policy6/{identity-based-policy6}'
            ],
            'v_range': [['6.0.0', '6.2.0']]
        },
        'pkg_footer_policy_identitybasedpolicy': {
            'params': ['pkg', 'policy', 'identity-based-policy'],
            'urls': [
                '/pm/config/global/pkg/{pkg}/global/footer/policy/{policy}/identity-based-policy/{identity-based-policy}'
            ],
            'v_range': [['6.0.0', '6.2.0']]
        },
        'pkg_footer_shapingpolicy': {
            'params': ['pkg', 'shaping-policy', 'adom'],
            'urls': [
                '/pm/config/global/pkg/{pkg}/global/footer/shaping-policy/{shaping-policy}',
                '/pm/config/adom/{adom}/pkg/{pkg}/global/footer/shaping-policy/{shaping-policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_header_consolidated_policy': {
            'params': ['pkg', 'policy', 'adom'],
            'urls': [
                '/pm/config/global/pkg/{pkg}/global/header/consolidated/policy/{policy}',
                '/pm/config/adom/{adom}/pkg/{pkg}/global/header/consolidated/policy/{policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_header_policy': {
            'params': ['pkg', 'policy', 'adom'],
            'urls': [
                '/pm/config/global/pkg/{pkg}/global/header/policy/{policy}',
                '/pm/config/adom/{adom}/pkg/{pkg}/global/header/policy/{policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_header_policy6': {
            'params': ['pkg', 'policy6', 'adom'],
            'urls': [
                '/pm/config/global/pkg/{pkg}/global/header/policy6/{policy6}',
                '/pm/config/adom/{adom}/pkg/{pkg}/global/header/policy6/{policy6}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_header_policy6_identitybasedpolicy6': {
            'params': ['pkg', 'policy6', 'identity-based-policy6'],
            'urls': [
                '/pm/config/global/pkg/{pkg}/global/header/policy6/{policy6}/identity-based-policy6/{identity-based-policy6}'
            ],
            'v_range': [['6.0.0', '6.2.0']]
        },
        'pkg_header_policy_identitybasedpolicy': {
            'params': ['pkg', 'policy', 'identity-based-policy'],
            'urls': [
                '/pm/config/global/pkg/{pkg}/global/header/policy/{policy}/identity-based-policy/{identity-based-policy}'
            ],
            'v_range': [['6.0.0', '6.2.0']]
        },
        'pkg_header_shapingpolicy': {
            'params': ['pkg', 'shaping-policy', 'adom'],
            'urls': [
                '/pm/config/global/pkg/{pkg}/global/header/shaping-policy/{shaping-policy}',
                '/pm/config/adom/{adom}/pkg/{pkg}/global/header/shaping-policy/{shaping-policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pkg_user_nacpolicy': {
            'params': ['pkg', 'nac-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pkg/{pkg}/user/nac-policy/{nac-policy}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'pm_config_adom_options': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/_adom/options'
            ],
            'v_range': [['6.2.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'pm_config_application_list': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/_application/list',
                '/pm/config/global/_application/list'
            ],
            'v_range': [['6.2.0', '']]
        },
        'pm_config_category_list': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/_category/list',
                '/pm/config/global/_category/list'
            ],
            'v_range': [['6.2.0', '']]
        },
        'pm_config_data_defaultsslvpnoschecklist': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/_data/default_sslvpn_os_check_list',
                '/pm/config/global/_data/default_sslvpn_os_check_list'
            ],
            'v_range': [['7.2.5', '7.2.5']]
        },
        'pm_config_data_tablesize': {
            'params': ['tablesize', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/_data/tablesize/{tablesize}',
                '/pm/config/global/_data/tablesize/{tablesize}'
            ],
            'v_range': [['6.2.0', '7.0.6'], ['7.2.0', '7.2.1']]
        },
        'pm_config_data_tablesize_faz': {
            'params': ['faz', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/_data/tablesize/faz/{faz}',
                '/pm/config/global/_data/tablesize/faz/{faz}'
            ],
            'v_range': [['6.2.0', '7.0.6'], ['7.2.0', '7.2.1']]
        },
        'pm_config_data_tablesize_fmg': {
            'params': ['fmg', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/_data/tablesize/fmg/{fmg}',
                '/pm/config/global/_data/tablesize/fmg/{fmg}'
            ],
            'v_range': [['6.2.0', '7.0.6'], ['7.2.0', '7.2.1']]
        },
        'pm_config_data_tablesize_fos': {
            'params': ['fos', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/_data/tablesize/fos/{fos}',
                '/pm/config/global/_data/tablesize/fos/{fos}'
            ],
            'v_range': [['6.2.0', '7.0.6'], ['7.2.0', '7.2.1']]
        },
        'pm_config_data_tablesize_log': {
            'params': ['log', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/_data/tablesize/log/{log}',
                '/pm/config/global/_data/tablesize/log/{log}'
            ],
            'v_range': [['6.2.0', '7.0.6'], ['7.2.0', '7.2.1']]
        },
        'pm_config_fct_endpointcontrol_profile': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/_fct/endpoint-control/profile'
            ],
            'v_range': [['6.2.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '7.4.1']]
        },
        'pm_config_metafields_firewall_address': {
            'params': [],
            'urls': [
                '/pm/config/_meta_fields/firewall/address'
            ],
            'v_range': [['6.2.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'pm_config_metafields_firewall_addrgrp': {
            'params': [],
            'urls': [
                '/pm/config/_meta_fields/firewall/addrgrp'
            ],
            'v_range': [['6.2.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'pm_config_metafields_firewall_centralsnatmap': {
            'params': [],
            'urls': [
                '/pm/config/_meta_fields/firewall/central-snat-map'
            ],
            'v_range': [['6.2.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'pm_config_metafields_firewall_policy': {
            'params': [],
            'urls': [
                '/pm/config/_meta_fields/firewall/policy'
            ],
            'v_range': [['6.2.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'pm_config_metafields_firewall_service_custom': {
            'params': [],
            'urls': [
                '/pm/config/_meta_fields/firewall/service/custom'
            ],
            'v_range': [['6.2.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'pm_config_metafields_firewall_service_group': {
            'params': [],
            'urls': [
                '/pm/config/_meta_fields/firewall/service/group'
            ],
            'v_range': [['6.2.0', '6.2.5'], ['6.2.7', '6.4.1'], ['6.4.3', '']]
        },
        'pm_config_package_status': {
            'params': ['device_name', 'vdom_name', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/_package/status/{device_name}/{vdom_name}'
            ],
            'v_range': [['7.0.7', '7.0.12'], ['7.2.2', '']]
        },
        'pm_config_pblock_firewall_consolidated_policy': {
            'params': ['pblock', 'policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pblock/{pblock}/firewall/consolidated/policy/{policy}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'pm_config_pblock_firewall_policy': {
            'params': ['pblock', 'policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pblock/{pblock}/firewall/policy/{policy}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'pm_config_pblock_firewall_policy6': {
            'params': ['pblock', 'policy6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pblock/{pblock}/firewall/policy6/{policy6}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'pm_config_pblock_firewall_securitypolicy': {
            'params': ['pblock', 'security-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/pblock/{pblock}/firewall/security-policy/{security-policy}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'pm_config_rule_list': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/_rule/list',
                '/pm/config/global/_rule/list'
            ],
            'v_range': [['6.2.0', '']]
        },
        'pm_devprof': {
            'params': ['pkg_path', 'adom'],
            'urls': [
                '/pm/devprof/adom/{adom}/{pkg_path}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pm_devprof_adom': {
            'params': ['adom'],
            'urls': [
                '/pm/devprof/adom/{adom}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pm_pblock': {
            'params': ['pkg_path', 'adom'],
            'urls': [
                '/pm/pblock/adom/{adom}/{pkg_path}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'pm_pblock_adom': {
            'params': ['adom'],
            'urls': [
                '/pm/pblock/adom/{adom}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'pm_pkg': {
            'params': ['pkg_path', 'adom'],
            'urls': [
                '/pm/pkg/adom/{adom}/{pkg_path}',
                '/pm/pkg/global/{pkg_path}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pm_pkg_adom': {
            'params': ['adom'],
            'urls': [
                '/pm/pkg/adom/{adom}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pm_pkg_global': {
            'params': [],
            'urls': [
                '/pm/pkg/global'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pm_pkg_schedule': {
            'params': ['pkg_name_path', 'adom'],
            'urls': [
                '/pm/pkg/adom/{adom}/{pkg_name_path}/schedule',
                '/pm/pkg/global/{pkg_name_path}/schedule'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pm_wanprof': {
            'params': ['pkg_path', 'adom'],
            'urls': [
                '/pm/wanprof/adom/{adom}/{pkg_path}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'pm_wanprof_adom': {
            'params': ['adom'],
            'urls': [
                '/pm/wanprof/adom/{adom}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'qosprofile': {
            'params': ['qos-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/qos-profile/{qos-profile}',
                '/pm/config/global/obj/wireless-controller/qos-profile/{qos-profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'region': {
            'params': ['region', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/region/{region}',
                '/pm/config/global/obj/wireless-controller/region/{region}'
            ],
            'v_range': [['6.2.8', '6.2.12'], ['6.4.6', '']]
        },
        'router_accesslist': {
            'params': ['access-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/router/access-list/{access-list}',
                '/pm/config/global/obj/router/access-list/{access-list}'
            ],
            'v_range': [['7.0.2', '']]
        },
        'router_accesslist6': {
            'params': ['access-list6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/router/access-list6/{access-list6}',
                '/pm/config/global/obj/router/access-list6/{access-list6}'
            ],
            'v_range': [['7.0.2', '']]
        },
        'router_accesslist6_rule': {
            'params': ['access-list6', 'rule', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/router/access-list6/{access-list6}/rule/{rule}',
                '/pm/config/global/obj/router/access-list6/{access-list6}/rule/{rule}'
            ],
            'v_range': [['7.0.2', '']]
        },
        'router_accesslist_rule': {
            'params': ['access-list', 'rule', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/router/access-list/{access-list}/rule/{rule}',
                '/pm/config/global/obj/router/access-list/{access-list}/rule/{rule}'
            ],
            'v_range': [['7.0.2', '']]
        },
        'router_aspathlist': {
            'params': ['aspath-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/router/aspath-list/{aspath-list}',
                '/pm/config/global/obj/router/aspath-list/{aspath-list}'
            ],
            'v_range': [['7.0.2', '']]
        },
        'router_aspathlist_rule': {
            'params': ['aspath-list', 'rule', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/router/aspath-list/{aspath-list}/rule/{rule}',
                '/pm/config/global/obj/router/aspath-list/{aspath-list}/rule/{rule}'
            ],
            'v_range': [['7.0.2', '']]
        },
        'router_communitylist': {
            'params': ['community-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/router/community-list/{community-list}',
                '/pm/config/global/obj/router/community-list/{community-list}'
            ],
            'v_range': [['7.0.2', '']]
        },
        'router_communitylist_rule': {
            'params': ['community-list', 'rule', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/router/community-list/{community-list}/rule/{rule}',
                '/pm/config/global/obj/router/community-list/{community-list}/rule/{rule}'
            ],
            'v_range': [['7.0.2', '']]
        },
        'router_prefixlist': {
            'params': ['prefix-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/router/prefix-list/{prefix-list}',
                '/pm/config/global/obj/router/prefix-list/{prefix-list}'
            ],
            'v_range': [['7.0.2', '']]
        },
        'router_prefixlist6': {
            'params': ['prefix-list6', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/router/prefix-list6/{prefix-list6}',
                '/pm/config/global/obj/router/prefix-list6/{prefix-list6}'
            ],
            'v_range': [['7.0.2', '']]
        },
        'router_prefixlist6_rule': {
            'params': ['prefix-list6', 'rule', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/router/prefix-list6/{prefix-list6}/rule/{rule}',
                '/pm/config/global/obj/router/prefix-list6/{prefix-list6}/rule/{rule}'
            ],
            'v_range': [['7.0.2', '']]
        },
        'router_prefixlist_rule': {
            'params': ['prefix-list', 'rule', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/router/prefix-list/{prefix-list}/rule/{rule}',
                '/pm/config/global/obj/router/prefix-list/{prefix-list}/rule/{rule}'
            ],
            'v_range': [['7.0.2', '']]
        },
        'router_routemap': {
            'params': ['route-map', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/router/route-map/{route-map}',
                '/pm/config/global/obj/router/route-map/{route-map}'
            ],
            'v_range': [['7.0.2', '']]
        },
        'router_routemap_rule': {
            'params': ['route-map', 'rule', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/router/route-map/{route-map}/rule/{rule}',
                '/pm/config/global/obj/router/route-map/{route-map}/rule/{rule}'
            ],
            'v_range': [['7.0.2', '']]
        },
        'sctpfilter_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/sctp-filter/profile/{profile}',
                '/pm/config/global/obj/sctp-filter/profile/{profile}'
            ],
            'v_range': [['7.2.5', '7.2.5'], ['7.4.2', '']]
        },
        'sctpfilter_profile_ppidfilters': {
            'params': ['profile', 'ppid-filters', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/sctp-filter/profile/{profile}/ppid-filters/{ppid-filters}',
                '/pm/config/global/obj/sctp-filter/profile/{profile}/ppid-filters/{ppid-filters}'
            ],
            'v_range': [['7.2.5', '7.2.5'], ['7.4.2', '']]
        },
        'spamfilter_bwl': {
            'params': ['bwl', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/spamfilter/bwl/{bwl}',
                '/pm/config/global/obj/spamfilter/bwl/{bwl}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'spamfilter_bwl_entries': {
            'params': ['bwl', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/spamfilter/bwl/{bwl}/entries/{entries}',
                '/pm/config/global/obj/spamfilter/bwl/{bwl}/entries/{entries}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'spamfilter_bword': {
            'params': ['bword', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/spamfilter/bword/{bword}',
                '/pm/config/global/obj/spamfilter/bword/{bword}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'spamfilter_bword_entries': {
            'params': ['bword', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/spamfilter/bword/{bword}/entries/{entries}',
                '/pm/config/global/obj/spamfilter/bword/{bword}/entries/{entries}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'spamfilter_dnsbl': {
            'params': ['dnsbl', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/spamfilter/dnsbl/{dnsbl}',
                '/pm/config/global/obj/spamfilter/dnsbl/{dnsbl}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'spamfilter_dnsbl_entries': {
            'params': ['dnsbl', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/spamfilter/dnsbl/{dnsbl}/entries/{entries}',
                '/pm/config/global/obj/spamfilter/dnsbl/{dnsbl}/entries/{entries}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'spamfilter_iptrust': {
            'params': ['iptrust', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/spamfilter/iptrust/{iptrust}',
                '/pm/config/global/obj/spamfilter/iptrust/{iptrust}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'spamfilter_iptrust_entries': {
            'params': ['iptrust', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/spamfilter/iptrust/{iptrust}/entries/{entries}',
                '/pm/config/global/obj/spamfilter/iptrust/{iptrust}/entries/{entries}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'spamfilter_mheader': {
            'params': ['mheader', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/spamfilter/mheader/{mheader}',
                '/pm/config/global/obj/spamfilter/mheader/{mheader}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'spamfilter_mheader_entries': {
            'params': ['mheader', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/spamfilter/mheader/{mheader}/entries/{entries}',
                '/pm/config/global/obj/spamfilter/mheader/{mheader}/entries/{entries}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'spamfilter_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/spamfilter/profile/{profile}',
                '/pm/config/global/obj/spamfilter/profile/{profile}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'spamfilter_profile_gmail': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/spamfilter/profile/{profile}/gmail',
                '/pm/config/global/obj/spamfilter/profile/{profile}/gmail'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'spamfilter_profile_imap': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/spamfilter/profile/{profile}/imap',
                '/pm/config/global/obj/spamfilter/profile/{profile}/imap'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'spamfilter_profile_mapi': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/spamfilter/profile/{profile}/mapi',
                '/pm/config/global/obj/spamfilter/profile/{profile}/mapi'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'spamfilter_profile_msnhotmail': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/spamfilter/profile/{profile}/msn-hotmail',
                '/pm/config/global/obj/spamfilter/profile/{profile}/msn-hotmail'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'spamfilter_profile_pop3': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/spamfilter/profile/{profile}/pop3',
                '/pm/config/global/obj/spamfilter/profile/{profile}/pop3'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'spamfilter_profile_smtp': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/spamfilter/profile/{profile}/smtp',
                '/pm/config/global/obj/spamfilter/profile/{profile}/smtp'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'spamfilter_profile_yahoomail': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/spamfilter/profile/{profile}/yahoo-mail',
                '/pm/config/global/obj/spamfilter/profile/{profile}/yahoo-mail'
            ],
            'v_range': [['6.0.0', '6.2.12']]
        },
        'sshfilter_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/ssh-filter/profile/{profile}',
                '/pm/config/global/obj/ssh-filter/profile/{profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'sshfilter_profile_filefilter': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/ssh-filter/profile/{profile}/file-filter',
                '/pm/config/global/obj/ssh-filter/profile/{profile}/file-filter'
            ],
            'v_range': [['6.2.2', '']]
        },
        'sshfilter_profile_filefilter_entries': {
            'params': ['profile', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/ssh-filter/profile/{profile}/file-filter/entries/{entries}',
                '/pm/config/global/obj/ssh-filter/profile/{profile}/file-filter/entries/{entries}'
            ],
            'v_range': [['6.2.2', '']]
        },
        'sshfilter_profile_shellcommands': {
            'params': ['profile', 'shell-commands', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/ssh-filter/profile/{profile}/shell-commands/{shell-commands}',
                '/pm/config/global/obj/ssh-filter/profile/{profile}/shell-commands/{shell-commands}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'switchcontroller_acl_group': {
            'params': ['group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/acl/group/{group}',
                '/pm/config/global/obj/switch-controller/acl/group/{group}'
            ],
            'v_range': [['7.4.0', '']]
        },
        'switchcontroller_acl_ingress': {
            'params': ['ingress', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/acl/ingress/{ingress}',
                '/pm/config/global/obj/switch-controller/acl/ingress/{ingress}'
            ],
            'v_range': [['7.4.0', '']]
        },
        'switchcontroller_acl_ingress_action': {
            'params': ['ingress', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/acl/ingress/{ingress}/action',
                '/pm/config/global/obj/switch-controller/acl/ingress/{ingress}/action'
            ],
            'v_range': [['7.4.0', '']]
        },
        'switchcontroller_acl_ingress_classifier': {
            'params': ['ingress', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/acl/ingress/{ingress}/classifier',
                '/pm/config/global/obj/switch-controller/acl/ingress/{ingress}/classifier'
            ],
            'v_range': [['7.4.0', '']]
        },
        'switchcontroller_customcommand': {
            'params': ['custom-command', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/custom-command/{custom-command}',
                '/pm/config/global/obj/switch-controller/custom-command/{custom-command}'
            ],
            'v_range': [['7.0.0', '']]
        },
        'switchcontroller_dsl_policy': {
            'params': ['policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/dsl/policy/{policy}',
                '/pm/config/global/obj/switch-controller/dsl/policy/{policy}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'switchcontroller_dynamicportpolicy': {
            'params': ['dynamic-port-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/dynamic-port-policy/{dynamic-port-policy}',
                '/pm/config/global/obj/switch-controller/dynamic-port-policy/{dynamic-port-policy}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'switchcontroller_dynamicportpolicy_policy': {
            'params': ['dynamic-port-policy', 'policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/dynamic-port-policy/{dynamic-port-policy}/policy/{policy}',
                '/pm/config/global/obj/switch-controller/dynamic-port-policy/{dynamic-port-policy}/policy/{policy}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'switchcontroller_fortilinksettings': {
            'params': ['fortilink-settings', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/fortilink-settings/{fortilink-settings}',
                '/pm/config/global/obj/switch-controller/fortilink-settings/{fortilink-settings}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'switchcontroller_fortilinksettings_nacports': {
            'params': ['fortilink-settings', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/fortilink-settings/{fortilink-settings}/nac-ports',
                '/pm/config/global/obj/switch-controller/fortilink-settings/{fortilink-settings}/nac-ports'
            ],
            'v_range': [['7.2.1', '']]
        },
        'switchcontroller_lldpprofile': {
            'params': ['lldp-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/lldp-profile/{lldp-profile}',
                '/pm/config/global/obj/switch-controller/lldp-profile/{lldp-profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'switchcontroller_lldpprofile_customtlvs': {
            'params': ['lldp-profile', 'custom-tlvs', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/lldp-profile/{lldp-profile}/custom-tlvs/{custom-tlvs}',
                '/pm/config/global/obj/switch-controller/lldp-profile/{lldp-profile}/custom-tlvs/{custom-tlvs}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'switchcontroller_lldpprofile_medlocationservice': {
            'params': ['lldp-profile', 'med-location-service', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/lldp-profile/{lldp-profile}/med-location-service/{med-location-service}',
                '/pm/config/global/obj/switch-controller/lldp-profile/{lldp-profile}/med-location-service/{med-location-service}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'switchcontroller_lldpprofile_mednetworkpolicy': {
            'params': ['lldp-profile', 'med-network-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/lldp-profile/{lldp-profile}/med-network-policy/{med-network-policy}',
                '/pm/config/global/obj/switch-controller/lldp-profile/{lldp-profile}/med-network-policy/{med-network-policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'switchcontroller_macpolicy': {
            'params': ['mac-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/mac-policy/{mac-policy}',
                '/pm/config/global/obj/switch-controller/mac-policy/{mac-policy}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'switchcontroller_managedswitch': {
            'params': ['managed-switch', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/managed-switch/{managed-switch}',
                '/pm/config/global/obj/switch-controller/managed-switch/{managed-switch}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'switchcontroller_managedswitch_8021xsettings': {
            'params': ['device', 'vdom', 'managed-switch'],
            'urls': [
                '/pm/config/device/{device}/vdom/{vdom}/switch-controller/managed-switch/{managed-switch}/802-1X-settings'
            ],
            'v_range': [['6.0.0', '6.2.0']]
        },
        'switchcontroller_managedswitch_customcommand': {
            'params': ['managed-switch', 'custom-command', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/managed-switch/{managed-switch}/custom-command/{custom-command}',
                '/pm/config/global/obj/switch-controller/managed-switch/{managed-switch}/custom-command/{custom-command}'
            ],
            'v_range': [['7.0.0', '']]
        },
        'switchcontroller_managedswitch_dhcpsnoopingstaticclient': {
            'params': ['managed-switch', 'dhcp-snooping-static-client', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/managed-switch/{managed-switch}/dhcp-snooping-static-client/{dhcp-snooping-static-client}',
                '/pm/config/global/obj/switch-controller/managed-switch/{managed-switch}/dhcp-snooping-static-client/{dhcp-snooping-static-client}'
            ],
            'v_range': [['7.2.2', '']]
        },
        'switchcontroller_managedswitch_igmpsnooping': {
            'params': ['device', 'vdom', 'managed-switch'],
            'urls': [
                '/pm/config/device/{device}/vdom/{vdom}/switch-controller/managed-switch/{managed-switch}/igmp-snooping'
            ],
            'v_range': [['6.0.0', '6.2.0']]
        },
        'switchcontroller_managedswitch_ipsourceguard': {
            'params': ['managed-switch', 'ip-source-guard', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/managed-switch/{managed-switch}/ip-source-guard/{ip-source-guard}',
                '/pm/config/global/obj/switch-controller/managed-switch/{managed-switch}/ip-source-guard/{ip-source-guard}'
            ],
            'v_range': [['6.4.0', '6.4.1']]
        },
        'switchcontroller_managedswitch_ipsourceguard_bindingentry': {
            'params': ['managed-switch', 'ip-source-guard', 'binding-entry', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/managed-switch/{managed-switch}/ip-source-guard/{ip-source-guard}/binding-entry/{binding-entry}',
                '/pm/config/global/obj/switch-controller/managed-switch/{managed-switch}/ip-source-guard/{ip-source-guard}/binding-entry/{binding-entry}'
            ],
            'v_range': [['6.4.0', '6.4.1']]
        },
        'switchcontroller_managedswitch_mirror': {
            'params': ['device', 'vdom', 'managed-switch', 'mirror'],
            'urls': [
                '/pm/config/device/{device}/vdom/{vdom}/switch-controller/managed-switch/{managed-switch}/mirror/{mirror}'
            ],
            'v_range': [['6.0.0', '6.2.0']]
        },
        'switchcontroller_managedswitch_ports': {
            'params': ['managed-switch', 'ports', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/managed-switch/{managed-switch}/ports/{ports}',
                '/pm/config/global/obj/switch-controller/managed-switch/{managed-switch}/ports/{ports}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'switchcontroller_managedswitch_ports_dhcpsnoopoption82override': {
            'params': ['managed-switch', 'ports', 'dhcp-snoop-option82-override', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/managed-switch/{managed-switch}/ports/{ports}/dhcp-snoop-option82-override/{dhcp-snoop-option82'
                '-override}',
                '/pm/config/global/obj/switch-controller/managed-switch/{managed-switch}/ports/{ports}/dhcp-snoop-option82-override/{dhcp-snoop-option82-over'
                'ride}'
            ],
            'v_range': [['7.4.0', '']]
        },
        'switchcontroller_managedswitch_remotelog': {
            'params': ['managed-switch', 'remote-log', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/managed-switch/{managed-switch}/remote-log/{remote-log}',
                '/pm/config/global/obj/switch-controller/managed-switch/{managed-switch}/remote-log/{remote-log}'
            ],
            'v_range': [['6.2.1', '6.2.3']]
        },
        'switchcontroller_managedswitch_routeoffloadrouter': {
            'params': ['managed-switch', 'route-offload-router', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/managed-switch/{managed-switch}/route-offload-router/{route-offload-router}',
                '/pm/config/global/obj/switch-controller/managed-switch/{managed-switch}/route-offload-router/{route-offload-router}'
            ],
            'v_range': [['7.4.1', '']]
        },
        'switchcontroller_managedswitch_snmpcommunity': {
            'params': ['managed-switch', 'snmp-community', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/managed-switch/{managed-switch}/snmp-community/{snmp-community}',
                '/pm/config/global/obj/switch-controller/managed-switch/{managed-switch}/snmp-community/{snmp-community}'
            ],
            'v_range': [['6.2.1', '6.2.3']]
        },
        'switchcontroller_managedswitch_snmpcommunity_hosts': {
            'params': ['managed-switch', 'snmp-community', 'hosts', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/managed-switch/{managed-switch}/snmp-community/{snmp-community}/hosts/{hosts}',
                '/pm/config/global/obj/switch-controller/managed-switch/{managed-switch}/snmp-community/{snmp-community}/hosts/{hosts}'
            ],
            'v_range': [['6.2.1', '6.2.3']]
        },
        'switchcontroller_managedswitch_snmpsysinfo': {
            'params': ['managed-switch', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/managed-switch/{managed-switch}/snmp-sysinfo',
                '/pm/config/global/obj/switch-controller/managed-switch/{managed-switch}/snmp-sysinfo'
            ],
            'v_range': [['6.2.1', '6.2.3']]
        },
        'switchcontroller_managedswitch_snmptrapthreshold': {
            'params': ['managed-switch', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/managed-switch/{managed-switch}/snmp-trap-threshold',
                '/pm/config/global/obj/switch-controller/managed-switch/{managed-switch}/snmp-trap-threshold'
            ],
            'v_range': [['6.2.1', '6.2.3']]
        },
        'switchcontroller_managedswitch_snmpuser': {
            'params': ['managed-switch', 'snmp-user', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/managed-switch/{managed-switch}/snmp-user/{snmp-user}',
                '/pm/config/global/obj/switch-controller/managed-switch/{managed-switch}/snmp-user/{snmp-user}'
            ],
            'v_range': [['6.2.1', '6.2.3']]
        },
        'switchcontroller_managedswitch_staticmac': {
            'params': ['device', 'vdom', 'managed-switch', 'static-mac'],
            'urls': [
                '/pm/config/device/{device}/vdom/{vdom}/switch-controller/managed-switch/{managed-switch}/static-mac/{static-mac}'
            ],
            'v_range': [['6.2.0', '6.2.0']]
        },
        'switchcontroller_managedswitch_stormcontrol': {
            'params': ['device', 'vdom', 'managed-switch'],
            'urls': [
                '/pm/config/device/{device}/vdom/{vdom}/switch-controller/managed-switch/{managed-switch}/storm-control'
            ],
            'v_range': [['6.0.0', '6.2.0']]
        },
        'switchcontroller_managedswitch_stpinstance': {
            'params': ['device', 'vdom', 'managed-switch', 'stp-instance'],
            'urls': [
                '/pm/config/device/{device}/vdom/{vdom}/switch-controller/managed-switch/{managed-switch}/stp-instance/{stp-instance}'
            ],
            'v_range': [['6.2.0', '6.2.0']]
        },
        'switchcontroller_managedswitch_stpsettings': {
            'params': ['device', 'vdom', 'managed-switch'],
            'urls': [
                '/pm/config/device/{device}/vdom/{vdom}/switch-controller/managed-switch/{managed-switch}/stp-settings'
            ],
            'v_range': [['6.0.0', '6.2.0']]
        },
        'switchcontroller_managedswitch_switchlog': {
            'params': ['device', 'vdom', 'managed-switch'],
            'urls': [
                '/pm/config/device/{device}/vdom/{vdom}/switch-controller/managed-switch/{managed-switch}/switch-log'
            ],
            'v_range': [['6.0.0', '6.2.0']]
        },
        'switchcontroller_managedswitch_switchstpsettings': {
            'params': ['device', 'vdom', 'managed-switch'],
            'urls': [
                '/pm/config/device/{device}/vdom/{vdom}/switch-controller/managed-switch/{managed-switch}/switch-stp-settings'
            ],
            'v_range': [['6.0.0', '6.2.0']]
        },
        'switchcontroller_managedswitch_vlan': {
            'params': ['managed-switch', 'vlan', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/managed-switch/{managed-switch}/vlan/{vlan}',
                '/pm/config/global/obj/switch-controller/managed-switch/{managed-switch}/vlan/{vlan}'
            ],
            'v_range': [['7.4.2', '']]
        },
        'switchcontroller_ptp_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/ptp/profile/{profile}',
                '/pm/config/global/obj/switch-controller/ptp/profile/{profile}'
            ],
            'v_range': [['7.4.1', '']]
        },
        'switchcontroller_qos_dot1pmap': {
            'params': ['dot1p-map', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/qos/dot1p-map/{dot1p-map}',
                '/pm/config/global/obj/switch-controller/qos/dot1p-map/{dot1p-map}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'switchcontroller_qos_ipdscpmap': {
            'params': ['ip-dscp-map', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/qos/ip-dscp-map/{ip-dscp-map}',
                '/pm/config/global/obj/switch-controller/qos/ip-dscp-map/{ip-dscp-map}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'switchcontroller_qos_ipdscpmap_map': {
            'params': ['ip-dscp-map', 'map', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/qos/ip-dscp-map/{ip-dscp-map}/map/{map}',
                '/pm/config/global/obj/switch-controller/qos/ip-dscp-map/{ip-dscp-map}/map/{map}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'switchcontroller_qos_qospolicy': {
            'params': ['qos-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/qos/qos-policy/{qos-policy}',
                '/pm/config/global/obj/switch-controller/qos/qos-policy/{qos-policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'switchcontroller_qos_queuepolicy': {
            'params': ['queue-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/qos/queue-policy/{queue-policy}',
                '/pm/config/global/obj/switch-controller/qos/queue-policy/{queue-policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'switchcontroller_qos_queuepolicy_cosqueue': {
            'params': ['queue-policy', 'cos-queue', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/qos/queue-policy/{queue-policy}/cos-queue/{cos-queue}',
                '/pm/config/global/obj/switch-controller/qos/queue-policy/{queue-policy}/cos-queue/{cos-queue}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'switchcontroller_securitypolicy_8021x': {
            'params': ['802-1X', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/security-policy/802-1X/{802-1X}',
                '/pm/config/global/obj/switch-controller/security-policy/802-1X/{802-1X}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'switchcontroller_securitypolicy_captiveportal': {
            'params': ['captive-portal', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/security-policy/captive-portal/{captive-portal}',
                '/pm/config/global/obj/switch-controller/security-policy/captive-portal/{captive-portal}'
            ],
            'v_range': [['6.0.0', '6.2.1']]
        },
        'switchcontroller_switchinterfacetag': {
            'params': ['switch-interface-tag', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/switch-interface-tag/{switch-interface-tag}',
                '/pm/config/global/obj/switch-controller/switch-interface-tag/{switch-interface-tag}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'switchcontroller_trafficpolicy': {
            'params': ['traffic-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/traffic-policy/{traffic-policy}',
                '/pm/config/global/obj/switch-controller/traffic-policy/{traffic-policy}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'switchcontroller_vlanpolicy': {
            'params': ['vlan-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/switch-controller/vlan-policy/{vlan-policy}',
                '/pm/config/global/obj/switch-controller/vlan-policy/{vlan-policy}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'sys_ha_status': {
            'params': [],
            'urls': [
                '/sys/ha/status'
            ],
            'v_range': [['6.0.0', '']]
        },
        'sys_status': {
            'params': [],
            'urls': [
                '/sys/status'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_admin_group': {
            'params': ['group'],
            'urls': [
                '/cli/global/system/admin/group/{group}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_admin_group_member': {
            'params': ['group', 'member'],
            'urls': [
                '/cli/global/system/admin/group/{group}/member/{member}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_admin_ldap': {
            'params': ['ldap'],
            'urls': [
                '/cli/global/system/admin/ldap/{ldap}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_admin_ldap_adom': {
            'params': ['ldap', 'adom'],
            'urls': [
                '/cli/global/system/admin/ldap/{ldap}/adom/{adom}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_admin_profile': {
            'params': ['profile'],
            'urls': [
                '/cli/global/system/admin/profile/{profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_admin_profile_datamaskcustomfields': {
            'params': ['profile', 'datamask-custom-fields'],
            'urls': [
                '/cli/global/system/admin/profile/{profile}/datamask-custom-fields/{datamask-custom-fields}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_admin_profile_writepasswdprofiles': {
            'params': ['profile', 'write-passwd-profiles'],
            'urls': [
                '/cli/global/system/admin/profile/{profile}/write-passwd-profiles/{write-passwd-profiles}'
            ],
            'v_range': [['7.4.2', '']]
        },
        'system_admin_profile_writepasswduserlist': {
            'params': ['profile', 'write-passwd-user-list'],
            'urls': [
                '/cli/global/system/admin/profile/{profile}/write-passwd-user-list/{write-passwd-user-list}'
            ],
            'v_range': [['7.4.2', '']]
        },
        'system_admin_radius': {
            'params': ['radius'],
            'urls': [
                '/cli/global/system/admin/radius/{radius}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_admin_setting': {
            'params': [],
            'urls': [
                '/cli/global/system/admin/setting'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_admin_tacacs': {
            'params': ['tacacs'],
            'urls': [
                '/cli/global/system/admin/tacacs/{tacacs}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_admin_user': {
            'params': ['user'],
            'urls': [
                '/cli/global/system/admin/user/{user}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_admin_user_adom': {
            'params': ['user', 'adom'],
            'urls': [
                '/cli/global/system/admin/user/{user}/adom/{adom}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_admin_user_adomexclude': {
            'params': ['user', 'adom-exclude'],
            'urls': [
                '/cli/global/system/admin/user/{user}/adom-exclude/{adom-exclude}'
            ],
            'v_range': [['6.0.0', '7.0.2']]
        },
        'system_admin_user_appfilter': {
            'params': ['user', 'app-filter'],
            'urls': [
                '/cli/global/system/admin/user/{user}/app-filter/{app-filter}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_admin_user_dashboard': {
            'params': ['user', 'dashboard'],
            'urls': [
                '/cli/global/system/admin/user/{user}/dashboard/{dashboard}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_admin_user_dashboardtabs': {
            'params': ['user', 'dashboard-tabs'],
            'urls': [
                '/cli/global/system/admin/user/{user}/dashboard-tabs/{dashboard-tabs}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_admin_user_ipsfilter': {
            'params': ['user', 'ips-filter'],
            'urls': [
                '/cli/global/system/admin/user/{user}/ips-filter/{ips-filter}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_admin_user_metadata': {
            'params': ['user', 'meta-data'],
            'urls': [
                '/cli/global/system/admin/user/{user}/meta-data/{meta-data}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_admin_user_policypackage': {
            'params': ['user', 'policy-package'],
            'urls': [
                '/cli/global/system/admin/user/{user}/policy-package/{policy-package}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_admin_user_restrictdevvdom': {
            'params': ['user', 'restrict-dev-vdom'],
            'urls': [
                '/cli/global/system/admin/user/{user}/restrict-dev-vdom/{restrict-dev-vdom}'
            ],
            'v_range': [['6.0.0', '6.2.3'], ['6.4.0', '6.4.0']]
        },
        'system_admin_user_webfilter': {
            'params': ['user', 'web-filter'],
            'urls': [
                '/cli/global/system/admin/user/{user}/web-filter/{web-filter}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_alertconsole': {
            'params': [],
            'urls': [
                '/cli/global/system/alert-console'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_alertemail': {
            'params': [],
            'urls': [
                '/cli/global/system/alertemail'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_alertevent': {
            'params': ['alert-event'],
            'urls': [
                '/cli/global/system/alert-event/{alert-event}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_alertevent_alertdestination': {
            'params': ['alert-event', 'alert-destination'],
            'urls': [
                '/cli/global/system/alert-event/{alert-event}/alert-destination/{alert-destination}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_autodelete': {
            'params': [],
            'urls': [
                '/cli/global/system/auto-delete'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_autodelete_dlpfilesautodeletion': {
            'params': [],
            'urls': [
                '/cli/global/system/auto-delete/dlp-files-auto-deletion'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_autodelete_logautodeletion': {
            'params': [],
            'urls': [
                '/cli/global/system/auto-delete/log-auto-deletion'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_autodelete_quarantinefilesautodeletion': {
            'params': [],
            'urls': [
                '/cli/global/system/auto-delete/quarantine-files-auto-deletion'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_autodelete_reportautodeletion': {
            'params': [],
            'urls': [
                '/cli/global/system/auto-delete/report-auto-deletion'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_backup_allsettings': {
            'params': [],
            'urls': [
                '/cli/global/system/backup/all-settings'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_certificate_ca': {
            'params': ['ca'],
            'urls': [
                '/cli/global/system/certificate/ca/{ca}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_certificate_crl': {
            'params': ['crl'],
            'urls': [
                '/cli/global/system/certificate/crl/{crl}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_certificate_local': {
            'params': ['local'],
            'urls': [
                '/cli/global/system/certificate/local/{local}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_certificate_oftp': {
            'params': [],
            'urls': [
                '/cli/global/system/certificate/oftp'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_certificate_remote': {
            'params': ['remote'],
            'urls': [
                '/cli/global/system/certificate/remote/{remote}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_certificate_ssh': {
            'params': ['ssh'],
            'urls': [
                '/cli/global/system/certificate/ssh/{ssh}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_connector': {
            'params': [],
            'urls': [
                '/cli/global/system/connector'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_csf': {
            'params': [],
            'urls': [
                '/cli/global/system/csf'
            ],
            'v_range': [['7.4.1', '']]
        },
        'system_csf_fabricconnector': {
            'params': ['fabric-connector'],
            'urls': [
                '/cli/global/system/csf/fabric-connector/{fabric-connector}'
            ],
            'v_range': [['7.4.1', '']]
        },
        'system_csf_trustedlist': {
            'params': ['trusted-list'],
            'urls': [
                '/cli/global/system/csf/trusted-list/{trusted-list}'
            ],
            'v_range': [['7.4.1', '']]
        },
        'system_customlanguage': {
            'params': ['custom-language', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/custom-language/{custom-language}',
                '/pm/config/global/obj/system/custom-language/{custom-language}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_dhcp_server': {
            'params': ['server', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/dhcp/server/{server}',
                '/pm/config/global/obj/system/dhcp/server/{server}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_dhcp_server_excluderange': {
            'params': ['server', 'exclude-range', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/dhcp/server/{server}/exclude-range/{exclude-range}',
                '/pm/config/global/obj/system/dhcp/server/{server}/exclude-range/{exclude-range}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_dhcp_server_iprange': {
            'params': ['server', 'ip-range', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/dhcp/server/{server}/ip-range/{ip-range}',
                '/pm/config/global/obj/system/dhcp/server/{server}/ip-range/{ip-range}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_dhcp_server_options': {
            'params': ['server', 'options', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/dhcp/server/{server}/options/{options}',
                '/pm/config/global/obj/system/dhcp/server/{server}/options/{options}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_dhcp_server_reservedaddress': {
            'params': ['server', 'reserved-address', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/dhcp/server/{server}/reserved-address/{reserved-address}',
                '/pm/config/global/obj/system/dhcp/server/{server}/reserved-address/{reserved-address}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_dm': {
            'params': [],
            'urls': [
                '/cli/global/system/dm'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_dns': {
            'params': [],
            'urls': [
                '/cli/global/system/dns'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_docker': {
            'params': [],
            'urls': [
                '/cli/global/system/docker'
            ],
            'v_range': [['6.4.0', '']]
        },
        'system_externalresource': {
            'params': ['external-resource', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/external-resource/{external-resource}',
                '/pm/config/global/obj/system/external-resource/{external-resource}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_fips': {
            'params': [],
            'urls': [
                '/cli/global/system/fips'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_fortiguard': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/fortiguard',
                '/pm/config/global/obj/system/fortiguard'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_fortiview_autocache': {
            'params': [],
            'urls': [
                '/cli/global/system/fortiview/auto-cache'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_fortiview_setting': {
            'params': [],
            'urls': [
                '/cli/global/system/fortiview/setting'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_geoipcountry': {
            'params': ['geoip-country', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/geoip-country/{geoip-country}',
                '/pm/config/global/obj/system/geoip-country/{geoip-country}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_geoipoverride': {
            'params': ['geoip-override', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/geoip-override/{geoip-override}',
                '/pm/config/global/obj/system/geoip-override/{geoip-override}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_geoipoverride_ip6range': {
            'params': ['geoip-override', 'ip6-range', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/geoip-override/{geoip-override}/ip6-range/{ip6-range}',
                '/pm/config/global/obj/system/geoip-override/{geoip-override}/ip6-range/{ip6-range}'
            ],
            'v_range': [['6.4.0', '']]
        },
        'system_geoipoverride_iprange': {
            'params': ['geoip-override', 'ip-range', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/geoip-override/{geoip-override}/ip-range/{ip-range}',
                '/pm/config/global/obj/system/geoip-override/{geoip-override}/ip-range/{ip-range}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_global': {
            'params': [],
            'urls': [
                '/cli/global/system/global'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_guiact': {
            'params': [],
            'urls': [
                '/cli/global/system/guiact'
            ],
            'v_range': [['6.0.0', '7.0.11'], ['7.2.0', '7.2.4'], ['7.4.0', '7.4.0']]
        },
        'system_ha': {
            'params': [],
            'urls': [
                '/cli/global/system/ha'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_ha_monitoredinterfaces': {
            'params': ['monitored-interfaces'],
            'urls': [
                '/cli/global/system/ha/monitored-interfaces/{monitored-interfaces}'
            ],
            'v_range': [['7.2.0', '']]
        },
        'system_ha_monitoredips': {
            'params': ['monitored-ips'],
            'urls': [
                '/cli/global/system/ha/monitored-ips/{monitored-ips}'
            ],
            'v_range': [['7.2.0', '']]
        },
        'system_ha_peer': {
            'params': ['peer'],
            'urls': [
                '/cli/global/system/ha/peer/{peer}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_hascheduledcheck': {
            'params': [],
            'urls': [
                '/cli/global/system/ha-scheduled-check'
            ],
            'v_range': [['7.0.1', '']]
        },
        'system_interface': {
            'params': ['interface'],
            'urls': [
                '/cli/global/system/interface/{interface}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_interface_ipv6': {
            'params': ['interface'],
            'urls': [
                '/cli/global/system/interface/{interface}/ipv6'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_interface_member': {
            'params': ['interface', 'member'],
            'urls': [
                '/cli/global/system/interface/{interface}/member/{member}'
            ],
            'v_range': [['7.2.0', '']]
        },
        'system_localinpolicy': {
            'params': ['local-in-policy'],
            'urls': [
                '/cli/global/system/local-in-policy/{local-in-policy}'
            ],
            'v_range': [['7.2.0', '']]
        },
        'system_localinpolicy6': {
            'params': ['local-in-policy6'],
            'urls': [
                '/cli/global/system/local-in-policy6/{local-in-policy6}'
            ],
            'v_range': [['7.2.0', '']]
        },
        'system_locallog_disk_filter': {
            'params': [],
            'urls': [
                '/cli/global/system/locallog/disk/filter'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_locallog_disk_setting': {
            'params': [],
            'urls': [
                '/cli/global/system/locallog/disk/setting'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_locallog_fortianalyzer2_filter': {
            'params': [],
            'urls': [
                '/cli/global/system/locallog/fortianalyzer2/filter'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_locallog_fortianalyzer2_setting': {
            'params': [],
            'urls': [
                '/cli/global/system/locallog/fortianalyzer2/setting'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_locallog_fortianalyzer3_filter': {
            'params': [],
            'urls': [
                '/cli/global/system/locallog/fortianalyzer3/filter'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_locallog_fortianalyzer3_setting': {
            'params': [],
            'urls': [
                '/cli/global/system/locallog/fortianalyzer3/setting'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_locallog_fortianalyzer_filter': {
            'params': [],
            'urls': [
                '/cli/global/system/locallog/fortianalyzer/filter'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_locallog_fortianalyzer_setting': {
            'params': [],
            'urls': [
                '/cli/global/system/locallog/fortianalyzer/setting'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_locallog_memory_filter': {
            'params': [],
            'urls': [
                '/cli/global/system/locallog/memory/filter'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_locallog_memory_setting': {
            'params': [],
            'urls': [
                '/cli/global/system/locallog/memory/setting'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_locallog_setting': {
            'params': [],
            'urls': [
                '/cli/global/system/locallog/setting'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_locallog_syslogd2_filter': {
            'params': [],
            'urls': [
                '/cli/global/system/locallog/syslogd2/filter'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_locallog_syslogd2_setting': {
            'params': [],
            'urls': [
                '/cli/global/system/locallog/syslogd2/setting'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_locallog_syslogd3_filter': {
            'params': [],
            'urls': [
                '/cli/global/system/locallog/syslogd3/filter'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_locallog_syslogd3_setting': {
            'params': [],
            'urls': [
                '/cli/global/system/locallog/syslogd3/setting'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_locallog_syslogd_filter': {
            'params': [],
            'urls': [
                '/cli/global/system/locallog/syslogd/filter'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_locallog_syslogd_setting': {
            'params': [],
            'urls': [
                '/cli/global/system/locallog/syslogd/setting'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_log_alert': {
            'params': [],
            'urls': [
                '/cli/global/system/log/alert'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_log_devicedisable': {
            'params': ['device-disable'],
            'urls': [
                '/cli/global/system/log/device-disable/{device-disable}'
            ],
            'v_range': [['6.4.4', '']]
        },
        'system_log_fospolicystats': {
            'params': [],
            'urls': [
                '/cli/global/system/log/fos-policy-stats'
            ],
            'v_range': [['7.0.2', '']]
        },
        'system_log_interfacestats': {
            'params': [],
            'urls': [
                '/cli/global/system/log/interface-stats'
            ],
            'v_range': [['6.2.1', '']]
        },
        'system_log_ioc': {
            'params': [],
            'urls': [
                '/cli/global/system/log/ioc'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_log_maildomain': {
            'params': ['mail-domain'],
            'urls': [
                '/cli/global/system/log/mail-domain/{mail-domain}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_log_ratelimit': {
            'params': [],
            'urls': [
                '/cli/global/system/log/ratelimit'
            ],
            'v_range': [['6.4.8', '']]
        },
        'system_log_ratelimit_device': {
            'params': ['device'],
            'urls': [
                '/cli/global/system/log/ratelimit/device/{device}'
            ],
            'v_range': [['6.4.8', '7.0.2']]
        },
        'system_log_ratelimit_ratelimits': {
            'params': ['ratelimits'],
            'urls': [
                '/cli/global/system/log/ratelimit/ratelimits/{ratelimits}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'system_log_settings': {
            'params': [],
            'urls': [
                '/cli/global/system/log/settings'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_log_settings_rollinganalyzer': {
            'params': [],
            'urls': [
                '/cli/global/system/log/settings/rolling-analyzer'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_log_settings_rollinglocal': {
            'params': [],
            'urls': [
                '/cli/global/system/log/settings/rolling-local'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_log_settings_rollingregular': {
            'params': [],
            'urls': [
                '/cli/global/system/log/settings/rolling-regular'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_log_topology': {
            'params': [],
            'urls': [
                '/cli/global/system/log/topology'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.2', '']]
        },
        'system_logfetch_clientprofile': {
            'params': ['client-profile'],
            'urls': [
                '/cli/global/system/log-fetch/client-profile/{client-profile}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'system_logfetch_clientprofile_devicefilter': {
            'params': ['client-profile', 'device-filter'],
            'urls': [
                '/cli/global/system/log-fetch/client-profile/{client-profile}/device-filter/{device-filter}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'system_logfetch_clientprofile_logfilter': {
            'params': ['client-profile', 'log-filter'],
            'urls': [
                '/cli/global/system/log-fetch/client-profile/{client-profile}/log-filter/{log-filter}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'system_logfetch_serversettings': {
            'params': [],
            'urls': [
                '/cli/global/system/log-fetch/server-settings'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'system_mail': {
            'params': ['mail'],
            'urls': [
                '/cli/global/system/mail/{mail}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_mcpolicydisabledadoms': {
            'params': ['mc-policy-disabled-adoms'],
            'urls': [
                '/cli/global/system/global/mc-policy-disabled-adoms/{mc-policy-disabled-adoms}'
            ],
            'v_range': [['6.2.3', '']]
        },
        'system_meta': {
            'params': ['meta', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/meta/{meta}',
                '/pm/config/global/obj/system/meta/{meta}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_meta_sysmetafields': {
            'params': ['meta', 'sys_meta_fields', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/meta/{meta}/sys_meta_fields/{sys_meta_fields}',
                '/pm/config/global/obj/system/meta/{meta}/sys_meta_fields/{sys_meta_fields}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_metadata_admins': {
            'params': ['admins'],
            'urls': [
                '/cli/global/system/metadata/admins/{admins}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_npu': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu',
                '/pm/config/global/obj/system/npu'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_npu_backgroundssescan': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/background-sse-scan',
                '/pm/config/global/obj/system/npu/background-sse-scan'
            ],
            'v_range': [['6.4.8', '6.4.14'], ['7.0.3', '']]
        },
        'system_npu_dosoptions': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/dos-options',
                '/pm/config/global/obj/system/npu/dos-options'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_npu_dswdtsprofile': {
            'params': ['dsw-dts-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/dsw-dts-profile/{dsw-dts-profile}',
                '/pm/config/global/obj/system/npu/dsw-dts-profile/{dsw-dts-profile}'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_npu_dswqueuedtsprofile': {
            'params': ['dsw-queue-dts-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/dsw-queue-dts-profile/{dsw-queue-dts-profile}',
                '/pm/config/global/obj/system/npu/dsw-queue-dts-profile/{dsw-queue-dts-profile}'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_npu_fpanomaly': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/fp-anomaly',
                '/pm/config/global/obj/system/npu/fp-anomaly'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_npu_hpe': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/hpe',
                '/pm/config/global/obj/system/npu/hpe'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_npu_ipreassembly': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/ip-reassembly',
                '/pm/config/global/obj/system/npu/ip-reassembly'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_npu_isfnpqueues': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/isf-np-queues',
                '/pm/config/global/obj/system/npu/isf-np-queues'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_npu_npqueues': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/np-queues',
                '/pm/config/global/obj/system/npu/np-queues'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_npu_npqueues_ethernettype': {
            'params': ['ethernet-type', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/np-queues/ethernet-type/{ethernet-type}',
                '/pm/config/global/obj/system/npu/np-queues/ethernet-type/{ethernet-type}'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_npu_npqueues_ipprotocol': {
            'params': ['ip-protocol', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/np-queues/ip-protocol/{ip-protocol}',
                '/pm/config/global/obj/system/npu/np-queues/ip-protocol/{ip-protocol}'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_npu_npqueues_ipservice': {
            'params': ['ip-service', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/np-queues/ip-service/{ip-service}',
                '/pm/config/global/obj/system/npu/np-queues/ip-service/{ip-service}'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_npu_npqueues_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/np-queues/profile/{profile}',
                '/pm/config/global/obj/system/npu/np-queues/profile/{profile}'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_npu_npqueues_scheduler': {
            'params': ['scheduler', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/np-queues/scheduler/{scheduler}',
                '/pm/config/global/obj/system/npu/np-queues/scheduler/{scheduler}'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_npu_nputcam': {
            'params': ['npu-tcam', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/npu-tcam/{npu-tcam}',
                '/pm/config/global/obj/system/npu/npu-tcam/{npu-tcam}'
            ],
            'v_range': [['7.4.2', '']]
        },
        'system_npu_nputcam_data': {
            'params': ['npu-tcam', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/npu-tcam/{npu-tcam}/data',
                '/pm/config/global/obj/system/npu/npu-tcam/{npu-tcam}/data'
            ],
            'v_range': [['7.4.2', '']]
        },
        'system_npu_nputcam_mask': {
            'params': ['npu-tcam', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/npu-tcam/{npu-tcam}/mask',
                '/pm/config/global/obj/system/npu/npu-tcam/{npu-tcam}/mask'
            ],
            'v_range': [['7.4.2', '']]
        },
        'system_npu_nputcam_miract': {
            'params': ['npu-tcam', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/npu-tcam/{npu-tcam}/mir-act',
                '/pm/config/global/obj/system/npu/npu-tcam/{npu-tcam}/mir-act'
            ],
            'v_range': [['7.4.2', '']]
        },
        'system_npu_nputcam_priact': {
            'params': ['npu-tcam', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/npu-tcam/{npu-tcam}/pri-act',
                '/pm/config/global/obj/system/npu/npu-tcam/{npu-tcam}/pri-act'
            ],
            'v_range': [['7.4.2', '']]
        },
        'system_npu_nputcam_sact': {
            'params': ['npu-tcam', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/npu-tcam/{npu-tcam}/sact',
                '/pm/config/global/obj/system/npu/npu-tcam/{npu-tcam}/sact'
            ],
            'v_range': [['7.4.2', '']]
        },
        'system_npu_nputcam_tact': {
            'params': ['npu-tcam', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/npu-tcam/{npu-tcam}/tact',
                '/pm/config/global/obj/system/npu/npu-tcam/{npu-tcam}/tact'
            ],
            'v_range': [['7.4.2', '']]
        },
        'system_npu_portcpumap': {
            'params': ['port-cpu-map', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/port-cpu-map/{port-cpu-map}',
                '/pm/config/global/obj/system/npu/port-cpu-map/{port-cpu-map}'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_npu_portnpumap': {
            'params': ['port-npu-map', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/port-npu-map/{port-npu-map}',
                '/pm/config/global/obj/system/npu/port-npu-map/{port-npu-map}'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_npu_portpathoption': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/port-path-option',
                '/pm/config/global/obj/system/npu/port-path-option'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_npu_priorityprotocol': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/priority-protocol',
                '/pm/config/global/obj/system/npu/priority-protocol'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_npu_ssehascan': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/sse-ha-scan',
                '/pm/config/global/obj/system/npu/sse-ha-scan'
            ],
            'v_range': [['6.4.10', '6.4.14'], ['7.0.4', '7.0.12'], ['7.2.1', '']]
        },
        'system_npu_swehhash': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/sw-eh-hash',
                '/pm/config/global/obj/system/npu/sw-eh-hash'
            ],
            'v_range': [['7.0.1', '']]
        },
        'system_npu_swtrhash': {
            'params': ['adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/sw-tr-hash',
                '/pm/config/global/obj/system/npu/sw-tr-hash'
            ],
            'v_range': [['7.2.4', '']]
        },
        'system_npu_tcptimeoutprofile': {
            'params': ['tcp-timeout-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/tcp-timeout-profile/{tcp-timeout-profile}',
                '/pm/config/global/obj/system/npu/tcp-timeout-profile/{tcp-timeout-profile}'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_npu_udptimeoutprofile': {
            'params': ['udp-timeout-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/npu/udp-timeout-profile/{udp-timeout-profile}',
                '/pm/config/global/obj/system/npu/udp-timeout-profile/{udp-timeout-profile}'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.1', '']]
        },
        'system_ntp': {
            'params': [],
            'urls': [
                '/cli/global/system/ntp'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_ntp_ntpserver': {
            'params': ['ntpserver'],
            'urls': [
                '/cli/global/system/ntp/ntpserver/{ntpserver}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_objecttag': {
            'params': ['object-tag', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/object-tag/{object-tag}',
                '/pm/config/global/obj/system/object-tag/{object-tag}'
            ],
            'v_range': [['6.2.0', '6.4.14']]
        },
        'system_objecttagging': {
            'params': ['object-tagging', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/object-tagging/{object-tagging}',
                '/pm/config/global/obj/system/object-tagging/{object-tagging}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_passwordpolicy': {
            'params': [],
            'urls': [
                '/cli/global/system/password-policy'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_performance': {
            'params': [],
            'urls': [
                '/cli/global/system/performance'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup': {
            'params': ['replacemsg-group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_admin': {
            'params': ['replacemsg-group', 'admin', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/admin/{admin}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/admin/{admin}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_alertmail': {
            'params': ['replacemsg-group', 'alertmail', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/alertmail/{alertmail}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/alertmail/{alertmail}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_auth': {
            'params': ['replacemsg-group', 'auth', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/auth/{auth}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/auth/{auth}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_automation': {
            'params': ['replacemsg-group', 'automation', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/automation/{automation}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/automation/{automation}'
            ],
            'v_range': [['7.0.0', '']]
        },
        'system_replacemsggroup_custommessage': {
            'params': ['replacemsg-group', 'custom-message', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/custom-message/{custom-message}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/custom-message/{custom-message}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_devicedetectionportal': {
            'params': ['replacemsg-group', 'device-detection-portal', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/device-detection-portal/{device-detection-portal}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/device-detection-portal/{device-detection-portal}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_ec': {
            'params': ['replacemsg-group', 'ec', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/ec/{ec}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/ec/{ec}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'system_replacemsggroup_fortiguardwf': {
            'params': ['replacemsg-group', 'fortiguard-wf', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/fortiguard-wf/{fortiguard-wf}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/fortiguard-wf/{fortiguard-wf}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_ftp': {
            'params': ['replacemsg-group', 'ftp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/ftp/{ftp}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/ftp/{ftp}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_http': {
            'params': ['replacemsg-group', 'http', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/http/{http}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/http/{http}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_icap': {
            'params': ['replacemsg-group', 'icap', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/icap/{icap}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/icap/{icap}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_mail': {
            'params': ['replacemsg-group', 'mail', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/mail/{mail}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/mail/{mail}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_mm1': {
            'params': ['replacemsg-group', 'mm1', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/mm1/{mm1}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/mm1/{mm1}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_mm3': {
            'params': ['replacemsg-group', 'mm3', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/mm3/{mm3}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/mm3/{mm3}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_mm4': {
            'params': ['replacemsg-group', 'mm4', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/mm4/{mm4}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/mm4/{mm4}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_mm7': {
            'params': ['replacemsg-group', 'mm7', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/mm7/{mm7}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/mm7/{mm7}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_mms': {
            'params': ['replacemsg-group', 'mms', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/mms/{mms}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/mms/{mms}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_nacquar': {
            'params': ['replacemsg-group', 'nac-quar', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/nac-quar/{nac-quar}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/nac-quar/{nac-quar}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_nntp': {
            'params': ['replacemsg-group', 'nntp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/nntp/{nntp}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/nntp/{nntp}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_spam': {
            'params': ['replacemsg-group', 'spam', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/spam/{spam}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/spam/{spam}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_sslvpn': {
            'params': ['replacemsg-group', 'sslvpn', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/sslvpn/{sslvpn}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/sslvpn/{sslvpn}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_trafficquota': {
            'params': ['replacemsg-group', 'traffic-quota', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/traffic-quota/{traffic-quota}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/traffic-quota/{traffic-quota}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_utm': {
            'params': ['replacemsg-group', 'utm', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/utm/{utm}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/utm/{utm}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsggroup_webproxy': {
            'params': ['replacemsg-group', 'webproxy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-group/{replacemsg-group}/webproxy/{webproxy}',
                '/pm/config/global/obj/system/replacemsg-group/{replacemsg-group}/webproxy/{webproxy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_replacemsgimage': {
            'params': ['replacemsg-image', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/replacemsg-image/{replacemsg-image}',
                '/pm/config/global/obj/system/replacemsg-image/{replacemsg-image}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_report_autocache': {
            'params': [],
            'urls': [
                '/cli/global/system/report/auto-cache'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_report_estbrowsetime': {
            'params': [],
            'urls': [
                '/cli/global/system/report/est-browse-time'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_report_group': {
            'params': ['group'],
            'urls': [
                '/cli/global/system/report/group/{group}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_report_group_chartalternative': {
            'params': ['group', 'chart-alternative'],
            'urls': [
                '/cli/global/system/report/group/{group}/chart-alternative/{chart-alternative}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_report_group_groupby': {
            'params': ['group', 'group-by'],
            'urls': [
                '/cli/global/system/report/group/{group}/group-by/{group-by}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_report_setting': {
            'params': [],
            'urls': [
                '/cli/global/system/report/setting'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_route': {
            'params': ['route'],
            'urls': [
                '/cli/global/system/route/{route}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_route6': {
            'params': ['route6'],
            'urls': [
                '/cli/global/system/route6/{route6}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_saml': {
            'params': [],
            'urls': [
                '/cli/global/system/saml'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_saml_fabricidp': {
            'params': ['fabric-idp'],
            'urls': [
                '/cli/global/system/saml/fabric-idp/{fabric-idp}'
            ],
            'v_range': [['6.4.0', '']]
        },
        'system_saml_serviceproviders': {
            'params': ['service-providers'],
            'urls': [
                '/cli/global/system/saml/service-providers/{service-providers}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_sdnconnector': {
            'params': ['sdn-connector', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/sdn-connector/{sdn-connector}',
                '/pm/config/global/obj/system/sdn-connector/{sdn-connector}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_sdnconnector_compartmentlist': {
            'params': ['sdn-connector', 'compartment-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/sdn-connector/{sdn-connector}/compartment-list/{compartment-list}',
                '/pm/config/global/obj/system/sdn-connector/{sdn-connector}/compartment-list/{compartment-list}'
            ],
            'v_range': [['7.4.0', '']]
        },
        'system_sdnconnector_externalaccountlist': {
            'params': ['sdn-connector', 'external-account-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/sdn-connector/{sdn-connector}/external-account-list/{external-account-list}',
                '/pm/config/global/obj/system/sdn-connector/{sdn-connector}/external-account-list/{external-account-list}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'system_sdnconnector_externalip': {
            'params': ['sdn-connector', 'external-ip', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/sdn-connector/{sdn-connector}/external-ip/{external-ip}',
                '/pm/config/global/obj/system/sdn-connector/{sdn-connector}/external-ip/{external-ip}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_sdnconnector_forwardingrule': {
            'params': ['sdn-connector', 'forwarding-rule', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/sdn-connector/{sdn-connector}/forwarding-rule/{forwarding-rule}',
                '/pm/config/global/obj/system/sdn-connector/{sdn-connector}/forwarding-rule/{forwarding-rule}'
            ],
            'v_range': [['7.0.2', '']]
        },
        'system_sdnconnector_gcpprojectlist': {
            'params': ['sdn-connector', 'gcp-project-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/sdn-connector/{sdn-connector}/gcp-project-list/{gcp-project-list}',
                '/pm/config/global/obj/system/sdn-connector/{sdn-connector}/gcp-project-list/{gcp-project-list}'
            ],
            'v_range': [['6.4.7', '6.4.14'], ['7.0.2', '']]
        },
        'system_sdnconnector_nic': {
            'params': ['sdn-connector', 'nic', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/sdn-connector/{sdn-connector}/nic/{nic}',
                '/pm/config/global/obj/system/sdn-connector/{sdn-connector}/nic/{nic}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_sdnconnector_nic_ip': {
            'params': ['sdn-connector', 'nic', 'ip', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/sdn-connector/{sdn-connector}/nic/{nic}/ip/{ip}',
                '/pm/config/global/obj/system/sdn-connector/{sdn-connector}/nic/{nic}/ip/{ip}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_sdnconnector_ociregionlist': {
            'params': ['sdn-connector', 'oci-region-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/sdn-connector/{sdn-connector}/oci-region-list/{oci-region-list}',
                '/pm/config/global/obj/system/sdn-connector/{sdn-connector}/oci-region-list/{oci-region-list}'
            ],
            'v_range': [['7.4.0', '']]
        },
        'system_sdnconnector_route': {
            'params': ['sdn-connector', 'route', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/sdn-connector/{sdn-connector}/route/{route}',
                '/pm/config/global/obj/system/sdn-connector/{sdn-connector}/route/{route}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_sdnconnector_routetable': {
            'params': ['sdn-connector', 'route-table', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/sdn-connector/{sdn-connector}/route-table/{route-table}',
                '/pm/config/global/obj/system/sdn-connector/{sdn-connector}/route-table/{route-table}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_sdnconnector_routetable_route': {
            'params': ['sdn-connector', 'route-table', 'route', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/sdn-connector/{sdn-connector}/route-table/{route-table}/route/{route}',
                '/pm/config/global/obj/system/sdn-connector/{sdn-connector}/route-table/{route-table}/route/{route}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_sdnproxy': {
            'params': ['sdn-proxy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/sdn-proxy/{sdn-proxy}',
                '/pm/config/global/obj/system/sdn-proxy/{sdn-proxy}'
            ],
            'v_range': [['7.4.1', '']]
        },
        'system_smsserver': {
            'params': ['sms-server', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/sms-server/{sms-server}',
                '/pm/config/global/obj/system/sms-server/{sms-server}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_sniffer': {
            'params': ['sniffer'],
            'urls': [
                '/cli/global/system/sniffer/{sniffer}'
            ],
            'v_range': [['6.2.2', '']]
        },
        'system_snmp_community': {
            'params': ['community'],
            'urls': [
                '/cli/global/system/snmp/community/{community}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_snmp_community_hosts': {
            'params': ['community', 'hosts'],
            'urls': [
                '/cli/global/system/snmp/community/{community}/hosts/{hosts}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_snmp_community_hosts6': {
            'params': ['community', 'hosts6'],
            'urls': [
                '/cli/global/system/snmp/community/{community}/hosts6/{hosts6}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_snmp_sysinfo': {
            'params': [],
            'urls': [
                '/cli/global/system/snmp/sysinfo'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_snmp_user': {
            'params': ['user'],
            'urls': [
                '/cli/global/system/snmp/user/{user}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_socfabric': {
            'params': [],
            'urls': [
                '/cli/global/system/soc-fabric'
            ],
            'v_range': [['7.0.0', '']]
        },
        'system_socfabric_trustedlist': {
            'params': ['trusted-list'],
            'urls': [
                '/cli/global/system/soc-fabric/trusted-list/{trusted-list}'
            ],
            'v_range': [['7.4.0', '']]
        },
        'system_sql': {
            'params': [],
            'urls': [
                '/cli/global/system/sql'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_sql_customindex': {
            'params': ['custom-index'],
            'urls': [
                '/cli/global/system/sql/custom-index/{custom-index}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_sql_customskipidx': {
            'params': ['custom-skipidx'],
            'urls': [
                '/cli/global/system/sql/custom-skipidx/{custom-skipidx}'
            ],
            'v_range': [['6.2.3', '']]
        },
        'system_sql_tsindexfield': {
            'params': ['ts-index-field'],
            'urls': [
                '/cli/global/system/sql/ts-index-field/{ts-index-field}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_sslciphersuites': {
            'params': ['ssl-cipher-suites'],
            'urls': [
                '/cli/global/system/global/ssl-cipher-suites/{ssl-cipher-suites}'
            ],
            'v_range': [['6.4.8', '6.4.14'], ['7.0.2', '']]
        },
        'system_status': {
            'params': [],
            'urls': [
                '/cli/global/system/status'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_syslog': {
            'params': ['syslog'],
            'urls': [
                '/cli/global/system/syslog/{syslog}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_virtualwirepair': {
            'params': ['virtual-wire-pair', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/system/virtual-wire-pair/{virtual-wire-pair}',
                '/pm/config/global/obj/system/virtual-wire-pair/{virtual-wire-pair}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_webproxy': {
            'params': [],
            'urls': [
                '/cli/global/system/web-proxy'
            ],
            'v_range': [['6.4.8', '6.4.14'], ['7.0.3', '']]
        },
        'system_workflow_approvalmatrix': {
            'params': ['approval-matrix'],
            'urls': [
                '/cli/global/system/workflow/approval-matrix/{approval-matrix}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'system_workflow_approvalmatrix_approver': {
            'params': ['approval-matrix', 'approver'],
            'urls': [
                '/cli/global/system/workflow/approval-matrix/{approval-matrix}/approver/{approver}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'task_task': {
            'params': ['task'],
            'urls': [
                '/task/task/{task}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'task_task_history': {
            'params': ['task', 'history'],
            'urls': [
                '/task/task/{task}/history/{history}'
            ],
            'v_range': [['6.0.0', '6.2.12']]
        },
        'task_task_line': {
            'params': ['task', 'line'],
            'urls': [
                '/task/task/{task}/line/{line}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'task_task_line_history': {
            'params': ['task', 'line', 'history'],
            'urls': [
                '/task/task/{task}/line/{line}/history/{history}'
            ],
            'v_range': [['6.4.0', '']]
        },
        'template': {
            'params': ['template', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/cli/template/{template}',
                '/pm/config/global/obj/cli/template/{template}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'templategroup': {
            'params': ['template-group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/cli/template-group/{template-group}',
                '/pm/config/global/obj/cli/template-group/{template-group}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_adgrp': {
            'params': ['adgrp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/adgrp/{adgrp}',
                '/pm/config/global/obj/user/adgrp/{adgrp}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_certificate': {
            'params': ['certificate', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/certificate/{certificate}',
                '/pm/config/global/obj/user/certificate/{certificate}'
            ],
            'v_range': [['7.0.8', '7.0.12'], ['7.2.3', '']]
        },
        'user_clearpass': {
            'params': ['clearpass', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/clearpass/{clearpass}',
                '/pm/config/global/obj/user/clearpass/{clearpass}'
            ],
            'v_range': [['6.2.1', '']]
        },
        'user_connector': {
            'params': ['connector', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/connector/{connector}',
                '/pm/config/global/obj/user/connector/{connector}'
            ],
            'v_range': [['7.0.1', '']]
        },
        'user_device': {
            'params': ['device', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/device/{device}',
                '/pm/config/global/obj/user/device/{device}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_device_dynamicmapping': {
            'params': ['device', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/device/{device}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/user/device/{device}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'user_device_tagging': {
            'params': ['device', 'tagging', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/device/{device}/tagging/{tagging}',
                '/pm/config/global/obj/user/device/{device}/tagging/{tagging}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_deviceaccesslist': {
            'params': ['device-access-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/device-access-list/{device-access-list}',
                '/pm/config/global/obj/user/device-access-list/{device-access-list}'
            ],
            'v_range': [['6.2.2', '7.2.1']]
        },
        'user_deviceaccesslist_devicelist': {
            'params': ['device-access-list', 'device-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/device-access-list/{device-access-list}/device-list/{device-list}',
                '/pm/config/global/obj/user/device-access-list/{device-access-list}/device-list/{device-list}'
            ],
            'v_range': [['6.2.2', '7.2.1']]
        },
        'user_devicecategory': {
            'params': ['device-category', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/device-category/{device-category}',
                '/pm/config/global/obj/user/device-category/{device-category}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'user_devicegroup': {
            'params': ['device-group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/device-group/{device-group}',
                '/pm/config/global/obj/user/device-group/{device-group}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'user_devicegroup_dynamicmapping': {
            'params': ['device-group', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/device-group/{device-group}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/user/device-group/{device-group}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'user_devicegroup_tagging': {
            'params': ['device-group', 'tagging', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/device-group/{device-group}/tagging/{tagging}',
                '/pm/config/global/obj/user/device-group/{device-group}/tagging/{tagging}'
            ],
            'v_range': [['6.0.0', '7.2.1']]
        },
        'user_domaincontroller': {
            'params': ['domain-controller', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/domain-controller/{domain-controller}',
                '/pm/config/global/obj/user/domain-controller/{domain-controller}'
            ],
            'v_range': [['6.2.1', '']]
        },
        'user_domaincontroller_extraserver': {
            'params': ['domain-controller', 'extra-server', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/domain-controller/{domain-controller}/extra-server/{extra-server}',
                '/pm/config/global/obj/user/domain-controller/{domain-controller}/extra-server/{extra-server}'
            ],
            'v_range': [['6.2.1', '']]
        },
        'user_exchange': {
            'params': ['exchange', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/exchange/{exchange}',
                '/pm/config/global/obj/user/exchange/{exchange}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'user_flexvm': {
            'params': ['flexvm', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/flexvm/{flexvm}',
                '/pm/config/global/obj/user/flexvm/{flexvm}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'user_fortitoken': {
            'params': ['fortitoken', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/fortitoken/{fortitoken}',
                '/pm/config/global/obj/user/fortitoken/{fortitoken}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_fsso': {
            'params': ['fsso', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/fsso/{fsso}',
                '/pm/config/global/obj/user/fsso/{fsso}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_fsso_dynamicmapping': {
            'params': ['fsso', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/fsso/{fsso}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/user/fsso/{fsso}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'user_fssopolling': {
            'params': ['fsso-polling', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/fsso-polling/{fsso-polling}',
                '/pm/config/global/obj/user/fsso-polling/{fsso-polling}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_fssopolling_adgrp': {
            'params': ['fsso-polling', 'adgrp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/fsso-polling/{fsso-polling}/adgrp/{adgrp}',
                '/pm/config/global/obj/user/fsso-polling/{fsso-polling}/adgrp/{adgrp}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_group': {
            'params': ['group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/group/{group}',
                '/pm/config/global/obj/user/group/{group}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_group_dynamicmapping': {
            'params': ['group', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/group/{group}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/user/group/{group}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['7.0.2', '7.4.0']]
        },
        'user_group_dynamicmapping_guest': {
            'params': ['group', 'dynamic_mapping', 'guest', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/group/{group}/dynamic_mapping/{dynamic_mapping}/guest/{guest}',
                '/pm/config/global/obj/user/group/{group}/dynamic_mapping/{dynamic_mapping}/guest/{guest}'
            ],
            'v_range': [['7.0.2', '7.4.0']]
        },
        'user_group_dynamicmapping_match': {
            'params': ['group', 'dynamic_mapping', 'match', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/group/{group}/dynamic_mapping/{dynamic_mapping}/match/{match}',
                '/pm/config/global/obj/user/group/{group}/dynamic_mapping/{dynamic_mapping}/match/{match}'
            ],
            'v_range': [['7.0.2', '7.4.0']]
        },
        'user_group_dynamicmapping_sslvpnoschecklist': {
            'params': ['group', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/group/{group}/dynamic_mapping/{dynamic_mapping}/sslvpn-os-check-list',
                '/pm/config/global/obj/user/group/{group}/dynamic_mapping/{dynamic_mapping}/sslvpn-os-check-list'
            ],
            'v_range': [['7.0.2', '7.4.0']]
        },
        'user_group_guest': {
            'params': ['group', 'guest', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/group/{group}/guest/{guest}',
                '/pm/config/global/obj/user/group/{group}/guest/{guest}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_group_match': {
            'params': ['group', 'match', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/group/{group}/match/{match}',
                '/pm/config/global/obj/user/group/{group}/match/{match}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_json': {
            'params': ['json', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/json/{json}',
                '/pm/config/global/obj/user/json/{json}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'user_krbkeytab': {
            'params': ['krb-keytab', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/krb-keytab/{krb-keytab}',
                '/pm/config/global/obj/user/krb-keytab/{krb-keytab}'
            ],
            'v_range': [['6.2.1', '']]
        },
        'user_ldap': {
            'params': ['ldap', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/ldap/{ldap}',
                '/pm/config/global/obj/user/ldap/{ldap}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_ldap_dynamicmapping': {
            'params': ['ldap', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/ldap/{ldap}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/user/ldap/{ldap}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'user_local': {
            'params': ['local', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/local/{local}',
                '/pm/config/global/obj/user/local/{local}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_nsx': {
            'params': ['nsx', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/nsx/{nsx}',
                '/pm/config/global/obj/user/nsx/{nsx}'
            ],
            'v_range': [['6.2.1', '']]
        },
        'user_nsx_service': {
            'params': ['nsx', 'service', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/nsx/{nsx}/service/{service}',
                '/pm/config/global/obj/user/nsx/{nsx}/service/{service}'
            ],
            'v_range': [['7.0.4', '']]
        },
        'user_passwordpolicy': {
            'params': ['password-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/password-policy/{password-policy}',
                '/pm/config/global/obj/user/password-policy/{password-policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_peer': {
            'params': ['peer', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/peer/{peer}',
                '/pm/config/global/obj/user/peer/{peer}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_peergrp': {
            'params': ['peergrp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/peergrp/{peergrp}',
                '/pm/config/global/obj/user/peergrp/{peergrp}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_pop3': {
            'params': ['pop3', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/pop3/{pop3}',
                '/pm/config/global/obj/user/pop3/{pop3}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_pxgrid': {
            'params': ['pxgrid', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/pxgrid/{pxgrid}',
                '/pm/config/global/obj/user/pxgrid/{pxgrid}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_radius': {
            'params': ['radius', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/radius/{radius}',
                '/pm/config/global/obj/user/radius/{radius}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_radius_accountingserver': {
            'params': ['radius', 'accounting-server', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/radius/{radius}/accounting-server/{accounting-server}',
                '/pm/config/global/obj/user/radius/{radius}/accounting-server/{accounting-server}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_radius_dynamicmapping': {
            'params': ['radius', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/radius/{radius}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/user/radius/{radius}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'user_radius_dynamicmapping_accountingserver': {
            'params': ['radius', 'dynamic_mapping', 'accounting-server', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/radius/{radius}/dynamic_mapping/{dynamic_mapping}/accounting-server/{accounting-server}',
                '/pm/config/global/obj/user/radius/{radius}/dynamic_mapping/{dynamic_mapping}/accounting-server/{accounting-server}'
            ],
            'v_range': [['6.2.6', '6.2.12'], ['6.4.2', '7.4.0']]
        },
        'user_saml': {
            'params': ['saml', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/saml/{saml}',
                '/pm/config/global/obj/user/saml/{saml}'
            ],
            'v_range': [['6.4.0', '']]
        },
        'user_saml_dynamicmapping': {
            'params': ['saml', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/saml/{saml}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/user/saml/{saml}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['7.0.5', '7.0.12'], ['7.2.1', '7.4.0']]
        },
        'user_securityexemptlist': {
            'params': ['security-exempt-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/security-exempt-list/{security-exempt-list}',
                '/pm/config/global/obj/user/security-exempt-list/{security-exempt-list}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_securityexemptlist_rule': {
            'params': ['security-exempt-list', 'rule', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/security-exempt-list/{security-exempt-list}/rule/{rule}',
                '/pm/config/global/obj/user/security-exempt-list/{security-exempt-list}/rule/{rule}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_tacacs': {
            'params': ['tacacs+', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/tacacs+/{tacacs+}',
                '/pm/config/global/obj/user/tacacs+/{tacacs+}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'user_tacacs_dynamicmapping': {
            'params': ['tacacs+', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/tacacs+/{tacacs+}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/user/tacacs+/{tacacs+}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'user_vcenter': {
            'params': ['vcenter', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/vcenter/{vcenter}',
                '/pm/config/global/obj/user/vcenter/{vcenter}'
            ],
            'v_range': [['6.4.0', '']]
        },
        'user_vcenter_rule': {
            'params': ['vcenter', 'rule', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/user/vcenter/{vcenter}/rule/{rule}',
                '/pm/config/global/obj/user/vcenter/{vcenter}/rule/{rule}'
            ],
            'v_range': [['6.4.0', '']]
        },
        'utmprofile': {
            'params': ['utm-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/utm-profile/{utm-profile}',
                '/pm/config/global/obj/wireless-controller/utm-profile/{utm-profile}'
            ],
            'v_range': [['6.2.2', '']]
        },
        'vap': {
            'params': ['vap', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/vap/{vap}',
                '/pm/config/global/obj/wireless-controller/vap/{vap}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vap_dynamicmapping': {
            'params': ['vap', 'dynamic_mapping', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/vap/{vap}/dynamic_mapping/{dynamic_mapping}',
                '/pm/config/global/obj/wireless-controller/vap/{vap}/dynamic_mapping/{dynamic_mapping}'
            ],
            'v_range': [['6.0.0', '7.4.0']]
        },
        'vap_macfilterlist': {
            'params': ['vap', 'mac-filter-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/vap/{vap}/mac-filter-list/{mac-filter-list}',
                '/pm/config/global/obj/wireless-controller/vap/{vap}/mac-filter-list/{mac-filter-list}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vap_mpskkey': {
            'params': ['vap', 'mpsk-key', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/vap/{vap}/mpsk-key/{mpsk-key}',
                '/pm/config/global/obj/wireless-controller/vap/{vap}/mpsk-key/{mpsk-key}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vap_portalmessageoverrides': {
            'params': ['vap', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/vap/{vap}/portal-message-overrides',
                '/pm/config/global/obj/wireless-controller/vap/{vap}/portal-message-overrides'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vap_vlanname': {
            'params': ['vap', 'vlan-name', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/vap/{vap}/vlan-name/{vlan-name}',
                '/pm/config/global/obj/wireless-controller/vap/{vap}/vlan-name/{vlan-name}'
            ],
            'v_range': [['7.0.3', '']]
        },
        'vap_vlanpool': {
            'params': ['vap', 'vlan-pool', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/vap/{vap}/vlan-pool/{vlan-pool}',
                '/pm/config/global/obj/wireless-controller/vap/{vap}/vlan-pool/{vlan-pool}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vapgroup': {
            'params': ['vap-group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/vap-group/{vap-group}',
                '/pm/config/global/obj/wireless-controller/vap-group/{vap-group}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'videofilter_keyword': {
            'params': ['keyword', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/videofilter/keyword/{keyword}',
                '/pm/config/global/obj/videofilter/keyword/{keyword}'
            ],
            'v_range': [['7.4.2', '']]
        },
        'videofilter_keyword_word': {
            'params': ['keyword', 'word', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/videofilter/keyword/{keyword}/word/{word}',
                '/pm/config/global/obj/videofilter/keyword/{keyword}/word/{word}'
            ],
            'v_range': [['7.4.2', '']]
        },
        'videofilter_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/videofilter/profile/{profile}',
                '/pm/config/global/obj/videofilter/profile/{profile}'
            ],
            'v_range': [['7.0.0', '']]
        },
        'videofilter_profile_filters': {
            'params': ['profile', 'filters', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/videofilter/profile/{profile}/filters/{filters}',
                '/pm/config/global/obj/videofilter/profile/{profile}/filters/{filters}'
            ],
            'v_range': [['7.4.2', '']]
        },
        'videofilter_profile_fortiguardcategory': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/videofilter/profile/{profile}/fortiguard-category',
                '/pm/config/global/obj/videofilter/profile/{profile}/fortiguard-category'
            ],
            'v_range': [['7.0.0', '']]
        },
        'videofilter_profile_fortiguardcategory_filters': {
            'params': ['profile', 'filters', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/videofilter/profile/{profile}/fortiguard-category/filters/{filters}',
                '/pm/config/global/obj/videofilter/profile/{profile}/fortiguard-category/filters/{filters}'
            ],
            'v_range': [['7.0.0', '']]
        },
        'videofilter_youtubechannelfilter': {
            'params': ['youtube-channel-filter', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/videofilter/youtube-channel-filter/{youtube-channel-filter}',
                '/pm/config/global/obj/videofilter/youtube-channel-filter/{youtube-channel-filter}'
            ],
            'v_range': [['7.0.0', '']]
        },
        'videofilter_youtubechannelfilter_entries': {
            'params': ['youtube-channel-filter', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/videofilter/youtube-channel-filter/{youtube-channel-filter}/entries/{entries}',
                '/pm/config/global/obj/videofilter/youtube-channel-filter/{youtube-channel-filter}/entries/{entries}'
            ],
            'v_range': [['7.0.0', '']]
        },
        'videofilter_youtubekey': {
            'params': ['youtube-key', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/videofilter/youtube-key/{youtube-key}',
                '/pm/config/global/obj/videofilter/youtube-key/{youtube-key}'
            ],
            'v_range': [['7.4.2', '']]
        },
        'virtualpatch_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/virtual-patch/profile/{profile}',
                '/pm/config/global/obj/virtual-patch/profile/{profile}'
            ],
            'v_range': [['7.4.1', '']]
        },
        'virtualpatch_profile_exemption': {
            'params': ['profile', 'exemption', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/virtual-patch/profile/{profile}/exemption/{exemption}',
                '/pm/config/global/obj/virtual-patch/profile/{profile}/exemption/{exemption}'
            ],
            'v_range': [['7.4.1', '']]
        },
        'voip_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/voip/profile/{profile}',
                '/pm/config/global/obj/voip/profile/{profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'voip_profile_msrp': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/voip/profile/{profile}/msrp',
                '/pm/config/global/obj/voip/profile/{profile}/msrp'
            ],
            'v_range': [['7.0.2', '']]
        },
        'voip_profile_sccp': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/voip/profile/{profile}/sccp',
                '/pm/config/global/obj/voip/profile/{profile}/sccp'
            ],
            'v_range': [['6.0.0', '']]
        },
        'voip_profile_sip': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/voip/profile/{profile}/sip',
                '/pm/config/global/obj/voip/profile/{profile}/sip'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpn_certificate_ca': {
            'params': ['ca', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpn/certificate/ca/{ca}',
                '/pm/config/global/obj/vpn/certificate/ca/{ca}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpn_certificate_ocspserver': {
            'params': ['ocsp-server', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpn/certificate/ocsp-server/{ocsp-server}',
                '/pm/config/global/obj/vpn/certificate/ocsp-server/{ocsp-server}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpn_certificate_remote': {
            'params': ['remote', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpn/certificate/remote/{remote}',
                '/pm/config/global/obj/vpn/certificate/remote/{remote}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpn_ipsec_fec': {
            'params': ['fec', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpn/ipsec/fec/{fec}',
                '/pm/config/global/obj/vpn/ipsec/fec/{fec}'
            ],
            'v_range': [['7.2.0', '']]
        },
        'vpn_ipsec_fec_mappings': {
            'params': ['fec', 'mappings', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpn/ipsec/fec/{fec}/mappings/{mappings}',
                '/pm/config/global/obj/vpn/ipsec/fec/{fec}/mappings/{mappings}'
            ],
            'v_range': [['7.2.0', '']]
        },
        'vpn_ssl_settings': {
            'params': ['device', 'vdom'],
            'urls': [
                '/pm/config/device/{device}/vdom/{vdom}/vpn/ssl/settings'
            ],
            'v_range': [['6.2.6', '6.2.12'], ['6.4.2', '']]
        },
        'vpn_ssl_settings_authenticationrule': {
            'params': ['device', 'vdom', 'authentication-rule'],
            'urls': [
                '/pm/config/device/{device}/vdom/{vdom}/vpn/ssl/settings/authentication-rule/{authentication-rule}'
            ],
            'v_range': [['6.2.6', '6.2.12'], ['6.4.2', '']]
        },
        'vpnmgr_node': {
            'params': ['node', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpnmgr/node/{node}',
                '/pm/config/global/obj/vpnmgr/node/{node}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpnmgr_node_iprange': {
            'params': ['node', 'ip-range', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpnmgr/node/{node}/ip-range/{ip-range}',
                '/pm/config/global/obj/vpnmgr/node/{node}/ip-range/{ip-range}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpnmgr_node_ipv4excluderange': {
            'params': ['node', 'ipv4-exclude-range', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpnmgr/node/{node}/ipv4-exclude-range/{ipv4-exclude-range}',
                '/pm/config/global/obj/vpnmgr/node/{node}/ipv4-exclude-range/{ipv4-exclude-range}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpnmgr_node_protectedsubnet': {
            'params': ['node', 'protected_subnet', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpnmgr/node/{node}/protected_subnet/{protected_subnet}',
                '/pm/config/global/obj/vpnmgr/node/{node}/protected_subnet/{protected_subnet}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpnmgr_node_summaryaddr': {
            'params': ['node', 'summary_addr', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpnmgr/node/{node}/summary_addr/{summary_addr}',
                '/pm/config/global/obj/vpnmgr/node/{node}/summary_addr/{summary_addr}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpnmgr_vpntable': {
            'params': ['vpntable', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpnmgr/vpntable/{vpntable}',
                '/pm/config/global/obj/vpnmgr/vpntable/{vpntable}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpnsslweb_hostchecksoftware': {
            'params': ['host-check-software', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpn/ssl/web/host-check-software/{host-check-software}',
                '/pm/config/global/obj/vpn/ssl/web/host-check-software/{host-check-software}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpnsslweb_hostchecksoftware_checkitemlist': {
            'params': ['host-check-software', 'check-item-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpn/ssl/web/host-check-software/{host-check-software}/check-item-list/{check-item-list}',
                '/pm/config/global/obj/vpn/ssl/web/host-check-software/{host-check-software}/check-item-list/{check-item-list}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpnsslweb_portal': {
            'params': ['portal', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpn/ssl/web/portal/{portal}',
                '/pm/config/global/obj/vpn/ssl/web/portal/{portal}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpnsslweb_portal_bookmarkgroup': {
            'params': ['portal', 'bookmark-group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpn/ssl/web/portal/{portal}/bookmark-group/{bookmark-group}',
                '/pm/config/global/obj/vpn/ssl/web/portal/{portal}/bookmark-group/{bookmark-group}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpnsslweb_portal_bookmarkgroup_bookmarks': {
            'params': ['portal', 'bookmark-group', 'bookmarks', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpn/ssl/web/portal/{portal}/bookmark-group/{bookmark-group}/bookmarks/{bookmarks}',
                '/pm/config/global/obj/vpn/ssl/web/portal/{portal}/bookmark-group/{bookmark-group}/bookmarks/{bookmarks}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpnsslweb_portal_bookmarkgroup_bookmarks_formdata': {
            'params': ['portal', 'bookmark-group', 'bookmarks', 'form-data', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpn/ssl/web/portal/{portal}/bookmark-group/{bookmark-group}/bookmarks/{bookmarks}/form-data/{form-data}',
                '/pm/config/global/obj/vpn/ssl/web/portal/{portal}/bookmark-group/{bookmark-group}/bookmarks/{bookmarks}/form-data/{form-data}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpnsslweb_portal_landingpage': {
            'params': ['portal', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpn/ssl/web/portal/{portal}/landing-page',
                '/pm/config/global/obj/vpn/ssl/web/portal/{portal}/landing-page'
            ],
            'v_range': [['7.4.0', '']]
        },
        'vpnsslweb_portal_landingpage_formdata': {
            'params': ['portal', 'form-data', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpn/ssl/web/portal/{portal}/landing-page/form-data/{form-data}',
                '/pm/config/global/obj/vpn/ssl/web/portal/{portal}/landing-page/form-data/{form-data}'
            ],
            'v_range': [['7.4.0', '']]
        },
        'vpnsslweb_portal_macaddrcheckrule': {
            'params': ['portal', 'mac-addr-check-rule', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpn/ssl/web/portal/{portal}/mac-addr-check-rule/{mac-addr-check-rule}',
                '/pm/config/global/obj/vpn/ssl/web/portal/{portal}/mac-addr-check-rule/{mac-addr-check-rule}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpnsslweb_portal_oschecklist': {
            'params': ['portal', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpn/ssl/web/portal/{portal}/os-check-list',
                '/pm/config/global/obj/vpn/ssl/web/portal/{portal}/os-check-list'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpnsslweb_portal_splitdns': {
            'params': ['portal', 'split-dns', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpn/ssl/web/portal/{portal}/split-dns/{split-dns}',
                '/pm/config/global/obj/vpn/ssl/web/portal/{portal}/split-dns/{split-dns}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpnsslweb_realm': {
            'params': ['realm', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpn/ssl/web/realm/{realm}',
                '/pm/config/global/obj/vpn/ssl/web/realm/{realm}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'vpnsslweb_virtualdesktopapplist': {
            'params': ['virtual-desktop-app-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpn/ssl/web/virtual-desktop-app-list/{virtual-desktop-app-list}',
                '/pm/config/global/obj/vpn/ssl/web/virtual-desktop-app-list/{virtual-desktop-app-list}'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'vpnsslweb_virtualdesktopapplist_apps': {
            'params': ['virtual-desktop-app-list', 'apps', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/vpn/ssl/web/virtual-desktop-app-list/{virtual-desktop-app-list}/apps/{apps}',
                '/pm/config/global/obj/vpn/ssl/web/virtual-desktop-app-list/{virtual-desktop-app-list}/apps/{apps}'
            ],
            'v_range': [['6.2.0', '6.2.12']]
        },
        'waf_mainclass': {
            'params': ['main-class', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/main-class/{main-class}',
                '/pm/config/global/obj/waf/main-class/{main-class}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}',
                '/pm/config/global/obj/waf/profile/{profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_addresslist': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/address-list',
                '/pm/config/global/obj/waf/profile/{profile}/address-list'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_constraint': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/constraint',
                '/pm/config/global/obj/waf/profile/{profile}/constraint'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_constraint_contentlength': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/constraint/content-length',
                '/pm/config/global/obj/waf/profile/{profile}/constraint/content-length'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_constraint_exception': {
            'params': ['profile', 'exception', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/constraint/exception/{exception}',
                '/pm/config/global/obj/waf/profile/{profile}/constraint/exception/{exception}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_constraint_headerlength': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/constraint/header-length',
                '/pm/config/global/obj/waf/profile/{profile}/constraint/header-length'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_constraint_hostname': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/constraint/hostname',
                '/pm/config/global/obj/waf/profile/{profile}/constraint/hostname'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_constraint_linelength': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/constraint/line-length',
                '/pm/config/global/obj/waf/profile/{profile}/constraint/line-length'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_constraint_malformed': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/constraint/malformed',
                '/pm/config/global/obj/waf/profile/{profile}/constraint/malformed'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_constraint_maxcookie': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/constraint/max-cookie',
                '/pm/config/global/obj/waf/profile/{profile}/constraint/max-cookie'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_constraint_maxheaderline': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/constraint/max-header-line',
                '/pm/config/global/obj/waf/profile/{profile}/constraint/max-header-line'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_constraint_maxrangesegment': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/constraint/max-range-segment',
                '/pm/config/global/obj/waf/profile/{profile}/constraint/max-range-segment'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_constraint_maxurlparam': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/constraint/max-url-param',
                '/pm/config/global/obj/waf/profile/{profile}/constraint/max-url-param'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_constraint_method': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/constraint/method',
                '/pm/config/global/obj/waf/profile/{profile}/constraint/method'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_constraint_paramlength': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/constraint/param-length',
                '/pm/config/global/obj/waf/profile/{profile}/constraint/param-length'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_constraint_urlparamlength': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/constraint/url-param-length',
                '/pm/config/global/obj/waf/profile/{profile}/constraint/url-param-length'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_constraint_version': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/constraint/version',
                '/pm/config/global/obj/waf/profile/{profile}/constraint/version'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_method': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/method',
                '/pm/config/global/obj/waf/profile/{profile}/method'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_method_methodpolicy': {
            'params': ['profile', 'method-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/method/method-policy/{method-policy}',
                '/pm/config/global/obj/waf/profile/{profile}/method/method-policy/{method-policy}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_signature': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/signature',
                '/pm/config/global/obj/waf/profile/{profile}/signature'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_signature_customsignature': {
            'params': ['profile', 'custom-signature', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/signature/custom-signature/{custom-signature}',
                '/pm/config/global/obj/waf/profile/{profile}/signature/custom-signature/{custom-signature}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_signature_mainclass': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/signature/main-class',
                '/pm/config/global/obj/waf/profile/{profile}/signature/main-class'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_urlaccess': {
            'params': ['profile', 'url-access', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/url-access/{url-access}',
                '/pm/config/global/obj/waf/profile/{profile}/url-access/{url-access}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_profile_urlaccess_accesspattern': {
            'params': ['profile', 'url-access', 'access-pattern', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/profile/{profile}/url-access/{url-access}/access-pattern/{access-pattern}',
                '/pm/config/global/obj/waf/profile/{profile}/url-access/{url-access}/access-pattern/{access-pattern}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_signature': {
            'params': ['signature', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/signature/{signature}',
                '/pm/config/global/obj/waf/signature/{signature}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'waf_subclass': {
            'params': ['sub-class', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/waf/sub-class/{sub-class}',
                '/pm/config/global/obj/waf/sub-class/{sub-class}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wagprofile': {
            'params': ['wag-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/wag-profile/{wag-profile}',
                '/pm/config/global/obj/wireless-controller/wag-profile/{wag-profile}'
            ],
            'v_range': [['6.2.3', '']]
        },
        'wanopt_authgroup': {
            'params': ['auth-group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wanopt/auth-group/{auth-group}',
                '/pm/config/global/obj/wanopt/auth-group/{auth-group}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wanopt_peer': {
            'params': ['peer', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wanopt/peer/{peer}',
                '/pm/config/global/obj/wanopt/peer/{peer}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wanopt_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wanopt/profile/{profile}',
                '/pm/config/global/obj/wanopt/profile/{profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wanopt_profile_cifs': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wanopt/profile/{profile}/cifs',
                '/pm/config/global/obj/wanopt/profile/{profile}/cifs'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wanopt_profile_ftp': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wanopt/profile/{profile}/ftp',
                '/pm/config/global/obj/wanopt/profile/{profile}/ftp'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wanopt_profile_http': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wanopt/profile/{profile}/http',
                '/pm/config/global/obj/wanopt/profile/{profile}/http'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wanopt_profile_mapi': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wanopt/profile/{profile}/mapi',
                '/pm/config/global/obj/wanopt/profile/{profile}/mapi'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wanopt_profile_tcp': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wanopt/profile/{profile}/tcp',
                '/pm/config/global/obj/wanopt/profile/{profile}/tcp'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wanprof_system_sdwan': {
            'params': ['wanprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/wanprof/{wanprof}/system/sdwan'
            ],
            'v_range': [['6.4.1', '']]
        },
        'wanprof_system_sdwan_duplication': {
            'params': ['wanprof', 'duplication', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/wanprof/{wanprof}/system/sdwan/duplication/{duplication}'
            ],
            'v_range': [['6.4.2', '']]
        },
        'wanprof_system_sdwan_healthcheck': {
            'params': ['wanprof', 'health-check', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/wanprof/{wanprof}/system/sdwan/health-check/{health-check}'
            ],
            'v_range': [['6.4.1', '']]
        },
        'wanprof_system_sdwan_healthcheck_sla': {
            'params': ['wanprof', 'health-check', 'sla', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/wanprof/{wanprof}/system/sdwan/health-check/{health-check}/sla/{sla}'
            ],
            'v_range': [['6.4.1', '']]
        },
        'wanprof_system_sdwan_members': {
            'params': ['wanprof', 'members', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/wanprof/{wanprof}/system/sdwan/members/{members}'
            ],
            'v_range': [['6.4.1', '']]
        },
        'wanprof_system_sdwan_neighbor': {
            'params': ['wanprof', 'neighbor', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/wanprof/{wanprof}/system/sdwan/neighbor/{neighbor}'
            ],
            'v_range': [['6.4.1', '']]
        },
        'wanprof_system_sdwan_service': {
            'params': ['wanprof', 'service', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/wanprof/{wanprof}/system/sdwan/service/{service}'
            ],
            'v_range': [['6.4.1', '']]
        },
        'wanprof_system_sdwan_service_sla': {
            'params': ['wanprof', 'service', 'sla', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/wanprof/{wanprof}/system/sdwan/service/{service}/sla/{sla}'
            ],
            'v_range': [['6.4.1', '']]
        },
        'wanprof_system_sdwan_zone': {
            'params': ['wanprof', 'zone', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/wanprof/{wanprof}/system/sdwan/zone/{zone}'
            ],
            'v_range': [['6.4.1', '']]
        },
        'wanprof_system_virtualwanlink': {
            'params': ['wanprof', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/wanprof/{wanprof}/system/virtual-wan-link'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wanprof_system_virtualwanlink_healthcheck': {
            'params': ['wanprof', 'health-check', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/wanprof/{wanprof}/system/virtual-wan-link/health-check/{health-check}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wanprof_system_virtualwanlink_healthcheck_sla': {
            'params': ['wanprof', 'health-check', 'sla', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/wanprof/{wanprof}/system/virtual-wan-link/health-check/{health-check}/sla/{sla}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wanprof_system_virtualwanlink_members': {
            'params': ['wanprof', 'members', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/wanprof/{wanprof}/system/virtual-wan-link/members/{members}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wanprof_system_virtualwanlink_neighbor': {
            'params': ['wanprof', 'neighbor', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/wanprof/{wanprof}/system/virtual-wan-link/neighbor/{neighbor}'
            ],
            'v_range': [['6.2.1', '']]
        },
        'wanprof_system_virtualwanlink_service': {
            'params': ['wanprof', 'service', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/wanprof/{wanprof}/system/virtual-wan-link/service/{service}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wanprof_system_virtualwanlink_service_sla': {
            'params': ['wanprof', 'service', 'sla', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/wanprof/{wanprof}/system/virtual-wan-link/service/{service}/sla/{sla}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webfilter_categories': {
            'params': ['categories', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/categories/{categories}',
                '/pm/config/global/obj/webfilter/categories/{categories}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webfilter_content': {
            'params': ['content', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/content/{content}',
                '/pm/config/global/obj/webfilter/content/{content}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webfilter_content_entries': {
            'params': ['content', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/content/{content}/entries/{entries}',
                '/pm/config/global/obj/webfilter/content/{content}/entries/{entries}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webfilter_contentheader': {
            'params': ['content-header', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/content-header/{content-header}',
                '/pm/config/global/obj/webfilter/content-header/{content-header}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webfilter_contentheader_entries': {
            'params': ['content-header', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/content-header/{content-header}/entries/{entries}',
                '/pm/config/global/obj/webfilter/content-header/{content-header}/entries/{entries}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webfilter_ftgdlocalcat': {
            'params': ['ftgd-local-cat', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/ftgd-local-cat/{ftgd-local-cat}',
                '/pm/config/global/obj/webfilter/ftgd-local-cat/{ftgd-local-cat}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webfilter_ftgdlocalrating': {
            'params': ['ftgd-local-rating', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/ftgd-local-rating/{ftgd-local-rating}',
                '/pm/config/global/obj/webfilter/ftgd-local-rating/{ftgd-local-rating}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webfilter_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/profile/{profile}',
                '/pm/config/global/obj/webfilter/profile/{profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webfilter_profile_antiphish': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/profile/{profile}/antiphish',
                '/pm/config/global/obj/webfilter/profile/{profile}/antiphish'
            ],
            'v_range': [['6.4.0', '']]
        },
        'webfilter_profile_antiphish_custompatterns': {
            'params': ['profile', 'custom-patterns', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/profile/{profile}/antiphish/custom-patterns/{custom-patterns}',
                '/pm/config/global/obj/webfilter/profile/{profile}/antiphish/custom-patterns/{custom-patterns}'
            ],
            'v_range': [['6.4.0', '']]
        },
        'webfilter_profile_antiphish_inspectionentries': {
            'params': ['profile', 'inspection-entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/profile/{profile}/antiphish/inspection-entries/{inspection-entries}',
                '/pm/config/global/obj/webfilter/profile/{profile}/antiphish/inspection-entries/{inspection-entries}'
            ],
            'v_range': [['6.4.0', '']]
        },
        'webfilter_profile_filefilter': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/profile/{profile}/file-filter',
                '/pm/config/global/obj/webfilter/profile/{profile}/file-filter'
            ],
            'v_range': [['6.2.0', '']]
        },
        'webfilter_profile_filefilter_entries': {
            'params': ['profile', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/profile/{profile}/file-filter/entries/{entries}',
                '/pm/config/global/obj/webfilter/profile/{profile}/file-filter/entries/{entries}'
            ],
            'v_range': [['6.2.0', '']]
        },
        'webfilter_profile_ftgdwf': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/profile/{profile}/ftgd-wf',
                '/pm/config/global/obj/webfilter/profile/{profile}/ftgd-wf'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webfilter_profile_ftgdwf_filters': {
            'params': ['profile', 'filters', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/profile/{profile}/ftgd-wf/filters/{filters}',
                '/pm/config/global/obj/webfilter/profile/{profile}/ftgd-wf/filters/{filters}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webfilter_profile_ftgdwf_quota': {
            'params': ['profile', 'quota', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/profile/{profile}/ftgd-wf/quota/{quota}',
                '/pm/config/global/obj/webfilter/profile/{profile}/ftgd-wf/quota/{quota}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webfilter_profile_override': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/profile/{profile}/override',
                '/pm/config/global/obj/webfilter/profile/{profile}/override'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webfilter_profile_urlextraction': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/profile/{profile}/url-extraction',
                '/pm/config/global/obj/webfilter/profile/{profile}/url-extraction'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webfilter_profile_web': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/profile/{profile}/web',
                '/pm/config/global/obj/webfilter/profile/{profile}/web'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webfilter_profile_youtubechannelfilter': {
            'params': ['profile', 'youtube-channel-filter', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/profile/{profile}/youtube-channel-filter/{youtube-channel-filter}',
                '/pm/config/global/obj/webfilter/profile/{profile}/youtube-channel-filter/{youtube-channel-filter}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webfilter_urlfilter': {
            'params': ['urlfilter', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/urlfilter/{urlfilter}',
                '/pm/config/global/obj/webfilter/urlfilter/{urlfilter}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webfilter_urlfilter_entries': {
            'params': ['urlfilter', 'entries', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/webfilter/urlfilter/{urlfilter}/entries/{entries}',
                '/pm/config/global/obj/webfilter/urlfilter/{urlfilter}/entries/{entries}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webproxy_forwardserver': {
            'params': ['forward-server', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/web-proxy/forward-server/{forward-server}',
                '/pm/config/global/obj/web-proxy/forward-server/{forward-server}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webproxy_forwardservergroup': {
            'params': ['forward-server-group', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/web-proxy/forward-server-group/{forward-server-group}',
                '/pm/config/global/obj/web-proxy/forward-server-group/{forward-server-group}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webproxy_forwardservergroup_serverlist': {
            'params': ['forward-server-group', 'server-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/web-proxy/forward-server-group/{forward-server-group}/server-list/{server-list}',
                '/pm/config/global/obj/web-proxy/forward-server-group/{forward-server-group}/server-list/{server-list}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webproxy_profile': {
            'params': ['profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/web-proxy/profile/{profile}',
                '/pm/config/global/obj/web-proxy/profile/{profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webproxy_profile_headers': {
            'params': ['profile', 'headers', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/web-proxy/profile/{profile}/headers/{headers}',
                '/pm/config/global/obj/web-proxy/profile/{profile}/headers/{headers}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'webproxy_wisp': {
            'params': ['wisp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/web-proxy/wisp/{wisp}',
                '/pm/config/global/obj/web-proxy/wisp/{wisp}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'widsprofile': {
            'params': ['wids-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/wids-profile/{wids-profile}',
                '/pm/config/global/obj/wireless-controller/wids-profile/{wids-profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wireless_accesscontrollist': {
            'params': ['access-control-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/access-control-list/{access-control-list}',
                '/pm/config/global/obj/wireless-controller/access-control-list/{access-control-list}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'wireless_accesscontrollist_layer3ipv4rules': {
            'params': ['access-control-list', 'layer3-ipv4-rules', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/access-control-list/{access-control-list}/layer3-ipv4-rules/{layer3-ipv4-rules}',
                '/pm/config/global/obj/wireless-controller/access-control-list/{access-control-list}/layer3-ipv4-rules/{layer3-ipv4-rules}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'wireless_accesscontrollist_layer3ipv6rules': {
            'params': ['access-control-list', 'layer3-ipv6-rules', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/access-control-list/{access-control-list}/layer3-ipv6-rules/{layer3-ipv6-rules}',
                '/pm/config/global/obj/wireless-controller/access-control-list/{access-control-list}/layer3-ipv6-rules/{layer3-ipv6-rules}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'wireless_address': {
            'params': ['address', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/address/{address}',
                '/pm/config/global/obj/wireless-controller/address/{address}'
            ],
            'v_range': [['7.0.1', '']]
        },
        'wireless_addrgrp': {
            'params': ['addrgrp', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/addrgrp/{addrgrp}',
                '/pm/config/global/obj/wireless-controller/addrgrp/{addrgrp}'
            ],
            'v_range': [['7.0.1', '']]
        },
        'wireless_ssidpolicy': {
            'params': ['ssid-policy', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/ssid-policy/{ssid-policy}',
                '/pm/config/global/obj/wireless-controller/ssid-policy/{ssid-policy}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'wireless_syslogprofile': {
            'params': ['syslog-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/syslog-profile/{syslog-profile}',
                '/pm/config/global/obj/wireless-controller/syslog-profile/{syslog-profile}'
            ],
            'v_range': [['7.2.1', '']]
        },
        'wtpprofile': {
            'params': ['wtp-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/wtp-profile/{wtp-profile}',
                '/pm/config/global/obj/wireless-controller/wtp-profile/{wtp-profile}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wtpprofile_denymaclist': {
            'params': ['wtp-profile', 'deny-mac-list', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/wtp-profile/{wtp-profile}/deny-mac-list/{deny-mac-list}',
                '/pm/config/global/obj/wireless-controller/wtp-profile/{wtp-profile}/deny-mac-list/{deny-mac-list}'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wtpprofile_eslsesdongle': {
            'params': ['wtp-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/wtp-profile/{wtp-profile}/esl-ses-dongle',
                '/pm/config/global/obj/wireless-controller/wtp-profile/{wtp-profile}/esl-ses-dongle'
            ],
            'v_range': [['7.0.1', '']]
        },
        'wtpprofile_lan': {
            'params': ['wtp-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/wtp-profile/{wtp-profile}/lan',
                '/pm/config/global/obj/wireless-controller/wtp-profile/{wtp-profile}/lan'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wtpprofile_lbs': {
            'params': ['wtp-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/wtp-profile/{wtp-profile}/lbs',
                '/pm/config/global/obj/wireless-controller/wtp-profile/{wtp-profile}/lbs'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wtpprofile_platform': {
            'params': ['wtp-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/wtp-profile/{wtp-profile}/platform',
                '/pm/config/global/obj/wireless-controller/wtp-profile/{wtp-profile}/platform'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wtpprofile_radio1': {
            'params': ['wtp-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/wtp-profile/{wtp-profile}/radio-1',
                '/pm/config/global/obj/wireless-controller/wtp-profile/{wtp-profile}/radio-1'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wtpprofile_radio2': {
            'params': ['wtp-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/wtp-profile/{wtp-profile}/radio-2',
                '/pm/config/global/obj/wireless-controller/wtp-profile/{wtp-profile}/radio-2'
            ],
            'v_range': [['6.0.0', '']]
        },
        'wtpprofile_radio3': {
            'params': ['wtp-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/wtp-profile/{wtp-profile}/radio-3',
                '/pm/config/global/obj/wireless-controller/wtp-profile/{wtp-profile}/radio-3'
            ],
            'v_range': [['6.2.2', '']]
        },
        'wtpprofile_radio4': {
            'params': ['wtp-profile', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/wtp-profile/{wtp-profile}/radio-4',
                '/pm/config/global/obj/wireless-controller/wtp-profile/{wtp-profile}/radio-4'
            ],
            'v_range': [['6.2.5', '']]
        },
        'wtpprofile_splittunnelingacl': {
            'params': ['wtp-profile', 'split-tunneling-acl', 'adom'],
            'urls': [
                '/pm/config/adom/{adom}/obj/wireless-controller/wtp-profile/{wtp-profile}/split-tunneling-acl/{split-tunneling-acl}',
                '/pm/config/global/obj/wireless-controller/wtp-profile/{wtp-profile}/split-tunneling-acl/{split-tunneling-acl}'
            ],
            'v_range': [['6.0.0', '']]
        }
    }

    module_arg_spec = {
        'access_token': {'type': 'str', 'no_log': True},
        'enable_log': {'type': 'bool', 'default': False},
        'forticloud_access_token': {'type': 'str', 'no_log': True},
        'workspace_locking_adom': {'type': 'str'},
        'workspace_locking_timeout': {'type': 'int', 'default': 300},
        'export_playbooks': {
            'required': True,
            'type': 'dict',
            'options': {
                'selector': {
                    'required': True,
                    'type': 'list',
                    'elements': 'str',
                    'choices': [
                        'all',
                        'adom_options',
                        'antivirus_mmschecksum',
                        'antivirus_mmschecksum_entries',
                        'antivirus_notification',
                        'antivirus_notification_entries',
                        'antivirus_profile',
                        'antivirus_profile_cifs',
                        'antivirus_profile_contentdisarm',
                        'antivirus_profile_ftp',
                        'antivirus_profile_http',
                        'antivirus_profile_imap',
                        'antivirus_profile_mapi',
                        'antivirus_profile_nacquar',
                        'antivirus_profile_nntp',
                        'antivirus_profile_outbreakprevention',
                        'antivirus_profile_pop3',
                        'antivirus_profile_smb',
                        'antivirus_profile_smtp',
                        'antivirus_profile_ssh',
                        'apcfgprofile',
                        'apcfgprofile_commandlist',
                        'application_casi_profile',
                        'application_casi_profile_entries',
                        'application_categories',
                        'application_custom',
                        'application_group',
                        'application_internetservice',
                        'application_internetservice_entry',
                        'application_internetservicecustom',
                        'application_internetservicecustom_disableentry',
                        'application_internetservicecustom_disableentry_iprange',
                        'application_internetservicecustom_entry',
                        'application_internetservicecustom_entry_portrange',
                        'application_list',
                        'application_list_defaultnetworkservices',
                        'application_list_entries',
                        'application_list_entries_parameters',
                        'application_list_entries_parameters_members',
                        'arrpprofile',
                        'authentication_scheme',
                        'bleprofile',
                        'bonjourprofile',
                        'bonjourprofile_policylist',
                        'casb_profile',
                        'casb_profile_saasapplication',
                        'casb_profile_saasapplication_accessrule',
                        'casb_profile_saasapplication_customcontrol',
                        'casb_profile_saasapplication_customcontrol_option',
                        'casb_saasapplication',
                        'casb_useractivity',
                        'casb_useractivity_controloptions',
                        'casb_useractivity_controloptions_operations',
                        'casb_useractivity_match',
                        'casb_useractivity_match_rules',
                        'certificate_template',
                        'cifs_domaincontroller',
                        'cifs_profile',
                        'cifs_profile_filefilter',
                        'cifs_profile_filefilter_entries',
                        'cifs_profile_serverkeytab',
                        'cloud_orchestaws',
                        'cloud_orchestawsconnector',
                        'cloud_orchestawstemplate_autoscaleexistingvpc',
                        'cloud_orchestawstemplate_autoscalenewvpc',
                        'cloud_orchestawstemplate_autoscaletgwnewvpc',
                        'cloud_orchestration',
                        'credentialstore_domaincontroller',
                        'devprof_device_profile_fortianalyzer',
                        'devprof_device_profile_fortiguard',
                        'devprof_log_fortianalyzer_setting',
                        'devprof_log_fortianalyzercloud_setting',
                        'devprof_log_syslogd_filter',
                        'devprof_log_syslogd_filter_excludelist',
                        'devprof_log_syslogd_filter_excludelist_fields',
                        'devprof_log_syslogd_filter_freestyle',
                        'devprof_log_syslogd_setting',
                        'devprof_log_syslogd_setting_customfieldname',
                        'devprof_system_centralmanagement',
                        'devprof_system_centralmanagement_serverlist',
                        'devprof_system_dns',
                        'devprof_system_emailserver',
                        'devprof_system_global',
                        'devprof_system_ntp',
                        'devprof_system_ntp_ntpserver',
                        'devprof_system_replacemsg_admin',
                        'devprof_system_replacemsg_alertmail',
                        'devprof_system_replacemsg_auth',
                        'devprof_system_replacemsg_devicedetectionportal',
                        'devprof_system_replacemsg_ec',
                        'devprof_system_replacemsg_fortiguardwf',
                        'devprof_system_replacemsg_ftp',
                        'devprof_system_replacemsg_http',
                        'devprof_system_replacemsg_mail',
                        'devprof_system_replacemsg_mms',
                        'devprof_system_replacemsg_nacquar',
                        'devprof_system_replacemsg_nntp',
                        'devprof_system_replacemsg_spam',
                        'devprof_system_replacemsg_sslvpn',
                        'devprof_system_replacemsg_trafficquota',
                        'devprof_system_replacemsg_utm',
                        'devprof_system_replacemsg_webproxy',
                        'devprof_system_snmp_community',
                        'devprof_system_snmp_community_hosts',
                        'devprof_system_snmp_community_hosts6',
                        'devprof_system_snmp_sysinfo',
                        'devprof_system_snmp_user',
                        'diameterfilter_profile',
                        'dlp_datatype',
                        'dlp_dictionary',
                        'dlp_dictionary_entries',
                        'dlp_filepattern',
                        'dlp_filepattern_entries',
                        'dlp_fpsensitivity',
                        'dlp_profile',
                        'dlp_profile_rule',
                        'dlp_sensitivity',
                        'dlp_sensor',
                        'dlp_sensor_entries',
                        'dlp_sensor_filter',
                        'dnsfilter_domainfilter',
                        'dnsfilter_domainfilter_entries',
                        'dnsfilter_profile',
                        'dnsfilter_profile_dnstranslation',
                        'dnsfilter_profile_domainfilter',
                        'dnsfilter_profile_ftgddns',
                        'dnsfilter_profile_ftgddns_filters',
                        'dnsfilter_profile_urlfilter',
                        'dnsfilter_urlfilter',
                        'dnsfilter_urlfilter_entries',
                        'dvmdb_adom',
                        'dvmdb_device',
                        'dvmdb_device_haslave',
                        'dvmdb_device_vdom',
                        'dvmdb_folder',
                        'dvmdb_group',
                        'dvmdb_metafields_adom',
                        'dvmdb_metafields_device',
                        'dvmdb_metafields_group',
                        'dvmdb_revision',
                        'dvmdb_script',
                        'dvmdb_script_log_latest',
                        'dvmdb_script_log_latest_device',
                        'dvmdb_script_log_list',
                        'dvmdb_script_log_list_device',
                        'dvmdb_script_log_output_device_logid',
                        'dvmdb_script_log_output_logid',
                        'dvmdb_script_log_summary',
                        'dvmdb_script_log_summary_device',
                        'dvmdb_script_scriptschedule',
                        'dvmdb_workflow',
                        'dvmdb_workflow_wflog',
                        'dvmdb_workspace_dirty',
                        'dvmdb_workspace_dirty_dev',
                        'dvmdb_workspace_lockinfo',
                        'dvmdb_workspace_lockinfo_dev',
                        'dvmdb_workspace_lockinfo_obj',
                        'dvmdb_workspace_lockinfo_pkg',
                        'dynamic_address',
                        'dynamic_address_dynamicaddrmapping',
                        'dynamic_certificate_local',
                        'dynamic_certificate_local_dynamicmapping',
                        'dynamic_input_interface',
                        'dynamic_input_interface_dynamicmapping',
                        'dynamic_interface',
                        'dynamic_interface_dynamicmapping',
                        'dynamic_interface_platformmapping',
                        'dynamic_ippool',
                        'dynamic_multicast_interface',
                        'dynamic_multicast_interface_dynamicmapping',
                        'dynamic_vip',
                        'dynamic_virtualwanlink_members',
                        'dynamic_virtualwanlink_members_dynamicmapping',
                        'dynamic_virtualwanlink_neighbor',
                        'dynamic_virtualwanlink_neighbor_dynamicmapping',
                        'dynamic_virtualwanlink_server',
                        'dynamic_virtualwanlink_server_dynamicmapping',
                        'dynamic_vpntunnel',
                        'dynamic_vpntunnel_dynamicmapping',
                        'emailfilter_blockallowlist',
                        'emailfilter_blockallowlist_entries',
                        'emailfilter_bwl',
                        'emailfilter_bwl_entries',
                        'emailfilter_bword',
                        'emailfilter_bword_entries',
                        'emailfilter_dnsbl',
                        'emailfilter_dnsbl_entries',
                        'emailfilter_fortishield',
                        'emailfilter_iptrust',
                        'emailfilter_iptrust_entries',
                        'emailfilter_mheader',
                        'emailfilter_mheader_entries',
                        'emailfilter_options',
                        'emailfilter_profile',
                        'emailfilter_profile_filefilter',
                        'emailfilter_profile_filefilter_entries',
                        'emailfilter_profile_gmail',
                        'emailfilter_profile_imap',
                        'emailfilter_profile_mapi',
                        'emailfilter_profile_msnhotmail',
                        'emailfilter_profile_otherwebmails',
                        'emailfilter_profile_pop3',
                        'emailfilter_profile_smtp',
                        'emailfilter_profile_yahoomail',
                        'endpointcontrol_fctems',
                        'extendercontroller_dataplan',
                        'extendercontroller_extenderprofile',
                        'extendercontroller_extenderprofile_cellular',
                        'extendercontroller_extenderprofile_cellular_controllerreport',
                        'extendercontroller_extenderprofile_cellular_modem1',
                        'extendercontroller_extenderprofile_cellular_modem1_autoswitch',
                        'extendercontroller_extenderprofile_cellular_modem2',
                        'extendercontroller_extenderprofile_cellular_modem2_autoswitch',
                        'extendercontroller_extenderprofile_cellular_smsnotification',
                        'extendercontroller_extenderprofile_cellular_smsnotification_alert',
                        'extendercontroller_extenderprofile_cellular_smsnotification_receiver',
                        'extendercontroller_extenderprofile_lanextension',
                        'extendercontroller_extenderprofile_lanextension_backhaul',
                        'extendercontroller_simprofile',
                        'extendercontroller_simprofile_autoswitchprofile',
                        'extendercontroller_template',
                        'extensioncontroller_dataplan',
                        'extensioncontroller_extenderprofile',
                        'extensioncontroller_extenderprofile_cellular',
                        'extensioncontroller_extenderprofile_cellular_controllerreport',
                        'extensioncontroller_extenderprofile_cellular_modem1',
                        'extensioncontroller_extenderprofile_cellular_modem1_autoswitch',
                        'extensioncontroller_extenderprofile_cellular_modem2',
                        'extensioncontroller_extenderprofile_cellular_modem2_autoswitch',
                        'extensioncontroller_extenderprofile_cellular_smsnotification',
                        'extensioncontroller_extenderprofile_cellular_smsnotification_alert',
                        'extensioncontroller_extenderprofile_cellular_smsnotification_receiver',
                        'extensioncontroller_extenderprofile_lanextension',
                        'extensioncontroller_extenderprofile_lanextension_backhaul',
                        'filefilter_profile',
                        'filefilter_profile_rules',
                        'firewall_accessproxy',
                        'firewall_accessproxy6',
                        'firewall_accessproxy6_apigateway',
                        'firewall_accessproxy6_apigateway6',
                        'firewall_accessproxy6_apigateway6_quic',
                        'firewall_accessproxy6_apigateway6_realservers',
                        'firewall_accessproxy6_apigateway6_sslciphersuites',
                        'firewall_accessproxy6_apigateway_quic',
                        'firewall_accessproxy6_apigateway_realservers',
                        'firewall_accessproxy6_apigateway_sslciphersuites',
                        'firewall_accessproxy_apigateway',
                        'firewall_accessproxy_apigateway6',
                        'firewall_accessproxy_apigateway6_quic',
                        'firewall_accessproxy_apigateway6_realservers',
                        'firewall_accessproxy_apigateway6_sslciphersuites',
                        'firewall_accessproxy_apigateway_quic',
                        'firewall_accessproxy_apigateway_realservers',
                        'firewall_accessproxy_apigateway_sslciphersuites',
                        'firewall_accessproxy_realservers',
                        'firewall_accessproxy_serverpubkeyauthsettings',
                        'firewall_accessproxy_serverpubkeyauthsettings_certextension',
                        'firewall_accessproxysshclientcert',
                        'firewall_accessproxysshclientcert_certextension',
                        'firewall_accessproxyvirtualhost',
                        'firewall_address',
                        'firewall_address6',
                        'firewall_address6_dynamicmapping',
                        'firewall_address6_dynamicmapping_subnetsegment',
                        'firewall_address6_list',
                        'firewall_address6_profilelist',
                        'firewall_address6_subnetsegment',
                        'firewall_address6_tagging',
                        'firewall_address6template',
                        'firewall_address6template_subnetsegment',
                        'firewall_address6template_subnetsegment_values',
                        'firewall_address_dynamicmapping',
                        'firewall_address_list',
                        'firewall_address_profilelist',
                        'firewall_address_tagging',
                        'firewall_addrgrp',
                        'firewall_addrgrp6',
                        'firewall_addrgrp6_dynamicmapping',
                        'firewall_addrgrp6_tagging',
                        'firewall_addrgrp_dynamicmapping',
                        'firewall_addrgrp_tagging',
                        'firewall_carrierendpointbwl',
                        'firewall_carrierendpointbwl_entries',
                        'firewall_casbprofile',
                        'firewall_casbprofile_saasapplication',
                        'firewall_casbprofile_saasapplication_accessrule',
                        'firewall_casbprofile_saasapplication_customcontrol',
                        'firewall_casbprofile_saasapplication_customcontrol_option',
                        'firewall_decryptedtrafficmirror',
                        'firewall_explicitproxyaddress',
                        'firewall_explicitproxyaddress_headergroup',
                        'firewall_explicitproxyaddrgrp',
                        'firewall_gtp',
                        'firewall_gtp_apn',
                        'firewall_gtp_ieremovepolicy',
                        'firewall_gtp_ievalidation',
                        'firewall_gtp_imsi',
                        'firewall_gtp_ippolicy',
                        'firewall_gtp_messagefilter',
                        'firewall_gtp_messageratelimit',
                        'firewall_gtp_messageratelimitv0',
                        'firewall_gtp_messageratelimitv1',
                        'firewall_gtp_messageratelimitv2',
                        'firewall_gtp_noippolicy',
                        'firewall_gtp_perapnshaper',
                        'firewall_gtp_policy',
                        'firewall_gtp_policyv2',
                        'firewall_identitybasedroute',
                        'firewall_identitybasedroute_rule',
                        'firewall_internetservice',
                        'firewall_internetservice_entry',
                        'firewall_internetserviceaddition',
                        'firewall_internetserviceaddition_entry',
                        'firewall_internetserviceaddition_entry_portrange',
                        'firewall_internetservicecustom',
                        'firewall_internetservicecustom_disableentry',
                        'firewall_internetservicecustom_disableentry_iprange',
                        'firewall_internetservicecustom_entry',
                        'firewall_internetservicecustom_entry_portrange',
                        'firewall_internetservicecustomgroup',
                        'firewall_internetservicegroup',
                        'firewall_internetservicename',
                        'firewall_ippool',
                        'firewall_ippool6',
                        'firewall_ippool6_dynamicmapping',
                        'firewall_ippool_dynamicmapping',
                        'firewall_ippoolgrp',
                        'firewall_ldbmonitor',
                        'firewall_mmsprofile',
                        'firewall_mmsprofile_dupe',
                        'firewall_mmsprofile_flood',
                        'firewall_mmsprofile_notification',
                        'firewall_mmsprofile_notifmsisdn',
                        'firewall_mmsprofile_outbreakprevention',
                        'firewall_multicastaddress',
                        'firewall_multicastaddress6',
                        'firewall_multicastaddress6_tagging',
                        'firewall_multicastaddress_tagging',
                        'firewall_networkservicedynamic',
                        'firewall_profilegroup',
                        'firewall_profileprotocoloptions',
                        'firewall_profileprotocoloptions_cifs',
                        'firewall_profileprotocoloptions_cifs_filefilter',
                        'firewall_profileprotocoloptions_cifs_filefilter_entries',
                        'firewall_profileprotocoloptions_cifs_serverkeytab',
                        'firewall_profileprotocoloptions_dns',
                        'firewall_profileprotocoloptions_ftp',
                        'firewall_profileprotocoloptions_http',
                        'firewall_profileprotocoloptions_imap',
                        'firewall_profileprotocoloptions_mailsignature',
                        'firewall_profileprotocoloptions_mapi',
                        'firewall_profileprotocoloptions_nntp',
                        'firewall_profileprotocoloptions_pop3',
                        'firewall_profileprotocoloptions_smtp',
                        'firewall_profileprotocoloptions_ssh',
                        'firewall_proxyaddress',
                        'firewall_proxyaddress_headergroup',
                        'firewall_proxyaddress_tagging',
                        'firewall_proxyaddrgrp',
                        'firewall_proxyaddrgrp_tagging',
                        'firewall_schedule_group',
                        'firewall_schedule_onetime',
                        'firewall_schedule_recurring',
                        'firewall_service_category',
                        'firewall_service_custom',
                        'firewall_service_group',
                        'firewall_shaper_peripshaper',
                        'firewall_shaper_trafficshaper',
                        'firewall_shapingprofile',
                        'firewall_shapingprofile_shapingentries',
                        'firewall_ssh_localca',
                        'firewall_sslsshprofile',
                        'firewall_sslsshprofile_dot',
                        'firewall_sslsshprofile_ftps',
                        'firewall_sslsshprofile_https',
                        'firewall_sslsshprofile_imaps',
                        'firewall_sslsshprofile_pop3s',
                        'firewall_sslsshprofile_smtps',
                        'firewall_sslsshprofile_ssh',
                        'firewall_sslsshprofile_ssl',
                        'firewall_sslsshprofile_sslexempt',
                        'firewall_sslsshprofile_sslserver',
                        'firewall_trafficclass',
                        'firewall_vendormac',
                        'firewall_vip',
                        'firewall_vip46',
                        'firewall_vip46_dynamicmapping',
                        'firewall_vip46_realservers',
                        'firewall_vip6',
                        'firewall_vip64',
                        'firewall_vip64_dynamicmapping',
                        'firewall_vip64_realservers',
                        'firewall_vip6_dynamicmapping',
                        'firewall_vip6_dynamicmapping_realservers',
                        'firewall_vip6_dynamicmapping_sslciphersuites',
                        'firewall_vip6_quic',
                        'firewall_vip6_realservers',
                        'firewall_vip6_sslciphersuites',
                        'firewall_vip6_sslserverciphersuites',
                        'firewall_vip_dynamicmapping',
                        'firewall_vip_dynamicmapping_realservers',
                        'firewall_vip_dynamicmapping_sslciphersuites',
                        'firewall_vip_gslbpublicips',
                        'firewall_vip_quic',
                        'firewall_vip_realservers',
                        'firewall_vip_sslciphersuites',
                        'firewall_vip_sslserverciphersuites',
                        'firewall_vipgrp',
                        'firewall_vipgrp46',
                        'firewall_vipgrp6',
                        'firewall_vipgrp64',
                        'firewall_vipgrp_dynamicmapping',
                        'firewall_wildcardfqdn_custom',
                        'firewall_wildcardfqdn_group',
                        'fmg_device_blueprint',
                        'fmg_fabric_authorization_template',
                        'fmg_fabric_authorization_template_platforms',
                        'fmg_variable',
                        'fmg_variable_dynamicmapping',
                        'fmupdate_analyzer_virusreport',
                        'fmupdate_avips_advancedlog',
                        'fmupdate_avips_webproxy',
                        'fmupdate_customurllist',
                        'fmupdate_diskquota',
                        'fmupdate_fctservices',
                        'fmupdate_fdssetting',
                        'fmupdate_fdssetting_pushoverride',
                        'fmupdate_fdssetting_pushoverridetoclient',
                        'fmupdate_fdssetting_pushoverridetoclient_announceip',
                        'fmupdate_fdssetting_serveroverride',
                        'fmupdate_fdssetting_serveroverride_servlist',
                        'fmupdate_fdssetting_updateschedule',
                        'fmupdate_fwmsetting',
                        'fmupdate_fwmsetting_upgradetimeout',
                        'fmupdate_multilayer',
                        'fmupdate_publicnetwork',
                        'fmupdate_serveraccesspriorities',
                        'fmupdate_serveraccesspriorities_privateserver',
                        'fmupdate_serveroverridestatus',
                        'fmupdate_service',
                        'fmupdate_webspam_fgdsetting',
                        'fmupdate_webspam_fgdsetting_serveroverride',
                        'fmupdate_webspam_fgdsetting_serveroverride_servlist',
                        'fmupdate_webspam_webproxy',
                        'footer_consolidated_policy',
                        'footer_policy',
                        'footer_policy6',
                        'footer_policy6_identitybasedpolicy6',
                        'footer_policy_identitybasedpolicy',
                        'footer_shapingpolicy',
                        'fsp_vlan',
                        'fsp_vlan_dhcpserver',
                        'fsp_vlan_dhcpserver_excluderange',
                        'fsp_vlan_dhcpserver_iprange',
                        'fsp_vlan_dhcpserver_options',
                        'fsp_vlan_dhcpserver_reservedaddress',
                        'fsp_vlan_dynamicmapping',
                        'fsp_vlan_dynamicmapping_dhcpserver',
                        'fsp_vlan_dynamicmapping_dhcpserver_excluderange',
                        'fsp_vlan_dynamicmapping_dhcpserver_iprange',
                        'fsp_vlan_dynamicmapping_dhcpserver_options',
                        'fsp_vlan_dynamicmapping_dhcpserver_reservedaddress',
                        'fsp_vlan_dynamicmapping_interface',
                        'fsp_vlan_dynamicmapping_interface_ipv6',
                        'fsp_vlan_dynamicmapping_interface_ipv6_ip6delegatedprefixlist',
                        'fsp_vlan_dynamicmapping_interface_ipv6_ip6extraaddr',
                        'fsp_vlan_dynamicmapping_interface_ipv6_ip6prefixlist',
                        'fsp_vlan_dynamicmapping_interface_ipv6_vrrp6',
                        'fsp_vlan_dynamicmapping_interface_secondaryip',
                        'fsp_vlan_dynamicmapping_interface_vrrp',
                        'fsp_vlan_dynamicmapping_interface_vrrp_proxyarp',
                        'fsp_vlan_interface',
                        'fsp_vlan_interface_ipv6',
                        'fsp_vlan_interface_ipv6_ip6delegatedprefixlist',
                        'fsp_vlan_interface_ipv6_ip6extraaddr',
                        'fsp_vlan_interface_ipv6_ip6prefixlist',
                        'fsp_vlan_interface_ipv6_vrrp6',
                        'fsp_vlan_interface_secondaryip',
                        'fsp_vlan_interface_vrrp',
                        'fsp_vlan_interface_vrrp_proxyarp',
                        'gtp_apn',
                        'gtp_apngrp',
                        'gtp_iewhitelist',
                        'gtp_iewhitelist_entries',
                        'gtp_messagefilterv0v1',
                        'gtp_messagefilterv2',
                        'gtp_tunnellimit',
                        'header_consolidated_policy',
                        'header_policy',
                        'header_policy6',
                        'header_policy6_identitybasedpolicy6',
                        'header_policy_identitybasedpolicy',
                        'header_shapingpolicy',
                        'hotspot20_anqp3gppcellular',
                        'hotspot20_anqp3gppcellular_mccmnclist',
                        'hotspot20_anqpipaddresstype',
                        'hotspot20_anqpnairealm',
                        'hotspot20_anqpnairealm_nailist',
                        'hotspot20_anqpnairealm_nailist_eapmethod',
                        'hotspot20_anqpnairealm_nailist_eapmethod_authparam',
                        'hotspot20_anqpnetworkauthtype',
                        'hotspot20_anqproamingconsortium',
                        'hotspot20_anqproamingconsortium_oilist',
                        'hotspot20_anqpvenuename',
                        'hotspot20_anqpvenuename_valuelist',
                        'hotspot20_anqpvenueurl',
                        'hotspot20_anqpvenueurl_valuelist',
                        'hotspot20_h2qpadviceofcharge',
                        'hotspot20_h2qpadviceofcharge_aoclist',
                        'hotspot20_h2qpadviceofcharge_aoclist_planinfo',
                        'hotspot20_h2qpconncapability',
                        'hotspot20_h2qpoperatorname',
                        'hotspot20_h2qpoperatorname_valuelist',
                        'hotspot20_h2qposuprovider',
                        'hotspot20_h2qposuprovider_friendlyname',
                        'hotspot20_h2qposuprovider_servicedescription',
                        'hotspot20_h2qposuprovidernai',
                        'hotspot20_h2qposuprovidernai_nailist',
                        'hotspot20_h2qptermsandconditions',
                        'hotspot20_h2qpwanmetric',
                        'hotspot20_hsprofile',
                        'hotspot20_icon',
                        'hotspot20_icon_iconlist',
                        'hotspot20_qosmap',
                        'hotspot20_qosmap_dscpexcept',
                        'hotspot20_qosmap_dscprange',
                        'icap_profile',
                        'icap_profile_icapheaders',
                        'icap_profile_respmodforwardrules',
                        'icap_profile_respmodforwardrules_headergroup',
                        'icap_server',
                        'ips_baseline_sensor',
                        'ips_baseline_sensor_entries',
                        'ips_baseline_sensor_entries_exemptip',
                        'ips_baseline_sensor_filter',
                        'ips_baseline_sensor_override',
                        'ips_baseline_sensor_override_exemptip',
                        'ips_custom',
                        'ips_sensor',
                        'ips_sensor_entries',
                        'ips_sensor_entries_exemptip',
                        'ips_sensor_filter',
                        'ips_sensor_override',
                        'ips_sensor_override_exemptip',
                        'log_customfield',
                        'log_npuserver',
                        'log_npuserver_servergroup',
                        'log_npuserver_serverinfo',
                        'metafields_system_admin_user',
                        'mpskprofile',
                        'mpskprofile_mpskgroup',
                        'mpskprofile_mpskgroup_mpskkey',
                        'nacprofile',
                        'pkg_authentication_rule',
                        'pkg_authentication_setting',
                        'pkg_central_dnat',
                        'pkg_central_dnat6',
                        'pkg_firewall_acl',
                        'pkg_firewall_acl6',
                        'pkg_firewall_centralsnatmap',
                        'pkg_firewall_consolidated_policy',
                        'pkg_firewall_dospolicy',
                        'pkg_firewall_dospolicy6',
                        'pkg_firewall_dospolicy6_anomaly',
                        'pkg_firewall_dospolicy_anomaly',
                        'pkg_firewall_explicitproxypolicy',
                        'pkg_firewall_explicitproxypolicy_identitybasedpolicy',
                        'pkg_firewall_hyperscalepolicy',
                        'pkg_firewall_hyperscalepolicy46',
                        'pkg_firewall_hyperscalepolicy6',
                        'pkg_firewall_hyperscalepolicy64',
                        'pkg_firewall_interfacepolicy',
                        'pkg_firewall_interfacepolicy6',
                        'pkg_firewall_localinpolicy',
                        'pkg_firewall_localinpolicy6',
                        'pkg_firewall_multicastpolicy',
                        'pkg_firewall_multicastpolicy6',
                        'pkg_firewall_policy',
                        'pkg_firewall_policy46',
                        'pkg_firewall_policy6',
                        'pkg_firewall_policy64',
                        'pkg_firewall_policy_vpndstnode',
                        'pkg_firewall_policy_vpnsrcnode',
                        'pkg_firewall_proxypolicy',
                        'pkg_firewall_securitypolicy',
                        'pkg_firewall_shapingpolicy',
                        'pkg_footer_consolidated_policy',
                        'pkg_footer_policy',
                        'pkg_footer_policy6',
                        'pkg_footer_policy6_identitybasedpolicy6',
                        'pkg_footer_policy_identitybasedpolicy',
                        'pkg_footer_shapingpolicy',
                        'pkg_header_consolidated_policy',
                        'pkg_header_policy',
                        'pkg_header_policy6',
                        'pkg_header_policy6_identitybasedpolicy6',
                        'pkg_header_policy_identitybasedpolicy',
                        'pkg_header_shapingpolicy',
                        'pkg_user_nacpolicy',
                        'pm_config_adom_options',
                        'pm_config_application_list',
                        'pm_config_category_list',
                        'pm_config_data_defaultsslvpnoschecklist',
                        'pm_config_data_tablesize',
                        'pm_config_data_tablesize_faz',
                        'pm_config_data_tablesize_fmg',
                        'pm_config_data_tablesize_fos',
                        'pm_config_data_tablesize_log',
                        'pm_config_fct_endpointcontrol_profile',
                        'pm_config_metafields_firewall_address',
                        'pm_config_metafields_firewall_addrgrp',
                        'pm_config_metafields_firewall_centralsnatmap',
                        'pm_config_metafields_firewall_policy',
                        'pm_config_metafields_firewall_service_custom',
                        'pm_config_metafields_firewall_service_group',
                        'pm_config_package_status',
                        'pm_config_pblock_firewall_consolidated_policy',
                        'pm_config_pblock_firewall_policy',
                        'pm_config_pblock_firewall_policy6',
                        'pm_config_pblock_firewall_securitypolicy',
                        'pm_config_rule_list',
                        'pm_devprof',
                        'pm_devprof_adom',
                        'pm_pblock',
                        'pm_pblock_adom',
                        'pm_pkg',
                        'pm_pkg_adom',
                        'pm_pkg_global',
                        'pm_pkg_schedule',
                        'pm_wanprof',
                        'pm_wanprof_adom',
                        'qosprofile',
                        'region',
                        'router_accesslist',
                        'router_accesslist6',
                        'router_accesslist6_rule',
                        'router_accesslist_rule',
                        'router_aspathlist',
                        'router_aspathlist_rule',
                        'router_communitylist',
                        'router_communitylist_rule',
                        'router_prefixlist',
                        'router_prefixlist6',
                        'router_prefixlist6_rule',
                        'router_prefixlist_rule',
                        'router_routemap',
                        'router_routemap_rule',
                        'sctpfilter_profile',
                        'sctpfilter_profile_ppidfilters',
                        'spamfilter_bwl',
                        'spamfilter_bwl_entries',
                        'spamfilter_bword',
                        'spamfilter_bword_entries',
                        'spamfilter_dnsbl',
                        'spamfilter_dnsbl_entries',
                        'spamfilter_iptrust',
                        'spamfilter_iptrust_entries',
                        'spamfilter_mheader',
                        'spamfilter_mheader_entries',
                        'spamfilter_profile',
                        'spamfilter_profile_gmail',
                        'spamfilter_profile_imap',
                        'spamfilter_profile_mapi',
                        'spamfilter_profile_msnhotmail',
                        'spamfilter_profile_pop3',
                        'spamfilter_profile_smtp',
                        'spamfilter_profile_yahoomail',
                        'sshfilter_profile',
                        'sshfilter_profile_filefilter',
                        'sshfilter_profile_filefilter_entries',
                        'sshfilter_profile_shellcommands',
                        'switchcontroller_acl_group',
                        'switchcontroller_acl_ingress',
                        'switchcontroller_acl_ingress_action',
                        'switchcontroller_acl_ingress_classifier',
                        'switchcontroller_customcommand',
                        'switchcontroller_dsl_policy',
                        'switchcontroller_dynamicportpolicy',
                        'switchcontroller_dynamicportpolicy_policy',
                        'switchcontroller_fortilinksettings',
                        'switchcontroller_fortilinksettings_nacports',
                        'switchcontroller_lldpprofile',
                        'switchcontroller_lldpprofile_customtlvs',
                        'switchcontroller_lldpprofile_medlocationservice',
                        'switchcontroller_lldpprofile_mednetworkpolicy',
                        'switchcontroller_macpolicy',
                        'switchcontroller_managedswitch',
                        'switchcontroller_managedswitch_8021xsettings',
                        'switchcontroller_managedswitch_customcommand',
                        'switchcontroller_managedswitch_dhcpsnoopingstaticclient',
                        'switchcontroller_managedswitch_igmpsnooping',
                        'switchcontroller_managedswitch_ipsourceguard',
                        'switchcontroller_managedswitch_ipsourceguard_bindingentry',
                        'switchcontroller_managedswitch_mirror',
                        'switchcontroller_managedswitch_ports',
                        'switchcontroller_managedswitch_ports_dhcpsnoopoption82override',
                        'switchcontroller_managedswitch_remotelog',
                        'switchcontroller_managedswitch_routeoffloadrouter',
                        'switchcontroller_managedswitch_snmpcommunity',
                        'switchcontroller_managedswitch_snmpcommunity_hosts',
                        'switchcontroller_managedswitch_snmpsysinfo',
                        'switchcontroller_managedswitch_snmptrapthreshold',
                        'switchcontroller_managedswitch_snmpuser',
                        'switchcontroller_managedswitch_staticmac',
                        'switchcontroller_managedswitch_stormcontrol',
                        'switchcontroller_managedswitch_stpinstance',
                        'switchcontroller_managedswitch_stpsettings',
                        'switchcontroller_managedswitch_switchlog',
                        'switchcontroller_managedswitch_switchstpsettings',
                        'switchcontroller_managedswitch_vlan',
                        'switchcontroller_ptp_profile',
                        'switchcontroller_qos_dot1pmap',
                        'switchcontroller_qos_ipdscpmap',
                        'switchcontroller_qos_ipdscpmap_map',
                        'switchcontroller_qos_qospolicy',
                        'switchcontroller_qos_queuepolicy',
                        'switchcontroller_qos_queuepolicy_cosqueue',
                        'switchcontroller_securitypolicy_8021x',
                        'switchcontroller_securitypolicy_captiveportal',
                        'switchcontroller_switchinterfacetag',
                        'switchcontroller_trafficpolicy',
                        'switchcontroller_vlanpolicy',
                        'sys_ha_status',
                        'sys_status',
                        'system_admin_group',
                        'system_admin_group_member',
                        'system_admin_ldap',
                        'system_admin_ldap_adom',
                        'system_admin_profile',
                        'system_admin_profile_datamaskcustomfields',
                        'system_admin_profile_writepasswdprofiles',
                        'system_admin_profile_writepasswduserlist',
                        'system_admin_radius',
                        'system_admin_setting',
                        'system_admin_tacacs',
                        'system_admin_user',
                        'system_admin_user_adom',
                        'system_admin_user_adomexclude',
                        'system_admin_user_appfilter',
                        'system_admin_user_dashboard',
                        'system_admin_user_dashboardtabs',
                        'system_admin_user_ipsfilter',
                        'system_admin_user_metadata',
                        'system_admin_user_policypackage',
                        'system_admin_user_restrictdevvdom',
                        'system_admin_user_webfilter',
                        'system_alertconsole',
                        'system_alertemail',
                        'system_alertevent',
                        'system_alertevent_alertdestination',
                        'system_autodelete',
                        'system_autodelete_dlpfilesautodeletion',
                        'system_autodelete_logautodeletion',
                        'system_autodelete_quarantinefilesautodeletion',
                        'system_autodelete_reportautodeletion',
                        'system_backup_allsettings',
                        'system_certificate_ca',
                        'system_certificate_crl',
                        'system_certificate_local',
                        'system_certificate_oftp',
                        'system_certificate_remote',
                        'system_certificate_ssh',
                        'system_connector',
                        'system_csf',
                        'system_csf_fabricconnector',
                        'system_csf_trustedlist',
                        'system_customlanguage',
                        'system_dhcp_server',
                        'system_dhcp_server_excluderange',
                        'system_dhcp_server_iprange',
                        'system_dhcp_server_options',
                        'system_dhcp_server_reservedaddress',
                        'system_dm',
                        'system_dns',
                        'system_docker',
                        'system_externalresource',
                        'system_fips',
                        'system_fortiguard',
                        'system_fortiview_autocache',
                        'system_fortiview_setting',
                        'system_geoipcountry',
                        'system_geoipoverride',
                        'system_geoipoverride_ip6range',
                        'system_geoipoverride_iprange',
                        'system_global',
                        'system_guiact',
                        'system_ha',
                        'system_ha_monitoredinterfaces',
                        'system_ha_monitoredips',
                        'system_ha_peer',
                        'system_hascheduledcheck',
                        'system_interface',
                        'system_interface_ipv6',
                        'system_interface_member',
                        'system_localinpolicy',
                        'system_localinpolicy6',
                        'system_locallog_disk_filter',
                        'system_locallog_disk_setting',
                        'system_locallog_fortianalyzer2_filter',
                        'system_locallog_fortianalyzer2_setting',
                        'system_locallog_fortianalyzer3_filter',
                        'system_locallog_fortianalyzer3_setting',
                        'system_locallog_fortianalyzer_filter',
                        'system_locallog_fortianalyzer_setting',
                        'system_locallog_memory_filter',
                        'system_locallog_memory_setting',
                        'system_locallog_setting',
                        'system_locallog_syslogd2_filter',
                        'system_locallog_syslogd2_setting',
                        'system_locallog_syslogd3_filter',
                        'system_locallog_syslogd3_setting',
                        'system_locallog_syslogd_filter',
                        'system_locallog_syslogd_setting',
                        'system_log_alert',
                        'system_log_devicedisable',
                        'system_log_fospolicystats',
                        'system_log_interfacestats',
                        'system_log_ioc',
                        'system_log_maildomain',
                        'system_log_ratelimit',
                        'system_log_ratelimit_device',
                        'system_log_ratelimit_ratelimits',
                        'system_log_settings',
                        'system_log_settings_rollinganalyzer',
                        'system_log_settings_rollinglocal',
                        'system_log_settings_rollingregular',
                        'system_log_topology',
                        'system_logfetch_clientprofile',
                        'system_logfetch_clientprofile_devicefilter',
                        'system_logfetch_clientprofile_logfilter',
                        'system_logfetch_serversettings',
                        'system_mail',
                        'system_mcpolicydisabledadoms',
                        'system_meta',
                        'system_meta_sysmetafields',
                        'system_metadata_admins',
                        'system_npu',
                        'system_npu_backgroundssescan',
                        'system_npu_dosoptions',
                        'system_npu_dswdtsprofile',
                        'system_npu_dswqueuedtsprofile',
                        'system_npu_fpanomaly',
                        'system_npu_hpe',
                        'system_npu_ipreassembly',
                        'system_npu_isfnpqueues',
                        'system_npu_npqueues',
                        'system_npu_npqueues_ethernettype',
                        'system_npu_npqueues_ipprotocol',
                        'system_npu_npqueues_ipservice',
                        'system_npu_npqueues_profile',
                        'system_npu_npqueues_scheduler',
                        'system_npu_nputcam',
                        'system_npu_nputcam_data',
                        'system_npu_nputcam_mask',
                        'system_npu_nputcam_miract',
                        'system_npu_nputcam_priact',
                        'system_npu_nputcam_sact',
                        'system_npu_nputcam_tact',
                        'system_npu_portcpumap',
                        'system_npu_portnpumap',
                        'system_npu_portpathoption',
                        'system_npu_priorityprotocol',
                        'system_npu_ssehascan',
                        'system_npu_swehhash',
                        'system_npu_swtrhash',
                        'system_npu_tcptimeoutprofile',
                        'system_npu_udptimeoutprofile',
                        'system_ntp',
                        'system_ntp_ntpserver',
                        'system_objecttag',
                        'system_objecttagging',
                        'system_passwordpolicy',
                        'system_performance',
                        'system_replacemsggroup',
                        'system_replacemsggroup_admin',
                        'system_replacemsggroup_alertmail',
                        'system_replacemsggroup_auth',
                        'system_replacemsggroup_automation',
                        'system_replacemsggroup_custommessage',
                        'system_replacemsggroup_devicedetectionportal',
                        'system_replacemsggroup_ec',
                        'system_replacemsggroup_fortiguardwf',
                        'system_replacemsggroup_ftp',
                        'system_replacemsggroup_http',
                        'system_replacemsggroup_icap',
                        'system_replacemsggroup_mail',
                        'system_replacemsggroup_mm1',
                        'system_replacemsggroup_mm3',
                        'system_replacemsggroup_mm4',
                        'system_replacemsggroup_mm7',
                        'system_replacemsggroup_mms',
                        'system_replacemsggroup_nacquar',
                        'system_replacemsggroup_nntp',
                        'system_replacemsggroup_spam',
                        'system_replacemsggroup_sslvpn',
                        'system_replacemsggroup_trafficquota',
                        'system_replacemsggroup_utm',
                        'system_replacemsggroup_webproxy',
                        'system_replacemsgimage',
                        'system_report_autocache',
                        'system_report_estbrowsetime',
                        'system_report_group',
                        'system_report_group_chartalternative',
                        'system_report_group_groupby',
                        'system_report_setting',
                        'system_route',
                        'system_route6',
                        'system_saml',
                        'system_saml_fabricidp',
                        'system_saml_serviceproviders',
                        'system_sdnconnector',
                        'system_sdnconnector_compartmentlist',
                        'system_sdnconnector_externalaccountlist',
                        'system_sdnconnector_externalip',
                        'system_sdnconnector_forwardingrule',
                        'system_sdnconnector_gcpprojectlist',
                        'system_sdnconnector_nic',
                        'system_sdnconnector_nic_ip',
                        'system_sdnconnector_ociregionlist',
                        'system_sdnconnector_route',
                        'system_sdnconnector_routetable',
                        'system_sdnconnector_routetable_route',
                        'system_sdnproxy',
                        'system_smsserver',
                        'system_sniffer',
                        'system_snmp_community',
                        'system_snmp_community_hosts',
                        'system_snmp_community_hosts6',
                        'system_snmp_sysinfo',
                        'system_snmp_user',
                        'system_socfabric',
                        'system_socfabric_trustedlist',
                        'system_sql',
                        'system_sql_customindex',
                        'system_sql_customskipidx',
                        'system_sql_tsindexfield',
                        'system_sslciphersuites',
                        'system_status',
                        'system_syslog',
                        'system_virtualwirepair',
                        'system_webproxy',
                        'system_workflow_approvalmatrix',
                        'system_workflow_approvalmatrix_approver',
                        'task_task',
                        'task_task_history',
                        'task_task_line',
                        'task_task_line_history',
                        'template',
                        'templategroup',
                        'user_adgrp',
                        'user_certificate',
                        'user_clearpass',
                        'user_connector',
                        'user_device',
                        'user_device_dynamicmapping',
                        'user_device_tagging',
                        'user_deviceaccesslist',
                        'user_deviceaccesslist_devicelist',
                        'user_devicecategory',
                        'user_devicegroup',
                        'user_devicegroup_dynamicmapping',
                        'user_devicegroup_tagging',
                        'user_domaincontroller',
                        'user_domaincontroller_extraserver',
                        'user_exchange',
                        'user_flexvm',
                        'user_fortitoken',
                        'user_fsso',
                        'user_fsso_dynamicmapping',
                        'user_fssopolling',
                        'user_fssopolling_adgrp',
                        'user_group',
                        'user_group_dynamicmapping',
                        'user_group_dynamicmapping_guest',
                        'user_group_dynamicmapping_match',
                        'user_group_dynamicmapping_sslvpnoschecklist',
                        'user_group_guest',
                        'user_group_match',
                        'user_json',
                        'user_krbkeytab',
                        'user_ldap',
                        'user_ldap_dynamicmapping',
                        'user_local',
                        'user_nsx',
                        'user_nsx_service',
                        'user_passwordpolicy',
                        'user_peer',
                        'user_peergrp',
                        'user_pop3',
                        'user_pxgrid',
                        'user_radius',
                        'user_radius_accountingserver',
                        'user_radius_dynamicmapping',
                        'user_radius_dynamicmapping_accountingserver',
                        'user_saml',
                        'user_saml_dynamicmapping',
                        'user_securityexemptlist',
                        'user_securityexemptlist_rule',
                        'user_tacacs',
                        'user_tacacs_dynamicmapping',
                        'user_vcenter',
                        'user_vcenter_rule',
                        'utmprofile',
                        'vap',
                        'vap_dynamicmapping',
                        'vap_macfilterlist',
                        'vap_mpskkey',
                        'vap_portalmessageoverrides',
                        'vap_vlanname',
                        'vap_vlanpool',
                        'vapgroup',
                        'videofilter_keyword',
                        'videofilter_keyword_word',
                        'videofilter_profile',
                        'videofilter_profile_filters',
                        'videofilter_profile_fortiguardcategory',
                        'videofilter_profile_fortiguardcategory_filters',
                        'videofilter_youtubechannelfilter',
                        'videofilter_youtubechannelfilter_entries',
                        'videofilter_youtubekey',
                        'virtualpatch_profile',
                        'virtualpatch_profile_exemption',
                        'voip_profile',
                        'voip_profile_msrp',
                        'voip_profile_sccp',
                        'voip_profile_sip',
                        'vpn_certificate_ca',
                        'vpn_certificate_ocspserver',
                        'vpn_certificate_remote',
                        'vpn_ipsec_fec',
                        'vpn_ipsec_fec_mappings',
                        'vpn_ssl_settings',
                        'vpn_ssl_settings_authenticationrule',
                        'vpnmgr_node',
                        'vpnmgr_node_iprange',
                        'vpnmgr_node_ipv4excluderange',
                        'vpnmgr_node_protectedsubnet',
                        'vpnmgr_node_summaryaddr',
                        'vpnmgr_vpntable',
                        'vpnsslweb_hostchecksoftware',
                        'vpnsslweb_hostchecksoftware_checkitemlist',
                        'vpnsslweb_portal',
                        'vpnsslweb_portal_bookmarkgroup',
                        'vpnsslweb_portal_bookmarkgroup_bookmarks',
                        'vpnsslweb_portal_bookmarkgroup_bookmarks_formdata',
                        'vpnsslweb_portal_landingpage',
                        'vpnsslweb_portal_landingpage_formdata',
                        'vpnsslweb_portal_macaddrcheckrule',
                        'vpnsslweb_portal_oschecklist',
                        'vpnsslweb_portal_splitdns',
                        'vpnsslweb_realm',
                        'vpnsslweb_virtualdesktopapplist',
                        'vpnsslweb_virtualdesktopapplist_apps',
                        'waf_mainclass',
                        'waf_profile',
                        'waf_profile_addresslist',
                        'waf_profile_constraint',
                        'waf_profile_constraint_contentlength',
                        'waf_profile_constraint_exception',
                        'waf_profile_constraint_headerlength',
                        'waf_profile_constraint_hostname',
                        'waf_profile_constraint_linelength',
                        'waf_profile_constraint_malformed',
                        'waf_profile_constraint_maxcookie',
                        'waf_profile_constraint_maxheaderline',
                        'waf_profile_constraint_maxrangesegment',
                        'waf_profile_constraint_maxurlparam',
                        'waf_profile_constraint_method',
                        'waf_profile_constraint_paramlength',
                        'waf_profile_constraint_urlparamlength',
                        'waf_profile_constraint_version',
                        'waf_profile_method',
                        'waf_profile_method_methodpolicy',
                        'waf_profile_signature',
                        'waf_profile_signature_customsignature',
                        'waf_profile_signature_mainclass',
                        'waf_profile_urlaccess',
                        'waf_profile_urlaccess_accesspattern',
                        'waf_signature',
                        'waf_subclass',
                        'wagprofile',
                        'wanopt_authgroup',
                        'wanopt_peer',
                        'wanopt_profile',
                        'wanopt_profile_cifs',
                        'wanopt_profile_ftp',
                        'wanopt_profile_http',
                        'wanopt_profile_mapi',
                        'wanopt_profile_tcp',
                        'wanprof_system_sdwan',
                        'wanprof_system_sdwan_duplication',
                        'wanprof_system_sdwan_healthcheck',
                        'wanprof_system_sdwan_healthcheck_sla',
                        'wanprof_system_sdwan_members',
                        'wanprof_system_sdwan_neighbor',
                        'wanprof_system_sdwan_service',
                        'wanprof_system_sdwan_service_sla',
                        'wanprof_system_sdwan_zone',
                        'wanprof_system_virtualwanlink',
                        'wanprof_system_virtualwanlink_healthcheck',
                        'wanprof_system_virtualwanlink_healthcheck_sla',
                        'wanprof_system_virtualwanlink_members',
                        'wanprof_system_virtualwanlink_neighbor',
                        'wanprof_system_virtualwanlink_service',
                        'wanprof_system_virtualwanlink_service_sla',
                        'webfilter_categories',
                        'webfilter_content',
                        'webfilter_content_entries',
                        'webfilter_contentheader',
                        'webfilter_contentheader_entries',
                        'webfilter_ftgdlocalcat',
                        'webfilter_ftgdlocalrating',
                        'webfilter_profile',
                        'webfilter_profile_antiphish',
                        'webfilter_profile_antiphish_custompatterns',
                        'webfilter_profile_antiphish_inspectionentries',
                        'webfilter_profile_filefilter',
                        'webfilter_profile_filefilter_entries',
                        'webfilter_profile_ftgdwf',
                        'webfilter_profile_ftgdwf_filters',
                        'webfilter_profile_ftgdwf_quota',
                        'webfilter_profile_override',
                        'webfilter_profile_urlextraction',
                        'webfilter_profile_web',
                        'webfilter_profile_youtubechannelfilter',
                        'webfilter_urlfilter',
                        'webfilter_urlfilter_entries',
                        'webproxy_forwardserver',
                        'webproxy_forwardservergroup',
                        'webproxy_forwardservergroup_serverlist',
                        'webproxy_profile',
                        'webproxy_profile_headers',
                        'webproxy_wisp',
                        'widsprofile',
                        'wireless_accesscontrollist',
                        'wireless_accesscontrollist_layer3ipv4rules',
                        'wireless_accesscontrollist_layer3ipv6rules',
                        'wireless_address',
                        'wireless_addrgrp',
                        'wireless_ssidpolicy',
                        'wireless_syslogprofile',
                        'wtpprofile',
                        'wtpprofile_denymaclist',
                        'wtpprofile_eslsesdongle',
                        'wtpprofile_lan',
                        'wtpprofile_lbs',
                        'wtpprofile_platform',
                        'wtpprofile_radio1',
                        'wtpprofile_radio2',
                        'wtpprofile_radio3',
                        'wtpprofile_radio4',
                        'wtpprofile_splittunnelingacl'
                    ]
                },
                'path': {
                    'required': False,
                    'default': './',
                    'type': 'str'
                },
                'params': {
                    'required': False,
                    'type': 'dict'
                }
            }
        }
    }
    module = AnsibleModule(argument_spec=module_arg_spec,
                           supports_check_mode=False)
    fmgr = None
    if module._socket_path:
        connection = Connection(module._socket_path)
        connection.set_option('access_token', module.params['access_token'] if 'access_token' in module.params else None)
        connection.set_option('enable_log', module.params['enable_log'] if 'enable_log' in module.params else False)
        connection.set_option('forticloud_access_token',
                              module.params['forticloud_access_token'] if 'forticloud_access_token' in module.params else None)
        fmgr = NAPIManager(None, None, None, None, module, connection)
        fmgr.process_export(export_metadata)
    else:
        module.fail_json(msg='MUST RUN IN HTTPAPI MODE')
    module.exit_json(meta=module.params)


if __name__ == '__main__':
    main()
