/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.util.Enumeration;
import writer2latex.office.ListStyle;
import writer2latex.office.OfficeReader;
import writer2latex.office.OfficeStyleFamily;
import writer2latex.util.CSVList;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.StyleConverterHelper;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xhtml.XhtmlConfig;
import writer2latex.xhtml.XhtmlStyleMapItem;

public class ListStyleConverter
extends StyleConverterHelper {
    public ListStyleConverter(OfficeReader ofr, XhtmlConfig config, Converter converter, int nType) {
        super(ofr, config, converter, nType);
        this.styleMap = config.getXListStyleMap();
        this.bConvertStyles = config.xhtmlFormatting() == 3 || config.xhtmlFormatting() == 2;
        this.bConvertHard = config.xhtmlFormatting() == 3 || config.xhtmlFormatting() == 1;
    }

    public void applyStyle(int nLevel, String sStyleName, StyleInfo info) {
        ListStyle style = this.ofr.getListStyle(sStyleName);
        if (style != null) {
            if (style.isAutomatic()) {
                this.applyStyle(nLevel, style.getParentName(), info);
                if (this.bConvertHard) {
                    this.cssList(style, nLevel, info.props);
                }
            } else {
                String sDisplayName = style.getDisplayName();
                if (this.styleMap.contains(sDisplayName)) {
                    XhtmlStyleMapItem map = this.styleMap.get(sDisplayName);
                    if (map.sElement.length() > 0) {
                        info.sTagName = map.sElement;
                    }
                    if (!"(none)".equals(map.sCss)) {
                        info.sClass = map.sCss;
                    }
                } else {
                    info.sClass = "listlevel" + Integer.toString(nLevel) + this.styleNames.getExportName(sDisplayName);
                }
            }
        }
    }

    @Override
    public String getStyleDeclarations(String sIndent) {
        if (this.bConvertStyles) {
            StringBuilder buf = new StringBuilder();
            Enumeration<String> names = this.styleNames.keys();
            while (names.hasMoreElements()) {
                String sDisplayName = names.nextElement();
                ListStyle style = (ListStyle)this.getStyles().getStyleByDisplayName(sDisplayName);
                if (style.isAutomatic()) continue;
                for (int nLevel = 1; nLevel < 10; ++nLevel) {
                    CSVList props = new CSVList(";");
                    this.cssList(style, nLevel, props);
                    buf.append(sIndent);
                    buf.append(".listlevel");
                    buf.append(nLevel);
                    buf.append(this.styleNames.getExportName(sDisplayName));
                    buf.append(" {");
                    buf.append(props.toString());
                    buf.append("}");
                    buf.append(this.config.prettyPrint() ? "\n" : " ");
                    if (this.config.listFormatting() != 2) continue;
                    CSVList parProps = new CSVList(";");
                    this.cssListParMargins(style, nLevel, parProps);
                    if (parProps.isEmpty()) continue;
                    buf.append(sIndent).append(".listlevel").append(nLevel).append(this.styleNames.getExportName(sDisplayName)).append(" p {").append(parProps.toString()).append("}").append(this.config.prettyPrint() ? "\n" : " ");
                }
            }
            return buf.toString();
        }
        return "";
    }

    @Override
    public OfficeStyleFamily getStyles() {
        return this.ofr.getListStyles();
    }

    private void cssList(ListStyle style, int nLevel, CSVList props) {
        props.addValue("margin-top", "0");
        props.addValue("margin-bottom", "0");
        if (this.config.listFormatting() != 2) {
            String sHref;
            String sLevelType = style.getLevelType(nLevel);
            if ("text:list-level-style-number".equals(sLevelType)) {
                String sNumFormat = style.getLevelProperty(nLevel, "style:num-format");
                if ("1".equals(sNumFormat)) {
                    props.addValue("list-style-type", "decimal");
                } else if ("i".equals(sNumFormat)) {
                    props.addValue("list-style-type", "lower-roman");
                } else if ("I".equals(sNumFormat)) {
                    props.addValue("list-style-type", "upper-roman");
                } else if ("a".equals(sNumFormat)) {
                    props.addValue("list-style-type", "lower-alpha");
                } else if ("A".equals(sNumFormat)) {
                    props.addValue("list-style-type", "upper-alpha");
                }
            } else if ("text:list-level-style-bullet".equals(sLevelType)) {
                switch (nLevel % 3) {
                    case 1: {
                        props.addValue("list-style-type", "disc");
                        break;
                    }
                    case 2: {
                        props.addValue("list-style-type", "circle");
                        break;
                    }
                    case 0: {
                        props.addValue("list-style-type", "square");
                    }
                }
            } else if ("text:list-level-style-image".equals(sLevelType) && (sHref = style.getLevelProperty(nLevel, "xlink:href")) != null) {
                props.addValue("list-style-image", "url('" + sHref + "')");
            }
        } else {
            props.addValue("list-style-type:none");
            if (style.isAutomatic() && nLevel > 1) {
                props.addValue("margin-left", "2em");
            } else {
                props.addValue("margin-left", "0");
            }
            props.addValue("padding-left", "0");
        }
        props.addValue("clear:left");
    }

    private void cssListParMargins(ListStyle style, int nLevel, CSVList props) {
        String sMarginLeft = style.getLevelStyleProperty(nLevel, "fo:margin-left");
        if (sMarginLeft != null) {
            props.addValue("margin-left", sMarginLeft);
        } else {
            props.addValue("margin-left", "0");
        }
        String sTextIndent = style.getLevelStyleProperty(nLevel, "fo:text-indent");
        if (sTextIndent != null) {
            props.addValue("text-indent", sTextIndent);
        } else {
            props.addValue("text-indent", "0");
        }
    }
}

