"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAsyncLanguageServicePlugin = void 0;
const language_core_1 = require("@volar/language-core");
const common_1 = require("../common");
const decorateLanguageService_1 = require("../node/decorateLanguageService");
const decorateLanguageServiceHost_1 = require("../node/decorateLanguageServiceHost");
const createLanguageServicePlugin_1 = require("./createLanguageServicePlugin");
function createAsyncLanguageServicePlugin(extensions, scriptKind, create) {
    return modules => {
        const { typescript: ts } = modules;
        const pluginModule = {
            create(info) {
                if (!createLanguageServicePlugin_1.decoratedLanguageServices.has(info.languageService)
                    && !createLanguageServicePlugin_1.decoratedLanguageServiceHosts.has(info.languageServiceHost)) {
                    createLanguageServicePlugin_1.decoratedLanguageServices.add(info.languageService);
                    createLanguageServicePlugin_1.decoratedLanguageServiceHosts.add(info.languageServiceHost);
                    const emptySnapshot = ts.ScriptSnapshot.fromString('');
                    const getScriptSnapshot = info.languageServiceHost.getScriptSnapshot.bind(info.languageServiceHost);
                    const getScriptVersion = info.languageServiceHost.getScriptVersion.bind(info.languageServiceHost);
                    const getScriptKind = info.languageServiceHost.getScriptKind?.bind(info.languageServiceHost);
                    const getProjectVersion = info.languageServiceHost.getProjectVersion?.bind(info.languageServiceHost);
                    let initialized = false;
                    info.languageServiceHost.getScriptSnapshot = fileName => {
                        if (!initialized && extensions.some(ext => fileName.endsWith(ext))) {
                            return emptySnapshot;
                        }
                        return getScriptSnapshot(fileName);
                    };
                    info.languageServiceHost.getScriptVersion = fileName => {
                        if (!initialized && extensions.some(ext => fileName.endsWith(ext))) {
                            return 'initializing...';
                        }
                        return getScriptVersion(fileName);
                    };
                    if (getScriptKind) {
                        info.languageServiceHost.getScriptKind = fileName => {
                            if (!initialized && extensions.some(ext => fileName.endsWith(ext))) {
                                return scriptKind; // TODO: bypass upstream bug
                            }
                            return getScriptKind(fileName);
                        };
                    }
                    if (getProjectVersion) {
                        info.languageServiceHost.getProjectVersion = () => {
                            if (!initialized) {
                                return getProjectVersion() + ',initializing...';
                            }
                            return getProjectVersion();
                        };
                    }
                    create(ts, info).then(({ languagePlugins, setup }) => {
                        const syncedScriptVersions = new language_core_1.FileMap(ts.sys.useCaseSensitiveFileNames);
                        const language = (0, language_core_1.createLanguage)([
                            ...languagePlugins,
                            { getLanguageId: common_1.resolveFileLanguageId },
                        ], new language_core_1.FileMap(ts.sys.useCaseSensitiveFileNames), fileName => {
                            const version = getScriptVersion(fileName);
                            if (syncedScriptVersions.get(fileName) === version) {
                                return;
                            }
                            syncedScriptVersions.set(fileName, version);
                            const snapshot = getScriptSnapshot(fileName);
                            if (snapshot) {
                                language.scripts.set(fileName, snapshot);
                            }
                            else {
                                language.scripts.delete(fileName);
                            }
                        });
                        (0, decorateLanguageService_1.decorateLanguageService)(language, info.languageService);
                        (0, decorateLanguageServiceHost_1.decorateLanguageServiceHost)(ts, language, info.languageServiceHost);
                        setup?.(language);
                        info.project.markAsDirty();
                        initialized = true;
                    });
                }
                return info.languageService;
            },
            getExternalFiles(project, updateLevel = 0) {
                if (updateLevel >= (1)
                    || !createLanguageServicePlugin_1.externalFiles.has(project)) {
                    const oldFiles = createLanguageServicePlugin_1.externalFiles.get(project);
                    const newFiles = extensions.length ? (0, decorateLanguageServiceHost_1.searchExternalFiles)(ts, project, extensions) : [];
                    createLanguageServicePlugin_1.externalFiles.set(project, newFiles);
                    if (oldFiles && !(0, createLanguageServicePlugin_1.arrayItemsEqual)(oldFiles, newFiles)) {
                        project.refreshDiagnostics();
                    }
                }
                return createLanguageServicePlugin_1.externalFiles.get(project);
            },
        };
        return pluginModule;
    };
}
exports.createAsyncLanguageServicePlugin = createAsyncLanguageServicePlugin;
//# sourceMappingURL=createAsyncLanguageServicePlugin.js.map