/// <reference types="node" />
import * as net from 'net';
import type * as ts from 'typescript';
import type { Request } from './server';
export { TypeScriptProjectHost } from '@volar/typescript';
export interface NamedPipeServer {
    path: string;
    serverKind: ts.server.ProjectKind;
    currentDirectory: string;
}
export declare function readPipeTable(): NamedPipeServer[];
export declare function updatePipeTable(servers: NamedPipeServer[]): void;
export declare function connect(path: string): Promise<net.Socket | undefined>;
export declare function searchNamedPipeServerForFile(fileName: string): Promise<{
    server: NamedPipeServer;
    projectInfo: {
        name: string;
        kind: ts.server.ProjectKind;
    };
} | {
    server: NamedPipeServer;
    projectInfo: undefined;
} | undefined>;
export declare function sendRequestWorker<T>(request: Request, client: net.Socket): Promise<T | null | undefined>;
