import type { Disposable, DocumentSelector, FormattingOptions, ProviderResult, LanguageServiceContext, LanguageServicePlugin } from '@volar/language-service';
import * as html from 'vscode-html-languageservice';
import { TextDocument } from 'vscode-languageserver-textdocument';
export interface Provide {
    'html/htmlDocument': (document: TextDocument) => html.HTMLDocument | undefined;
    'html/languageService': () => html.LanguageService;
    'html/documentContext': () => html.DocumentContext;
}
export declare function create({ documentSelector, useDefaultDataProvider, getDocumentContext, isFormattingEnabled, getFormattingOptions, getCompletionConfiguration, getHoverSettings, getCustomData, onDidChangeCustomData, }?: {
    documentSelector?: DocumentSelector;
    useDefaultDataProvider?: boolean;
    isFormattingEnabled?(document: TextDocument, context: LanguageServiceContext): ProviderResult<boolean>;
    isAutoCreateQuotesEnabled?(document: TextDocument, context: LanguageServiceContext): ProviderResult<boolean>;
    isAutoClosingTagsEnabled?(document: TextDocument, context: LanguageServiceContext): ProviderResult<boolean>;
    getDocumentContext?(context: LanguageServiceContext): html.DocumentContext;
    getFormattingOptions?(document: TextDocument, options: FormattingOptions, context: LanguageServiceContext): ProviderResult<html.HTMLFormatConfiguration>;
    getCompletionConfiguration?(document: TextDocument, context: LanguageServiceContext): ProviderResult<html.CompletionConfiguration | undefined>;
    getHoverSettings?(document: TextDocument, context: LanguageServiceContext): ProviderResult<html.HoverSettings | undefined>;
    getCustomData?(context: LanguageServiceContext): ProviderResult<html.IHTMLDataProvider[]>;
    onDidChangeCustomData?(listener: () => void, context: LanguageServiceContext): Disposable;
}): LanguageServicePlugin;
//# sourceMappingURL=index.d.ts.map