"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = void 0;
const language_core_1 = require("@vue/language-core");
function create() {
    return {
        name: 'vue-codelens-references',
        create(context) {
            return {
                provideReferencesCodeLensRanges(document) {
                    return worker(document.uri, virtualCode => {
                        const result = [];
                        for (const map of context.documents.getMaps(virtualCode) ?? []) {
                            for (const mapping of map.map.mappings) {
                                if (!mapping.data.__referencesCodeLens) {
                                    continue;
                                }
                                result.push({
                                    start: document.positionAt(mapping.generatedOffsets[0]),
                                    end: document.positionAt(mapping.generatedOffsets[mapping.generatedOffsets.length - 1]
                                        + mapping.lengths[mapping.lengths.length - 1]),
                                });
                            }
                        }
                        return result;
                    });
                },
            };
            function worker(uri, callback) {
                const decoded = context.decodeEmbeddedDocumentUri(uri);
                const sourceScript = decoded && context.language.scripts.get(decoded[0]);
                const virtualCode = decoded && sourceScript?.generated?.embeddedCodes.get(decoded[1]);
                if (!virtualCode || !(sourceScript?.generated?.root instanceof language_core_1.VueVirtualCode) || !sourceScript) {
                    return;
                }
                return callback(virtualCode, sourceScript);
            }
        },
    };
}
exports.create = create;
//# sourceMappingURL=vue-codelens-references.js.map