import type { LanguageServiceContext } from '@volar/language-service';
import type * as vscode from 'vscode-languageserver-protocol';
import { AttrNameCasing, TagNameCasing } from '../types';
import type { URI } from 'vscode-uri';
export declare function convertTagName(context: LanguageServiceContext, uri: URI, casing: TagNameCasing, tsPluginClient: typeof import('@vue/typescript-plugin/lib/client') | undefined): Promise<vscode.TextEdit[] | undefined>;
export declare function convertAttrName(context: LanguageServiceContext, uri: URI, casing: AttrNameCasing, tsPluginClient?: typeof import('@vue/typescript-plugin/lib/client')): Promise<vscode.TextEdit[] | undefined>;
export declare function getNameCasing(context: LanguageServiceContext, uri: URI): Promise<{
    tag: TagNameCasing;
    attr: AttrNameCasing;
}>;
export declare function detect(context: LanguageServiceContext, uri: URI): Promise<{
    tag: TagNameCasing[];
    attr: AttrNameCasing[];
}>;
