import type { Mapping } from '@volar/language-core';
import type { Code, Sfc, VueLanguagePlugin } from '../types';
export declare const tsCodegen: WeakMap<Sfc, {
    scriptRanges: () => {
        exportDefault: (import("../types").TextRange & {
            expression: import("../types").TextRange;
            args: import("../types").TextRange;
            argsNode: import("typescript").ObjectLiteralExpression | undefined;
            componentsOption: import("../types").TextRange | undefined;
            componentsOptionNode: import("typescript").ObjectLiteralExpression | undefined;
            nameOption: import("../types").TextRange | undefined;
        }) | undefined;
        classBlockEnd: number | undefined;
        bindings: import("../types").TextRange[];
    } | undefined;
    scriptSetupRanges: () => {
        leadingCommentEndOffset: number;
        importSectionEndOffset: number;
        bindings: import("../types").TextRange[];
        importComponentNames: Set<string>;
        props: {
            name?: string | undefined;
            define?: (import("../types").TextRange & {
                arg?: import("../types").TextRange | undefined;
                typeArg?: import("../types").TextRange | undefined;
            } & {
                statement: import("../types").TextRange;
            }) | undefined;
            withDefaults?: (import("../types").TextRange & {
                arg?: import("../types").TextRange | undefined;
            }) | undefined;
        };
        slots: {
            name?: string | undefined;
            isObjectBindingPattern?: boolean | undefined;
            define?: (import("../types").TextRange & {
                arg?: import("../types").TextRange | undefined;
                typeArg?: import("../types").TextRange | undefined;
            }) | undefined;
        };
        emits: {
            name?: string | undefined;
            define?: (import("../types").TextRange & {
                arg?: import("../types").TextRange | undefined;
                typeArg?: import("../types").TextRange | undefined;
            }) | undefined;
        };
        expose: {
            name?: string | undefined;
            define?: (import("../types").TextRange & {
                arg?: import("../types").TextRange | undefined;
                typeArg?: import("../types").TextRange | undefined;
            }) | undefined;
        };
        defineProp: {
            name: import("../types").TextRange | undefined;
            nameIsString: boolean;
            type: import("../types").TextRange | undefined;
            modifierType?: import("../types").TextRange | undefined;
            defaultValue: import("../types").TextRange | undefined;
            required: boolean;
            isModel?: boolean | undefined;
        }[];
        options: {
            name?: string | undefined;
        };
    } | undefined;
    lang: () => string;
    generatedScript: () => {
        codes: Code[];
        linkedCodeMappings: Mapping<unknown>[];
    };
    generatedTemplate: () => {
        codes: Code[];
        slots: {
            name: string;
            loc?: number | undefined;
            tagRange: [number, number];
            varName: string;
            nodeLoc: any;
        }[];
        dynamicSlots: {
            expVar: string;
            varName: string;
        }[];
        codeFeatures: {
            all: import("../types").VueCodeInformation;
            verification: import("../types").VueCodeInformation;
            completion: import("../types").VueCodeInformation;
            additionalCompletion: import("../types").VueCodeInformation;
            navigation: import("../types").VueCodeInformation;
            navigationWithoutRename: import("../types").VueCodeInformation;
            navigationAndCompletion: import("../types").VueCodeInformation;
            navigationAndAdditionalCompletion: import("../types").VueCodeInformation;
            withoutHighlight: import("../types").VueCodeInformation;
            withoutHighlightAndCompletion: import("../types").VueCodeInformation;
            withoutHighlightAndCompletionAndNavigation: import("../types").VueCodeInformation;
        };
        accessExternalVariables: Map<string, Set<number>>;
        hasSlotElements: Set<import("@vue/compiler-dom").ElementNode>;
        blockConditions: string[];
        usedComponentCtxVars: Set<string>;
        scopedClasses: {
            className: string;
            offset: number;
        }[];
        emptyClassOffsets: number[];
        hasSlot: boolean;
        accessExternalVariable(name: string, offset?: number | undefined): void;
        hasLocalVariable: (name: string) => boolean;
        addLocalVariable: (name: string) => void;
        removeLocalVariable: (name: string) => void;
        getInternalVariable: () => string;
        ignoreError: () => Generator<Code, any, unknown>;
        expectError: (prevNode: import("@vue/compiler-dom").CommentNode) => Generator<Code, any, unknown>;
        resetDirectiveComments: (endStr: string) => Generator<Code, any, unknown>;
        generateAutoImportCompletion: () => Generator<Code, any, unknown>;
    } | undefined;
}>;
declare const plugin: VueLanguagePlugin;
export default plugin;
