export type CodeRangeKey = 'sourceOffsets' | 'generatedOffsets';
export interface Mapping<Data = unknown> {
    sourceOffsets: number[];
    generatedOffsets: number[];
    lengths: number[];
    generatedLengths?: number[];
    data: Data;
}
export declare class SourceMap<Data = unknown> {
    readonly mappings: Mapping<Data>[];
    private sourceCodeOffsetsMemo;
    private generatedCodeOffsetsMemo;
    constructor(mappings: Mapping<Data>[]);
    getSourceOffsets(generatedOffset: number): Generator<readonly [number, Mapping<Data>], void, unknown>;
    getGeneratedOffsets(sourceOffset: number): Generator<readonly [number, Mapping<Data>], void, unknown>;
    findMatching(offset: number, fromRange: CodeRangeKey, toRange: CodeRangeKey): Generator<readonly [number, Mapping<Data>], void, unknown>;
    private getMemoBasedOnRange;
    private createMemo;
}
