import type { VirtualCode } from '@volar/language-core';
import type { TextDocument } from 'vscode-languageserver-textdocument';
import type { URI } from 'vscode-uri';
import type { SourceMapWithDocuments } from '../documents';
import type { LanguageServicePlugin, LanguageServicePluginInstance, LanguageServiceContext } from '../types';
export declare function documentFeatureWorker<T>(context: LanguageServiceContext, uri: URI, valid: (map: SourceMapWithDocuments) => boolean, worker: (plugin: [LanguageServicePlugin, LanguageServicePluginInstance], document: TextDocument) => Thenable<T | null | undefined> | T | null | undefined, transformResult: (result: T, map?: SourceMapWithDocuments) => T | undefined, combineResult?: (results: T[]) => T): Promise<T | undefined>;
export declare function languageFeatureWorker<T, K>(context: LanguageServiceContext, uri: URI, getRealDocParams: () => K, eachVirtualDocParams: (map: SourceMapWithDocuments) => Generator<K>, worker: (plugin: [LanguageServicePlugin, LanguageServicePluginInstance], document: TextDocument, params: K, map?: SourceMapWithDocuments) => Thenable<T | null | undefined> | T | null | undefined, transformResult: (result: T, map?: SourceMapWithDocuments) => T | undefined, combineResult?: (results: T[]) => T): Promise<T | undefined>;
export declare function safeCall<T>(cb: () => Thenable<T> | T, errorMsg?: string): Promise<T | undefined>;
export declare function forEachEmbeddedDocument(context: LanguageServiceContext, sourceScriptId: URI, current: VirtualCode): Generator<SourceMapWithDocuments>;
export declare function getEmbeddedFilesByLevel(context: LanguageServiceContext, sourceFileUri: URI, rootFile: VirtualCode, level: number): VirtualCode[];
