import { type Language } from '@volar/language-core';
import type * as vscode from 'vscode-languageserver-protocol';
import { URI } from 'vscode-uri';
import type { LanguageServicePlugin, LanguageServiceContext, LanguageServiceEnvironment } from './types';
export type LanguageService = ReturnType<typeof createLanguageService>;
export declare function createLanguageService(language: Language<URI>, plugins: LanguageServicePlugin[], env: LanguageServiceEnvironment): {
    getSemanticTokenLegend: () => {
        tokenModifiers: string[];
        tokenTypes: string[];
    };
    getTriggerCharacters: () => string[];
    getAutoFormatTriggerCharacters: () => string[];
    getSignatureHelpTriggerCharacters: () => string[];
    getSignatureHelpRetriggerCharacters: () => string[];
    format: (uri: URI, options: vscode.FormattingOptions, range: vscode.Range | undefined, onTypeParams: {
        ch: string;
        position: vscode.Position;
    } | undefined, token?: vscode.CancellationToken) => Promise<vscode.TextEdit[] | undefined>;
    getFoldingRanges: (uri: URI, token?: vscode.CancellationToken) => Promise<vscode.FoldingRange[] | undefined>;
    getSelectionRanges: (uri: URI, positions: vscode.Position[], token?: vscode.CancellationToken) => Promise<vscode.SelectionRange[] | undefined>;
    findLinkedEditingRanges: (uri: URI, position: vscode.Position, token?: vscode.CancellationToken) => Promise<vscode.LinkedEditingRanges | undefined>;
    findDocumentSymbols: (uri: URI, token?: vscode.CancellationToken) => Promise<vscode.DocumentSymbol[] | undefined>;
    findDocumentColors: (uri: URI, token?: vscode.CancellationToken) => Promise<vscode.ColorInformation[] | undefined>;
    getColorPresentations: (uri: URI, color: vscode.Color, range: vscode.Range, token?: vscode.CancellationToken) => Promise<vscode.ColorPresentation[] | undefined>;
    doValidation: (uri: URI, token?: vscode.CancellationToken, response?: ((result: vscode.Diagnostic[]) => void) | undefined) => Promise<vscode.Diagnostic[]>;
    findReferences: (uri: URI, position: vscode.Position, referenceContext: vscode.ReferenceContext, token?: vscode.CancellationToken) => Promise<vscode.Location[] | undefined>;
    findFileReferences: (uri: URI, token?: vscode.CancellationToken) => import("./types").NullableProviderResult<vscode.Location[]>;
    findDefinition: (uri: URI, position: vscode.Position, token?: vscode.CancellationToken) => Promise<vscode.LocationLink[] | undefined>;
    findTypeDefinition: (uri: URI, position: vscode.Position, token?: vscode.CancellationToken) => Promise<vscode.LocationLink[] | undefined>;
    findImplementations: (uri: URI, position: vscode.Position, token?: vscode.CancellationToken) => Promise<vscode.LocationLink[] | undefined>;
    prepareRename: (uri: URI, position: vscode.Position, token?: vscode.CancellationToken) => Promise<vscode.Range | {
        range: vscode.Range;
        placeholder: string;
    } | {
        message: string;
    } | undefined>;
    doRename: (uri: URI, position: vscode.Position, newName: string, token?: vscode.CancellationToken) => Promise<vscode.WorkspaceEdit | undefined>;
    getEditsForFileRename: (oldUri: URI, newUri: URI, token?: vscode.CancellationToken) => Promise<vscode.WorkspaceEdit | undefined>;
    getSemanticTokens: (uri: URI, range: vscode.Range | undefined, legend: vscode.SemanticTokensLegend, token?: vscode.CancellationToken, _reportProgress?: ((tokens: vscode.SemanticTokens) => void) | undefined) => Promise<vscode.SemanticTokens | undefined>;
    doHover: (uri: URI, position: vscode.Position, token?: vscode.CancellationToken) => Promise<vscode.Hover | undefined>;
    doComplete: (uri: URI, position: vscode.Position, completionContext?: vscode.CompletionContext, token?: vscode.CancellationToken) => Promise<vscode.CompletionList>;
    doCodeActions: (uri: URI, range: vscode.Range, codeActionContext: vscode.CodeActionContext, token?: vscode.CancellationToken) => Promise<vscode.CodeAction[] | undefined>;
    doCodeActionResolve: (item: vscode.CodeAction, token?: vscode.CancellationToken) => Promise<vscode.CodeAction>;
    doCompletionResolve: (item: vscode.CompletionItem, token?: vscode.CancellationToken) => Promise<vscode.CompletionItem>;
    getSignatureHelp: (uri: URI, position: vscode.Position, signatureHelpContext?: vscode.SignatureHelpContext, token?: vscode.CancellationToken) => Promise<vscode.SignatureHelp | undefined>;
    doCodeLens: (uri: URI, token?: vscode.CancellationToken) => Promise<vscode.CodeLens[]>;
    doCodeLensResolve: (item: vscode.CodeLens, token?: vscode.CancellationToken) => Promise<vscode.CodeLens>;
    findDocumentHighlights: (uri: URI, position: vscode.Position, token?: vscode.CancellationToken) => Promise<vscode.DocumentHighlight[] | undefined>;
    findDocumentLinks: (uri: URI, token?: vscode.CancellationToken) => Promise<vscode.DocumentLink[]>;
    doDocumentLinkResolve: (item: vscode.DocumentLink, token?: vscode.CancellationToken) => Promise<vscode.DocumentLink>;
    findWorkspaceSymbols: (query: string, token?: vscode.CancellationToken) => Promise<vscode.WorkspaceSymbol[]>;
    doAutoInsert: (uri: URI, selection: vscode.Position, change: {
        rangeOffset: number;
        rangeLength: number;
        text: string;
    }, token?: vscode.CancellationToken) => Promise<string | undefined>;
    doDocumentDrop: (uri: URI, position: vscode.Position, dataTransfer: Map<string, import("./types").DataTransferItem>, token?: vscode.CancellationToken) => Promise<import("./types").DocumentDropEdit | undefined>;
    getInlayHints: (uri: URI, range: vscode.Range, token?: vscode.CancellationToken) => Promise<vscode.InlayHint[] | undefined>;
    doInlayHintResolve: (item: vscode.InlayHint, token?: vscode.CancellationToken) => Promise<vscode.InlayHint>;
    callHierarchy: {
        doPrepare(uri: URI, position: vscode.Position, token?: vscode.CancellationToken): Promise<vscode.CallHierarchyItem[] | undefined>;
        getIncomingCalls(item: vscode.CallHierarchyItem, token: vscode.CancellationToken): Promise<vscode.CallHierarchyIncomingCall[]>;
        getOutgoingCalls(item: vscode.CallHierarchyItem, token: vscode.CancellationToken): Promise<vscode.CallHierarchyOutgoingCall[]>;
    };
    dispose: () => void;
    context: LanguageServiceContext;
};
