"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = void 0;
const common_1 = require("../utils/common");
const cancellation_1 = require("../utils/cancellation");
const transform_1 = require("../utils/transform");
const vscode_uri_1 = require("vscode-uri");
function register(context) {
    return async (query, token = cancellation_1.NoneCancellationToken) => {
        const symbolsList = [];
        for (const plugin of context.plugins) {
            if (context.disabledServicePlugins.has(plugin[1])) {
                continue;
            }
            if (token.isCancellationRequested) {
                break;
            }
            if (!plugin[1].provideWorkspaceSymbols) {
                continue;
            }
            const embeddedSymbols = await plugin[1].provideWorkspaceSymbols(query, token);
            if (!embeddedSymbols) {
                continue;
            }
            const symbols = embeddedSymbols.map(symbol => (0, transform_1.transformWorkspaceSymbol)(symbol, loc => {
                const decoded = context.decodeEmbeddedDocumentUri(vscode_uri_1.URI.parse(loc.uri));
                const sourceScript = decoded && context.language.scripts.get(decoded[0]);
                const virtualCode = decoded && sourceScript?.generated?.embeddedCodes.get(decoded[1]);
                if (virtualCode) {
                    for (const map of context.documents.getMaps(virtualCode)) {
                        const range = map.getSourceRange(loc.range);
                        if (range) {
                            return { uri: map.sourceDocument.uri, range };
                        }
                    }
                }
                else {
                    return loc;
                }
            })).filter(common_1.notEmpty);
            symbolsList.push(symbols);
        }
        return symbolsList.flat();
    };
}
exports.register = register;
//# sourceMappingURL=provideWorkspaceSymbols.js.map