"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = void 0;
const language_core_1 = require("@volar/language-core");
const vscode_uri_1 = require("vscode-uri");
const cancellation_1 = require("../utils/cancellation");
const common_1 = require("../utils/common");
const dedupe = require("../utils/dedupe");
const featureWorkers_1 = require("../utils/featureWorkers");
function register(context) {
    return (uri, position, token = cancellation_1.NoneCancellationToken) => {
        return (0, featureWorkers_1.languageFeatureWorker)(context, uri, () => position, map => map.getGeneratedPositions(position, language_core_1.isHighlightEnabled), async (plugin, document, position) => {
            if (token.isCancellationRequested) {
                return;
            }
            const recursiveChecker = dedupe.createLocationSet();
            const result = [];
            await withLinkedCode(document, position);
            return result;
            async function withLinkedCode(document, position) {
                if (!plugin[1].provideDocumentHighlights) {
                    return;
                }
                if (recursiveChecker.has({ uri: document.uri, range: { start: position, end: position } })) {
                    return;
                }
                recursiveChecker.add({ uri: document.uri, range: { start: position, end: position } });
                const references = await plugin[1].provideDocumentHighlights(document, position, token) ?? [];
                for (const reference of references) {
                    let foundMirrorPosition = false;
                    recursiveChecker.add({ uri: document.uri, range: { start: reference.range.start, end: reference.range.start } });
                    const decoded = context.decodeEmbeddedDocumentUri(vscode_uri_1.URI.parse(document.uri));
                    const sourceScript = decoded && context.language.scripts.get(decoded[0]);
                    const virtualCode = decoded && sourceScript?.generated?.embeddedCodes.get(decoded[1]);
                    const linkedCodeMap = virtualCode && sourceScript
                        ? context.documents.getLinkedCodeMap(virtualCode, sourceScript.id)
                        : undefined;
                    if (linkedCodeMap) {
                        for (const linkedPos of linkedCodeMap.getLinkedCodePositions(reference.range.start)) {
                            if (recursiveChecker.has({ uri: linkedCodeMap.document.uri, range: { start: linkedPos, end: linkedPos } })) {
                                continue;
                            }
                            foundMirrorPosition = true;
                            await withLinkedCode(linkedCodeMap.document, linkedPos);
                        }
                    }
                    if (!foundMirrorPosition) {
                        result.push(reference);
                    }
                }
            }
        }, (data, map) => data
            .map(highlight => {
            if (!map) {
                return highlight;
            }
            const range = map.getSourceRange(highlight.range, language_core_1.isHighlightEnabled);
            if (range) {
                return {
                    ...highlight,
                    range,
                };
            }
        })
            .filter(common_1.notEmpty), arr => arr.flat());
    };
}
exports.register = register;
//# sourceMappingURL=provideDocumentHighlights.js.map