import type * as vscode from 'vscode-languageserver-protocol';
import type { LanguageServiceContext } from '../types';
import { URI } from 'vscode-uri';
export interface PluginCallHierarchyData {
    uri: string;
    original: Pick<vscode.CallHierarchyItem, 'data'>;
    pluginIndex: number;
    embeddedDocumentUri: string | undefined;
}
export declare function register(context: LanguageServiceContext): {
    doPrepare(uri: URI, position: vscode.Position, token?: vscode.CancellationToken): Promise<vscode.CallHierarchyItem[] | undefined>;
    getIncomingCalls(item: vscode.CallHierarchyItem, token: vscode.CancellationToken): Promise<vscode.CallHierarchyIncomingCall[]>;
    getOutgoingCalls(item: vscode.CallHierarchyItem, token: vscode.CancellationToken): Promise<vscode.CallHierarchyOutgoingCall[]>;
};
