"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = void 0;
const language_core_1 = require("@volar/language-core");
const cancellation_1 = require("../utils/cancellation");
const featureWorkers_1 = require("../utils/featureWorkers");
function register(context) {
    return (uri, selection, change, token = cancellation_1.NoneCancellationToken) => {
        return (0, featureWorkers_1.languageFeatureWorker)(context, uri, () => ({ selection, change }), function* (map) {
            for (const mappedPosition of map.getGeneratedPositions(selection, language_core_1.isAutoInsertEnabled)) {
                for (const mapped of map.map.getGeneratedOffsets(change.rangeOffset)) {
                    yield {
                        selection: mappedPosition,
                        change: {
                            text: change.text,
                            rangeOffset: mapped[0],
                            rangeLength: change.rangeLength,
                        },
                    };
                    break;
                }
            }
        }, (plugin, document, args) => {
            if (token.isCancellationRequested) {
                return;
            }
            return plugin[1].provideAutoInsertSnippet?.(document, args.selection, args.change, token);
        }, snippet => snippet);
    };
}
exports.register = register;
//# sourceMappingURL=provideAutoInsertSnippet.js.map