"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LinkedCodeMapWithDocument = exports.SourceMapWithDocuments = void 0;
const language_core_1 = require("@volar/language-core");
class SourceMapWithDocuments {
    constructor(sourceDocument, embeddedDocument, map, virtuaoCode) {
        this.sourceDocument = sourceDocument;
        this.embeddedDocument = embeddedDocument;
        this.map = map;
        this.virtuaoCode = virtuaoCode;
    }
    // Range APIs
    getSourceRange(range, filter = () => true) {
        for (const result of this.getSourceRanges(range, filter)) {
            return result;
        }
    }
    getGeneratedRange(range, filter = () => true) {
        for (const result of this.getGeneratedRanges(range, filter)) {
            return result;
        }
    }
    *getSourceRanges(range, filter = () => true) {
        for (const result of this.findRanges(range, filter, 'getSourcePositionsBase', 'matchSourcePosition')) {
            yield result;
        }
    }
    *getGeneratedRanges(range, filter = () => true) {
        for (const result of this.findRanges(range, filter, 'getGeneratedPositionsBase', 'matchGeneratedPosition')) {
            yield result;
        }
    }
    *findRanges(range, filter, api, api2) {
        const failedLookUps = [];
        for (const mapped of this[api](range.start, filter)) {
            const end = this[api2](range.end, mapped[1]);
            if (end) {
                yield { start: mapped[0], end };
            }
            else {
                failedLookUps.push(mapped);
            }
        }
        for (const failedLookUp of failedLookUps) {
            for (const mapped of this[api](range.end, filter)) {
                yield { start: failedLookUp[0], end: mapped[0] };
            }
        }
    }
    // Position APIs
    getSourcePosition(position, filter = () => true) {
        for (const mapped of this.getSourcePositions(position, filter)) {
            return mapped;
        }
    }
    getGeneratedPosition(position, filter = () => true) {
        for (const mapped of this.getGeneratedPositions(position, filter)) {
            return mapped;
        }
    }
    *getSourcePositions(position, filter = () => true) {
        for (const mapped of this.getSourcePositionsBase(position, filter)) {
            yield mapped[0];
        }
    }
    *getGeneratedPositions(position, filter = () => true) {
        for (const mapped of this.getGeneratedPositionsBase(position, filter)) {
            yield mapped[0];
        }
    }
    *getSourcePositionsBase(position, filter = () => true) {
        for (const mapped of this.findPositions(position, filter, this.embeddedDocument, this.sourceDocument, 'generatedOffsets', 'sourceOffsets')) {
            yield mapped;
        }
    }
    *getGeneratedPositionsBase(position, filter = () => true) {
        for (const mapped of this.findPositions(position, filter, this.sourceDocument, this.embeddedDocument, 'sourceOffsets', 'generatedOffsets')) {
            yield mapped;
        }
    }
    *findPositions(position, filter, fromDoc, toDoc, from, to) {
        for (const mapped of this.map.findMatching(fromDoc.offsetAt(position), from, to)) {
            if (!filter(mapped[1].data)) {
                continue;
            }
            yield [toDoc.positionAt(mapped[0]), mapped[1]];
        }
    }
    matchSourcePosition(position, mapping) {
        let offset = (0, language_core_1.translateOffset)(this.embeddedDocument.offsetAt(position), mapping.generatedOffsets, mapping.sourceOffsets, mapping.generatedLengths ?? mapping.lengths, mapping.lengths);
        if (offset !== undefined) {
            return this.sourceDocument.positionAt(offset);
        }
    }
    matchGeneratedPosition(position, mapping) {
        let offset = (0, language_core_1.translateOffset)(this.sourceDocument.offsetAt(position), mapping.sourceOffsets, mapping.generatedOffsets, mapping.lengths, mapping.generatedLengths ?? mapping.lengths);
        if (offset !== undefined) {
            return this.embeddedDocument.positionAt(offset);
        }
    }
}
exports.SourceMapWithDocuments = SourceMapWithDocuments;
class LinkedCodeMapWithDocument extends SourceMapWithDocuments {
    constructor(document, linkedMap, virtualCode) {
        super(document, document, linkedMap, virtualCode);
        this.document = document;
        this.linkedMap = linkedMap;
        this.virtualCode = virtualCode;
    }
    *getLinkedCodePositions(posotion) {
        for (const linkedPosition of this.linkedMap.getLinkedOffsets(this.document.offsetAt(posotion))) {
            yield this.document.positionAt(linkedPosition);
        }
    }
}
exports.LinkedCodeMapWithDocument = LinkedCodeMapWithDocument;
//# sourceMappingURL=documents.js.map