import { CodeInformation, CodeRangeKey, LinkedCodeMap, Mapping, SourceMap, VirtualCode } from '@volar/language-core';
import type * as vscode from 'vscode-languageserver-protocol';
import type { TextDocument } from 'vscode-languageserver-textdocument';
export declare class SourceMapWithDocuments {
    sourceDocument: TextDocument;
    embeddedDocument: TextDocument;
    map: SourceMap<CodeInformation>;
    virtuaoCode?: VirtualCode | undefined;
    constructor(sourceDocument: TextDocument, embeddedDocument: TextDocument, map: SourceMap<CodeInformation>, virtuaoCode?: VirtualCode | undefined);
    getSourceRange(range: vscode.Range, filter?: (data: CodeInformation) => boolean): vscode.Range | undefined;
    getGeneratedRange(range: vscode.Range, filter?: (data: CodeInformation) => boolean): vscode.Range | undefined;
    getSourceRanges(range: vscode.Range, filter?: (data: CodeInformation) => boolean): Generator<vscode.Range, void, unknown>;
    getGeneratedRanges(range: vscode.Range, filter?: (data: CodeInformation) => boolean): Generator<vscode.Range, void, unknown>;
    protected findRanges(range: vscode.Range, filter: (data: CodeInformation) => boolean, api: 'getSourcePositionsBase' | 'getGeneratedPositionsBase', api2: 'matchSourcePosition' | 'matchGeneratedPosition'): Generator<vscode.Range, void, unknown>;
    getSourcePosition(position: vscode.Position, filter?: (data: CodeInformation) => boolean): import("vscode-languageserver-textdocument").Position | undefined;
    getGeneratedPosition(position: vscode.Position, filter?: (data: CodeInformation) => boolean): import("vscode-languageserver-textdocument").Position | undefined;
    getSourcePositions(position: vscode.Position, filter?: (data: CodeInformation) => boolean): Generator<import("vscode-languageserver-textdocument").Position, void, unknown>;
    getGeneratedPositions(position: vscode.Position, filter?: (data: CodeInformation) => boolean): Generator<import("vscode-languageserver-textdocument").Position, void, unknown>;
    getSourcePositionsBase(position: vscode.Position, filter?: (data: CodeInformation) => boolean): Generator<readonly [import("vscode-languageserver-textdocument").Position, Mapping<CodeInformation>], void, unknown>;
    getGeneratedPositionsBase(position: vscode.Position, filter?: (data: CodeInformation) => boolean): Generator<readonly [import("vscode-languageserver-textdocument").Position, Mapping<CodeInformation>], void, unknown>;
    protected findPositions(position: vscode.Position, filter: (data: CodeInformation) => boolean, fromDoc: TextDocument, toDoc: TextDocument, from: CodeRangeKey, to: CodeRangeKey): Generator<readonly [import("vscode-languageserver-textdocument").Position, Mapping<CodeInformation>], void, unknown>;
    protected matchSourcePosition(position: vscode.Position, mapping: Mapping): import("vscode-languageserver-textdocument").Position | undefined;
    protected matchGeneratedPosition(position: vscode.Position, mapping: Mapping): import("vscode-languageserver-textdocument").Position | undefined;
}
export declare class LinkedCodeMapWithDocument extends SourceMapWithDocuments {
    document: TextDocument;
    linkedMap: LinkedCodeMap;
    virtualCode: VirtualCode;
    constructor(document: TextDocument, linkedMap: LinkedCodeMap, virtualCode: VirtualCode);
    getLinkedCodePositions(posotion: vscode.Position): Generator<import("vscode-languageserver-textdocument").Position, void, unknown>;
}
