import { FileSystem } from '@volar/language-service';
import * as vscode from 'vscode-languageserver/node';
export * from 'vscode-languageserver/node';
export * from './index';
export * from './lib/project/simpleProject';
export * from './lib/project/typescriptProject';
export * from './lib/server';
export declare function createConnection(): vscode._Connection<vscode._, vscode._, vscode._, vscode._, vscode._, vscode._, import("vscode-languageserver/lib/common/inlineCompletion.proposed").InlineCompletionFeatureShape, vscode._>;
export declare function createServer(connection: vscode.Connection): {
    connection: vscode.Connection;
    fs: FileSystem;
    initializeParams: vscode.InitializeParams;
    initializeResult: import("./index").VolarInitializeResult;
    languageServicePlugins: import("@volar/language-service").LanguageServicePlugin<any>[];
    project: import("./index").LanguageServerProject;
    pullModelDiagnostics: boolean;
    documents: vscode.TextDocuments<import("@volar/snapshot-document/lib/snapshotDocument").SnapshotDocument>;
    workspaceFolders: Map<import("vscode-uri").URI, boolean>;
    getSyncedDocumentKey: (uri: import("vscode-uri").URI) => string | undefined;
    initialize: (initializeParams: vscode.InitializeParams, project: import("./index").LanguageServerProject, languageServicePlugins: import("@volar/language-service").LanguageServicePlugin<any>[], options?: {
        pullModelDiagnostics?: boolean | undefined;
    } | undefined) => import("./index").VolarInitializeResult;
    initialized: () => void;
    shutdown: () => void;
    watchFiles: (patterns: string[]) => void;
    getConfiguration: <T>(section: string, scopeUri?: string | undefined) => Promise<T | undefined>;
    onDidChangeConfiguration: (cb: vscode.NotificationHandler<vscode.DidChangeConfigurationParams>) => {
        dispose(): void;
    };
    onDidChangeWatchedFiles: (cb: vscode.NotificationHandler<vscode.DidChangeWatchedFilesParams>) => {
        dispose: () => void;
    };
    clearPushDiagnostics: () => void;
    refresh: (projects: import("./index").LanguageServerProject) => Promise<void>;
};
export declare const fs: FileSystem;
export declare function loadTsdkByPath(tsdk: string, locale: string | undefined): {
    typescript: typeof import("typescript");
    diagnosticMessages: import("typescript").MapLike<string> | undefined;
};
