"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createServerBase = void 0;
const language_service_1 = require("@volar/language-service");
const snapshot_document_1 = require("@volar/snapshot-document");
const request_light_1 = require("request-light");
const vscode = require("vscode-languageserver");
const vscode_uri_1 = require("vscode-uri");
const registerEditorFeatures_js_1 = require("./register/registerEditorFeatures.js");
const registerLanguageFeatures_js_1 = require("./register/registerLanguageFeatures.js");
__exportStar(require("@volar/snapshot-document"), exports);
function createServerBase(connection, fs) {
    let semanticTokensReq = 0;
    let documentUpdatedReq = 0;
    const syncedDocumentParsedUriToUri = new Map();
    const didChangeWatchedFilesCallbacks = new Set();
    const didChangeConfigurationCallbacks = new Set();
    const configurations = new Map();
    const documentsCache = new Map();
    const documents = new vscode.TextDocuments({
        create(uri, languageId, version, text) {
            const cache = documentsCache.get(uri)?.deref();
            if (cache && cache.languageId === languageId && cache.version === version && cache.getText() === text) {
                return cache;
            }
            const document = new snapshot_document_1.SnapshotDocument(uri, languageId, version, text);
            documentsCache.set(uri, new WeakRef(document));
            return document;
        },
        update(snapshot, contentChanges, version) {
            snapshot.update(contentChanges, version);
            return snapshot;
        },
    });
    documents.listen(connection);
    documents.onDidOpen(({ document }) => {
        const parsedUri = vscode_uri_1.URI.parse(document.uri);
        syncedDocumentParsedUriToUri.set(parsedUri.toString(), document.uri);
    });
    documents.onDidClose(e => {
        syncedDocumentParsedUriToUri.delete(vscode_uri_1.URI.parse(e.document.uri).toString());
    });
    const status = {
        connection,
        fs: createFsWithCache(fs),
        initializeParams: undefined,
        initializeResult: undefined,
        languageServicePlugins: [],
        project: undefined,
        pullModelDiagnostics: false,
        documents,
        workspaceFolders: (0, language_service_1.createUriMap)(),
        getSyncedDocumentKey,
        initialize,
        initialized,
        shutdown,
        watchFiles,
        getConfiguration,
        onDidChangeConfiguration,
        onDidChangeWatchedFiles,
        clearPushDiagnostics,
        refresh,
    };
    return status;
    function getSyncedDocumentKey(uri) {
        const originalUri = syncedDocumentParsedUriToUri.get(uri.toString());
        if (originalUri) {
            return originalUri;
        }
    }
    function initialize(initializeParams, project, languageServicePlugins, options) {
        status.initializeParams = initializeParams;
        status.project = project;
        status.languageServicePlugins = languageServicePlugins;
        status.pullModelDiagnostics = options?.pullModelDiagnostics ?? false;
        if (initializeParams.workspaceFolders?.length) {
            for (const folder of initializeParams.workspaceFolders) {
                status.workspaceFolders.set(vscode_uri_1.URI.parse(folder.uri), true);
            }
        }
        else if (initializeParams.rootUri) {
            status.workspaceFolders.set(vscode_uri_1.URI.parse(initializeParams.rootUri), true);
        }
        else if (initializeParams.rootPath) {
            status.workspaceFolders.set(vscode_uri_1.URI.file(initializeParams.rootPath), true);
        }
        const capabilitiesArr = status.languageServicePlugins.map(plugin => plugin.capabilities);
        status.initializeResult = { capabilities: {} };
        status.initializeResult.capabilities = {
            textDocumentSync: vscode.TextDocumentSyncKind.Incremental,
            workspace: {
                // #18
                workspaceFolders: {
                    supported: true,
                    changeNotifications: true,
                },
            },
            selectionRangeProvider: capabilitiesArr.some(data => data.selectionRangeProvider) ? true : undefined,
            foldingRangeProvider: capabilitiesArr.some(data => data.foldingRangeProvider) ? true : undefined,
            linkedEditingRangeProvider: capabilitiesArr.some(data => data.linkedEditingRangeProvider) ? true : undefined,
            colorProvider: capabilitiesArr.some(data => data.colorProvider) ? true : undefined,
            documentSymbolProvider: capabilitiesArr.some(data => data.documentSymbolProvider) ? true : undefined,
            documentFormattingProvider: capabilitiesArr.some(data => data.documentFormattingProvider) ? true : undefined,
            documentRangeFormattingProvider: capabilitiesArr.some(data => data.documentFormattingProvider) ? true : undefined,
            referencesProvider: capabilitiesArr.some(data => data.referencesProvider) ? true : undefined,
            implementationProvider: capabilitiesArr.some(data => data.implementationProvider) ? true : undefined,
            definitionProvider: capabilitiesArr.some(data => data.definitionProvider) ? true : undefined,
            typeDefinitionProvider: capabilitiesArr.some(data => data.typeDefinitionProvider) ? true : undefined,
            callHierarchyProvider: capabilitiesArr.some(data => data.callHierarchyProvider) ? true : undefined,
            hoverProvider: capabilitiesArr.some(data => data.hoverProvider) ? true : undefined,
            documentHighlightProvider: capabilitiesArr.some(data => data.documentHighlightProvider) ? true : undefined,
            workspaceSymbolProvider: capabilitiesArr.some(data => data.workspaceSymbolProvider) ? true : undefined,
            renameProvider: capabilitiesArr.some(data => data.renameProvider)
                ? { prepareProvider: capabilitiesArr.some(data => data.renameProvider?.prepareProvider) }
                : undefined,
            documentLinkProvider: capabilitiesArr.some(data => data.documentLinkProvider)
                ? { resolveProvider: capabilitiesArr.some(data => data.documentLinkProvider?.resolveProvider) }
                : undefined,
            codeLensProvider: capabilitiesArr.some(data => data.codeLensProvider)
                ? { resolveProvider: capabilitiesArr.some(data => data.codeLensProvider?.resolveProvider) }
                : undefined,
            inlayHintProvider: capabilitiesArr.some(data => data.inlayHintProvider)
                ? { resolveProvider: capabilitiesArr.some(data => data.inlayHintProvider?.resolveProvider) }
                : undefined,
            signatureHelpProvider: capabilitiesArr.some(data => data.signatureHelpProvider)
                ? {
                    triggerCharacters: [...new Set(capabilitiesArr.map(data => data.signatureHelpProvider?.triggerCharacters ?? []).flat())],
                    retriggerCharacters: [...new Set(capabilitiesArr.map(data => data.signatureHelpProvider?.retriggerCharacters ?? []).flat())],
                }
                : undefined,
            completionProvider: capabilitiesArr.some(data => data.completionProvider)
                ? {
                    resolveProvider: capabilitiesArr.some(data => data.completionProvider?.resolveProvider),
                    triggerCharacters: [...new Set(capabilitiesArr.map(data => data.completionProvider?.triggerCharacters ?? []).flat())],
                }
                : undefined,
            semanticTokensProvider: capabilitiesArr.some(data => data.semanticTokensProvider)
                ? {
                    range: true,
                    full: false,
                    legend: {
                        tokenTypes: [...new Set(capabilitiesArr.map(data => data.semanticTokensProvider?.legend?.tokenTypes ?? []).flat())],
                        tokenModifiers: [...new Set(capabilitiesArr.map(data => data.semanticTokensProvider?.legend?.tokenModifiers ?? []).flat())],
                    },
                }
                : undefined,
            codeActionProvider: capabilitiesArr.some(data => data.codeActionProvider)
                ? {
                    resolveProvider: capabilitiesArr.some(data => data.codeActionProvider?.resolveProvider),
                    codeActionKinds: capabilitiesArr.some(data => data.codeActionProvider?.codeActionKinds)
                        ? [...new Set(capabilitiesArr.map(data => data.codeActionProvider?.codeActionKinds ?? []).flat())]
                        : undefined,
                }
                : undefined,
            diagnosticProvider: capabilitiesArr.some(data => data.diagnosticProvider)
                ? {
                    interFileDependencies: true,
                    workspaceDiagnostics: false,
                }
                : undefined,
            documentOnTypeFormattingProvider: capabilitiesArr.some(data => data.documentOnTypeFormattingProvider)
                ? {
                    firstTriggerCharacter: [...new Set(capabilitiesArr.map(data => data.documentOnTypeFormattingProvider?.triggerCharacters ?? []).flat())][0],
                    moreTriggerCharacter: [...new Set(capabilitiesArr.map(data => data.documentOnTypeFormattingProvider?.triggerCharacters ?? []).flat())].slice(1),
                }
                : undefined,
        };
        if (!status.pullModelDiagnostics && status.initializeResult.capabilities.diagnosticProvider) {
            status.initializeResult.capabilities.diagnosticProvider = undefined;
            activateServerPushDiagnostics(project);
        }
        if (capabilitiesArr.some(data => data.autoInsertionProvider)) {
            const triggerCharacterToConfigurationSections = new Map();
            const tryAdd = (char, section) => {
                let sectionSet = triggerCharacterToConfigurationSections.get(char);
                if (!sectionSet) {
                    triggerCharacterToConfigurationSections.set(char, sectionSet = new Set());
                }
                if (section) {
                    sectionSet.add(section);
                }
            };
            for (const data of capabilitiesArr) {
                if (data.autoInsertionProvider) {
                    const { triggerCharacters, configurationSections } = data.autoInsertionProvider;
                    if (configurationSections) {
                        if (configurationSections.length !== triggerCharacters.length) {
                            throw new Error('configurationSections.length !== triggerCharacters.length');
                        }
                        for (let i = 0; i < configurationSections.length; i++) {
                            tryAdd(triggerCharacters[i], configurationSections[i]);
                        }
                    }
                    else {
                        for (const char of triggerCharacters) {
                            tryAdd(char);
                        }
                    }
                }
            }
            status.initializeResult.autoInsertion = {
                triggerCharacters: [],
                configurationSections: [],
            };
            for (const [char, sections] of triggerCharacterToConfigurationSections) {
                if (sections.size) {
                    for (const section of sections) {
                        status.initializeResult.autoInsertion.triggerCharacters.push(char);
                        status.initializeResult.autoInsertion.configurationSections.push(section);
                    }
                }
                else {
                    status.initializeResult.autoInsertion.triggerCharacters.push(char);
                    status.initializeResult.autoInsertion.configurationSections.push(null);
                }
            }
        }
        return status.initializeResult;
    }
    function initialized() {
        status.project.setup(status);
        (0, registerEditorFeatures_js_1.registerEditorFeatures)(status);
        (0, registerLanguageFeatures_js_1.registerLanguageFeatures)(status);
        registerWorkspaceFoldersWatcher();
        registerConfigurationWatcher();
        updateHttpSettings();
        onDidChangeConfiguration(updateHttpSettings);
    }
    function shutdown() {
        status.project.reload();
    }
    async function updateHttpSettings() {
        const httpSettings = await getConfiguration('http');
        (0, request_light_1.configure)(httpSettings?.proxy, httpSettings?.proxyStrictSSL ?? false);
    }
    function getConfiguration(section, scopeUri) {
        if (!status.initializeParams?.capabilities.workspace?.configuration) {
            return Promise.resolve(undefined);
        }
        if (!scopeUri && status.initializeParams.capabilities.workspace?.didChangeConfiguration) {
            if (!configurations.has(section)) {
                configurations.set(section, getConfigurationWorker(section, scopeUri));
            }
            return configurations.get(section);
        }
        return getConfigurationWorker(section, scopeUri);
    }
    async function getConfigurationWorker(section, scopeUri) {
        return (await connection.workspace.getConfiguration({ scopeUri, section })) ?? undefined /* replace null to undefined */;
    }
    function onDidChangeConfiguration(cb) {
        didChangeConfigurationCallbacks.add(cb);
        return {
            dispose() {
                didChangeConfigurationCallbacks.delete(cb);
            },
        };
    }
    function onDidChangeWatchedFiles(cb) {
        didChangeWatchedFilesCallbacks.add(cb);
        return {
            dispose: () => {
                didChangeWatchedFilesCallbacks.delete(cb);
            },
        };
    }
    function createFsWithCache(fs) {
        const readFileCache = (0, language_service_1.createUriMap)();
        const statCache = (0, language_service_1.createUriMap)();
        const readDirectoryCache = (0, language_service_1.createUriMap)();
        documents.onDidSave(({ document }) => {
            const uri = vscode_uri_1.URI.parse(document.uri);
            readFileCache.set(uri, document.getText());
            statCache.delete(uri);
        });
        onDidChangeWatchedFiles(({ changes }) => {
            for (const change of changes) {
                const changeUri = vscode_uri_1.URI.parse(change.uri);
                const dir = vscode_uri_1.URI.parse(change.uri.substring(0, change.uri.lastIndexOf('/')));
                if (change.type === vscode.FileChangeType.Deleted) {
                    readFileCache.set(changeUri, undefined);
                    statCache.set(changeUri, undefined);
                    readDirectoryCache.delete(dir);
                }
                else if (change.type === vscode.FileChangeType.Changed) {
                    readFileCache.delete(changeUri);
                    statCache.delete(changeUri);
                }
                else if (change.type === vscode.FileChangeType.Created) {
                    readFileCache.delete(changeUri);
                    statCache.delete(changeUri);
                    readDirectoryCache.delete(dir);
                }
            }
        });
        return {
            readFile: uri => {
                if (!readFileCache.has(uri)) {
                    readFileCache.set(uri, fs.readFile(uri));
                }
                return readFileCache.get(uri);
            },
            stat: uri => {
                if (!statCache.has(uri)) {
                    statCache.set(uri, fs.stat(uri));
                }
                return statCache.get(uri);
            },
            readDirectory: uri => {
                if (!readDirectoryCache.has(uri)) {
                    readDirectoryCache.set(uri, fs.readDirectory(uri));
                }
                return readDirectoryCache.get(uri);
            },
        };
    }
    function registerConfigurationWatcher() {
        const didChangeConfiguration = status.initializeParams?.capabilities.workspace?.didChangeConfiguration;
        if (didChangeConfiguration) {
            connection.onDidChangeConfiguration(params => {
                configurations.clear();
                for (const cb of didChangeConfigurationCallbacks) {
                    cb(params);
                }
            });
            if (didChangeConfiguration.dynamicRegistration) {
                connection.client.register(vscode.DidChangeConfigurationNotification.type);
            }
        }
    }
    function watchFiles(patterns) {
        const didChangeWatchedFiles = status.initializeParams?.capabilities.workspace?.didChangeWatchedFiles;
        const fileOperations = status.initializeParams?.capabilities.workspace?.fileOperations;
        if (didChangeWatchedFiles) {
            connection.onDidChangeWatchedFiles(e => {
                for (const cb of didChangeWatchedFilesCallbacks) {
                    cb(e);
                }
            });
            if (didChangeWatchedFiles.dynamicRegistration) {
                connection.client.register(vscode.DidChangeWatchedFilesNotification.type, {
                    watchers: patterns.map(pattern => ({ globPattern: pattern })),
                });
            }
        }
        if (fileOperations?.dynamicRegistration && fileOperations.willRename) {
            connection.client.register(vscode.WillRenameFilesRequest.type, {
                filters: patterns.map(pattern => ({ pattern: { glob: pattern } })),
            });
        }
    }
    function registerWorkspaceFoldersWatcher() {
        if (status.initializeParams?.capabilities.workspace?.workspaceFolders) {
            connection.workspace.onDidChangeWorkspaceFolders(e => {
                for (const folder of e.added) {
                    status.workspaceFolders.set(vscode_uri_1.URI.parse(folder.uri), true);
                }
                for (const folder of e.removed) {
                    status.workspaceFolders.delete(vscode_uri_1.URI.parse(folder.uri));
                }
                status.project.reload();
            });
        }
    }
    function activateServerPushDiagnostics(projects) {
        documents.onDidChangeContent(({ document }) => {
            pushAllDiagnostics(projects, document.uri);
        });
        documents.onDidClose(({ document }) => {
            connection.sendDiagnostics({ uri: document.uri, diagnostics: [] });
        });
        onDidChangeConfiguration(() => refresh(projects));
    }
    function clearPushDiagnostics() {
        if (!status.pullModelDiagnostics) {
            for (const document of documents.all()) {
                connection.sendDiagnostics({ uri: document.uri, diagnostics: [] });
            }
        }
    }
    async function refresh(projects) {
        const req = ++semanticTokensReq;
        if (!status.pullModelDiagnostics) {
            await pushAllDiagnostics(projects);
        }
        const delay = 250;
        await sleep(delay);
        if (req === semanticTokensReq) {
            if (status.initializeParams?.capabilities.workspace?.semanticTokens?.refreshSupport) {
                connection.languages.semanticTokens.refresh();
            }
            if (status.initializeParams?.capabilities.workspace?.inlayHint?.refreshSupport) {
                connection.languages.inlayHint.refresh();
            }
            if (status.pullModelDiagnostics && status.initializeParams?.capabilities.workspace?.diagnostics?.refreshSupport) {
                connection.languages.diagnostics.refresh();
            }
        }
    }
    async function pushAllDiagnostics(projects, docUri) {
        const req = ++documentUpdatedReq;
        const delay = 250;
        const token = {
            get isCancellationRequested() {
                return req !== documentUpdatedReq;
            },
            onCancellationRequested: vscode.Event.None,
        };
        const changeDoc = docUri ? documents.get(docUri) : undefined;
        const otherDocs = [...documents.all()].filter(doc => doc !== changeDoc);
        if (changeDoc) {
            await sleep(delay);
            if (token.isCancellationRequested) {
                return;
            }
            await pushDiagnostics(projects, changeDoc.uri, changeDoc.version, token);
        }
        for (const doc of otherDocs) {
            await sleep(delay);
            if (token.isCancellationRequested) {
                break;
            }
            await pushDiagnostics(projects, doc.uri, doc.version, token);
        }
    }
    async function pushDiagnostics(projects, uriStr, version, cancel) {
        const uri = vscode_uri_1.URI.parse(uriStr);
        const languageService = (await projects.getLanguageService(uri));
        const errors = await languageService.doValidation(uri, cancel, result => {
            connection.sendDiagnostics({ uri: uriStr, diagnostics: result, version });
        });
        connection.sendDiagnostics({ uri: uriStr, diagnostics: errors, version });
    }
}
exports.createServerBase = createServerBase;
function sleep(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}
//# sourceMappingURL=server.js.map