import * as vscode from 'vscode-languageserver/browser';
import { URI } from 'vscode-uri';
export * from 'vscode-languageserver/browser';
export * from './index';
export * from './lib/project/simpleProject';
export * from './lib/project/typescriptProject';
export * from './lib/server';
export declare function createConnection(): vscode.Connection;
export declare function createServer(connection: vscode.Connection): {
    connection: vscode.Connection;
    fs: import("@volar/language-service").FileSystem;
    initializeParams: vscode.InitializeParams;
    initializeResult: import("./index").VolarInitializeResult;
    languageServicePlugins: import("@volar/language-service").LanguageServicePlugin<any>[];
    project: import("./index").LanguageServerProject;
    pullModelDiagnostics: boolean;
    documents: vscode.TextDocuments<import("@volar/snapshot-document/lib/snapshotDocument").SnapshotDocument>;
    workspaceFolders: Map<URI, boolean>;
    getSyncedDocumentKey: (uri: URI) => string | undefined;
    initialize: (initializeParams: vscode.InitializeParams, project: import("./index").LanguageServerProject, languageServicePlugins: import("@volar/language-service").LanguageServicePlugin<any>[], options?: {
        pullModelDiagnostics?: boolean | undefined;
    } | undefined) => import("./index").VolarInitializeResult;
    initialized: () => void;
    shutdown: () => void;
    watchFiles: (patterns: string[]) => void;
    getConfiguration: <T>(section: string, scopeUri?: string | undefined) => Promise<T | undefined>;
    onDidChangeConfiguration: (cb: vscode.NotificationHandler<vscode.DidChangeConfigurationParams>) => {
        dispose(): void;
    };
    onDidChangeWatchedFiles: (cb: vscode.NotificationHandler<vscode.DidChangeWatchedFilesParams>) => {
        dispose: () => void;
    };
    clearPushDiagnostics: () => void;
    refresh: (projects: import("./index").LanguageServerProject) => Promise<void>;
};
export declare function loadTsdkByUrl(tsdkUrl: string, locale: string | undefined): Promise<{
    typescript: typeof import("typescript");
    diagnosticMessages: import("typescript").MapLike<string> | undefined;
}>;
