import type { LanguagePlugin, LanguageServerProject, ProviderResult } from '@volar/language-server';
import { Disposable, LanguageServiceEnvironment } from '@vue/language-service';
import { TypeScriptProjectHost } from '@vue/typescript-plugin/lib/utils';
import type * as ts from 'typescript';
import { URI } from 'vscode-uri';
export type GetLanguagePlugin<T> = (params: {
    serviceEnv: LanguageServiceEnvironment;
    asFileName: (scriptId: T) => string;
    configFileName?: string;
    projectHost?: TypeScriptProjectHost;
    sys?: ts.System & {
        version: number;
        sync(): Promise<number>;
    } & Disposable;
}) => ProviderResult<LanguagePlugin<URI>[]>;
export declare function createHybridModeProject(sys: ts.System, getLanguagePlugins: GetLanguagePlugin<URI>): LanguageServerProject;
export declare function notEmpty<T>(value: T | null | undefined): value is T;
