//
// Copyright 2023 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdGen/schema.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_USD_IMAGING_USD_IMAGING_GEOM_MODEL_SCHEMA_H
#define PXR_USD_IMAGING_USD_IMAGING_GEOM_MODEL_SCHEMA_H

#include "pxr/usdImaging/usdImaging/api.h"

#include "pxr/imaging/hd/schema.h" 

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

//-----------------------------------------------------------------------------

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

//-----------------------------------------------------------------------------

#define USD_IMAGING_GEOM_MODEL_SCHEMA_TOKENS \
    (geomModel) \
    (drawMode) \
    (applyDrawMode) \
    (drawModeColor) \
    (cardGeometry) \
    (cardTextureXPos) \
    (cardTextureYPos) \
    (cardTextureZPos) \
    (cardTextureXNeg) \
    (cardTextureYNeg) \
    (cardTextureZNeg) \
    ((default_, "default")) \
    (origin) \
    (bounds) \
    (cards) \
    (inherited) \
    (cross) \
    (box) \
    (fromTexture) \

TF_DECLARE_PUBLIC_TOKENS(UsdImagingGeomModelSchemaTokens, USDIMAGING_API,
    USD_IMAGING_GEOM_MODEL_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------
class UsdImagingGeomModelSchema : public HdSchema
{
public:
    UsdImagingGeomModelSchema(HdContainerDataSourceHandle container)
    : HdSchema(container) {}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    //ACCESSORS


    USDIMAGING_API
    HdTokenDataSourceHandle GetDrawMode();

    USDIMAGING_API
    HdBoolDataSourceHandle GetApplyDrawMode();

    USDIMAGING_API
    HdVec3fDataSourceHandle GetDrawModeColor();

    USDIMAGING_API
    HdTokenDataSourceHandle GetCardGeometry();

    USDIMAGING_API
    HdAssetPathDataSourceHandle GetCardTextureXPos();

    USDIMAGING_API
    HdAssetPathDataSourceHandle GetCardTextureYPos();

    USDIMAGING_API
    HdAssetPathDataSourceHandle GetCardTextureZPos();

    USDIMAGING_API
    HdAssetPathDataSourceHandle GetCardTextureXNeg();

    USDIMAGING_API
    HdAssetPathDataSourceHandle GetCardTextureYNeg();

    USDIMAGING_API
    HdAssetPathDataSourceHandle GetCardTextureZNeg();

    // RETRIEVING AND CONSTRUCTING

    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    USDIMAGING_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdTokenDataSourceHandle &drawMode,
        const HdBoolDataSourceHandle &applyDrawMode,
        const HdVec3fDataSourceHandle &drawModeColor,
        const HdTokenDataSourceHandle &cardGeometry,
        const HdAssetPathDataSourceHandle &cardTextureXPos,
        const HdAssetPathDataSourceHandle &cardTextureYPos,
        const HdAssetPathDataSourceHandle &cardTextureZPos,
        const HdAssetPathDataSourceHandle &cardTextureXNeg,
        const HdAssetPathDataSourceHandle &cardTextureYNeg,
        const HdAssetPathDataSourceHandle &cardTextureZNeg
    );

    /// \class UsdImagingGeomModelSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        USDIMAGING_API
        Builder &SetDrawMode(
            const HdTokenDataSourceHandle &drawMode);
        USDIMAGING_API
        Builder &SetApplyDrawMode(
            const HdBoolDataSourceHandle &applyDrawMode);
        USDIMAGING_API
        Builder &SetDrawModeColor(
            const HdVec3fDataSourceHandle &drawModeColor);
        USDIMAGING_API
        Builder &SetCardGeometry(
            const HdTokenDataSourceHandle &cardGeometry);
        USDIMAGING_API
        Builder &SetCardTextureXPos(
            const HdAssetPathDataSourceHandle &cardTextureXPos);
        USDIMAGING_API
        Builder &SetCardTextureYPos(
            const HdAssetPathDataSourceHandle &cardTextureYPos);
        USDIMAGING_API
        Builder &SetCardTextureZPos(
            const HdAssetPathDataSourceHandle &cardTextureZPos);
        USDIMAGING_API
        Builder &SetCardTextureXNeg(
            const HdAssetPathDataSourceHandle &cardTextureXNeg);
        USDIMAGING_API
        Builder &SetCardTextureYNeg(
            const HdAssetPathDataSourceHandle &cardTextureYNeg);
        USDIMAGING_API
        Builder &SetCardTextureZNeg(
            const HdAssetPathDataSourceHandle &cardTextureZNeg);

        /// Returns a container data source containing the members set thus far.
        USDIMAGING_API
        HdContainerDataSourceHandle Build();

    private:
        HdTokenDataSourceHandle _drawMode;
        HdBoolDataSourceHandle _applyDrawMode;
        HdVec3fDataSourceHandle _drawModeColor;
        HdTokenDataSourceHandle _cardGeometry;
        HdAssetPathDataSourceHandle _cardTextureXPos;
        HdAssetPathDataSourceHandle _cardTextureYPos;
        HdAssetPathDataSourceHandle _cardTextureZPos;
        HdAssetPathDataSourceHandle _cardTextureXNeg;
        HdAssetPathDataSourceHandle _cardTextureYNeg;
        HdAssetPathDataSourceHandle _cardTextureZNeg;
    };

    /// Retrieves a container data source with the schema's default name token
    /// "geomModel" from the parent container and constructs a
    /// UsdImagingGeomModelSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    USDIMAGING_API
    static UsdImagingGeomModelSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    USDIMAGING_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    USDIMAGING_API
    static const HdDataSourceLocator &GetDefaultLocator();

    // DATA SOURCE LOCATORS FOR MEMBERS
    //
    // The following methods return an HdDataSourceLocator (relative to the
    // prim-level data source) where the data source for a member can be found.
    //
    // This is often useful for checking intersection against the
    // HdDataSourceLocatorSet sent with HdDataSourceObserver::PrimsDirtied.


    /// Prim-level relative data source locator to locate drawMode.
    USDIMAGING_API
    static const HdDataSourceLocator &GetDrawModeLocator();


    /// Returns token data source for use as drawmode value.
    /// Values of...
    /// - UsdImagingGeomModelSchemaTokens->default_
    /// - UsdImagingGeomModelSchemaTokens->origin
    /// - UsdImagingGeomModelSchemaTokens->bounds
    /// - UsdImagingGeomModelSchemaTokens->cards
    /// - UsdImagingGeomModelSchemaTokens->inherited
    ///     ...will be stored statically and reused for future calls.
    USDIMAGING_API
    static HdTokenDataSourceHandle BuildDrawmodeDataSource(
        const TfToken &drawmode);
    /// Returns token data source for use as cardgeometry value.
    /// Values of...
    /// - UsdImagingGeomModelSchemaTokens->cross
    /// - UsdImagingGeomModelSchemaTokens->box
    /// - UsdImagingGeomModelSchemaTokens->fromTexture
    ///     ...will be stored statically and reused for future calls.
    USDIMAGING_API
    static HdTokenDataSourceHandle BuildCardgeometryDataSource(
        const TfToken &cardgeometry);

};

PXR_NAMESPACE_CLOSE_SCOPE

#endif