//
// Copyright 2016 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//
#ifndef PXR_USD_SDF_TOKENS_H
#define PXR_USD_SDF_TOKENS_H

#include "pxr/pxr.h"
#include "pxr/usd/sdf/api.h"
#include "pxr/base/tf/staticTokens.h"

PXR_NAMESPACE_OPEN_SCOPE

// Miscellaneous Tokens
#define SDF_TOKENS                                      \
    ((AnyTypeToken, "__AnyType__"))

TF_DECLARE_PUBLIC_TOKENS(SdfTokens, SDF_API, SDF_TOKENS);

#define SDF_PATH_ABSOLUTE_INDICATOR_CHAR '/'
#define SDF_PATH_ABSOLUTE_INDICATOR_STR "/"
#define SDF_PATH_RELATIVE_ROOT_CHAR '.'
#define SDF_PATH_RELATIVE_ROOT_STR "."
#define SDF_PATH_CHILD_DELIMITER_CHAR '/'
#define SDF_PATH_CHILD_DELIMITER_STR "/"
#define SDF_PATH_NS_DELIMITER_CHAR ':'
#define SDF_PATH_NS_DELIMITER_STR ":"
#define SDF_PATH_RELATIONSHIP_TARGET_START_CHAR '['
#define SDF_PATH_RELATIONSHIP_TARGET_START_STR "["
#define SDF_PATH_RELATIONSHIP_TARGET_END_CHAR ']'
#define SDF_PATH_RELATIONSHIP_TARGET_END_STR "]"
#define SDF_PATH_PROPERTY_DELIMITER_CHAR '.'
#define SDF_PATH_PROPERTY_DELIMITER_STR "."

#define SDF_PATH_TOKENS                                                 \
    ((absoluteIndicator, SDF_PATH_ABSOLUTE_INDICATOR_STR))              \
    ((relativeRoot, SDF_PATH_RELATIVE_ROOT_STR))                        \
    ((childDelimiter, SDF_PATH_CHILD_DELIMITER_STR))                    \
    ((propertyDelimiter, SDF_PATH_PROPERTY_DELIMITER_STR))              \
    ((relationshipTargetStart, SDF_PATH_RELATIONSHIP_TARGET_START_STR)) \
    ((relationshipTargetEnd, SDF_PATH_RELATIONSHIP_TARGET_END_STR))     \
    ((parentPathElement, ".."))                                         \
    ((mapperIndicator, "mapper"))                                       \
    ((expressionIndicator, "expression"))                               \
    ((mapperArgDelimiter, "."))                                         \
    ((namespaceDelimiter, SDF_PATH_NS_DELIMITER_STR))                   \
    ((empty, ""))

TF_DECLARE_PUBLIC_TOKENS(SdfPathTokens, SDF_API, SDF_PATH_TOKENS);

#define SDF_METADATA_DISPLAYGROUP_TOKENS              \
    ((core, ""))                                      \
    ((internal, "Internal"))                          \
    ((dmanip, "Direct Manip"))                        \
    ((pipeline, "Pipeline"))                          \
    ((symmetry, "Symmetry"))                          \
    ((ui, "User Interface"))

TF_DECLARE_PUBLIC_TOKENS(SdfMetadataDisplayGroupTokens,
                         SDF_API,
                         SDF_METADATA_DISPLAYGROUP_TOKENS);

PXR_NAMESPACE_CLOSE_SCOPE

#endif // PXR_USD_SDF_TOKENS_H
