//
// Copyright 2023 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* ** This file is generated by a script.  Do not edit directly.  Edit     ** */
/* ** defs.py or the (*)Schema.template.h files to make changes.           ** */
/* ************************************************************************** */

#ifndef PXR_IMAGING_HD_VOLUME_FIELD_SCHEMA_H
#define PXR_IMAGING_HD_VOLUME_FIELD_SCHEMA_H

#include "pxr/imaging/hd/api.h"

#include "pxr/imaging/hd/schema.h" 

PXR_NAMESPACE_OPEN_SCOPE

//-----------------------------------------------------------------------------

#define HDVOLUMEFIELD_SCHEMA_TOKENS \
    (volumeField) \
    (filePath) \
    (fieldName) \
    (fieldIndex) \
    (fieldDataType) \
    (vectorDataRoleHint) \

TF_DECLARE_PUBLIC_TOKENS(HdVolumeFieldSchemaTokens, HD_API,
    HDVOLUMEFIELD_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------

class HdVolumeFieldSchema : public HdSchema
{
public:
    HdVolumeFieldSchema(HdContainerDataSourceHandle container)
    : HdSchema(container) {}

    //ACCESSORS

    HD_API
    HdAssetPathDataSourceHandle GetFilePath();
    HD_API
    HdTokenDataSourceHandle GetFieldName();
    HD_API
    HdIntDataSourceHandle GetFieldIndex();
    HD_API
    HdTokenDataSourceHandle GetFieldDataType();
    HD_API
    HdTokenDataSourceHandle GetVectorDataRoleHint();

    // RETRIEVING AND CONSTRUCTING

    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HD_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdAssetPathDataSourceHandle &filePath,
        const HdTokenDataSourceHandle &fieldName,
        const HdIntDataSourceHandle &fieldIndex,
        const HdTokenDataSourceHandle &fieldDataType,
        const HdTokenDataSourceHandle &vectorDataRoleHint
    );

    /// \class HdVolumeFieldSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HD_API
        Builder &SetFilePath(
            const HdAssetPathDataSourceHandle &filePath);
        HD_API
        Builder &SetFieldName(
            const HdTokenDataSourceHandle &fieldName);
        HD_API
        Builder &SetFieldIndex(
            const HdIntDataSourceHandle &fieldIndex);
        HD_API
        Builder &SetFieldDataType(
            const HdTokenDataSourceHandle &fieldDataType);
        HD_API
        Builder &SetVectorDataRoleHint(
            const HdTokenDataSourceHandle &vectorDataRoleHint);

        /// Returns a container data source containing the members set thus far.
        HD_API
        HdContainerDataSourceHandle Build();

    private:
        HdAssetPathDataSourceHandle _filePath;
        HdTokenDataSourceHandle _fieldName;
        HdIntDataSourceHandle _fieldIndex;
        HdTokenDataSourceHandle _fieldDataType;
        HdTokenDataSourceHandle _vectorDataRoleHint;
    };

    /// Retrieves a container data source with the schema's default name token
    /// "volumeField" from the parent container and constructs a
    /// HdVolumeFieldSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    HD_API
    static HdVolumeFieldSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    HD_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    HD_API
    static const HdDataSourceLocator &GetDefaultLocator();

};

PXR_NAMESPACE_CLOSE_SCOPE

#endif