//
// Copyright 2023 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdGen/schema.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_IMAGING_HD_RENDER_SETTINGS_SCHEMA_H
#define PXR_IMAGING_HD_RENDER_SETTINGS_SCHEMA_H

#include "pxr/imaging/hd/api.h"
#include "pxr/imaging/hd/vectorSchemaTypeDefs.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

//-----------------------------------------------------------------------------

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

//-----------------------------------------------------------------------------

#define HD_RENDER_SETTINGS_SCHEMA_TOKENS \
    (renderSettings) \
    (namespacedSettings) \
    (active) \
    (renderProducts) \
    (includedPurposes) \
    (materialBindingPurposes) \
    (renderingColorSpace) \
    (shutterInterval) \

TF_DECLARE_PUBLIC_TOKENS(HdRenderSettingsSchemaTokens, HD_API,
    HD_RENDER_SETTINGS_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------
class HdRenderSettingsSchema : public HdSchema
{
public:
    HdRenderSettingsSchema(HdContainerDataSourceHandle container)
    : HdSchema(container) {}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    //ACCESSORS


    HD_API
    HdContainerDataSourceHandle GetNamespacedSettings();

    HD_API
    HdBoolDataSourceHandle GetActive();

    HD_API
    HdRenderProductVectorSchema GetRenderProducts();

    HD_API
    HdTokenArrayDataSourceHandle GetIncludedPurposes();

    HD_API
    HdTokenArrayDataSourceHandle GetMaterialBindingPurposes();

    HD_API
    HdTokenDataSourceHandle GetRenderingColorSpace();


    // Frame-relative time interval representing the sampling window for data
    // relevant to motion blur. Renderers can use this interval when querying
    // time-sampled data (e.g., xforms, points, velocities, ...) to simulate
    // motion blur effects. Note: This closely relates to the (frame-
    // relative) shutter interval of a camera specified via shutter open and
    // close times and is expected to span the union of the shutter intervals
    // of cameras used in generating the render artifacts.

    HD_API
    HdVec2dDataSourceHandle GetShutterInterval();

    // RETRIEVING AND CONSTRUCTING

    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HD_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdContainerDataSourceHandle &namespacedSettings,
        const HdBoolDataSourceHandle &active,
        const HdVectorDataSourceHandle &renderProducts,
        const HdTokenArrayDataSourceHandle &includedPurposes,
        const HdTokenArrayDataSourceHandle &materialBindingPurposes,
        const HdTokenDataSourceHandle &renderingColorSpace,
        const HdVec2dDataSourceHandle &shutterInterval
    );

    /// \class HdRenderSettingsSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HD_API
        Builder &SetNamespacedSettings(
            const HdContainerDataSourceHandle &namespacedSettings);
        HD_API
        Builder &SetActive(
            const HdBoolDataSourceHandle &active);
        HD_API
        Builder &SetRenderProducts(
            const HdVectorDataSourceHandle &renderProducts);
        HD_API
        Builder &SetIncludedPurposes(
            const HdTokenArrayDataSourceHandle &includedPurposes);
        HD_API
        Builder &SetMaterialBindingPurposes(
            const HdTokenArrayDataSourceHandle &materialBindingPurposes);
        HD_API
        Builder &SetRenderingColorSpace(
            const HdTokenDataSourceHandle &renderingColorSpace);
        HD_API
        Builder &SetShutterInterval(
            const HdVec2dDataSourceHandle &shutterInterval);

        /// Returns a container data source containing the members set thus far.
        HD_API
        HdContainerDataSourceHandle Build();

    private:
        HdContainerDataSourceHandle _namespacedSettings;
        HdBoolDataSourceHandle _active;
        HdVectorDataSourceHandle _renderProducts;
        HdTokenArrayDataSourceHandle _includedPurposes;
        HdTokenArrayDataSourceHandle _materialBindingPurposes;
        HdTokenDataSourceHandle _renderingColorSpace;
        HdVec2dDataSourceHandle _shutterInterval;
    };

    /// Retrieves a container data source with the schema's default name token
    /// "renderSettings" from the parent container and constructs a
    /// HdRenderSettingsSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    HD_API
    static HdRenderSettingsSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    HD_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    HD_API
    static const HdDataSourceLocator &GetDefaultLocator();

    // DATA SOURCE LOCATORS FOR MEMBERS
    //
    // The following methods return an HdDataSourceLocator (relative to the
    // prim-level data source) where the data source for a member can be found.
    //
    // This is often useful for checking intersection against the
    // HdDataSourceLocatorSet sent with HdDataSourceObserver::PrimsDirtied.


    /// Prim-level relative data source locator to locate namespacedSettings.
    HD_API
    static const HdDataSourceLocator &GetNamespacedSettingsLocator();

    /// Prim-level relative data source locator to locate active.
    HD_API
    static const HdDataSourceLocator &GetActiveLocator();

    /// Prim-level relative data source locator to locate renderProducts.
    HD_API
    static const HdDataSourceLocator &GetRenderProductsLocator();

    /// Prim-level relative data source locator to locate includedPurposes.
    HD_API
    static const HdDataSourceLocator &GetIncludedPurposesLocator();

    /// Prim-level relative data source locator to locate materialBindingPurposes.
    HD_API
    static const HdDataSourceLocator &GetMaterialBindingPurposesLocator();

    /// Prim-level relative data source locator to locate renderingColorSpace.
    HD_API
    static const HdDataSourceLocator &GetRenderingColorSpaceLocator();

    /// Prim-level relative data source locator to locate shutterInterval.
    HD_API
    static const HdDataSourceLocator &GetShutterIntervalLocator();


};

PXR_NAMESPACE_CLOSE_SCOPE

#endif