//
// Copyright 2023 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdGen/schema.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_IMAGING_HD_LEGACY_DISPLAY_STYLE_SCHEMA_H
#define PXR_IMAGING_HD_LEGACY_DISPLAY_STYLE_SCHEMA_H

#include "pxr/imaging/hd/api.h"

#include "pxr/imaging/hd/schema.h" 

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

//-----------------------------------------------------------------------------

#define HD_LEGACY_DISPLAY_STYLE_SCHEMA_TOKENS \
    (displayStyle) \
    (refineLevel) \
    (flatShadingEnabled) \
    (displacementEnabled) \
    (occludedSelectionShowsThrough) \
    (pointsShadingEnabled) \
    (materialIsFinal) \
    (shadingStyle) \
    (reprSelector) \
    (cullStyle) \

TF_DECLARE_PUBLIC_TOKENS(HdLegacyDisplayStyleSchemaTokens, HD_API,
    HD_LEGACY_DISPLAY_STYLE_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------

class HdLegacyDisplayStyleSchema : public HdSchema
{
public:
    HdLegacyDisplayStyleSchema(HdContainerDataSourceHandle container)
    : HdSchema(container) {}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    //ACCESSORS


    HD_API
    HdIntDataSourceHandle GetRefineLevel();

    HD_API
    HdBoolDataSourceHandle GetFlatShadingEnabled();

    HD_API
    HdBoolDataSourceHandle GetDisplacementEnabled();

    HD_API
    HdBoolDataSourceHandle GetOccludedSelectionShowsThrough();

    HD_API
    HdBoolDataSourceHandle GetPointsShadingEnabled();

    HD_API
    HdBoolDataSourceHandle GetMaterialIsFinal();

    HD_API
    HdTokenDataSourceHandle GetShadingStyle();

    HD_API
    HdTokenArrayDataSourceHandle GetReprSelector();

    HD_API
    HdTokenDataSourceHandle GetCullStyle();

    // RETRIEVING AND CONSTRUCTING

    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HD_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdIntDataSourceHandle &refineLevel,
        const HdBoolDataSourceHandle &flatShadingEnabled,
        const HdBoolDataSourceHandle &displacementEnabled,
        const HdBoolDataSourceHandle &occludedSelectionShowsThrough,
        const HdBoolDataSourceHandle &pointsShadingEnabled,
        const HdBoolDataSourceHandle &materialIsFinal,
        const HdTokenDataSourceHandle &shadingStyle,
        const HdTokenArrayDataSourceHandle &reprSelector,
        const HdTokenDataSourceHandle &cullStyle
    );

    /// \class HdLegacyDisplayStyleSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HD_API
        Builder &SetRefineLevel(
            const HdIntDataSourceHandle &refineLevel);
        HD_API
        Builder &SetFlatShadingEnabled(
            const HdBoolDataSourceHandle &flatShadingEnabled);
        HD_API
        Builder &SetDisplacementEnabled(
            const HdBoolDataSourceHandle &displacementEnabled);
        HD_API
        Builder &SetOccludedSelectionShowsThrough(
            const HdBoolDataSourceHandle &occludedSelectionShowsThrough);
        HD_API
        Builder &SetPointsShadingEnabled(
            const HdBoolDataSourceHandle &pointsShadingEnabled);
        HD_API
        Builder &SetMaterialIsFinal(
            const HdBoolDataSourceHandle &materialIsFinal);
        HD_API
        Builder &SetShadingStyle(
            const HdTokenDataSourceHandle &shadingStyle);
        HD_API
        Builder &SetReprSelector(
            const HdTokenArrayDataSourceHandle &reprSelector);
        HD_API
        Builder &SetCullStyle(
            const HdTokenDataSourceHandle &cullStyle);

        /// Returns a container data source containing the members set thus far.
        HD_API
        HdContainerDataSourceHandle Build();

    private:
        HdIntDataSourceHandle _refineLevel;
        HdBoolDataSourceHandle _flatShadingEnabled;
        HdBoolDataSourceHandle _displacementEnabled;
        HdBoolDataSourceHandle _occludedSelectionShowsThrough;
        HdBoolDataSourceHandle _pointsShadingEnabled;
        HdBoolDataSourceHandle _materialIsFinal;
        HdTokenDataSourceHandle _shadingStyle;
        HdTokenArrayDataSourceHandle _reprSelector;
        HdTokenDataSourceHandle _cullStyle;
    };

    /// Retrieves a container data source with the schema's default name token
    /// "displayStyle" from the parent container and constructs a
    /// HdLegacyDisplayStyleSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    HD_API
    static HdLegacyDisplayStyleSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    HD_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    HD_API
    static const HdDataSourceLocator &GetDefaultLocator();

    // DATA SOURCE LOCATORS FOR MEMBERS
    //
    // The following methods return an HdDataSourceLocator (relative to the
    // prim-level data source) where the data source for a member can be found.
    //
    // This is often useful for checking intersection against the
    // HdDataSourceLocatorSet sent with HdDataSourceObserver::PrimsDirtied.


    /// Prim-level relative data source locator to locate reprSelector.
    HD_API
    static const HdDataSourceLocator &GetReprSelectorLocator();

    /// Prim-level relative data source locator to locate cullStyle.
    HD_API
    static const HdDataSourceLocator &GetCullStyleLocator();


};

PXR_NAMESPACE_CLOSE_SCOPE

#endif