//
// Copyright 2023 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* ** This file is generated by a script.  Do not edit directly.  Edit     ** */
/* ** defs.py or the (*)Schema.template.h files to make changes.           ** */
/* ************************************************************************** */

#ifndef PXR_IMAGING_HD_INSTANCE_SCHEMA_H
#define PXR_IMAGING_HD_INSTANCE_SCHEMA_H

#include "pxr/imaging/hd/api.h"

#include "pxr/imaging/hd/schema.h" 

PXR_NAMESPACE_OPEN_SCOPE

//-----------------------------------------------------------------------------

#define HD_INSTANCE_SCHEMA_TOKENS \
    (instance) \
    (instancer) \
    (prototypeIndex) \
    (instanceIndex) \

TF_DECLARE_PUBLIC_TOKENS(HdInstanceSchemaTokens, HD_API,
    HD_INSTANCE_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------
// This schema can be considered the opposite of instancerTopology's
// "instanceLocations". When the scene coalesces scene prims into multiple
// instances of a single prototype, it inserts "instance" prims at the site of
// de-duplication. The instancer prim added to manage the prototype uses
// "instanceLocations" to point back to all of these instance prims.
//
// The instance prims aren't directly useful for rendering but can be useful
// for scene processing and data aggregation.
//

class HdInstanceSchema : public HdSchema
{
public:
    HdInstanceSchema(HdContainerDataSourceHandle container)
    : HdSchema(container) {}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    //ACCESSORS


    // Path to instancer for which a (sub-)entry was added to its
    // instancerTopology's instanceIndices during instance aggregation to
    // account for this instance. Note that instanceIndices is nested, that
    // is a vector data source containing integer arrays, one for each
    // prototype the instancer is instancing. Thus, we need two indices to
    // identify the entry: prototypeIndex is the outer index and
    // instanceIndex the inner index.
    HD_API
    HdPathDataSourceHandle GetInstancer();

    // Index into vector data source at instancer's instancerTopology's
    // instanceIndices to find entry corresponding to this instance.
    HD_API
    HdIntDataSourceHandle GetPrototypeIndex();

    // Index into int array within the vector data source at instancer's
    // instancerTopology's instanceIndices to find entry corresponding to
    // this instance.
    HD_API
    HdIntDataSourceHandle GetInstanceIndex();

    // RETRIEVING AND CONSTRUCTING

    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HD_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdPathDataSourceHandle &instancer,
        const HdIntDataSourceHandle &prototypeIndex,
        const HdIntDataSourceHandle &instanceIndex
    );

    /// \class HdInstanceSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HD_API
        Builder &SetInstancer(
            const HdPathDataSourceHandle &instancer);
        HD_API
        Builder &SetPrototypeIndex(
            const HdIntDataSourceHandle &prototypeIndex);
        HD_API
        Builder &SetInstanceIndex(
            const HdIntDataSourceHandle &instanceIndex);

        /// Returns a container data source containing the members set thus far.
        HD_API
        HdContainerDataSourceHandle Build();

    private:
        HdPathDataSourceHandle _instancer;
        HdIntDataSourceHandle _prototypeIndex;
        HdIntDataSourceHandle _instanceIndex;
    };

    /// Retrieves a container data source with the schema's default name token
    /// "instance" from the parent container and constructs a
    /// HdInstanceSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    HD_API
    static HdInstanceSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    HD_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    HD_API
    static const HdDataSourceLocator &GetDefaultLocator();

};

PXR_NAMESPACE_CLOSE_SCOPE

#endif