//
// Copyright 2023 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdGen/schema.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_IMAGING_HD_EXT_COMPUTATION_PRIMVAR_SCHEMA_H
#define PXR_IMAGING_HD_EXT_COMPUTATION_PRIMVAR_SCHEMA_H

#include "pxr/imaging/hd/api.h"

#include "pxr/imaging/hd/primvarSchema.h"


PXR_NAMESPACE_OPEN_SCOPE

//-----------------------------------------------------------------------------

#define HD_EXT_COMPUTATION_PRIMVAR_SCHEMA_TOKENS \
    (interpolation) \
    (role) \
    (sourceComputation) \
    (sourceComputationOutputName) \
    (valueType) \

TF_DECLARE_PUBLIC_TOKENS(HdExtComputationPrimvarSchemaTokens, HD_API,
    HD_EXT_COMPUTATION_PRIMVAR_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------

class HdExtComputationPrimvarSchema : public HdSchema
{
public:
    HdExtComputationPrimvarSchema(HdContainerDataSourceHandle container)
    : HdSchema(container) {}

// --(BEGIN CUSTOM CODE: Schema Methods)--

    // these return statically allocated instances for the common cases.
    static HdTokenDataSourceHandle BuildInterpolationDataSource(
            TfToken interpolation) {
        return HdPrimvarSchema::BuildInterpolationDataSource(interpolation);
    }

    static HdTokenDataSourceHandle BuildRoleDataSource(TfToken role) {
        return HdPrimvarSchema::BuildRoleDataSource(role);
    }

// --(END CUSTOM CODE: Schema Methods)--

    //ACCESSORS

    HD_API
    HdTokenDataSourceHandle GetInterpolation();
    HD_API
    HdTokenDataSourceHandle GetRole();
    HD_API
    HdPathDataSourceHandle GetSourceComputation();
    HD_API
    HdTokenDataSourceHandle GetSourceComputationOutputName();
    HD_API
    HdTupleTypeDataSourceHandle GetValueType();

    // RETRIEVING AND CONSTRUCTING

    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HD_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdTokenDataSourceHandle &interpolation,
        const HdTokenDataSourceHandle &role,
        const HdPathDataSourceHandle &sourceComputation,
        const HdTokenDataSourceHandle &sourceComputationOutputName,
        const HdTupleTypeDataSourceHandle &valueType
    );

    /// \class HdExtComputationPrimvarSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HD_API
        Builder &SetInterpolation(
            const HdTokenDataSourceHandle &interpolation);
        HD_API
        Builder &SetRole(
            const HdTokenDataSourceHandle &role);
        HD_API
        Builder &SetSourceComputation(
            const HdPathDataSourceHandle &sourceComputation);
        HD_API
        Builder &SetSourceComputationOutputName(
            const HdTokenDataSourceHandle &sourceComputationOutputName);
        HD_API
        Builder &SetValueType(
            const HdTupleTypeDataSourceHandle &valueType);

        /// Returns a container data source containing the members set thus far.
        HD_API
        HdContainerDataSourceHandle Build();

    private:
        HdTokenDataSourceHandle _interpolation;
        HdTokenDataSourceHandle _role;
        HdPathDataSourceHandle _sourceComputation;
        HdTokenDataSourceHandle _sourceComputationOutputName;
        HdTupleTypeDataSourceHandle _valueType;
    };

};

PXR_NAMESPACE_CLOSE_SCOPE

#endif