/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ig extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DE = "Jaman\u1ecb";
        final String metaValue_RO = "Romania";
        final String metaValue_lo = "La\u1ecd";
        final String metaValue_or = "\u1eccd\u1ecba";
        final String metaValue_si = "Sinhala";
        final String metaValue_te = "Tel\u1ee5g\u1ee5";
        final Object[][] data = new Object[][] {
            { "sbp", "Sang\u1ee5" },
            { "ksh", "Cologn\u1ecban" },
            { "nyn", "Nyak\u1ecdle" },
            { "Zsym", "Akara" },
            { "fil", "F\u1ecbl\u1ecbp\u1ecbn\u1ecd" },
            { "hmn", "Hmong" },
            { "Zsye", "Emoj\u1ecb" },
            { "ccp", "Chakma" },
            { "luy", "L\u1ee5y\u1ecba" },
            { "es_ES", "Spanishi nd\u1ecb Europe" },
            { "teo", "Tes\u1ecd" },
            { "AC", "Ascension Island" },
            { "AD", "Andorra" },
            { "AE", "United Arab Emirates" },
            { "AF", "Afghanistan" },
            { "af", "Afrikaans" },
            { "AG", "Antigua na Barbuda" },
            { "type.ca.ethiopic", "Kal\u1ecbnda Etop\u1ecba" },
            { "AI", "Anguilla" },
            { "ak", "Akan" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "am", "Amariik\u1ecb" },
            { "Arab", "Mkp\u1ee5r\u1ee5 Okwu Arabic" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "Jpan", "Japanese" },
            { "AR", "Argentina" },
            { "ar", "Arabiik\u1ecb" },
            { "Hrkt", "mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Japan\u1ecbs\u1ecb" },
            { "AS", "American Samoa" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "Bekee nd\u1ecb America" },
            { "AX", "Agwaetiti Aland" },
            { "AZ", "Azerbaijan" },
            { "az", "Azerbajan\u1ecb" },
            { "BA", "Bosnia & Herzegovina" },
            { "BB", "Barbados" },
            { "ceb", "Ceb\u1ee5an\u1ecd" },
            { "BD", "Bangladesh" },
            { "BE", "Belgium" },
            { "be", "Belarusian\u1ee5" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "bg", "B\u1ecdl\u1ee5gar\u1ecba" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Binin" },
            { "BL", "Barth\u00e9lemy D\u1ecb ns\u1ecd" },
            { "BM", "Bemuda" },
            { "bm", "Bambara" },
            { "BN", "Brunei" },
            { "bn", "Bengali" },
            { "BO", "Bolivia" },
            { "bo", "Tibetan" },
            { "BQ", "Caribbean Netherlands" },
            { "BR", "Brazil" },
            { "br", "Breton" },
            { "BS", "Bahamas" },
            { "bs", "Bosnia" },
            { "xog", "S\u1ecdga" },
            { "BT", "Bhutan" },
            { "BV", "Agwaetiti Bouvet" },
            { "BW", "Botswana" },
            { "Mymr", "Myanmar" },
            { "type.nu.laoo", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 La\u1ecd" },
            { "BY", "Belarus" },
            { "seh", "Sena" },
            { "BZ", "Belize" },
            { "type.ca.persian", "Kal\u1ecbnda Persian" },
            { "type.nu.hebr", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Hebrew" },
            { "CA", "Kanada" },
            { "ca", "Catalan" },
            { "CC", "Agwaetiti Cocos (Keeling)" },
            { "mzn", "Mazandaran\u1ecb" },
            { "ses", "K\u1ecdyraboro Sen\u1ecb" },
            { "CD", "Congo - Kinshasa" },
            { "ce", "Chechen" },
            { "CF", "Central African Republik" },
            { "CG", "Congo" },
            { "CH", "Switzerland" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Agwaetiti Cook" },
            { "CL", "Chile" },
            { "CM", "Cameroon" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "co", "K\u1ecds\u1ecban" },
            { "CP", "Agwaetiti Clipperton" },
            { "Orya", metaValue_or },
            { "CR", "Kosta Rika" },
            { "cs", "Cheek\u1ecb" },
            { "CU", "Cuba" },
            { "cu", "Church slavic" },
            { "CV", "Cape Verde" },
            { "CW", "Kurakao" },
            { "CX", "Agwaetiti Christmas" },
            { "CY", "Cyprus" },
            { "cy", "Wesh" },
            { "CZ", "Czechia" },
            { "type.nu.ethi", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Et\u1ecdp\u1ecba" },
            { "da", "Dan\u1ecbsh" },
            { "pt_PT", "As\u1ee5s\u1ee5 Portuguese nd\u1ecb Europe" },
            { "de", metaValue_DE },
            { "DE", metaValue_DE },
            { "DG", "Diego Garcia" },
            { "type.cf.standard", "\u1ee4s\u1ecdr\u1ecd eg\u1ecd nz\u1ee5gbe" },
            { "type.nu.deva", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Devanagar\u1ecb" },
            { "DJ", "Djibouti" },
            { "DK", "Denmark" },
            { "Brai", "Bra\u1ecblle" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "\u1ecdbere \u1ecdn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Armen\u1ecban" },
            { "DO", "Dominican Republik" },
            { "es_419", "Spanishi nd\u1ecb Latin America" },
            { "DZ", "Algeria" },
            { "dz", "D\u1ecdzng\u1ecdka" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Kal\u1ecbnda Chinese" },
            { "EA", "Ceuta & Melilla" },
            { "EC", "Ecuador" },
            { "dje", "Zarma" },
            { "type.nu.grek", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Greek" },
            { "EE", "Estonia" },
            { "ee", "Ewe" },
            { "type.lb.normal", "Akara akanka nkw\u1ee5s\u1ecb kwes\u1ecbr\u1ecb" },
            { "EG", "Egypt" },
            { "EH", "\u1eccd\u1ecbda Anyanw\u1ee5 Sahara" },
            { "el", "Giriik\u1ecb" },
            { "en", "Bekee" },
            { "eo", "Nd\u1ecb Esperant\u1ecd" },
            { "chr", "Cheroke" },
            { "ER", "Eritrea" },
            { "ES", "Spain" },
            { "es", "Spanishi" },
            { "ET", "Ethiopia" },
            { "et", "Nd\u1ecb Est\u1ecdn\u1ecba" },
            { "Hanb", "Han na Bopomofo" },
            { "EU", "Otu nzuk\u1ecd mba Europe" },
            { "eu", "Baskwe" },
            { "Hang", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Hang\u1ee5l" },
            { "type.ca.gregorian", "Kalenda Gregory" },
            { "EZ", "Gburugburu Euro" },
            { "shi", "Tach\u1ecbk\u1ecbt" },
            { "type.nu.gujr", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 G\u1ee5jarat\u1ecb" },
            { "hsb", "\u1ee4pa S\u1ecdrb\u1ecba" },
            { "Hani", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Han" },
            { "fa", "Peshian\u1ee5" },
            { "Hans", "Nke d\u1ecb mfe" },
            { "type.nu.latn", "\u1eccn\u1ee5 \u1eccg\u1ee5g\u1ee5 Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5" },
            { "Hant", "Izugbe" },
            { "ff", "Fula" },
            { "FI", "Finland" },
            { "fi", "F\u1ecbn\u1ecbsh" },
            { "FJ", "Fiji" },
            { "FK", "Agwaetiti Falkland" },
            { "FM", "Micronesia" },
            { "yue", "Kat\u1ecdn\u1ecbse" },
            { "FO", "Agwaetiti Faroe" },
            { "fo", "Far\u1ecdse" },
            { "Taml", "Tam\u1ecbl" },
            { "FR", "France" },
            { "fr", "F\u1ee5rench\u1ecb" },
            { "fy", "Westan Fr\u1ecbs\u1ecban" },
            { "GA", "Gabon" },
            { "ga", "\u1ecar\u1ecbsh" },
            { "GB", "United Kingdom" },
            { "pcm", "Pidg\u1ecbn" },
            { "GD", "Grenada" },
            { "gd", "S\u1ee5k\u1ecdt\u1ecbs Gel\u1ecb" },
            { "GE", "Georgia" },
            { "GF", "Frenchi Guiana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "gl", "Gal\u1ecbc\u1ecban" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatorial Guinea" },
            { "und", "As\u1ee5s\u1ee5 amagh\u1ecb" },
            { "GR", "Greece" },
            { "GS", "South Georgia na Agwaetiti South Sandwich" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "gu", "G\u1ee5arat\u1ecb" },
            { "gv", "Mans\u1ecb" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "ha", "Hausa" },
            { "zxx", "Nd\u1ecb \u1ecdz\u1ecd ab\u1ee5gh\u1ecb as\u1ee5s\u1ee5" },
            { "he", "Hebrew" },
            { "hi", "Hind\u1ecb" },
            { "de_AT", "Jaman nd\u1ecb Austria" },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Agwaetiti Heard na Agwaetiti McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "hr", "K\u1ecdr\u1ecdt\u1ecban" },
            { "agq", "Aghem" },
            { "gsw", "German Swiss" },
            { "HT", "Hati" },
            { "ht", "Ha\u1ecbt\u1ecban nd\u1ecb Cer\u1ecdle" },
            { "HU", "Hungary" },
            { "hu", "H\u1ee5ngarian" },
            { "ia", "Intal\u1ecbg\u1ee5a" },
            { "IC", "Agwaetiti Kanar\u1ecb" },
            { "Jamo", "Jam\u1ecd" },
            { "ID", "Indonesia" },
            { "id", "Indonisia" },
            { "type.nu.tibt", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 T\u1ecbbeta" },
            { "IE", "Ireland" },
            { "ig", "Igbo" },
            { "naq", "Nama" },
            { "ii", "S\u1ecbch\u1ee5ay\u1ecb" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "British Indian Ocean Territory" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Iceland" },
            { "is", "Ic\u1ecbland\u1ecbk" },
            { "IT", "Italy" },
            { "it", "Ital\u1ecbanu" },
            { "Zmth", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Mgbak\u1ecd" },
            { "type.nu.thai", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Ta\u1ecb" },
            { "type.nu.beng", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Bang" },
            { "ja", "Japaniisi" },
            { "Mlym", "Malayala" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Kal\u1ecbnda Islam" },
            { "JM", "Jamaika" },
            { "Beng", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Bangla" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "jv", "Java" },
            { "guz", "G\u1ee5sh\u1ecb" },
            { "type.nu.knda", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Kanada" },
            { "de_CH", "Jaman Izugbe nd\u1ecb Switzerland" },
            { "mai", "Ma\u1ecbt\u1ecbl\u1ecb" },
            { "smn", "Inar\u1ecb Sam\u1ecb" },
            { "ka", "Ge\u1ecdj\u1ecban" },
            { "type.ca.buddhist", "Kal\u1ecbnda B\u1ee5dd\u1ecbst" },
            { "KE", "Kenya" },
            { "419", "Latin America" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Cambodia" },
            { "KI", "Kiribati" },
            { "ki", "K\u1ecbk\u1ee5y\u1ee5" },
            { "mas", "Masa\u1ecb" },
            { "kk", "Kazak" },
            { "kl", "Kalaal\u1ecbs\u1ee5t" },
            { "KM", "Comorosu" },
            { "km", "Keme" },
            { "KN", "Kitts na Nevis D\u1ecb ns\u1ecd" },
            { "kn", "Kanhada" },
            { "Knda", "Kannaada" },
            { "fr_CA", "F\u1ee5rench nd\u1ecb Canada" },
            { "ko", "Kor\u1ecba" },
            { "KP", "Ugwu Korea" },
            { "KR", "South Korea" },
            { "ks", "Kashm\u1ecbr\u1ecb" },
            { "ku", "Nd\u1ecb K\u1ee5rd\u1ecbsh" },
            { "fr_CH", "F\u1ee5rench nd\u1ecb Switzerland" },
            { "KW", "Kuwait" },
            { "kw", "K\u1ecdn\u1ecbsh" },
            { "KY", "Agwaetiti Cayman" },
            { "ky", "Kyrayz" },
            { "KZ", "Kazakhstan" },
            { "Cyrl", "Mkp\u1ee5r\u1ee5 Okwu Cyrillic" },
            { "LA", "Laos" },
            { "la", "Lat\u1ecbn" },
            { "LB", "Lebanon" },
            { "lb", "L\u1ee5xenb\u1ecd\u1ee5g\u1ecbsh" },
            { "LC", "Lucia D\u1ecb ns\u1ecd" },
            { "type.nu.mlym", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Malayala" },
            { "lg", "Ganda" },
            { "nds", "Lowa German" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "Tibt", "T\u1ecbbeta" },
            { "ln", "L\u1ecbngala" },
            { "fur", "Fr\u1ee5l\u1ecban" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u1ee4s\u1ecdr\u1ecd Mmesh\u1ecd \u1ecbmper\u1ecba" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lithuania" },
            { "lt", "Lituanian" },
            { "LU", "Luxembourg" },
            { "lu", "L\u1ecbba-Katanga" },
            { "LV", "Latvia" },
            { "lv", "Latviani" },
            { "Kana", "Katakana" },
            { "LY", "Libia" },
            { "vun", "V\u1ee5nj\u1ecd" },
            { "lag", "Lang\u1ecb" },
            { "Thaa", "Taa" },
            { "MA", "Morocco" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Martin D\u1ecb ns\u1ecd" },
            { "MG", "Madagaskar" },
            { "mg", "Malagas\u1ecb" },
            { "MH", "Agwaetiti Marshall" },
            { "mi", "Ma\u1ecdr\u1ecb" },
            { "MK", "North Macedonia" },
            { "mk", "Mased\u1ecdn\u1ecba" },
            { "ML", "Mali" },
            { "ml", "Malayalam" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "mn", "M\u1ecdngol\u1ecban" },
            { "MO", "Macao SAR China" },
            { "MP", "Agwaetiti Northern Mariana" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "mr", "Marat\u1ecb" },
            { "MS", "Montserrat" },
            { "ms", "Maleyi" },
            { "MT", "Malta" },
            { "mt", "Mat\u1ecbse" },
            { "MU", "Mauritius" },
            { "MV", "Maldivesa" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "type.ca.japanese", "Kal\u1ecbnda Japanese" },
            { "MY", "Malaysia" },
            { "my", "B\u1ee5rmese" },
            { "MZ", "Mozambik" },
            { "Armn", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Armen\u1ecban" },
            { "dsb", "Lowa Sorb\u1ecban" },
            { "NA", "Namibia" },
            { "type.co.search", "\u1eccch\u1ee5ch\u1ee5 n\u1ecble" },
            { "202", "Sub-Saharan Afr\u1ecbka" },
            { "nb", "N\u1ecdrwey\u1ecban B\u1ecdkmal" },
            { "type.ca.hebrew", "Kal\u1ecbnda Hebrew" },
            { "NC", "New Caledonia" },
            { "nd", "N\u1ecdrt\u1ee5 Ndabede" },
            { "NE", "Niger" },
            { "ne", "Nepali" },
            { "NF", "Agwaetiti Norfolk" },
            { "NG", "Na\u1ecbj\u1ecbr\u1ecba" },
            { "NI", "Nicaragua" },
            { "NL", "Netherlands" },
            { "nl", "D\u1ecdch\u1ecb" },
            { "nn", "N\u1ecdrwey\u1ecban Nynersk" },
            { "NO", "Norway" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "R\u1ecdmb\u1ecd" },
            { "ny", "Nyanja" },
            { "NZ", "New Zealand" },
            { "kab", "Kabyle" },
            { "kam", "Kamba" },
            { "mer", "Mer\u1ee5" },
            { "type.nu.armn", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Armen\u1ecban" },
            { "OM", "Oman" },
            { "om", "\u1eccromo" },
            { "or", metaValue_or },
            { "os", "Osetik" },
            { "mfe", "M\u1ecdr\u1ecbsye" },
            { "PA", "Panama" },
            { "pa", "Punjabi" },
            { "dua", "D\u1ee5ala" },
            { "en_GB", "Bekee nd\u1ecb United Kingdom" },
            { "PE", "Peru" },
            { "PF", "Frenchi Polynesia" },
            { "PG", "Papua New Guinea" },
            { "PH", "Philippines" },
            { "PK", "Pakistan" },
            { "PL", "Poland" },
            { "pl", "Poliishi" },
            { "ewo", "Ew\u1ecdnd\u1ecd" },
            { "PM", "Pierre na Miquelon D\u1ecb ns\u1ecd" },
            { "PN", "Agwaetiti Pitcairn" },
            { "type.ca.dangi", "Kal\u1ecbnda Dang" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinian Territories" },
            { "ps", "Pash\u1ecd" },
            { "PT", "Portugal" },
            { "pt", "P\u1ecdrt\u1ee5g\u1ee5ese" },
            { "key.co", "\u1ee4s\u1ecdr\u1ecd Nhaz\u1ecb" },
            { "PW", "Palau" },
            { "type.nu.greklow", "\u1eccbere \u1ecdn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Greek" },
            { "PY", "Paraguay" },
            { "pt_BR", "P\u1ecdrt\u1ee5g\u1ee5ese nd\u1ecb Brazil" },
            { "mgh", "Mak\u1ee5wa Met\u1ecd" },
            { "Hebr", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Hebrew" },
            { "key.cf", "\u1ee4s\u1ecdr\u1ecd eg\u1ecd" },
            { "QA", "Qatar" },
            { "key.ca", "Kal\u1ecbnda" },
            { "Laoo", metaValue_lo },
            { "mgo", "Meta" },
            { "type.hc.h23", "\u1ee4s\u1ecdr\u1ecd Oge ok\u1ecbr\u1ecbk\u1ecbr\u1ecb 24" },
            { "type.hc.h24", "\u1ee4s\u1ecdr\u1ecd \u1eccge ok\u1ecbr\u1ecbk\u1ecbr\u1ecb 24" },
            { "type.nu.mymr", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Myamar" },
            { "QO", "Outlying Oceania" },
            { "qu", "Q\u1ee5ech\u1ee5a" },
            { "brx", "B\u1ecdd\u1ecd" },
            { "kde", "Mak\u1ecdnde" },
            { "001", "Uwa" },
            { "Ethi", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Et\u1ecdp\u1ecba" },
            { "002", "Afrika" },
            { "003", "Mpaghara Ugwu Amer\u1ecbka" },
            { "RE", "R\u00e9union" },
            { "type.hc.h12", "\u1ee4s\u1ecdr\u1ecd Oge ok\u1ecbr\u1ecbk\u1ecbri 12" },
            { "005", "Mpaghara Mgbada Ugwu America" },
            { "type.hc.h11", "\u1ee4s\u1ecdr\u1ecd \u1eccge \u1ecdk\u1ecbr\u1ecbk\u1ecbri 12" },
            { "009", "Oceania" },
            { "rm", "R\u1ecdmans\u1ecb" },
            { "rn", "R\u1ee5nd\u1ecb" },
            { "key.cu", "Eg\u1ecd" },
            { "ro", metaValue_RO },
            { "RO", metaValue_RO },
            { "RS", "Serbia" },
            { "type.nu.orya", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 \u1eccd\u1ecba" },
            { "type.nu.hanidec", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 nt\u1ee5p\u1ecd Ch\u1ecbnese" },
            { "RU", "R\u1ee5ss\u1ecba" },
            { "ru", "R\u1ecdshian" },
            { "RW", "Rwanda" },
            { "rw", "Kinyarwanda" },
            { "kea", "Kab\u1ee5verd\u1ecban\u1ee5" },
            { "en_AU", "Bekee nd\u1ecb Australia" },
            { "SA", "Saudi Arabia" },
            { "sa", "Sans\u1ecbk\u1ecbt" },
            { "SB", "Agwaetiti Solomon" },
            { "twq", "Tasawa" },
            { "011", "Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Afr\u1ecbka" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "sd", "S\u1ecbndh" },
            { "013", "Etiti America" },
            { "SE", "Sweden" },
            { "se", "N\u1ecdrtan Sam\u1ecb" },
            { "014", "Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Afr\u1ecbka" },
            { "015", "Mpaghara Ugwu Afr\u1ecbka" },
            { "SG", "Singapore" },
            { "sg", "Sang\u1ecd" },
            { "SH", "St. Helena" },
            { "type.lb.strict", "Akara akanka nkw\u1ee5s\u1ecb s\u1ecbr\u1ecb \u1ecbke" },
            { "si", metaValue_si },
            { "017", "Etiti Afr\u1ecbka" },
            { "SI", "Slovenia" },
            { "018", "Mpaghara Mgbada Ugwu Afr\u1ecbka" },
            { "SJ", "Svalbard & Jan Mayen" },
            { "019", "Amer\u1ecbka" },
            { "SK", "Slovakia" },
            { "sk", "Slova" },
            { "SL", "Sierra Leone" },
            { "sl", "Slov\u1ecban" },
            { "SM", "San Marino" },
            { "sm", "Sam\u1ecda" },
            { "SN", "Senegal" },
            { "sn", "Sh\u1ecdna" },
            { "SO", "Somalia" },
            { "so", "Somali" },
            { "type.nu.arab", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Arab na Ind\u1ecb" },
            { "type.nu.taml", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 \u1ecdd\u1ecbnala Tam\u1ecbl" },
            { "SR", "Suriname" },
            { "sr", "Seb\u1ecban" },
            { "SS", "South Sudan" },
            { "type.cf.account", "\u1ee4s\u1ecdr\u1ecd akant\u1ee5 eg\u1ecd" },
            { "ST", "S\u00e3o Tom\u00e9 & Pr\u00edncipe" },
            { "st", "S\u1ecd\u1ee5th Soto" },
            { "SV", "El Salvador" },
            { "sv", "S\u1ee5widiishi" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "type.nu.hantfin", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 akant\u1ee5 \u1ecdd\u1ecbnala Chinese" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "ta", "Tamil" },
            { "asa", "As\u1ee5" },
            { "type.ms.ussystem", "\u1ee4s\u1ecdr\u1ecd Mmesh\u1ecd US" },
            { "021", "Mpaghara Ugwu America" },
            { "142", "Asia" },
            { "TC", "Agwaetiti Turks na Caicos" },
            { "yav", "Yangben" },
            { "143", "Etiti Asia" },
            { "TD", "Chad" },
            { "te", metaValue_te },
            { "145", "Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Asia" },
            { "TF", "\u1ee4m\u1ee5 ngalaba Frenchi Southern" },
            { "TG", "Togo" },
            { "tg", "Taj\u1ecbk" },
            { "TH", "Thailand" },
            { "th", "Ta\u1ecb" },
            { "ti", "T\u1ecbgr\u1ecbnya" },
            { "TJ", "Tajikistan" },
            { "en_CA", "Bekee nd\u1ecb Canada" },
            { "029", "Onye Carrabean" },
            { "TK", "Tokelau" },
            { "tk", "Turk\u1ecbs" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "to", "T\u1ecdngan" },
            { "dyo", "J\u1ecdla-F\u1ecdny\u1ecb" },
            { "type.nu.jpan", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Japanese" },
            { "TR", "Turkey" },
            { "tr", "T\u1ecdkiishi" },
            { "TT", "Trinidad na Tobago" },
            { "tt", "Tata" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "nmg", "Kwas\u1ecb\u1ecd" },
            { "Zzzz", "Mkp\u1ee5r\u1ee5 okwu amagh\u1ecb" },
            { "150", "Europe" },
            { "UA", "Ukraine" },
            { "030", "Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Asia" },
            { "151", "Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Europe" },
            { "154", "Mpaghara Ugwu Europe" },
            { "034", "Mpaghara Mgbada Ugwu Asia" },
            { "155", "Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Europe" },
            { "035", "Mpaghara Mgbada Ugwu Asia d\u1ecb na \u1eccw\u1ee5wa Anyanw\u1ee5" },
            { "UG", "Uganda" },
            { "ug", "\u1ee4ygh\u1ee5r" },
            { "Kore", "Korea" },
            { "Zyyy", "k\u1ecdm\u1ecdn" },
            { "039", "Mpaghara Mgbada Ugwu Europe" },
            { "uk", "Ukureen\u1ecb" },
            { "Sinh", metaValue_si },
            { "UM", "Obere Agwaetiti D\u1ecb Na Mp\u1ee5ga U.S" },
            { "UN", "Mba \u1ee4wa Jik\u1ecdr\u1ecd \u1eccn\u1ee5" },
            { "ur", "Urd\u1ee5" },
            { "US", "United States" },
            { "haw", "Hawa\u1ecbl\u1ecban" },
            { "UY", "Uruguay" },
            { "prg", "Pr\u1ee5ss\u1ecban" },
            { "UZ", "Uzbekistan" },
            { "uz", "\u1ee4zbek" },
            { "nnh", "Nglemb\u1ecdn" },
            { "VA", "Vatican City" },
            { "VC", "Vincent na Grenadines D\u1ecb ns\u1ecd" },
            { "VE", "Venezuela" },
            { "type.ca.roc", "Kal\u1ecbnda rep\u1ee5blic nke China" },
            { "VG", "Agwaetiti British Virgin" },
            { "VI", "Agwaetiti Virgin nke US" },
            { "vi", "Vietnamisi" },
            { "khq", "K\u1ecdyra Ch\u1ecbn\u1ecb" },
            { "key.hc", "\u1eccge \u1ecdk\u1ecbr\u1ecbk\u1ecbr\u1ecb" },
            { "VN", "Vietnam" },
            { "vo", "Volap\u1ee5" },
            { "VU", "Vanuatu" },
            { "rwk", "Rwa" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis & Futuna" },
            { "Grek", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 gr\u1ecbk" },
            { "057", "Mpaghara Micronesian" },
            { "jgo", "Ng\u1ecdmba" },
            { "wo", "Wol\u1ecdf" },
            { "wae", "Wasa" },
            { "ar_001", "\u1ee4d\u1ecb Arabiik\u1ecb nke oge a" },
            { "WS", "Samoa" },
            { "Mong", "M\u1ecdng\u1ecdl\u1ecban" },
            { "XA", "Pseudo-Accents" },
            { "mni", "Man\u1ecbp\u1ee5r\u1ecb" },
            { "XB", "Pseudo-Bidi" },
            { "061", "Polynesia" },
            { "Latn", "Latin" },
            { "type.nu.hans", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 mfe Ch\u1ecbnese" },
            { "type.nu.hant", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 \u1ecddinala chinese" },
            { "xh", "Xh\u1ecdsa" },
            { "XK", "Kosovo" },
            { "type.nu.romanlow", "\u1eccbere \u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Roman" },
            { "Gujr", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 G\u1ee5jarat\u1ecb" },
            { "Zxxx", "Edegh\u1ecb ede" },
            { "kkj", "Kak\u1ecd" },
            { "YE", "Yemen" },
            { "type.co.standard", "Usoro Nhazi" },
            { "yi", "Y\u1ecbd\u1ecbsh" },
            { "yo", "Yoruba" },
            { "es_MX", "Spanishi nd\u1ecb Mexico" },
            { "YT", "Mayotte" },
            { "vai", "Val" },
            { "ZA", "South Africa" },
            { "type.lb.loose", "Akara akanka nkw\u1ee5s\u1ecb es\u1ecbgh\u1ecb \u1ecbke" },
            { "kln", "Kalenj\u1ecbn" },
            { "Deva", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Devangar\u1ecb" },
            { "zh", "Chainisi" },
            { "type.nu.geor", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Ge\u1ecdj\u1ecban" },
            { "Hira", "Mkp\u1ee5r\u1ee5 okw\u1ee5 H\u1ecbragana" },
            { "ZM", "Zambia" },
            { "Bopo", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Bopomofo" },
            { "key.lb", "Akara akanka nkw\u1ee5s\u1ecb" },
            { "zu", "Zulu" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Mpaghara Amagh\u1ecb" },
            { "Geor", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Ge\u1ecdj\u1ecban" },
            { "type.ms.metric", "\u1ee4s\u1ecdr\u1ecd Met\u1ecbr\u1ecbk" },
            { "type.ca.iso8601", "Kalenda ISO-8601" },
            { "type.nu.telu", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Tel\u1ee5g\u1ee5" },
            { "type.nu.jpanfin", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 akant\u1ee5 Japanese" },
            { "ebu", "Eb\u1ee5m" },
            { "jmc", "Machame" },
            { "zh_Hans", "As\u1ee5s\u1ee5 Chinese d\u1ecb mfe" },
            { "type.nu.hansfin", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 akant\u1ee5 mfe nke Chinese" },
            { "kok", "K\u1ecdnkan\u1ecb" },
            { "type.nu.arabext", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Arab na Ind\u1ecb agbat\u1ecbr\u1ecb" },
            { "nus", "N\u1ee5er" },
            { "type.nu.fullwide", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 \u1ecdb\u1ecdsara" },
            { "dav", "Ta\u1ecbta" },
            { "lrc", "N\u1ecdrt\u1ee5 L\u1ee5r\u1ecb" },
            { "zh_Hant", "As\u1ee5s\u1ee5 Chinese Izugbe" },
            { "type.nu.khmr", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Khmer" },
            { "mua", "M\u1ee5dang" },
            { "type.nu.guru", "On\u1ee5 \u1ecdg\u1ee5g\u1ee5 G\u1ee5m\u1ee5kh" },
            { "Khmr", "Khmer" },
            { "mul", "\u1ecct\u1ee5t\u1ee5 as\u1ee5s\u1ee5" },
            { "key.ms", "\u1ee4s\u1ecdr\u1ecd Mmesh\u1ecd" },
            { "type.nu.roman", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Roman" },
            { "sah", "Saka" },
            { "type.nu.tamldec", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Tam\u1ecb" },
            { "saq", "Samb\u1ee5r\u1ee5" },
            { "sat", "Santal\u1ecb" },
            { "key.nu", "N\u1ecdmba" },
            { "Guru", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 G\u1ee5rm\u1ee5k\u1ecb" },
            { "ksb", "Shabala" },
            { "Telu", metaValue_te },
            { "ksf", "Baf\u1ecba" },
        };
        return data;
    }
}
