#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 wide-word
version:              0.1.6.0
visibility:           public
id:                   wide-word-0.1.6.0-D22h283UnyLIbGWbfgogD4
key:                  wide-word-0.1.6.0-D22h283UnyLIbGWbfgogD4
license:              BSD-2-Clause
copyright:
    Copyright (c) 2017 Erik de Castro Lopo <erikd@mega-nerd.com>

maintainer:           erikd@mega-nerd.com
author:               Erik de Castro Lopo
stability:            provisional
homepage:             https://github.com/erikd/wide-word
synopsis:
    Data types for large but fixed width signed and unsigned integers

description:
    A library to provide data types for large (ie > 64 bits) but fixed width signed
    and unsigned integers with the usual typeclass instances to allow them to be used
    interchangeably with `Word64`.

    The types and operations are coded to be as fast as possible using strictness
    annotations, `INLINEABLE` pragmas and unboxed values and operations where
    appropriate.

category:             Data
abi:                  713606a38657c2a0d897e41b7f1f8c21
exposed:              True
exposed-modules:
    Data.WideWord Data.WideWord.Int128 Data.WideWord.Word128
    Data.WideWord.Word256 Data.WideWord.Word64

hidden-modules:       Data.WideWord.Compat
import-dirs:          /usr/lib/ghc-9.2.8/site-local/wide-word-0.1.6.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/wide-word-0.1.6.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-wide-word
hs-libraries:         HSwide-word-0.1.6.0-D22h283UnyLIbGWbfgogD4
depends:
    base-4.16.4.0 binary-0.8.9.0 deepseq-1.4.6.1 ghc-prim-0.8.0
    hashable-1.4.3.0-4gqtyFKn8Wu9OwsZtyYGdt
    primitive-0.7.4.0-IuAkHfsD4drDvErljoigXB

haddock-interfaces:   /usr/share/doc/haskell-wide-word/html/wide-word.haddock
haddock-html:         /usr/share/doc/haskell-wide-word/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

