#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 unordered-containers
version:              0.2.20
visibility:           public
id:                   unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
key:                  unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
license:              BSD-3-Clause
copyright:
    2010-2014 Johan Tibell
    2010 Edward Z. Yang

maintainer:           simon.jakobi@gmail.com, David.Feuer@gmail.com
author:               Johan Tibell
homepage:
    https://github.com/haskell-unordered-containers/unordered-containers

synopsis:             Efficient hashing-based container types
description:
    Efficient hashing-based container types.  The containers have been
    optimized for performance critical use, both in terms of large data
    quantities and high speed.

    The declared cost of each operation is either worst-case or
    amortized, but remains valid even if structures are shared.

    /Security/

    This package currently provides no defenses against hash collision attacks
    such as HashDoS.
    Users who need to store input from untrusted sources are advised to use
    @Data.Map@ or @Data.Set@ from the @containers@ package instead.

category:             Data
abi:                  44f440df4436ed111d520770b3e623ea
exposed:              True
exposed-modules:
    Data.HashMap.Internal Data.HashMap.Internal.Array
    Data.HashMap.Internal.Debug Data.HashMap.Internal.List
    Data.HashMap.Internal.Strict Data.HashMap.Lazy Data.HashMap.Strict
    Data.HashSet Data.HashSet.Internal

import-dirs:          /usr/lib/ghc-9.2.8/site-local/unordered-containers-0.2.20
library-dirs:         /usr/lib/ghc-9.2.8/site-local/unordered-containers-0.2.20
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-unordered-containers
hs-libraries:         HSunordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
depends:
    base-4.16.4.0 deepseq-1.4.6.1
    hashable-1.4.3.0-4gqtyFKn8Wu9OwsZtyYGdt template-haskell-2.18.0.0

haddock-interfaces:
    /usr/share/doc/haskell-unordered-containers/html/unordered-containers.haddock

haddock-html:         /usr/share/doc/haskell-unordered-containers/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

