#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 timezone-olson
version:              0.2.1
visibility:           public
id:                   timezone-olson-0.2.1-JZvcsqhYOAiEwiQhSiFRSg
key:                  timezone-olson-0.2.1-JZvcsqhYOAiEwiQhSiFRSg
license:              BSD-3-Clause
copyright:            Copyright (c) 2010-2021 Yitzchak Gale. All rights reserved.
maintainer:           yitz@sefer.org
author:               Yitzchak Gale
homepage:             http://projects.haskell.org/time-ng/
synopsis:
    A pure Haskell parser and renderer for binary Olson timezone files

description:
    A parser and renderer for binary Olson timezone
    files whose format is specified by the tzfile(5)
    man page on Unix-like systems. For more
    information about this format, see
    <http://www.iana.org/time-zones/repository/tz-link.html>.
    Functions are provided for converting the parsed data into
    '\''TimeZoneSeries'\'' objects from the timezone-series
    package. On many platforms, binary Olson timezone
    files suitable for use with this package are
    available in the directory /usr/share/zoneinfo
    and its subdirectories on your computer.
    For a way to read binary Olson timezone files at compile
    time, see the timezone-olson-th package
    (<http://hackage.haskell.org/package/timezone-olson-th>).

category:             Data
abi:                  69267f0993567e238bbe31d80146a94d
exposed:              True
exposed-modules:
    Data.Time.LocalTime.TimeZone.Olson
    Data.Time.LocalTime.TimeZone.Olson.Parse
    Data.Time.LocalTime.TimeZone.Olson.Render
    Data.Time.LocalTime.TimeZone.Olson.Types

import-dirs:          /usr/lib/ghc-9.2.8/site-local/timezone-olson-0.2.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/timezone-olson-0.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-timezone-olson
hs-libraries:         HStimezone-olson-0.2.1-JZvcsqhYOAiEwiQhSiFRSg
depends:
    base-4.16.4.0 binary-0.8.9.0 bytestring-0.11.4.0
    extensible-exceptions-0.1.1.4-D8VRIfPBfkhEPmMrxbU9lA time-1.11.1.1
    timezone-series-0.1.13-8lxErw9wrLf6Z6J89uOObG

haddock-interfaces:
    /usr/share/doc/haskell-timezone-olson/html/timezone-olson.haddock

haddock-html:         /usr/share/doc/haskell-timezone-olson/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

