#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 texmath
version:              0.12.8.4
visibility:           public
id:                   texmath-0.12.8.4-HqZ5E7CTL7vAjdJEykBB5u
key:                  texmath-0.12.8.4-HqZ5E7CTL7vAjdJEykBB5u
license:              GPL-2.0-only
maintainer:           jgm@berkeley.edu
author:               John MacFarlane, Matthew Pickering
stability:            Experimental
homepage:             http://github.com/jgm/texmath
synopsis:             Conversion between math formats.
description:
    The texmath library provides functions to read
    and write TeX math, presentation MathML, and OMML (Office
    Math Markup Language, used in Microsoft Office).  Support is also
    included for converting math formats to Gnu eqn, typst, and pandoc'\''s
    native format (allowing conversion, via pandoc, to a variety of
    different markup formats).  The TeX reader supports basic LaTeX
    and AMS extensions, and it can parse and apply LaTeX macros.
    (See <https://johnmacfarlane.net/texmath here> for a live demo of
    bidirectional conversion between LaTeX and MathML.)

    The package also includes several utility modules which may be
    useful for anyone looking to manipulate either TeX math or
    MathML.  For example, a copy of the MathML operator dictionary is
    included.

    Use the @executable@ flag to install a standalone
    executable, @texmath@, that converts formulas from one
    format to another. (Use the @--help@ flag for a description of all
    functionality).

    Use the @server@ flag to install a web server, @texmath-server@,
    that exposes a JSON API allowing conversion of individual
    formulas and batches of formulas.

category:             Text
abi:                  910616f307439a5a9085be7ba98eb796
exposed:              True
exposed-modules:
    Text.TeXMath Text.TeXMath.Readers.MathML
    Text.TeXMath.Readers.MathML.EntityMap
    Text.TeXMath.Readers.MathML.MMLDict Text.TeXMath.Readers.OMML
    Text.TeXMath.Readers.TeX Text.TeXMath.Readers.TeX.Macros
    Text.TeXMath.Shared Text.TeXMath.TeX Text.TeXMath.Types
    Text.TeXMath.Unicode.Fonts Text.TeXMath.Unicode.ToTeX
    Text.TeXMath.Unicode.ToUnicode Text.TeXMath.Writers.Eqn
    Text.TeXMath.Writers.MathML Text.TeXMath.Writers.OMML
    Text.TeXMath.Writers.Pandoc Text.TeXMath.Writers.TeX
    Text.TeXMath.Writers.Typst

hidden-modules:       Text.TeXMath.Readers.TeX.Commands Paths_texmath
import-dirs:          /usr/lib/ghc-9.2.8/site-local/texmath-0.12.8.4
library-dirs:         /usr/lib/ghc-9.2.8/site-local/texmath-0.12.8.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.2.8/texmath-0.12.8.4
hs-libraries:         HStexmath-0.12.8.4-HqZ5E7CTL7vAjdJEykBB5u
depends:
    base-4.16.4.0 containers-0.6.5.1 mtl-2.2.2
    pandoc-types-1.23.1-DdQZgf4FErf8aiJPYPPwhY parsec-3.1.15.0
    split-0.2.5-FikGR5xLeivE3fJUC4tXgQ
    syb-0.7.2.4-IT59ozboet0H3NdhoNJGts text-1.2.5.0
    typst-symbols-0.1.4-HjOBFCqxenh64KEW8EzY50
    xml-1.3.14-6RhFPlxQprr192No4Dq3gf

haddock-interfaces:   /usr/share/doc/haskell-texmath/html/texmath.haddock
haddock-html:         /usr/share/doc/haskell-texmath/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

