#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tamarin-prover-theory
version:              1.8.0
visibility:           public
id:                   tamarin-prover-theory-1.8.0-2P0f8Baoe5HB4xrQdfIn06
key:                  tamarin-prover-theory-1.8.0-2P0f8Baoe5HB4xrQdfIn06
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Cas Cremers, Jannik Dreier, Ralf Sasse, 2010-2023

maintainer:
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>
    Cas Cremers <cremers@cispa.de>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:
    Security protocol types and constraint solver library for the tamarin prover.

description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides the types to represent security
    protocols, and it implements the constraint solver.

category:             Theorem Provers
abi:                  3029e2f2157718102df241bb4a33110e
exposed:              True
exposed-modules:
    ClosedTheory Items.AccLemmaItem Items.CaseTestItem Items.ExportInfo
    Items.LemmaItem Items.OpenTheoryItem Items.OptionItem
    Items.ProcessItem Items.RuleItem Items.TheoryItem Lemma OpenTheory
    Pretty Prover Rule Theory Theory.Constraint.Solver
    Theory.Constraint.Solver.AnnotatedGoals
    Theory.Constraint.Solver.Contradictions
    Theory.Constraint.Solver.Goals Theory.Constraint.Solver.ProofMethod
    Theory.Constraint.Solver.Reduction
    Theory.Constraint.Solver.Simplify Theory.Constraint.Solver.Sources
    Theory.Constraint.System Theory.Constraint.System.Constraints
    Theory.Constraint.System.Dot Theory.Constraint.System.Guarded
    Theory.Constraint.System.JSON Theory.Model Theory.Model.Atom
    Theory.Model.Fact Theory.Model.Formula Theory.Model.Restriction
    Theory.Model.Rule Theory.Model.Signature Theory.Module Theory.Proof
    Theory.ProofSkeleton Theory.Sapic Theory.Sapic.Annotation
    Theory.Sapic.Pattern Theory.Sapic.Position Theory.Sapic.Print
    Theory.Sapic.Process Theory.Sapic.Term Theory.Text.Parser
    Theory.Text.Parser.Macro Theory.Text.Parser.Restriction
    Theory.Text.Parser.Signature Theory.Text.Parser.Token
    Theory.Text.Pretty Theory.Tools.AbstractInterpretation
    Theory.Tools.EquationStore Theory.Tools.InjectiveFactInstances
    Theory.Tools.IntruderRules Theory.Tools.LoopBreakers
    Theory.Tools.MessageDerivationChecks Theory.Tools.RuleVariants
    Theory.Tools.SubtermStore Theory.Tools.Wellformedness TheoryObject

hidden-modules:
    Theory.Syntactic.Predicate Theory.Text.Parser.Accountability
    Theory.Text.Parser.Exceptions Theory.Text.Parser.Fact
    Theory.Text.Parser.Formula Theory.Text.Parser.Lemma
    Theory.Text.Parser.Let Theory.Text.Parser.Proof
    Theory.Text.Parser.Rule Theory.Text.Parser.Sapic
    Theory.Text.Parser.Tactics Theory.Text.Parser.Term
    Theory.Sapic.PlainProcess Theory.Sapic.Substitution

import-dirs:          /usr/lib/ghc-9.2.8/site-local/tamarin-prover-theory-1.8.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/tamarin-prover-theory-1.8.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-theory
hs-libraries:         HStamarin-prover-theory-1.8.0-2P0f8Baoe5HB4xrQdfIn06
depends:
    aeson-2.1.2.1-F86TtVKFNKJLpW409aVG0j
    aeson-pretty-0.8.10-LXRQ45SpR4pHv7QmJp2GmJ array-0.5.4.0
    attoparsec-0.14.4-Bi4fbguKdku98LXMy0bDoK base-4.16.4.0
    binary-0.8.9.0 bytestring-0.11.4.0 containers-0.6.5.1
    deepseq-1.4.6.1 dlist-1.0-HCxoMn9TirQDgPCFxho7O exceptions-0.10.4
    fclabels-2.0.5.1-JkQdhYNM3JJEdlX5hjsQCN filepath-1.4.2.2 mtl-2.2.2
    parallel-3.2.2.0-KgDyPHm89eYAjQsIhXthC1 parsec-3.1.15.0
    pretty-1.1.3.6 process-1.6.16.0
    regex-pcre-0.95.0.0-8JTNevh6vF7HTkboxZ55oR
    regex-posix-0.96.0.1-Genc39RUTH74GYzEFB6fWq
    safe-0.3.21-CqIHKdkgiB2klcxc5dxay
    split-0.2.5-FikGR5xLeivE3fJUC4tXgQ
    tamarin-prover-term-1.8.0-7kLm7IPpdwD32U2Y2lvkyc
    tamarin-prover-utils-1.8.0-BjCPuIRZvNa1DgjVQPXXNd text-1.2.5.0
    transformers-0.5.6.2 uniplate-1.6.13-2wlaKTDzX4U4sRJV09tewv

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-theory/html/tamarin-prover-theory.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-theory/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

