#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 stm-containers
version:              1.2.0.3
visibility:           public
id:                   stm-containers-1.2.0.3-AbclNDwjJ741DRvs64VjHX
key:                  stm-containers-1.2.0.3-AbclNDwjJ741DRvs64VjHX
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/stm-containers
synopsis:             Containers for STM
description:
    This library is based on an STM-specialized implementation of
    Hash Array Mapped Trie.
    It provides efficient implementations of @Map@, @Set@
    and other data structures,
    which starting from version @1@ perform even better than their counterparts from \"unordered-containers\",
    but also scale well on concurrent access patterns.
    .
    For details on performance of the library, which are a bit outdated, see
    <http://nikita-volkov.github.io/stm-containers/ this blog post>.

category:             Data Structures, STM, Concurrency
abi:                  bd0dd09ae90db3a9b53337eab3d83794
exposed:              True
exposed-modules:
    StmContainers.Bimap StmContainers.Map StmContainers.Multimap
    StmContainers.Set

hidden-modules:       StmContainers.Prelude
import-dirs:          /usr/lib/ghc-9.2.8/site-local/stm-containers-1.2.0.3
library-dirs:         /usr/lib/ghc-9.2.8/site-local/stm-containers-1.2.0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-stm-containers
hs-libraries:         HSstm-containers-1.2.0.3-AbclNDwjJ741DRvs64VjHX
depends:
    base-4.16.4.0 deferred-folds-0.9.18.6-GquzRpErrnl11ZQrZBo5e1
    focus-1.0.3.2-EuoDZarCUGl6fLOfy9zX9f
    hashable-1.4.3.0-4gqtyFKn8Wu9OwsZtyYGdt
    list-t-1.0.5.4-8WXUQUVfTKQLcXUAyBA5X5
    stm-hamt-1.2.0.14-1zN7tp8NH8E32PoxzWwAjb transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-stm-containers/html/stm-containers.haddock

haddock-html:         /usr/share/doc/haskell-stm-containers/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

