#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 skein
version:              1.0.9.4
visibility:           public
id:                   skein-1.0.9.4-I3T91p6XZaISUb14OUQBP
key:                  skein-1.0.9.4-I3T91p6XZaISUb14OUQBP
license:              BSD-3-Clause
maintainer:           Felipe Lessa <felipe.lessa@gmail.com>
author:               Felipe Lessa <felipe.lessa@gmail.com>, Doug Whiting
homepage:             https://github.com/meteficha/skein
synopsis:
    Skein, a family of cryptographic hash functions.  Includes Skein-MAC as well.

description:
    Skein (<http://www.skein-hash.info/>) is a family of fast
    secure cryptographic hash functions designed by Niels
    Ferguson, Stefan Lucks, Bruce Schneier, Doug Whiting, Mihir
    Bellare, Tadayoshi Kohno, Jon Callas and Jesse Walker.

    This package uses bindings to the optimized C implementation
    of Skein.  We provide a high-level interface (see module
    "Crypto.Skein") to some of the Skein use cases.  We also
    provide a low-level interface (see module
    "Crypto.Skein.Internal") should you need to use Skein in a
    different way.

    Currently we have support for Skein as cryptographic hash
    function as Skein as a message authentication code
    (Skein-MAC).  For examples of how to use this package, see
    "Crypto.Skein" module documentation.

    This package includes Skein v1.3. Versions of this package
    before 1.0.0 implemented Skein v1.1.

category:             Cryptography
abi:                  449047a56a0414368fb364c8c50ba7a2
exposed:              True
exposed-modules:      Crypto.Skein Crypto.Skein.Internal
import-dirs:          /usr/lib/ghc-9.2.8/site-local/skein-1.0.9.4
library-dirs:         /usr/lib/ghc-9.2.8/site-local/skein-1.0.9.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-skein
hs-libraries:         HSskein-1.0.9.4-I3T91p6XZaISUb14OUQBP
includes:             skein.h
depends:
    base-4.16.4.0 bytestring-0.11.4.0
    cereal-0.5.8.3-9zcITCTkqXtHoa6jbeSF22
    crypto-api-0.13.3-95IFBy4WvL6L3p6UFm5MLc
    tagged-0.8.8-404YCiJ2agdDxJGZ4AybXg

haddock-interfaces:   /usr/share/doc/haskell-skein/html/skein.haddock
haddock-html:         /usr/share/doc/haskell-skein/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

