#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 serialise
version:              0.2.6.1
visibility:           public
id:                   serialise-0.2.6.1-InnVGEAKO7QLdcYno3sVG4
key:                  serialise-0.2.6.1-InnVGEAKO7QLdcYno3sVG4
license:              BSD-3-Clause
copyright:
    2015-2017 Duncan Coutts,
    2015-2017 Well-Typed LLP,
    2015 IRIS Connect Ltd

maintainer:           duncan@community.haskell.org, ben@smart-cactus.org
author:               Duncan Coutts
homepage:             https://github.com/well-typed/cborg
synopsis:             A binary serialisation library for Haskell values.
description:
    This package (formerly @binary-serialise-cbor@) provides pure, efficient
    serialization of Haskell values directly into @ByteString@s for storage or
    transmission purposes. By providing a set of type class instances, you can
    also serialise any custom data type you have as well.

    The underlying binary format used is the '\''Concise Binary Object
    Representation'\'', or CBOR, specified in RFC 7049. As a result,
    serialised Haskell values have implicit structure outside of the
    Haskell program itself, meaning they can be inspected or analyzed
    without custom tools.

    An implementation of the standard bijection between CBOR and JSON is provided
    by the [cborg-json](/package/cborg-json) package. Also see
    [cbor-tool](/package/cbor-tool) for a convenient command-line utility for
    working with CBOR data.

category:             Codec
abi:                  675b15f035d75f7d0481a0053b847472
exposed:              True
exposed-modules:
    Codec.Serialise Codec.Serialise.Class Codec.Serialise.Decoding
    Codec.Serialise.Encoding Codec.Serialise.IO
    Codec.Serialise.Internal.GeneralisedUTF8 Codec.Serialise.Properties
    Codec.Serialise.Tutorial

import-dirs:          /usr/lib/ghc-9.2.8/site-local/serialise-0.2.6.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/serialise-0.2.6.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-serialise
hs-libraries:         HSserialise-0.2.6.1-InnVGEAKO7QLdcYno3sVG4
depends:
    array-0.5.4.0 base-4.16.4.0 bytestring-0.11.4.0
    cborg-0.2.9.0-IwkrhVBuB0SJa5iegIS46P containers-0.6.5.1
    ghc-prim-0.8.0 half-0.3.1-3d34mZqOasEDojiioSdIMj
    hashable-1.4.3.0-4gqtyFKn8Wu9OwsZtyYGdt
    primitive-0.7.4.0-IuAkHfsD4drDvErljoigXB
    strict-0.4.0.1-2BKzgoeFlc2eYyiTjovRD text-1.2.5.0
    these-1.1.1.1-2swe2q6qcTTC2co2Di7Sc6 time-1.11.1.1
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
    vector-0.13.1.0-FuSYSqJEiCU51oStZmHlCe

haddock-interfaces:   /usr/share/doc/haskell-serialise/html/serialise.haddock
haddock-html:         /usr/share/doc/haskell-serialise/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

