#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 semialign
version:              1.2.0.1
visibility:           public
id:                   semialign-1.2.0.1-104tBATH94KH4Pl5hWi0Uw
key:                  semialign-1.2.0.1-104tBATH94KH4Pl5hWi0Uw
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               C. McCann, Oleg Grenrus
homepage:             https://github.com/haskellari/these
synopsis:
    Align and Zip type-classes from the common Semialign ancestor.

description:
    The major use of @These@ of this is provided by the @align@ member of
    @Semialign@ class, representing a generalized notion of "zipping with padding"
    that combines structures without truncating to the size of the smaller input.

    It turns out that @zip@ operation fits well the @Semialign@ class,
    forming lattice-like structure.

category:             Data, These
abi:                  460f2c07c67207c8d0513f49c70b38da
exposed:              True
exposed-modules:
    Data.Align Data.Crosswalk Data.Semialign Data.Semialign.Indexed
    Data.Zip

hidden-modules:       Data.Semialign.Internal
import-dirs:          /usr/lib/ghc-9.2.8/site-local/semialign-1.2.0.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/semialign-1.2.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-semialign
hs-libraries:         HSsemialign-1.2.0.1-104tBATH94KH4Pl5hWi0Uw
depends:
    base-4.16.4.0 containers-0.6.5.1
    hashable-1.4.3.0-4gqtyFKn8Wu9OwsZtyYGdt
    indexed-traversable-0.1.3-W9Su4KVkN93xsET3IfaRw
    indexed-traversable-instances-0.1.1.2-1FBxq0Ge1Y95aKvEqLMkG4
    semigroupoids-5.3.7-2dNUjUS9CZoECY4lfLye7D
    tagged-0.8.8-404YCiJ2agdDxJGZ4AybXg
    these-1.1.1.1-2swe2q6qcTTC2co2Di7Sc6 transformers-0.5.6.2
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
    vector-0.13.1.0-FuSYSqJEiCU51oStZmHlCe

haddock-interfaces:   /usr/share/doc/haskell-semialign/html/semialign.haddock
haddock-html:         /usr/share/doc/haskell-semialign/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

