#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 parameterized-utils
version:              2.1.8.0
visibility:           public
id:                   parameterized-utils-2.1.8.0-BOr8luBTZnb2JwGWNHHUZn
key:                  parameterized-utils-2.1.8.0-BOr8luBTZnb2JwGWNHHUZn
license:              BSD-3-Clause
copyright:            ©2016-2022 Galois, Inc.
maintainer:           kquick@galois.com, rscott@galois.com
author:               Galois Inc.
stability:            stable
homepage:             https://github.com/GaloisInc/parameterized-utils
synopsis:
    Classes and data structures for working with data-kind indexed types

description:
    This package contains collection classes and type representations
    used for working with values that have a single parameter.  It'\''s
    intended for things like expression libraries where one wishes
    to leverage the Haskell type-checker to improve type-safety by encoding
    the object language type system into data kinds.

category:             Data Structures, Dependent Types
abi:                  ba08bde24b2d3dbdf1525a611e8a33d7
exposed:              True
exposed-modules:
    Data.Parameterized Data.Parameterized.All Data.Parameterized.Axiom
    Data.Parameterized.BoolRepr Data.Parameterized.Classes
    Data.Parameterized.ClassesC Data.Parameterized.Compose
    Data.Parameterized.Context Data.Parameterized.Context.Safe
    Data.Parameterized.Context.Unsafe Data.Parameterized.Ctx
    Data.Parameterized.Ctx.Proofs Data.Parameterized.DataKind
    Data.Parameterized.DecidableEq Data.Parameterized.Fin
    Data.Parameterized.FinMap Data.Parameterized.FinMap.Safe
    Data.Parameterized.FinMap.Unsafe Data.Parameterized.HashTable
    Data.Parameterized.List Data.Parameterized.Map
    Data.Parameterized.NatRepr Data.Parameterized.Nonce
    Data.Parameterized.Nonce.Transformers
    Data.Parameterized.Nonce.Unsafe Data.Parameterized.Pair
    Data.Parameterized.Peano Data.Parameterized.Some
    Data.Parameterized.SymbolRepr Data.Parameterized.TH.GADT
    Data.Parameterized.TraversableF Data.Parameterized.TraversableFC
    Data.Parameterized.TraversableFC.WithIndex
    Data.Parameterized.Utils.BinTree Data.Parameterized.Utils.Endian
    Data.Parameterized.Vector Data.Parameterized.WithRepr

hidden-modules:       Data.Parameterized.NatRepr.Internal
import-dirs:          /usr/lib/ghc-9.2.8/site-local/parameterized-utils-2.1.8.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/parameterized-utils-2.1.8.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-parameterized-utils
hs-libraries:         HSparameterized-utils-2.1.8.0-BOr8luBTZnb2JwGWNHHUZn
depends:
    base-4.16.4.0 base-orphans-0.8.8.2-6ve0eRw4Ula2nCJtGYIJNG
    constraints-0.13.4-B4E95uxs5NtCdiYHdQ9Hv containers-0.6.5.1
    deepseq-1.4.6.1 ghc-prim-0.8.0
    hashable-1.4.3.0-4gqtyFKn8Wu9OwsZtyYGdt
    hashtables-1.3.1-Hmnbuv6HqNA8NY0t6CS25T
    indexed-traversable-0.1.3-W9Su4KVkN93xsET3IfaRw
    lens-5.2.3-KEHbFlXppcrGAx1vZwwIkx mtl-2.2.2
    profunctors-5.6.2-5vROZbe5UdTK0D0maJHxvc template-haskell-2.18.0.0
    text-1.2.5.0 th-abstraction-0.4.5.0-FQrzhXbdvQX3Z0wTw3euNu
    vector-0.13.1.0-FuSYSqJEiCU51oStZmHlCe

haddock-interfaces:
    /usr/share/doc/haskell-parameterized-utils/html/parameterized-utils.haddock

haddock-html:         /usr/share/doc/haskell-parameterized-utils/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

