#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 monoid-subclasses
version:              1.2.4.1
visibility:           public
id:                   monoid-subclasses-1.2.4.1-6HupWiSRAuEHYzKcONzwqZ
key:                  monoid-subclasses-1.2.4.1-6HupWiSRAuEHYzKcONzwqZ
license:              BSD-3-Clause
copyright:            (c) 2013-2023 Mario Blažević
maintainer:           Mario Blažević <blamario@protonmail.com>
author:               Mario Blažević
homepage:             https://github.com/blamario/monoid-subclasses/
synopsis:             Subclasses of Monoid
description:
    A hierarchy of subclasses of '\''Monoid'\'' together with their instances for all data structures from base, containers, and
    text packages.

category:             Data, Algebra, Text
abi:                  7ba1a29623a5aa6ae358c311406fb428
exposed:              True
exposed-modules:
    Data.Monoid.Cancellative Data.Monoid.Factorial Data.Monoid.GCD
    Data.Monoid.Instances.ByteString.UTF8
    Data.Monoid.Instances.CharVector Data.Monoid.Instances.Concat
    Data.Monoid.Instances.Measured Data.Monoid.Instances.Positioned
    Data.Monoid.Instances.PrefixMemory Data.Monoid.Instances.Stateful
    Data.Monoid.LCM Data.Monoid.Monus Data.Monoid.Null
    Data.Monoid.Textual Data.Semigroup.Cancellative
    Data.Semigroup.Factorial

import-dirs:          /usr/lib/ghc-9.2.8/site-local/monoid-subclasses-1.2.4.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/monoid-subclasses-1.2.4.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-monoid-subclasses
hs-libraries:         HSmonoid-subclasses-1.2.4.1-6HupWiSRAuEHYzKcONzwqZ
depends:
    base-4.16.4.0 bytestring-0.11.4.0
    commutative-semigroups-0.1.0.2-IutkYzDs43W8HtiWkPtj05
    containers-0.6.5.1 primes-0.2.1.0-4FlmqGEB4JCDXui124fQpB
    text-1.2.5.0 vector-0.13.1.0-FuSYSqJEiCU51oStZmHlCe

haddock-interfaces:
    /usr/share/doc/haskell-monoid-subclasses/html/monoid-subclasses.haddock

haddock-html:         /usr/share/doc/haskell-monoid-subclasses/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

