#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lumberjack
version:              1.0.3.0
visibility:           public
id:                   lumberjack-1.0.3.0-BKzxdexCLBW3aFOfWCWPLl
key:                  lumberjack-1.0.3.0-BKzxdexCLBW3aFOfWCWPLl
license:              ISC
copyright:            2020-2022, Galois Inc.
maintainer:           kquick@galois.com
author:               Kevin Quick
homepage:             https://github.com/GaloisInc/lumberjack
synopsis:             Trek through your code forest and make logs
description:
    This is a logging facility.  Yes, there are many, and this is the one
    with a beard, wearing flannel and boots, that gets the job done.  It'\''s
    not the fanciest, it doesn'\''t have a cargo-van full of features.  This
    logger is designed to be straightforward to use, provide a good set of
    standard features, and be useable across a broad set of code.

    * Logging itself is a monadic activity.  This activity is most often
    performed in a monad stack with a MonadIO context to allow
    writing to files.

    * The specific logging action implementations are managed separately
    from the actions of logging messages in the target code.  This
    allows logging to be configurable and the manner of logging to
    be specified at startup time without requiring changes in the
    code from which log messages are being generated.

    * The logging implementation code can use contravariant functors to
    adjust existing logging.

    * Main code will typically retrieve the logging actions from a Reader
    context in your monad stack.  That said, Log actions are not tied
    to an enclosing Monad.  There are helpers to support a Monad which
    can store Log actions, but Log actions can also be explicitly
    passed and used.

    * The prettyprinter package is used for formatting.

category:             Logging
abi:                  fd28a29d9896fa1f34700566bd208ff0
exposed:              True
exposed-modules:      Lumberjack
import-dirs:          /usr/lib/ghc-9.2.8/site-local/lumberjack-1.0.3.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/lumberjack-1.0.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lumberjack
hs-libraries:         HSlumberjack-1.0.3.0-BKzxdexCLBW3aFOfWCWPLl
depends:
    base-4.16.4.0 contravariant-1.5.5-6oWUjmJNxDBFhugVD5s9dq
    exceptions-0.10.4 prettyprinter-1.7.1-6adth5pam1GKTgbrd0Zc3O
    prettyprinter-ansi-terminal-1.1.3-6SmBHIq2mt2Jb0dulKL8Bm
    text-1.2.5.0 time-1.11.1.1

haddock-interfaces:   /usr/share/doc/haskell-lumberjack/html/lumberjack.haddock
haddock-html:         /usr/share/doc/haskell-lumberjack/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

