#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lattices
version:              2.1
visibility:           public
id:                   lattices-2.1-1hgnDt2dmX33zbF6h2aMQw
key:                  lattices-2.1-1hgnDt2dmX33zbF6h2aMQw
license:              BSD-3-Clause
copyright:
    (C) 2010-2015 Maximilian Bolingbroke, 2016-2019 Oleg Grenrus

maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Maximilian Bolingbroke <batterseapower@hotmail.com>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             http://github.com/phadej/lattices/
synopsis:
    Fine-grained library for constructing and manipulating lattices

description:
    In mathematics, a lattice is a partially ordered set in which every two
    elements @x@ and @y@ have a unique supremum (also called a least upper bound, join, or @x /\\ y@)
    and a unique infimum (also called a greatest lower bound, meet, or @x \\/ y@).

    This package provide type-classes for different lattice types, as well
    as a class for the partial order.

category:             Math
abi:                  a31803c88a427e164fb69257ebf3e0c4
exposed:              True
exposed-modules:
    Algebra.Heyting Algebra.Heyting.Free Algebra.Heyting.Free.Expr
    Algebra.Lattice Algebra.Lattice.Divisibility
    Algebra.Lattice.Dropped Algebra.Lattice.Free
    Algebra.Lattice.Free.Final Algebra.Lattice.Levitated
    Algebra.Lattice.Lexicographic Algebra.Lattice.Lifted
    Algebra.Lattice.M2 Algebra.Lattice.M3 Algebra.Lattice.N5
    Algebra.Lattice.Op Algebra.Lattice.Ordered Algebra.Lattice.Unicode
    Algebra.Lattice.Wide Algebra.Lattice.ZeroHalfOne Algebra.PartialOrd
    Algebra.PartialOrd.Instances

import-dirs:          /usr/lib/ghc-9.2.8/site-local/lattices-2.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/lattices-2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lattices
hs-libraries:         HSlattices-2.1-1hgnDt2dmX33zbF6h2aMQw
depends:
    QuickCheck-2.14.3-2FUI0ycZlrbG7BkVMiUKvc base-4.16.4.0
    base-compat-0.12.2-5hQPtIjgG5LKnb20qwjRWd containers-0.6.5.1
    deepseq-1.4.6.1 hashable-1.4.3.0-4gqtyFKn8Wu9OwsZtyYGdt
    integer-logarithms-1.0.3.1-6P0sCe8RoauAWF13sn9GHc
    semigroupoids-5.3.7-2dNUjUS9CZoECY4lfLye7D
    tagged-0.8.8-404YCiJ2agdDxJGZ4AybXg transformers-0.5.6.2
    universe-base-1.1.4-DL2ztXAQ6Wd3LlRSDaJoHX
    universe-reverse-instances-1.1.2-7oOBAv4fkgWOKvm7tbOGU
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox

haddock-interfaces:   /usr/share/doc/haskell-lattices/html/lattices.haddock
haddock-html:         /usr/share/doc/haskell-lattices/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

