#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 extra
version:              1.7.14
visibility:           public
id:                   extra-1.7.14-DnAQtxBkKEm2qogn2rCz4Q
key:                  extra-1.7.14-DnAQtxBkKEm2qogn2rCz4Q
license:              BSD-3-Clause
copyright:            Neil Mitchell 2014-2023
maintainer:           Neil Mitchell <ndmitchell@gmail.com>
author:               Neil Mitchell <ndmitchell@gmail.com>
homepage:             https://github.com/ndmitchell/extra#readme
synopsis:             Extra functions I use.
description:
    A library of extra functions for the standard Haskell libraries. Most functions are simple additions, filling out missing functionality. A few functions are available in later versions of GHC, but this package makes them available back to GHC 7.2.

    The module "Extra" documents all functions provided by this library. Modules such as "Data.List.Extra" provide extra functions over "Data.List" and also reexport "Data.List". Users are recommended to replace "Data.List" imports with "Data.List.Extra" if they need the extra functionality.

category:             Development
abi:                  6ed2554c5d684f58eb40e48b7f81b93b
exposed:              True
exposed-modules:
    Control.Concurrent.Extra Control.Exception.Extra
    Control.Monad.Extra Data.Either.Extra Data.Foldable.Extra
    Data.IORef.Extra Data.List.Extra Data.List.NonEmpty.Extra
    Data.Monoid.Extra Data.Tuple.Extra Data.Typeable.Extra
    Data.Version.Extra Extra Numeric.Extra System.Directory.Extra
    System.Environment.Extra System.IO.Extra System.Info.Extra
    System.Process.Extra System.Time.Extra Text.Read.Extra

hidden-modules:       Partial
import-dirs:          /usr/lib/ghc-9.2.8/site-local/extra-1.7.14
library-dirs:         /usr/lib/ghc-9.2.8/site-local/extra-1.7.14
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-extra
hs-libraries:         HSextra-1.7.14-DnAQtxBkKEm2qogn2rCz4Q
depends:
    base-4.16.4.0 clock-0.8.4-7IyCiFmS7Cb1oaoFOOmIGH directory-1.3.6.2
    filepath-1.4.2.2 process-1.6.16.0 time-1.11.1.1 unix-2.7.2.2

haddock-interfaces:   /usr/share/doc/haskell-extra/html/extra.haddock
haddock-html:         /usr/share/doc/haskell-extra/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

